#include "mac.h" 

// ##################################################################
// Getting MAC Address via popen() within C++-program in Windows 2000
// ##################################################################

#define MAC_ADDRESS_SIZE	17
const char	must_be_deleted = '\r';


// =====================================
vector<vector<string> > get_mac_via_popen ()
{   
const string	command_line = "ipconfig /all";
const string	delim_str (": ");
const string	str_physical_address ("Physical Address");
vector<string>	out_result;
vector<string>	err_result;
vector<string>	physical_address_result;
vector<vector<string> >	ret_value;

bool    ret_bool_code = popen_cplusplus_wrapper (command_line, out_result, err_result);
      
  if (!ret_bool_code)		return vector<vector<string> >();
  if (!err_result.empty ())	return vector<vector<string> >();
  if (out_result.empty ())	return vector<vector<string> >();

string tmp_string;
  for (unsigned int i = 0; i < out_result.size(); i++)
  {
    if (!(
	   (out_result[i][0] == ' ') 
	   || 
	   (out_result[i][0] == '\t') 
	   || 
	   (out_result[i][0] == '\r')
	   || 
	   (out_result[i][0] == '\0') 
	 )
       )
    {
      tmp_string = out_result[i];
      if ((*tmp_string.rbegin()) == '\r')
      {
        tmp_string = tmp_string.substr (0, tmp_string.size() - 1);
      }
    }

    if (!(out_result[i].find (str_physical_address) == string::npos))
    {
      ret_value.push_back (vector<string> ());

      string tmp2_string (out_result[i]);
      const string::size_type	find_index = tmp2_string.find_last_of (delim_str);   

      if (find_index == string::npos)	continue;

      // ---------------------
      tmp2_string = tmp2_string.substr(find_index + delim_str.size() - 1, MAC_ADDRESS_SIZE); 
      assert (tmp2_string.size() == MAC_ADDRESS_SIZE);     

      ret_value.rbegin()->push_back (tmp2_string);
      assert (ret_value.rbegin()->rbegin()->size() > 0);

      ret_value.rbegin()->push_back (tmp_string);
      tmp_string.clear();
      assert (tmp_string.empty());
      assert (ret_value.rbegin()->rbegin()->size() > 0);
    }
  }

  return ret_value;
   
} // get_mac_via_popen

