/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.db;

import com.rathedg.util.db.ConnectionTuner;
import com.rathedg.util.db.DBConnectionPool;
import com.rathedg.util.db.SimpleDBConnectionSource;
import com.rathedg.util.log.LoggerInterface;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public abstract class DBConnectionSource {
    public static final int INACTIVITY_TIME = 1000;
    private LoggerInterface logger;

    public static final DBConnectionSource getDBConnectionSource(String string, Properties properties, ConnectionTuner connectionTuner, int n, String string2) throws SQLException {
        if (n == 0) {
            return new SimpleDBConnectionSource(string, properties, connectionTuner);
        }
        return new DBConnectionPool(string, properties, connectionTuner, n, string2);
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract void releaseConnection(Connection var1) throws SQLException;

    public final void releaseConnectionSafe(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.releaseConnection(connection);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public abstract void releaseResources();

    public void setLogger(LoggerInterface loggerInterface) {
        this.logger = loggerInterface;
    }

    protected void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }
}

