/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.eru;

import com.rathedg.cachalot.Constants;
import com.rathedg.cachalot.ERUConstants;
import com.rathedg.cachalot.EventConnector;
import com.rathedg.cachalot.common.CommonDB;
import com.rathedg.cachalot.eru.Event;
import com.rathedg.cachalot.eru.EventProcessor;
import com.rathedg.socketserver.MessageHandler;
import com.rathedg.socketserver.TwoWayRequestHandler;
import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.db.ConnectionTuner;
import com.rathedg.util.db.DBConnectionSource;
import com.rathedg.util.db.DBUtils;
import com.rathedg.util.exception.InitializationException;
import com.rathedg.util.exception.InvalidValueException;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.net.IP;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class RequestHandler
implements TwoWayRequestHandler,
ConnectionTuner,
ERUConstants,
Constants {
    static final byte CACHEDB = -1;
    static final byte[] OK = new byte[]{0};
    static final byte DENIED = 1;
    static final byte[] ERROR = new byte[]{2};
    static final byte[] AUTHFAILED = new byte[]{-1};
    public static final boolean DEBUG = false;
    private DBConnectionSource dbsource;
    private int txLevel;
    private LoggerInterface logger;
    private Map users = new HashMap();
    private Map hosts = new HashMap();
    private Map coefs = new HashMap();
    private float hourPrice;
    private float inTrafficPrice;
    private float outTrafficPrice;
    private String password;
    private String clientPassword;
    private EventProcessor eventprocessor;
    private int eid;
    private String eids;

    public void init(Map map, LoggerInterface loggerInterface) throws InitializationException, InvalidValueException {
        this.init(new PropertyExtractor(map), loggerInterface);
    }

    public void init(PropertyExtractor propertyExtractor, LoggerInterface loggerInterface) throws InitializationException, InvalidValueException {
        System.out.println("RatheDG Cachalot System 1.2.0 ERU/S, (c) 2001-2003 Rathe Development Group.");
        this.password = this.clientPassword = propertyExtractor.getStringNotNullNotEmpty("password", true);
        this.logger = loggerInterface;
        try {
            DriverManager.registerDriver((Driver)Class.forName(propertyExtractor.getStringNotNullNotEmpty("db.driver", true)).newInstance());
        }
        catch (InvalidValueException invalidValueException) {
            throw invalidValueException;
        }
        catch (Exception exception) {
            throw new InitializationException("error instantiating or registering driver", exception);
        }
        this.txLevel = DBUtils.parseTXLevel(propertyExtractor.getStringNotNullNotEmpty("db.transaction", true));
        if (this.txLevel == -1) {
            throw new InitializationException("value 'db.transaction' is invalid");
        }
        try {
            this.dbsource = DBConnectionSource.getDBConnectionSource(propertyExtractor.getStringNotNullNotEmpty("db.url", true), new Properties(), this, 1, null);
        }
        catch (Throwable throwable) {
            if (this.dbsource != null) {
                this.dbsource.releaseResources();
            }
            throw new InitializationException("error connecting to db", throwable);
        }
        this.dbsource.setLogger(this.logger);
        EventConnector eventConnector = new EventConnector();
        if (eventConnector.getConnector(propertyExtractor.getStringNotNullNotEmpty(new String((byte[])eventConnector.getSynchronizer()), true)) == null) {
            this.eids = new String((byte[])eventConnector.getNotifier());
            this.eid = -1;
        } else {
            this.eid = (Integer)eventConnector.getWaiter();
        }
        try {
            this.cacheDB();
        }
        catch (InitializationException initializationException) {
            this.dbsource.releaseResources();
            throw initializationException;
        }
        Event.hosts = this.hosts;
        Event.users = this.users;
        this.eventprocessor = new EventProcessor(this.dbsource, loggerInterface, this.hourPrice, this.inTrafficPrice, this.outTrafficPrice, this.coefs);
    }

    public void shutdown() {
        this.eventprocessor.shutdown();
        this.dbsource.releaseResources();
    }

    private synchronized void cacheDB() throws InitializationException {
        this.hosts.clear();
        this.users.clear();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            ResultSet resultSet;
            try {
                Short s;
                connection = this.dbsource.getConnection();
                preparedStatement = connection.prepareStatement("SELECT u.f_uin,u.f_nick,g.f_hourcoef,g.f_intrafficcoef,g.f_outtrafficcoef FROM t_users u,t_groups g,t_useringroup r WHERE u.f_uin=r.f_useruin AND g.f_uin=r.f_groupuin");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    s = new Short(resultSet.getShort(1));
                    this.users.put(resultSet.getString(2).toLowerCase(), s);
                    this.coefs.put(s, new float[]{resultSet.getFloat(3), resultSet.getFloat(4), resultSet.getFloat(5)});
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT f_useruin,f_hourcoef,f_intrafficcoef,f_outtrafficcoef FROM t_usercoefs");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    s = new Short(resultSet.getShort(1));
                    this.coefs.put(s, new float[]{resultSet.getFloat(2), resultSet.getFloat(3), resultSet.getFloat(4)});
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                throw new InitializationException("error getting users and user coefficients from db", sQLException);
            }
            try {
                preparedStatement = connection.prepareStatement("SELECT f_address1,f_address2,f_address3,f_address4,f_uin FROM t_hosts");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.hosts.put(new IP(CommonDB.cb(resultSet.getShort(1)), CommonDB.cb(resultSet.getShort(2)), CommonDB.cb(resultSet.getShort(3)), CommonDB.cb(resultSet.getShort(4))), new Byte(CommonDB.cb(resultSet.getShort(5))));
                }
                resultSet.close();
                preparedStatement.close();
                if (this.hosts.size() > this.eid) {
                    this.logger.log(this.eids);
                    this.eid = 0;
                }
            }
            catch (SQLException sQLException) {
                throw new InitializationException("error getting hosts from db", sQLException);
            }
            try {
                preparedStatement = connection.prepareStatement("SELECT f_hourprice,f_intrafficprice,f_outtrafficprice FROM t_generaldata");
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                this.hourPrice = resultSet.getFloat(1);
                this.inTrafficPrice = resultSet.getFloat(2);
                this.outTrafficPrice = resultSet.getFloat(3);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw new InitializationException("error getting prices from db", sQLException);
            }
        }
        catch (InitializationException initializationException) {
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(connection);
            throw initializationException;
        }
        DBUtils.safeCloseStatement(preparedStatement);
        this.dbsource.releaseConnectionSafe(connection);
    }

    public void tune(Connection connection) throws SQLException {
        try {
            connection.setTransactionIsolation(this.txLevel);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error setting transaction isolation level " + sQLException.getMessage());
        }
    }

    public MessageHandler handle(short s, InetAddress inetAddress) {
        return new NetclubMessageHandler((byte)s, inetAddress);
    }

    public final class NetclubMessageHandler
    implements MessageHandler {
        private byte descriptor;
        private InetAddress address;
        private long time;
        private Event event;

        NetclubMessageHandler(byte by, InetAddress inetAddress) {
            this.descriptor = by;
            this.address = inetAddress;
        }

        public byte[] handle(byte[] byArray) {
            this.time = System.currentTimeMillis();
            try {
                if (RequestHandler.this.eid == 0) {
                    return this.formReturn(ERROR[0], RequestHandler.this.eids);
                }
                if (this.descriptor == -1) {
                    // empty if block
                }
                IP iP = new IP(this.address.getAddress());
                Byte by = (Byte)RequestHandler.this.hosts.get(iP);
                if (by == null) {
                    throw new UnknownEntityException("host", iP.toString());
                }
                int n = 0;
                while (n < byArray.length) {
                    if (byArray[n] == 0) break;
                    n = (byte)(n + 1);
                }
                String string = new String(byArray, 0, n);
                if (!string.equals(RequestHandler.this.clientPassword)) {
                    throw new AuthorizationFailedException();
                }
                this.event = new Event();
                this.event.code = this.descriptor;
                this.event.host = by;
                this.event.time = this.time;
                if (this.descriptor == 3) {
                    String string2 = new String(byArray, n + 1, byArray.length - n - 1).toLowerCase();
                    Short s = (Short)RequestHandler.this.users.get(string2);
                    if (s == null) {
                        throw new UnknownEntityException("user", string2);
                    }
                    this.event.user = s;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                this.event = null;
                RequestHandler.this.logger.log("unknown " + unknownEntityException.getName() + " '" + unknownEntityException.getObject() + "'" + " (descriptor=" + this.descriptor + ",address=" + this.address + ",data=" + new String(byArray) + ")");
                return this.formReturn(ERROR[0], "unknown " + unknownEntityException.getName() + " '" + unknownEntityException.getObject() + "'");
            }
            catch (AuthorizationFailedException authorizationFailedException) {
                this.event = null;
                RequestHandler.this.logger.log("authorization failed (descriptor=" + this.descriptor + ",address=" + this.address + ",data=" + new String(byArray) + ")");
                return AUTHFAILED;
            }
            catch (Throwable throwable) {
                this.event = null;
                RequestHandler.this.logger.log("error during request processing (descriptor=" + this.descriptor + ",address=" + this.address + ",data=" + new String(byArray) + "): " + throwable);
                return ERROR;
            }
            return OK;
        }

        private byte[] formReturn(byte by, String string) {
            int n = string.length();
            byte[] byArray = new byte[n + 1];
            byArray[0] = ERROR[0];
            string.getBytes(0, n, byArray, 1);
            return byArray;
        }

        public void commit() {
            if (this.event != null) {
                RequestHandler.this.eventprocessor.addEvent(this.event);
            }
        }

        public void rollback() {
        }

        public void release() {
            this.address = null;
            this.event = null;
        }

        final class UnknownEntityException
        extends Exception {
            private String name;
            private Object object;

            protected UnknownEntityException(String string, Object object) {
                this.name = string;
                this.object = object;
            }

            protected String getName() {
                return this.name;
            }

            protected Object getObject() {
                return this.object;
            }
        }

        final class AuthorizationFailedException
        extends Exception {
            AuthorizationFailedException() {
            }
        }
    }
}

