
// #########################################################
// === File #12 of 15 : fx_vect.cpp ========================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 1999 - 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@bigfoot.com, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Vector and Matrix with arbitrary bounds
//  FILE     : fx_vect.cpp
//
//  DESCRIPTION :
//         Implementation of flexible vector non-template class
//	   ----------------------------------------------------
//         - ClassBasicVector
//	   ----------------------------------------------------
//
//  -------	-----------
//  Created	Mar-15-1999
//  -------	-----------
//  Updated	Oct-30-2001    gcc-2.95.3,  Windows98
//  Updated	May-06-2002    gcc-3.0.4,   Windows2000
//  Updated	Dec-06-2002    gcc-3.2.0,   Windows2000
//
// ##############################################################


//===============================================
#include "fx_vect2.h"
//===============================================


//#################################################
unsigned long ClassBasicVector::countBasicVectorConstructors_s (0);
unsigned long ClassBasicVector::countBasicVectorDestructors_s (0);


//////////////////////////////////////////////////////////////////////
//####################################################################
//########### PART : ClassBasicVector methods ########################
//####################################################################
//////////////////////////////////////////////////////////////////////



//####################################################################
// Constructor-0
ClassBasicVector::ClassBasicVector ()
{
  countBasicVectorConstructors_s++;
} // ClassBasicVector::ClassBasicVector () 



//####################################################################
// Destructor
ClassBasicVector::~ClassBasicVector ()
{
  countBasicVectorDestructors_s++;
} // ClassBasicVector::~ClassBasicVector () 




//####################################################################
// static
string ClassBasicVector :: gstrBasicVectorAccount_S (string  msg_i)
{
string		ret_stringValue;
ostringstream       oss;

  if (!msg_i.empty ())
  {
    oss << "\t" 
                  << msg_i 
                  << " :"; 
  }

  oss << gstrAboutAccount (getTypeName<ClassBasicVector> (), countBasicVectorConstructors_s, countBasicVectorDestructors_s);

  oss << ends;
  ret_stringValue = oss.str(); 

  return ret_stringValue;

} // int ClassBasicVector :: gstrBasicVectorAccount_S (...)


//################################################################
//#                          END OF FILE                         # 
//################################################################


// ------------------- C++ code : END ----------------------
// === File #12 of 15 : fx_vect.cpp ========================
