/*
 * Decompiled with CFR 0.152.
 */
package vscript.interpreter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import vscript.GUI.PercentLayout;
import vscript.GUI.ScreenPos;
import vscript.Tag;
import vscript.VSRHelper;
import vscript.interpreter.EventMessageGroup;
import vscript.interpreter.EventTagManager;
import vscript.message.Messagable;
import vscript.message.Message;
import vscript.message.MessageNode;
import vscript.parser.Parser;

public abstract class TagInterpreter {
    public Object interpret(Tag tag, MessageNode messageNode, int n) {
        Object object;
        MessageNode messageNode2 = null;
        Object object2 = null;
        Messagable messagable = null;
        List list = this.getSubTagList();
        tag.parseTagBody(list);
        if (this.nameReqd()) {
            if (tag.getTagIdentifier() == null) {
                System.out.println(tag.getTagName() + " :Identifer not specified");
                return null;
            }
            if (tag.getTagIdentifier() != null) {
                messageNode2 = this.createMessageNode(tag, messageNode);
                tag.setMessageNode(messageNode2);
            }
        }
        if ((object2 = this.interpretObject(tag)) == null) {
            return null;
        }
        if (object2 instanceof Messagable) {
            messagable = (Messagable)object2;
            object = this.interpretEventTags(tag.getSubTag("event"), messageNode2);
            messagable.setEventTagManager((EventTagManager)object);
        }
        if (messageNode2 != null) {
            messageNode2.addInterpretedObject(object2);
        }
        tag.removeSubTag("event");
        this.setInterpretOrder(tag.getSubTag());
        object = tag.getSubTag();
        ListIterator listIterator = object.listIterator(0);
        while (listIterator.hasNext()) {
            String string;
            Object object3;
            Tag tag2 = (Tag)listIterator.next();
            if (tag2.getTagName().equalsIgnoreCase("comment")) continue;
            TagInterpreter tagInterpreter = tag2.getInterpreter();
            if (tagInterpreter == null) {
                System.out.println("No Interpreter Found for Tag :" + tag2.getTagName());
                continue;
            }
            if (!tagInterpreter.validLevel(n)) {
                System.out.println(tagInterpreter.getClass().getName() + " can not work at this level");
                continue;
            }
            Object object4 = tagInterpreter.interpret(tag2, messageNode2, n + 1);
            if (object4 instanceof JComponent && (object3 = messageNode2.getInterpretedObject()) instanceof JPanel && (string = tag2.getAttributeValue("pos")) != null) {
                ScreenPos screenPos = Parser.parsePos(string);
                this.addComponent((JComponent)object4, (JPanel)object3, screenPos, tag2.getTagIdentifier());
            }
            this.processObject(object4);
        }
        return object2;
    }

    protected List getSubTagList() {
        return null;
    }

    protected boolean nameReqd() {
        return true;
    }

    protected void processObject(Object object) {
    }

    protected void addComponent(JComponent jComponent, JPanel jPanel, ScreenPos screenPos, String string) {
        LayoutManager layoutManager = jPanel.getLayout();
        if (!(layoutManager instanceof PercentLayout)) {
            jPanel.setLayout(new PercentLayout());
        }
        if (screenPos != null) {
            jPanel.add((Component)jComponent, screenPos);
        }
    }

    protected abstract Object interpretObject(Tag var1);

    protected void setInterpretOrder(List list) {
    }

    private EventTagManager interpretEventTags(List list, MessageNode messageNode) {
        EventTagManager eventTagManager = new EventTagManager(messageNode);
        ListIterator listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            EventMessageGroup eventMessageGroup = null;
            Tag tag = (Tag)listIterator.next();
            TagInterpreter tagInterpreter = tag.getInterpreter();
            eventMessageGroup = (EventMessageGroup)tagInterpreter.interpret(tag, null, 0);
            eventTagManager.addEventMessageGroup(eventMessageGroup);
        }
        return eventTagManager;
    }

    private MessageNode createMessageNode(Tag tag, MessageNode messageNode) {
        String string = tag.getTagIdentifier();
        return new MessageNode(messageNode, string);
    }

    public boolean validLevel(int n) {
        return true;
    }

    public Image getImage(String string, String string2) {
        VSRHelper vSRHelper = VSRHelper.getVSRHelper();
        Image image = vSRHelper.getImage(string, string2);
        return image;
    }

    public static void setBorder(JComponent jComponent, String string) {
        int n = 1;
        if (string != null) {
            n = Integer.parseInt(string);
            Color color = VSRHelper.borderColor2;
            switch (n) {
                case 0: {
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                    break;
                }
                case 2: {
                    jComponent.setBorder(BorderFactory.createBevelBorder(1, VSRHelper.borderColor, color));
                    break;
                }
                case 3: {
                    jComponent.setBorder(BorderFactory.createBevelBorder(1, color, VSRHelper.borderColor));
                    break;
                }
                case 4: {
                    jComponent.setBorder(BorderFactory.createLineBorder(VSRHelper.borderColor, 1));
                    break;
                }
                case 5: {
                    Border border = BorderFactory.createBevelBorder(1, VSRHelper.borderColor, VSRHelper.borderColor);
                    jComponent.setBorder(border);
                    break;
                }
                case 6: {
                    Border border = BorderFactory.createBevelBorder(1, color, color);
                    jComponent.setBorder(border);
                }
            }
        }
    }

    public static void handleMessageGUI(JComponent jComponent, Message message) {
        String string = message.getMessageString();
        if (string != null) {
            TagInterpreter.processVisible(jComponent, string);
            TagInterpreter.processEnabled(jComponent, string);
            String[] stringArray = message.getArguments();
            if (string.equals("bcolor")) {
                if (stringArray.length == 1) {
                    TagInterpreter.processBColor(jComponent, stringArray[0]);
                }
            } else if (string.equals("fcolor")) {
                if (stringArray.length == 1) {
                    TagInterpreter.processFColor(jComponent, stringArray[0]);
                }
            } else if (string.equals("border")) {
                if (stringArray.length == 1) {
                    TagInterpreter.processBorder(jComponent, stringArray[0]);
                }
            } else if (string.equals("resize") && stringArray.length == 1) {
                ScreenPos screenPos = Parser.parsePos(stringArray[0]);
                LayoutManager layoutManager = jComponent.getParent().getLayout();
                if (layoutManager instanceof PercentLayout) {
                    ((PercentLayout)layoutManager).resize(jComponent, screenPos);
                    jComponent.revalidate();
                }
            }
        }
    }

    public static void processAttributes(Component component, Tag tag) {
        TagInterpreter.processAttributes(component, tag, true, true, true, true);
    }

    public static void processAttributes(Component component, Tag tag, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string;
        if (bl) {
            string = tag.getAttributeValue("bcolor");
            TagInterpreter.processBColor(component, string);
            string = tag.getAttributeValue("fcolor");
            TagInterpreter.processFColor(component, string);
        }
        if (bl4) {
            string = tag.getAttributeValue("border");
            TagInterpreter.processBorder(component, string);
        }
        if (bl2 && (string = tag.getAttributeValue("enabled")) != null) {
            if (string.equals("false")) {
                TagInterpreter.processEnabled(component, "disable");
            } else {
                TagInterpreter.processEnabled(component, "enable");
            }
        }
        if (bl3 && (string = tag.getAttributeValue("visible")) != null) {
            if (string.equals("false")) {
                TagInterpreter.processVisible(component, "hide");
            } else {
                TagInterpreter.processVisible(component, "show");
            }
        }
    }

    public static void processBColor(Component component, String string) {
        Color color = string != null ? Parser.parseColor(string) : VSRHelper.backColor;
        component.setBackground(color);
        component.repaint();
    }

    public static void processFColor(Component component, String string) {
        Color color = string != null ? Parser.parseColor(string) : VSRHelper.foreColor;
        component.setForeground(color);
        component.repaint();
    }

    public static void processBorder(Component component, String string) {
        if (string == null) {
            string = VSRHelper.border;
        }
        TagInterpreter.setBorder((JComponent)component, string);
        component.repaint();
    }

    public static void processVisible(Component component, String string) {
        if (string != null) {
            if (string.equals("show")) {
                component.setVisible(true);
            } else if (string.equals("hide")) {
                component.setVisible(false);
            }
        }
    }

    public static void processEnabled(Component component, String string) {
        if (string != null) {
            if (string.equals("enable")) {
                component.setEnabled(true);
            } else if (string.equals("disable")) {
                component.setEnabled(false);
            }
        }
    }
}

