/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.Image;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import vscript.GUI.CardContainerPanel;
import vscript.GUI.FormListener;
import vscript.GUI.ImagePanel;
import vscript.GUI.LoadListener;
import vscript.interpreter.EventTagManager;
import vscript.message.Message;

public class FormPanel
extends ImagePanel
implements LoadListener {
    private static FormPanel currentForm;
    private CardContainerPanel parentCardContainer;
    private String name;
    private List listenerList = new LinkedList();
    private EventTagManager etm;
    private JPanel container;

    public FormPanel(JPanel jPanel, String string, Image image, Image image2, String string2, boolean bl, boolean bl2) {
        super(image, image2, string2, null, bl, bl2);
        if (jPanel instanceof CardContainerPanel) {
            this.parentCardContainer = (CardContainerPanel)jPanel;
        }
        this.container = jPanel;
        this.name = string;
    }

    public void addFormListener(FormListener formListener) {
        this.listenerList.add(formListener);
    }

    public void handleMessage(Message message) {
        super.handleMessage(message);
        String string = message.getMessageString();
        if (string != null) {
            if (string.equals("show")) {
                if (currentForm != null && currentForm != this.container) {
                    currentForm.inform("formhide");
                }
                this.inform("formshow");
                currentForm = this;
                if (this.parentCardContainer != null) {
                    this.parentCardContainer.showCard(this.name);
                }
            } else if (string.equals("hide")) {
                this.inform("formhide");
            }
        }
    }

    public String getDataValue(String string) {
        return null;
    }

    private void inform(String string) {
        ListIterator listIterator = this.listenerList.listIterator(0);
        this.etm.processEvent(string);
        while (listIterator.hasNext()) {
            if (string.equals("formshow")) {
                ((FormListener)listIterator.next()).formShow();
                continue;
            }
            if (string.equals("formhide")) {
                ((FormListener)listIterator.next()).formHide();
                continue;
            }
            if (string.equals("formload")) {
                ((FormListener)listIterator.next()).formLoad();
                continue;
            }
            if (!string.equals("formunload")) continue;
            ((FormListener)listIterator.next()).formUnLoad();
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
        this.etm = eventTagManager;
    }

    public void componentLoaded() {
        this.inform("formload");
    }

    public void componentUnloaded() {
        if (this.isVisible()) {
            this.inform("formhide");
        }
        this.inform("formunload");
        currentForm = null;
    }
}

