/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Command;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomParams;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Event.ChatroomListener;
import jChatBox.Chat.Filter.Filter;
import jChatBox.Chat.LogListener;
import jChatBox.Chat.Monitor;
import jChatBox.Chat.UserParams;
import jChatBox.Command.CommandException;
import jChatBox.Command.CommandParams;
import jChatBox.Command.SystemCommand;
import jChatBox.Util.Conf;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class ModeratorCommand
extends SystemCommand {
    public String execute(String string, CommandParams commandParams, ChatroomUser chatroomUser) throws CommandException {
        if (chatroomUser.getType() != 2 && chatroomUser.getType() != 1) {
            throw new CommandException(Conf.COMMANDNOTALLOWED);
        }
        if (string != null && !string.equals("")) {
            string = string.toUpperCase();
            ChatroomManager chatroomManager = ChatroomManager.getInstance();
            if (chatroomManager == null) {
                throw new CommandException(Conf.SYSTEMERROR);
            }
            if (string.equals("OPENCHATROOM")) {
                String string2 = (String)commandParams.getParameter("name");
                String string3 = (String)commandParams.getParameter("subject");
                String string4 = (String)commandParams.getParameter("maxusers");
                String string5 = (String)commandParams.getParameter("history");
                String string6 = (String)commandParams.getParameter("mode");
                String string7 = (String)commandParams.getParameter("refreshmodel");
                String string8 = (String)commandParams.getParameter("refreshlimit");
                String string9 = (String)commandParams.getParameter("private");
                String string10 = (String)commandParams.getParameter("language");
                Vector vector = (Vector)commandParams.getParameter("moderatorlist");
                if (vector == null) {
                    vector = new Vector();
                }
                if (string2 != null && !string2.equals("")) {
                    if (string3 != null && !string3.equals("")) {
                        int n = -1;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        int n5 = -1;
                        boolean bl = true;
                        Vector<Filter> vector2 = new Vector<Filter>();
                        if (string4 != null) {
                            n = Integer.parseInt(string4);
                        }
                        if (string5 != null) {
                            n2 = Integer.parseInt(string5);
                        }
                        if (string8 != null) {
                            n3 = Integer.parseInt(string8);
                        }
                        if (string7 != null) {
                            n4 = Integer.parseInt(string7);
                        }
                        if (string6 != null) {
                            n5 = string6.toUpperCase().equals("NONFRAMED") ? 1 : (string6.toUpperCase().equals("FRAMED") ? 2 : (string6.toUpperCase().equals("BUFFEREDFRAMED") ? 3 : (string6.toUpperCase().equals("APPLET") ? 4 : (string6.toUpperCase().equals("FLASH") ? 5 : -1))));
                        }
                        if (string9 != null && string9.toUpperCase().equals("NO")) {
                            bl = false;
                        }
                        Vector vector3 = XMLConfig.FILTERS;
                        String string11 = null;
                        Filter filter = null;
                        int n6 = 0;
                        while (n6 < vector3.size()) {
                            filter = (Filter)vector3.elementAt(n6);
                            string11 = (String)commandParams.getParameter(filter.getID());
                            if (string11 != null && !string11.equals("")) {
                                vector2.addElement(filter);
                            }
                            ++n6;
                        }
                        ChatroomParams chatroomParams = new ChatroomParams(string2, string3, chatroomManager.getChatroomUID(), n, -1, n2, n3, n5, bl, string10, n4, vector2, vector);
                        Chatroom chatroom = new Chatroom(chatroomParams);
                        Vector vector4 = XMLConfig.LISTENERS;
                        String string12 = null;
                        ChatroomListener chatroomListener = null;
                        int n7 = 0;
                        while (n7 < vector4.size()) {
                            chatroomListener = (ChatroomListener)vector4.elementAt(n7);
                            string12 = (String)commandParams.getParameter(chatroomListener.getID());
                            if (string12 != null && !string12.equals("")) {
                                chatroom.addListener(chatroomListener);
                            }
                            ++n7;
                        }
                        chatroom.open();
                        chatroomManager.addChatroom(chatroom);
                        return Conf.CHATROOMOPENED;
                    }
                    throw new CommandException(Conf.CHATROOMSUBJECTMISSING);
                }
                throw new CommandException(Conf.CHATROOMNAMEMISSING);
            }
            if (string.equals("CLEARCHATROOM")) {
                String string13 = (String)commandParams.getParameter("id");
                if (string13 != null && !string13.equals("")) {
                    int n = Integer.parseInt(string13);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                        chatroomManager.getChatroom(n).clear();
                        return Conf.CHATROOMCLEARED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("CLOSECHATROOM")) {
                String string14 = (String)commandParams.getParameter("id");
                if (string14 != null && !string14.equals("")) {
                    int n = Integer.parseInt(string14);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                        chatroomManager.removeChatroom(n);
                        return Conf.CHATROOMCLOSED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("UPDATECHATROOM")) {
                String string15 = (String)commandParams.getParameter("id");
                String string16 = (String)commandParams.getParameter("subject");
                String string17 = (String)commandParams.getParameter("history");
                String string18 = (String)commandParams.getParameter("refreshlimit");
                String string19 = (String)commandParams.getParameter("refreshmodel");
                String string20 = (String)commandParams.getParameter("private");
                String string21 = (String)commandParams.getParameter("language");
                Vector vector = (Vector)commandParams.getParameter("moderatorlist");
                if (vector == null) {
                    vector = new Vector();
                }
                if (string15 != null && !string15.equals("")) {
                    int n = Integer.parseInt(string15);
                    if (string16 != null && !string16.equals("")) {
                        int n8 = -1;
                        int n9 = -1;
                        int n10 = -1;
                        boolean bl = true;
                        Vector<Filter> vector5 = new Vector<Filter>();
                        if (string17 != null) {
                            n8 = Integer.parseInt(string17);
                        }
                        if (string18 != null) {
                            n9 = Integer.parseInt(string18);
                        }
                        if (string19 != null) {
                            n10 = Integer.parseInt(string19);
                        }
                        if (string20 != null && string20.toUpperCase().equals("NO")) {
                            bl = false;
                        }
                        Vector vector6 = XMLConfig.FILTERS;
                        String string22 = null;
                        Filter filter = null;
                        int n11 = 0;
                        while (n11 < vector6.size()) {
                            filter = (Filter)vector6.elementAt(n11);
                            string22 = (String)commandParams.getParameter(filter.getID());
                            if (string22 != null && !string22.equals("")) {
                                vector5.addElement(filter);
                            }
                            ++n11;
                        }
                        try {
                            if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                                throw new CommandException(Conf.COMMANDNOTALLOWED);
                            }
                            Chatroom chatroom = chatroomManager.getChatroom(n);
                            ChatroomParams chatroomParams = chatroom.getParams();
                            ChatroomParams chatroomParams2 = new ChatroomParams(chatroomParams.getName(), string16, chatroomParams.getID(), chatroomParams.getMaxUsers(), chatroomParams.getMaxInactive(), n8, n9, chatroomParams.getDisplayMode(), bl, string21, n10, vector5, vector);
                            chatroom.updateParams(chatroomParams2);
                            return Conf.CHATROOMUPDATED;
                        }
                        catch (ChatException chatException) {
                            throw new CommandException(Conf.CHATROOMNOTFOUND);
                        }
                    }
                    throw new CommandException(Conf.CHATROOMSUBJECTMISSING);
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("GENERATETRANSCRIPT")) {
                String string23 = (String)commandParams.getParameter("id");
                String string24 = (String)commandParams.getParameter("filename");
                if (string23 != null && !string23.equals("")) {
                    int n = Integer.parseInt(string23);
                    if (string24 == null || string24.equals("")) {
                        string24 = "chatroom" + n + "transcript.txt";
                    }
                    Chatroom chatroom = null;
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                        chatroom = chatroomManager.getChatroom(n);
                        XMLConfig.TRANSCRIPTIMPL.process(chatroom, string24);
                        return Conf.CHATROOMTRANSCRIPTED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.TRANSCRIPTFAILED + " : " + chatException.getMessage());
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("KICKOFF") || string.equals("BAN")) {
                String string25 = (String)commandParams.getParameter("username");
                String string26 = (String)commandParams.getParameter("id");
                String string27 = (String)commandParams.getParameter("reason");
                if (string26 != null && !string26.equals("")) {
                    int n = Integer.parseInt(string26);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                    if (string25 != null && !string25.equals("")) {
                        Monitor monitor = Monitor.getInstance();
                        if (monitor == null) {
                            throw new CommandException(Conf.SYSTEMERROR);
                        }
                        Hashtable hashtable = monitor.getTable();
                        Enumeration enumeration = hashtable.keys();
                        ChatroomUser chatroomUser2 = null;
                        HttpSession httpSession = null;
                        int n12 = -1;
                        String string28 = null;
                        while (enumeration.hasMoreElements()) {
                            chatroomUser2 = (ChatroomUser)enumeration.nextElement();
                            httpSession = (HttpSession)hashtable.get(chatroomUser2);
                            n12 = chatroomUser2.getParams().getChatroom();
                            string28 = chatroomUser2.getName();
                            if (n != n12 || !string28.equals(string25)) continue;
                            if (chatroomUser2.getType() == 2 || chatroomUser2.getType() == 1) {
                                throw new CommandException(Conf.CANNOTKICKOFFORBAN);
                            }
                            httpSession.invalidate();
                            if (string.equals("KICKOFF")) {
                                this._$229(1, "User : " + string25 + "(" + chatroomUser2.getIP() + ") has been kicked off chatroom " + n);
                                return Conf.KICKEDOFF;
                            }
                            try {
                                Chatroom chatroom = chatroomManager.getChatroom(n);
                                chatroom.addToBlacklist(chatroomUser2, string27);
                                this._$229(1, "User : " + string25 + "(" + chatroomUser2.getIP() + ") has been banned of chatroom " + n);
                                return Conf.BANNED;
                            }
                            catch (ChatException chatException) {
                                if (chatException.getMessage().equalsIgnoreCase(Conf.ALREADYBANNED)) {
                                    throw new CommandException(Conf.ALREADYBANNED);
                                }
                                throw new CommandException(Conf.CHATROOMNOTFOUND);
                            }
                        }
                        throw new CommandException(Conf.NAMENOTFOUND);
                    }
                    throw new CommandException(Conf.USERNAMEMISSING);
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("BANIP")) {
                String string29 = (String)commandParams.getParameter("ip");
                String string30 = (String)commandParams.getParameter("id");
                String string31 = (String)commandParams.getParameter("reason");
                if (string30 != null && !string30.equals("")) {
                    int n = Integer.parseInt(string30);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                    if (string29 != null && !string29.equals("")) {
                        Monitor monitor = Monitor.getInstance();
                        if (monitor == null) {
                            throw new CommandException(Conf.SYSTEMERROR);
                        }
                        Serializable serializable = monitor.getTable();
                        Object object = ((Hashtable)serializable).keys();
                        ChatroomUser chatroomUser3 = null;
                        HttpSession httpSession = null;
                        int n13 = -1;
                        String string32 = null;
                        while (object.hasMoreElements()) {
                            chatroomUser3 = (ChatroomUser)object.nextElement();
                            httpSession = (HttpSession)((Hashtable)serializable).get(chatroomUser3);
                            n13 = chatroomUser3.getParams().getChatroom();
                            string32 = chatroomUser3.getIP();
                            if (n != n13 || !string32.equalsIgnoreCase(string29)) continue;
                            httpSession.invalidate();
                            break;
                        }
                        try {
                            serializable = chatroomManager.getChatroom(n);
                            object = new UserParams();
                            ((UserParams)object).setChatroom(n);
                            chatroomUser3 = new ChatroomUser(string29, string29, 0, (UserParams)object, (LogListener)((Object)serializable));
                            ((Chatroom)serializable).addToBlacklist(chatroomUser3, string31);
                            this._$229(1, "IP : " + chatroomUser3.getIP() + " has been banned of chatroom " + ((Chatroom)serializable).getParams().getName());
                            return Conf.BANNED;
                        }
                        catch (ChatException chatException) {
                            if (chatException.getMessage().equalsIgnoreCase(Conf.ALREADYBANNED)) {
                                throw new CommandException(Conf.ALREADYBANNED);
                            }
                            throw new CommandException(Conf.CHATROOMNOTFOUND);
                        }
                    }
                    throw new CommandException(Conf.IPADDRESSMISSING);
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("CLEAR")) {
                String string33 = (String)commandParams.getParameter("id");
                if (string33 != null && !string33.equals("")) {
                    int n = Integer.parseInt(string33);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                        Chatroom chatroom = chatroomManager.getChatroom(n);
                        chatroom.resetBlacklist();
                        this._$229(1, "Blacklist of Chatroom " + chatroom.getParams().getName() + " cleared");
                        return Conf.CHATROOMBLACKLISTCLEARED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("REMOVE")) {
                String string34 = (String)commandParams.getParameter("id");
                String string35 = (String)commandParams.getParameter("ip");
                if (string34 != null && !string34.equals("")) {
                    int n = Integer.parseInt(string34);
                    try {
                        if (chatroomUser.getType() != 2 && !chatroomManager.isModerateAllowed(n, chatroomUser.getName())) {
                            throw new CommandException(Conf.COMMANDNOTALLOWED);
                        }
                        Chatroom chatroom = chatroomManager.getChatroom(n);
                        chatroom.removeFromBlacklist(string35);
                        this._$229(1, "IP :" + string35 + " removed from blacklist of chatroom " + chatroom.getParams().getName());
                        return Conf.IPREMOVED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("JOIN")) {
                String string36 = (String)commandParams.getParameter("id");
                HttpSession httpSession = (HttpSession)commandParams.getParameter("session");
                if (string36 != null && !string36.equals("")) {
                    Object object;
                    Monitor monitor = Monitor.getInstance();
                    if (monitor == null) {
                        throw new CommandException(Conf.SYSTEMERROR);
                    }
                    int n = Integer.parseInt(string36);
                    Chatroom chatroom = null;
                    try {
                        chatroom = chatroomManager.getChatroom(n);
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                    try {
                        object = chatroomManager.getChatroom(chatroomUser.getParams().getChatroom());
                        if (object != null) {
                            ((Chatroom)object).removeUser(chatroomUser.getName());
                        }
                    }
                    catch (ChatException chatException) {
                        // empty catch block
                    }
                    try {
                        chatroom.addUser(chatroomUser);
                        object = chatroomUser.getParams();
                        ((UserParams)object).setChatroom(n);
                        ((UserParams)object).setRefresh(chatroom.getParams().getRefreshLimit());
                        chatroomUser.setParams((UserParams)object);
                        chatroomUser.updateChatroomLogListener(chatroom);
                        monitor.getTable().put(chatroomUser, httpSession);
                        httpSession.setMaxInactiveInterval(chatroom.getParams().getMaxInactive());
                        chatroomUser.updateMonitorLogListener(monitor);
                        if (chatroomUser.getType() == 2) {
                            return Conf.SYSTEMUSERJOINED;
                        }
                        return Conf.MODERATORUSERJOINED;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(chatException.getMessage());
                    }
                }
                throw new CommandException(Conf.CHATROOMIDMISSING);
            }
            if (string.equals("MODERATORHELP")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
                String string37 = (String)commandParams.getParameter("command");
                if (string37 != null && !string37.equals("")) {
                    String string38 = string37.toUpperCase();
                    if (string38.equals("GENERATETRANSCRIPT")) {
                        return Conf.GENERATETRANSCRIPTHELP + xMLPropertyResourceBundle.getString("moderator.command.generatetranscript.help");
                    }
                    if (string38.equals("CLEARCHATROOM")) {
                        return Conf.CLEARCHATROOMHELP + xMLPropertyResourceBundle.getString("moderator.command.clearchatroom.help");
                    }
                    if (string38.equals("CLOSECHATROOM")) {
                        return Conf.CLOSECHATROOMHELP + xMLPropertyResourceBundle.getString("moderator.command.closechatroom.help");
                    }
                    if (string38.equals("OPENCHATROOM")) {
                        return Conf.OPENCHATROOMHELP + xMLPropertyResourceBundle.getString("moderator.command.openchatroom.help");
                    }
                    if (string38.equals("KICKOFF")) {
                        return Conf.KICKOFFHELP + xMLPropertyResourceBundle.getString("moderator.command.kickoff.help");
                    }
                    if (string38.equals("BAN")) {
                        return Conf.BANHELP + xMLPropertyResourceBundle.getString("moderator.command.ban.help");
                    }
                    if (string38.equals("BANIP")) {
                        return Conf.BANIPHELP + xMLPropertyResourceBundle.getString("moderator.command.ban.help");
                    }
                    if (string38.equals("CLEAR")) {
                        return Conf.CLEARHELP + xMLPropertyResourceBundle.getString("moderator.command.clear.help");
                    }
                    throw new CommandException(string38 + " : " + Conf.UNKNOWNCOMMAND);
                }
                return Conf.MODERATORHELPHELP;
            }
            return super.execute(string, commandParams, chatroomUser);
        }
        throw new CommandException(Conf.UNKNOWNCOMMAND);
    }

    private void _$229(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

