/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Service;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Msg;
import jChatBox.Service.Login;
import jChatBox.Service.UserProcessor;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLConnector {
    private String _$7047 = "jChatBox.Service.UserLogin";
    private String _$7048 = "UTF-8";
    private String _$7049 = null;
    private String _$7050 = null;
    private String _$7051 = null;
    private String _$7052 = null;
    private UserProcessor _$7053 = null;
    private boolean _$7054 = false;

    public XMLConnector() {
        this.init();
    }

    public void init() {
        this._$7053 = new UserProcessor();
        this.trace(0, String.valueOf(String.valueOf(this.getClass().getName())).concat(" Initialized"));
    }

    public void setXMLEncoding(String string) {
        this._$7048 = string;
    }

    public void setLoginModule(String string) {
        this._$7047 = string;
    }

    public void setXSLGetManager(String string) {
        this._$7049 = string;
    }

    public void setXSLGetChat(String string) {
        this._$7050 = string;
    }

    public void setXSLError(String string) {
        this._$7052 = string;
    }

    public void setXSLGetChatroom(String string) {
        this._$7051 = string;
    }

    public void setDTDEnabled(boolean bl) {
        this._$7054 = bl;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        try {
            String string = httpServletRequest.getParameter("todo");
            if (string != null && !string.equals("")) {
                if ((string = string.toUpperCase()).equals("MANAGER")) {
                    String string2 = this.xmlGetManager();
                    return string2;
                }
                if (string.equals("CHATROOM")) {
                    String string3 = httpServletRequest.getParameter("id");
                    if (string3 != null && !string3.equals("")) {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string4 = this.xmlError(numberFormatException.getMessage(), 5);
                            return string4;
                        }
                        String string5 = this.xmlGetChatroom(n);
                        return string5;
                    }
                    String string6 = this.xmlError("id parameter missing", 5);
                    return string6;
                }
                if (string.equals("LANGUAGES")) {
                    String string7 = this.xmlGetLanguages();
                    return string7;
                }
                if (string.equals("RESOURCE")) {
                    String string8 = httpServletRequest.getParameter("language");
                    if (string8 != null && !string8.equals("")) {
                        String string9 = this.xmlGetResource(string8);
                        return string9;
                    }
                    String string10 = this.xmlError("language parameter missing", 5);
                    return string10;
                }
                if (string.equals("LOGIN")) {
                    Login login = this.getLoginInstance(this._$7047);
                    if (login != null) {
                        String string11 = login.doLogin(httpServletRequest, httpSession);
                        if (string11 != null) {
                            ChatroomUser chatroomUser = (ChatroomUser)httpSession.getValue(XMLConfig.USERSESSIONID);
                            String string12 = httpServletRequest.getParameter("newonly");
                            if (string12 != null && string12.equalsIgnoreCase("true")) {
                                String string13 = this.xmlGetChat(chatroomUser, httpSession);
                                return string13;
                            }
                            String string14 = this.xmlGetChat(chatroomUser);
                            return string14;
                        }
                        String string15 = this.xmlError(login.getSysMessage(), 1);
                        return string15;
                    }
                    String string16 = this.xmlError(String.valueOf(String.valueOf(this._$7047)).concat(" invalid or not found"), 2);
                    return string16;
                }
                if (string.equals("REFRESH") || string.equals("CHAT")) {
                    String string17 = this._$7053.execute(httpServletRequest, null, httpSession, null);
                    if (string17 == null) {
                        ChatroomUser chatroomUser = (ChatroomUser)httpSession.getValue(XMLConfig.USERSESSIONID);
                        String string18 = httpServletRequest.getParameter("newonly");
                        if (string18 != null && string18.equalsIgnoreCase("true")) {
                            String string19 = this.xmlGetChat(chatroomUser, httpSession);
                            return string19;
                        }
                        String string20 = this.xmlGetChat(chatroomUser);
                        return string20;
                    }
                    String string21 = this.xmlError(this._$7053.getSysMessage(httpSession), 3);
                    return string21;
                }
                if (string.equals("LOGOUT") || string.equals("QUIT")) {
                    this._$7053.execute(httpServletRequest, null, httpSession, null);
                    String string22 = this.xmlGetManager();
                    return string22;
                }
                String string23 = this.xmlError("Unknown action", 4);
                return string23;
            }
            String string24 = this.xmlError("todo parameter missing", 5);
            return string24;
        }
        catch (Exception exception) {
            String string = this.xmlError("Server Error", 0);
            return string;
        }
    }

    private String _$7075(Document document) {
        OutputFormat outputFormat = new OutputFormat("XML", this._$7048, true);
        outputFormat.setStandalone(false);
        outputFormat.setPreserveSpace(true);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setLineSeparator("\n");
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        try {
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
            stringWriter.close();
        }
        catch (IOException iOException) {
            this.trace(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass().getName()))).append(" ").append(iOException.getMessage()))));
        }
        return stringWriter.toString();
    }

    protected String xmlError(String string, int n) {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("ERROR", null, "error.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("ERROR");
        if (this._$7052 != null) {
            ProcessingInstruction processingInstruction = documentImpl.createProcessingInstruction("xml-stylesheet", String.valueOf(String.valueOf(new StringBuffer("type=\"text/xsl\" href=\"").append(this._$7052).append("\""))));
            documentImpl.appendChild(processingInstruction);
        }
        element.setAttribute("CODE", "".concat(String.valueOf(String.valueOf(n))));
        element.appendChild(documentImpl.createTextNode(string));
        documentImpl.appendChild(element);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetManager() {
        Object object;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("MANAGER", null, "manager.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("MANAGER");
        if (this._$7049 != null) {
            object = documentImpl.createProcessingInstruction("xml-stylesheet", String.valueOf(String.valueOf(new StringBuffer("type=\"text/xsl\" href=\"").append(this._$7049).append("\""))));
            documentImpl.appendChild((Node)object);
        }
        object = ChatroomManager.getInstance();
        Vector vector = ((ChatroomManager)object).getChatrooms();
        Chatroom chatroom = null;
        Element element2 = null;
        XMLPropertyResourceBundle xMLPropertyResourceBundle = null;
        for (int i = 0; i < vector.size(); ++i) {
            chatroom = (Chatroom)vector.elementAt(i);
            xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
            element2 = documentImpl.createElement("CHATROOM");
            element2.setAttribute("NAME", chatroom.getParams().getName());
            element2.setAttribute("ID", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getID()))));
            element2.setAttribute("SUBJECT", chatroom.getParams().getSubject());
            element2.setAttribute("MAXUSERS", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getMaxUsers()))));
            element2.setAttribute("TOTALUSERS", "".concat(String.valueOf(String.valueOf(chatroom.getTotalUsers()))));
            element2.setAttribute("LANGUAGE", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getLanguage()))));
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("login.date.format")).format(chatroom.getDate()));
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetLanguages() throws ChatException {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("LANGUAGES", null, "languages.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("LANGUAGES");
        element.setAttribute("DEFAULT", "".concat(String.valueOf(String.valueOf(XMLConfig.DEFAULTLANGUAGE))));
        Element element2 = null;
        Enumeration enumeration = XMLConfig.LANGUAGES.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            element2 = documentImpl.createElement("LANGUAGE");
            element2.setAttribute("NAME", string);
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetResource(String string) throws ChatException {
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(string);
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("RESOURCES", null, "resources.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("RESOURCES");
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Iterator iterator = xMLPropertyResourceBundle.getKeys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = xMLPropertyResourceBundle.getString(string2);
            element2 = documentImpl.createElement("ELEMENT");
            element3 = documentImpl.createElement("NAME");
            element3.appendChild(documentImpl.createTextNode(string2));
            element4 = documentImpl.createElement("VALUE");
            element4.appendChild(documentImpl.createTextNode(string3));
            element2.appendChild(element3);
            element2.appendChild(element4);
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetChatroom(int n) throws ChatException {
        Object object;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHATROOM", null, "chatroom.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("CHATROOM");
        if (this._$7051 != null) {
            object = documentImpl.createProcessingInstruction("xml-stylesheet", String.valueOf(String.valueOf(new StringBuffer("type=\"text/xsl\" href=\"").append(this._$7051).append("\""))));
            documentImpl.appendChild((Node)object);
        }
        object = ChatroomManager.getInstance();
        Chatroom chatroom = ((ChatroomManager)object).getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        Object var9_9 = null;
        element.setAttribute("NAME", chatroom.getParams().getName());
        element.setAttribute("ID", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getID()))));
        element.setAttribute("SUBJECT", chatroom.getParams().getSubject());
        element.setAttribute("MAXUSERS", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getMaxUsers()))));
        element.setAttribute("TOTALUSERS", "".concat(String.valueOf(String.valueOf(chatroom.getTotalUsers()))));
        element.setAttribute("LANGUAGE", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getLanguage()))));
        element.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("board.date.format")).format(chatroom.getDate()));
        documentImpl.appendChild(element);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetChat(ChatroomUser chatroomUser) throws ChatException {
        Node node;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHAT", null, "chat.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        if (this._$7050 != null) {
            node = documentImpl.createProcessingInstruction("xml-stylesheet", String.valueOf(String.valueOf(new StringBuffer("type=\"text/xsl\" href=\"").append(this._$7050).append("\""))));
            documentImpl.appendChild(node);
        }
        node = documentImpl.createElement("CHAT");
        Element element = null;
        Element element2 = null;
        int n = chatroomUser.getParams().getChatroom();
        String string = chatroomUser.getName();
        ChatroomManager chatroomManager = ChatroomManager.getInstance();
        Chatroom chatroom = chatroomManager.getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        node.setAttribute("ID", "".concat(String.valueOf(String.valueOf(n))));
        node.setAttribute("PRIVATEMSG", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getPrivateStatus()))));
        node.setAttribute("REFRESH", "".concat(String.valueOf(String.valueOf(chatroomUser.getParams().getRefresh()))));
        Vector vector = chatroom.getChat(string);
        Msg msg = null;
        int n2 = vector.size() - chatroom.getParams().getHistory();
        if (n2 < 0) {
            n2 = 0;
        }
        element = documentImpl.createElement("MSGS");
        for (int i = 0; n2 < vector.size() && i < chatroom.getParams().getHistory(); ++n2, ++i) {
            msg = (Msg)vector.elementAt(n2);
            element2 = documentImpl.createElement("MSG");
            element2.setAttribute("FROM", msg.getFrom());
            element2.setAttribute("TYPE", "".concat(String.valueOf(String.valueOf(msg.getType()))));
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format")).format(msg.getDate()));
            element2.appendChild(documentImpl.createTextNode(msg.getMsg()));
            element.appendChild(element2);
        }
        node.appendChild(element);
        Hashtable hashtable = chatroom.getUsers();
        ChatroomUser chatroomUser2 = null;
        Enumeration enumeration = hashtable.keys();
        String string2 = null;
        element = documentImpl.createElement("USERLIST");
        element.setAttribute("CURRENT", "".concat(String.valueOf(String.valueOf(chatroom.getTotalUsers()))));
        element.setAttribute("MAX", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getMaxUsers()))));
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            chatroomUser2 = (ChatroomUser)hashtable.get(string2);
            element2 = documentImpl.createElement("USER");
            element2.setAttribute("NAME", chatroomUser2.getName());
            element.appendChild(element2);
        }
        node.appendChild(element);
        documentImpl.appendChild(node);
        return this._$7075((Document)documentImpl);
    }

    protected String xmlGetChat(ChatroomUser chatroomUser, HttpSession httpSession) throws ChatException {
        Node node;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHAT", null, "chat.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$7054 ? new DocumentImpl(documentType) : new DocumentImpl();
        if (this._$7050 != null) {
            node = documentImpl.createProcessingInstruction("xml-stylesheet", String.valueOf(String.valueOf(new StringBuffer("type=\"text/xsl\" href=\"").append(this._$7050).append("\""))));
            documentImpl.appendChild(node);
        }
        node = documentImpl.createElement("CHAT");
        Element element = null;
        Element element2 = null;
        int n = chatroomUser.getParams().getChatroom();
        String string = chatroomUser.getName();
        ChatroomManager chatroomManager = ChatroomManager.getInstance();
        Chatroom chatroom = chatroomManager.getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        node.setAttribute("ID", "".concat(String.valueOf(String.valueOf(n))));
        node.setAttribute("PRIVATEMSG", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getPrivateStatus()))));
        node.setAttribute("REFRESH", "".concat(String.valueOf(String.valueOf(chatroomUser.getParams().getRefresh()))));
        Vector vector = chatroom.getChat(string);
        Msg msg = null;
        int n2 = vector.size() - chatroom.getParams().getHistory();
        Integer n3 = (Integer)httpSession.getValue("internallastindex");
        if (n3 != null && n3 > n2) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        element = documentImpl.createElement("MSGS");
        for (int i = 0; n2 < vector.size() && i < chatroom.getParams().getHistory(); ++n2, ++i) {
            msg = (Msg)vector.elementAt(n2);
            element2 = documentImpl.createElement("MSG");
            element2.setAttribute("FROM", msg.getFrom());
            element2.setAttribute("TYPE", "".concat(String.valueOf(String.valueOf(msg.getType()))));
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format")).format(msg.getDate()));
            element2.appendChild(documentImpl.createTextNode(msg.getMsg()));
            element.appendChild(element2);
        }
        n3 = new Integer(n2--);
        httpSession.putValue("internallastindex", (Object)n3);
        node.appendChild(element);
        Hashtable hashtable = chatroom.getUsers();
        ChatroomUser chatroomUser2 = null;
        Enumeration enumeration = hashtable.keys();
        String string2 = null;
        element = documentImpl.createElement("USERLIST");
        element.setAttribute("CURRENT", "".concat(String.valueOf(String.valueOf(chatroom.getTotalUsers()))));
        element.setAttribute("MAX", "".concat(String.valueOf(String.valueOf(chatroom.getParams().getMaxUsers()))));
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            chatroomUser2 = (ChatroomUser)hashtable.get(string2);
            element2 = documentImpl.createElement("USER");
            element2.setAttribute("NAME", chatroomUser2.getName());
            element.appendChild(element2);
        }
        node.appendChild(element);
        documentImpl.appendChild(node);
        return this._$7075((Document)documentImpl);
    }

    protected Login getLoginInstance(String string) {
        Login login = null;
        boolean bl = false;
        try {
            Class<?> clazz;
            for (Class<?> clazz2 = clazz = Class.forName(string); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (!clazz2.getName().equals("jChatBox.Service.Login")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.trace(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass().getName()))).append(" Error : Login implementation not found in ").append(string).append(" hierarchy"))));
            } else {
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                login = (Login)constructor.newInstance(null);
                this.trace(0, String.valueOf(String.valueOf(new StringBuffer("").append(this.getClass().getName()).append(" ").append(string).append(" loaded"))));
            }
        }
        catch (Exception exception) {
            this.trace(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass().getName()))).append(" Error : ").append(string).append(" : ").append(exception.getMessage()))));
        }
        return login;
    }

    protected void trace(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

