/*
 * Decompiled with CFR 0.152.
 */
import com.standbysoft.datepicker.DateSelectionModel;
import com.standbysoft.datepicker.DefaultDateSelectionModel;
import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;
import com.standbysoft.datepicker.event.DateSelectionListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisableSelectionDemo
extends JPanel {
    private JComboBox disableTypeComboBox;
    private JMonthView monthView;
    private JDatePicker datePicker;
    private JToggleButton toggleButton;
    private JLabel disableTypeLabel;
    private NoWeekendDateSelectionModel noWeekendSelectionModel;
    private ThisWeekOnlyDateSelectionModel thisWeekSelectionModel;
    private DefaultDateSelectionModel defaultSelectionModel = new DefaultDateSelectionModel();

    public DisableSelectionDemo() {
        this.noWeekendSelectionModel = new NoWeekendDateSelectionModel();
        this.thisWeekSelectionModel = new ThisWeekOnlyDateSelectionModel();
        this.monthView = new JMonthView();
        this.datePicker = new JDatePicker();
        this.toggleButton = new JToggleButton("Change disable state for dates");
        this.disableTypeLabel = new JLabel("Days to be disabled:");
        this.disableTypeComboBox = new JComboBox<String>(new String[]{"Disable weekends", "Keep only this week", "Disable at your choice"});
        this.toggleButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DisableSelectionDemo.this.disableTypeComboBox.setEnabled(!DisableSelectionDemo.this.toggleButton.isSelected());
            }
        });
        this.monthView.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                if (DisableSelectionDemo.this.toggleButton.isSelected()) {
                    Date[] dateArray = DisableSelectionDemo.this.defaultSelectionModel.getSelectedDates();
                    int n = 0;
                    while (n < dateArray.length) {
                        DisableSelectionDemo.this.defaultSelectionModel.addDisabled(dateArray[n]);
                        ++n;
                    }
                }
            }
        });
        this.disableTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = DisableSelectionDemo.this.disableTypeComboBox.getSelectedIndex();
                if (itemEvent.getStateChange() == 1) {
                    if (n == 0) {
                        DisableSelectionDemo.this.monthView.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.noWeekendSelectionModel);
                        DisableSelectionDemo.this.datePicker.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.noWeekendSelectionModel);
                        DisableSelectionDemo.this.toggleButton.setVisible(false);
                    } else if (n == 1) {
                        DisableSelectionDemo.this.monthView.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.thisWeekSelectionModel);
                        DisableSelectionDemo.this.datePicker.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.thisWeekSelectionModel);
                        DisableSelectionDemo.this.toggleButton.setVisible(false);
                    } else if (n == 2) {
                        DisableSelectionDemo.this.monthView.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.defaultSelectionModel);
                        DisableSelectionDemo.this.datePicker.setDateSelectionModel((DateSelectionModel)DisableSelectionDemo.this.defaultSelectionModel);
                        DisableSelectionDemo.this.toggleButton.setVisible(true);
                    }
                }
            }
        });
        this.disableTypeComboBox.setSelectedIndex(2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 7);
        this.datePicker.setSelectedDate(calendar.getTime());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.monthView, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.datePicker, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.disableTypeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.disableTypeComboBox, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(""), new GridBagConstraints(4, 0, 1, 4, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.toggleButton, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(""), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("MonthViewDisableSelectionDemo");
        jFrame.setDefaultCloseOperation(3);
        DisableSelectionDemo disableSelectionDemo = new DisableSelectionDemo();
        disableSelectionDemo.setOpaque(true);
        jFrame.setContentPane(disableSelectionDemo);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DisableSelectionDemo.createAndShowGUI();
            }
        });
    }
}

