/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ProcessorInclude
extends XSLTElementProcessor {
    private String m_href = null;

    ProcessorInclude() {
    }

    public String getHref() {
        return this.m_href;
    }

    public void setHref(String baseIdent) {
        this.m_href = baseIdent;
    }

    protected int getStylesheetType() {
        return 2;
    }

    protected int getStylesheetInclErr() {
        return 39;
    }

    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        this.setPropertiesFromAttributes(handler, rawName, attributes, this);
        try {
            String hrefUrl = SystemIDResolver.getAbsoluteURI(this.getHref(), handler.getBaseIdentifier());
            if (handler.importStackContains(hrefUrl)) {
                throw new SAXException(XSLMessages.createMessage(this.getStylesheetInclErr(), new Object[]{hrefUrl}));
            }
            handler.pushImportURL(hrefUrl);
            int savedStylesheetType = handler.getStylesheetType();
            handler.setStylesheetType(this.getStylesheetType());
            handler.pushNewNamespaceSupport();
            try {
                this.parse(handler, uri, localName, rawName, attributes);
                Object var9_9 = null;
                handler.setStylesheetType(savedStylesheetType);
                handler.popImportURL();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                handler.setStylesheetType(savedStylesheetType);
                handler.popImportURL();
                handler.popNamespaceSupport();
                throw throwable;
            }
            handler.popNamespaceSupport();
            {
            }
        }
        catch (TransformerException te) {
            handler.error(te.getMessage(), te);
        }
    }

    protected void parse(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        block20: {
            TransformerFactoryImpl processor = handler.getStylesheetProcessor();
            URIResolver uriresolver = processor.getURIResolver();
            try {
                Source source = null;
                if (null != uriresolver && null != (source = uriresolver.resolve(this.getHref(), handler.getBaseIdentifier())) && source instanceof DOMSource) {
                    Node node = ((DOMSource)source).getNode();
                    TreeWalker walker = new TreeWalker(handler, new DOM2Helper(), source.getSystemId());
                    try {
                        walker.traverse(node);
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                    return;
                }
                if (null == source) {
                    String absURL = SystemIDResolver.getAbsoluteURI(this.getHref(), handler.getBaseIdentifier());
                    source = new StreamSource(absURL);
                }
                XMLReader reader = null;
                if (source instanceof SAXSource) {
                    SAXSource saxSource = (SAXSource)source;
                    reader = saxSource.getXMLReader();
                }
                boolean isUserReader = reader != null;
                InputSource inputSource = SAXSource.sourceToInputSource(source);
                if (null == reader) {
                    try {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        SAXParser jaxpParser = factory.newSAXParser();
                        reader = jaxpParser.getXMLReader();
                    }
                    catch (ParserConfigurationException ex) {
                        throw new SAXException(ex);
                    }
                    catch (FactoryConfigurationError ex1) {
                        throw new SAXException(ex1.toString());
                    }
                    catch (NoSuchMethodError ex2) {
                    }
                    catch (AbstractMethodError ame) {
                        // empty catch block
                    }
                }
                if (null == reader) {
                    reader = XMLReaderFactory.createXMLReader();
                }
                if (null == reader) break block20;
                reader.setContentHandler(handler);
                try {
                    if (!isUserReader) {
                        reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    }
                }
                catch (SAXException se) {
                    // empty catch block
                }
                handler.pushBaseIndentifier(inputSource.getSystemId());
                try {
                    reader.parse(inputSource);
                    Object var17_25 = null;
                    handler.popBaseIndentifier();
                }
                catch (Throwable throwable) {
                    Object var17_26 = null;
                    handler.popBaseIndentifier();
                    throw throwable;
                }
                {
                }
            }
            catch (IOException ioe) {
                handler.error(37, new Object[]{this.getHref()}, ioe);
            }
            catch (TransformerException te) {
                handler.error(te.getMessage(), te);
            }
        }
    }
}

