<%
    ' This file is provided as part of ASP Power Widgets Samples
    '
    ' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT
    ' WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    ' INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
    ' OF MERCHANTABILITY AND/OR FITNESS FOR A  PARTICULAR
    ' PURPOSE.

    ' Copyright 1998-2002. All rights reserved.
    ' Dalun Software Inc. ASP Power Widgets
    ' http://dalun.com 
    ' mail: sales@dalun.com
    ' mail: techsupport@dalun.com
    ' if you have any suggestions or requirements, please write to us.
    ' Revisions:
    ' 2.0.0   Initial release
%>

<%
    CONST APP_VDIR = "/POP3"
    CONST ATTACHMENTS_TEMP_ROOT_FOLDER_URL = "http://#WEBSERVER#:#WEBPORT#/pop3/temp/"
     
    CONST SEGMENT_SIZE = 32
    
    CONST ERR_TIMEOUT       =       &H80400082
    CONST ERR_NOSESSION     =       &H80400081
    CONST ERR_INVALIDTICKET =       &H80400080
    CONST ERR_TOOMANYCONNECTIONS =  &H80400083 
    CONST ERR_INVALIDRESPONSE    =  &H80400084 
    CONST ERR_ERRRETURNEDFROMHOST=  &H80400085 
    
    CONST ERR_WAITTIMEOUT   =       &H80070102
    CONST ERR_LOGONFAILURE  =       &H80004005 
    CONST ERR_UNKNOW_HOST   =       &H80002AF9 
    CONST ERR_WSAETIMEDOUT  =       &H80002746                              
    CONST ERR_WSAECONNRESET  =      &H8000274C 
    CONST ERR_WSAECONNABORTED  =    &H80002745 
    CONST ERR_WSAECONNREFUSED  =    &H8000274D 

    Function ATTACHMENTS_TEMP_ROOT_FOLDER 
       ATTACHMENTS_TEMP_ROOT_FOLDER = Server.MapPath(APP_VDIR & "/temp") & "\"
    End function

    Function InitializeApp()    
        Dim strSig        
        On Error Resume Next
        strSig = Application("MY_APP_SIG")    
        If strSig = "" Then
            Set oPOP3 = Server.CreateObject("ASPPW.POP3.1")
            If Err = 0 Then
                'oPOP3.RegistrationCode = "Put your code here."   
                Application.Lock                 
                Set Application("oPOP3") = oPOP3 
                Application("MY_APP_SIG") = "COOL"
                Application.Unlock
            End if    
            Response.write "<!-- Application initialized. -->"
        End if
    End Function

    Function LogOut
        Dim objPOP3, strTicket 
        Set objPOP3 = GetPop3Object()
        strTicket = GetTicket()
        If Len(strTicket) > 0 Then
            objPOP3.LogOut strTicket
            InvalidateTicket
        End if
    End Function

    Function InvalidateTicket
        DelSetting "Ticket"
    End Function

    Function GetCachedXMLDOM(strFile)
        Dim strSig, bLoaded
        strSig = Application(strFile & "XMLSIG")
        If strSig = "" Then        
            Dim oDOM
            Set oDOM = Server.CreateObject("MSXML2.FreeThreadedDOMDocument")
            oDOM.async = false 
            bLoaded = oDOM.load(strFile)
            If bLoaded Then
                Application.Lock
                Set Application(strFile) = oDOM 
                Application(strFile & "XMLSIG") = "COOL"            
                Application.Unlock
                Set GetCachedXMLDOM = oDOM
            Else
                Response.write "Unable to load XML file " & strFile
                Set GetCachedXMLDOM = Nothing
            End if    
        Else
            Set GetCachedXMLDOM = Application(strFile)   
        End if    
    End Function

    Function GetPop3Object()
        Server.ScriptTimeout = 600 
        strSig = Application("MY_APP_SIG")
        If strSig <> "COOL" Then
            Response.Redirect "Logon.asp"
        End If
        Set GetPop3Object = Application("oPOP3")
    End Function
 
    Function GetTicket()
       Dim strTicke
       Dim oPop3
       strTicket = Request.Cookies("Ticket")
       If Len(strTicket) = 0 Then
            Server.Transfer "Logon.asp"
            Response.End                     
       End if 
       Set oPOP3 = GetPop3Object() 
       strTicket = oPop3.RefreshTicket(strTicket)
       SetTicket(strTicket)      
       GetTicket = strTicket      
    End Function
    
    Function SetTicket(strTicket)
        Response.Cookies("Ticket") = strTicket 
    End function
    
    Function GetErrorMessage(ErrObj)
        Dim sDes
        sDes = ErrObj.Description
        
        Select case ErrObj.number  
        case ERR_TIMEOUT      
            GetErrorMessage = "The host(your POP3 server) is not responding timely. <!--ERR_TIMEOUT-->" & sDes
        case ERR_WAITTIMEOUT      
            GetErrorMessage = "The host(your POP3 server) is not responding timely. " & sDes
        case ERR_NOSESSION
            GetErrorMessage = "There is no connection in cache for this ticket, please <A href=""logon.asp"">logon</A> again. " & sDes
        case ERR_INVALIDTICKET
            GetErrorMessage = "Invalid ticket, please <A href=""logon.asp"">logon</A> again. " & sDes
        case ERR_TOOMANYCONNECTIONS
            GetErrorMessage = "Service is unavailable now due to too many connections, please wait for a while to try again. " & sDes   
        case ERR_INVALIDRESPONSE 
            GetErrorMessage = "Unexpected response from the host(your POP3 server). " & sDes
        case ERR_ERRRETURNEDFROMHOST
            GetErrorMessage = "The host(your POP3 server) returns an error for your request. " & sDes        
        case ERR_UNKNOW_HOST
            GetErrorMessage = "The host(your POP3 server) is an unknown host. " & sDes
        case ERR_LOGONFAILURE
            GetErrorMessage = "Invalid account credential. " & sDes
        case ERR_WSAETIMEDOUT
            GetErrorMessage = "The connected host(your POP3 server) has failed to respond. " & sDes
        case ERR_WSAECONNABORTED
            GetErrorMessage = "An established connection was aborted by The host(your POP3 server). " & sDes 
        case ERR_WSAECONNRESET
            GetErrorMessage = "An existing connection was forcibly closed by the remote host(your POP3 server). " & sDes 
        case ERR_WSAECONNREFUSED
            GetErrorMessage = "No connection could be made because the target machine actively refused it." & sDes
        case else
            GetErrorMessage = "Error: 0x" & Hex(ErrObj.number) & ". " & sDes   
        End Select    
    End function
    
    Function CheckTimeout()    
        If Err = ERR_TIMEOUT OR Err = ERR_NOSESSION then 'Session timeout.
            Server.Transfer "Logon.asp"
            Response.End 
        End If
    End function

    Function GetAccountFromEmail(strEmail)    
        Dim i
        i = Instr(1, strEmail, "@")
        If i > 0 Then
            GetAccountFromEmail = Left(strEmail, i-1)
        Else
            GetAccountFromEmail = strEmail
        End if
    End function

    Function GetSegSize()
        Dim iSegSize
        Dim iSegNum
        On Error resume next
        iSegSize = CInt(GetSetting("SegSize"))
        iSegNum = CInt(GetSetting("SegNum"))
        On Error goto 0
        If iSegSize <= 0 or iSegNum < 0 Then
            iSegSize = SEGMENT_SIZE
            iSegNum = 0
        End If
        GetSegSize = iSegSize
    End function

    Function GetSegNum()
        Dim iSegSize
        Dim iSegNum
        On Error resume next
        iSegSize = CInt(GetSetting("SegSize"))
        iSegNum = CInt(GetSetting("SegNum"))
        On Error goto 0
        If iSegSize <= 0 or iSegNum < 0 Then
            iSegSize = SEGMENT_SIZE
            iSegNum = 0
        End If
        GetSegNum = iSegNum
    End function

    'Cookie functions
    Function SetSetting(strName, strValue)
        Response.Cookies(strName) = strValue         
    End function

    Function GetSetting(strName)
        Dim strValue
        If Len(Request.QueryString(strName)) <> 0 Then
            GetSetting = Request.QueryString(strName)
        ElseIf Len(Request.Cookies(strName)) <> 0 Then          
            GetSetting = Request.Cookies(strName)                 
        End if
    End function

    Function DelSetting(strName)
        Response.Cookies(strName) = ""
        Response.Cookies(strName).Expires = #Jan 1,1998#        
    End function

    Function ValidateLen(ByRef strInput, iMin, iMax)
        Dim iLen
        iLen = len(strInput)
        ValidateLen = (iLen >= iMin and iLen <= iMax )
    End function

    Function BeginPage()
        Response.write "<HTML><HEAD><TITLE>POP3 Mailbox Web Access</TITLE><LINK rel=""stylesheet"" href=""./images/mail.css""></HEAD><BODY>"
    End Function

    Function EndPage()
        Response.write "</BODY></HTML>"
    End Function
%>    
   
