/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "SliderUI";
    private boolean paintTicks = false;
    private boolean paintTrack = true;
    private boolean paintLabels = false;
    private boolean isInverted = false;
    private boolean nonValueChange = false;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks = false;
    boolean snapToValue = true;
    protected int orientation;
    private Dictionary labelTable;
    protected ChangeListener changeListener = this.createChangeListener();
    protected transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int n) {
        this(n, 0, 100, 50);
    }

    public JSlider(int n, int n2) {
        this(0, n, n2, 50);
    }

    public JSlider(int n, int n2, int n3) {
        this(0, n, n2, n3);
    }

    public JSlider(int n, int n2, int n3, int n4) {
        this.checkOrientation(n);
        this.orientation = n;
        this.sliderModel = new DefaultBoundedRangeModel(n4, 0, n2, n3);
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider(BoundedRangeModel boundedRangeModel) {
        this.orientation = 0;
        this.setModel(boundedRangeModel);
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = JSlider.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public Hashtable createStandardLabels(int n) {
        return this.createStandardLabels(n, this.getMinimum());
    }

    public Hashtable createStandardLabels(int n, int n2) {
        if (n2 > this.getMaximum() || n2 < this.getMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Label incremement must be > 0");
        }
        class SmartHashtable
        extends Hashtable
        implements PropertyChangeListener {
            private final /* synthetic */ JSlider this$0;
            int increment;
            int start;
            boolean startAtMin;

            public SmartHashtable(JSlider jSlider, int n, int n2) {
                this.this$0 = jSlider;
                this.increment = 0;
                this.start = 0;
                this.startAtMin = false;
                this.increment = n;
                this.start = n2;
                this.startAtMin = n2 == jSlider.getMinimum();
                this.createLabels();
            }

            void createLabels() {
                int n = this.start;
                while (n <= this.this$0.getMaximum()) {
                    this.put(new Integer(n), new 1.SmartHashtable.LabelUIResource(this, String.valueOf(n), 0));
                    n += this.increment;
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("minimum") && this.startAtMin) {
                    this.start = this.this$0.getMinimum();
                }
                if (propertyChangeEvent.getPropertyName().equals("minimum") || propertyChangeEvent.getPropertyName().equals("maximum")) {
                    Enumeration<K> enumeration = this.this$0.getLabelTable().keys();
                    K k = null;
                    Hashtable<K, V> hashtable = new Hashtable<K, V>();
                    while (enumeration.hasMoreElements()) {
                        k = enumeration.nextElement();
                        V v = this.this$0.getLabelTable().get(k);
                        if (v instanceof 1.SmartHashtable.LabelUIResource) continue;
                        hashtable.put(k, v);
                    }
                    this.clear();
                    this.createLabels();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        k = enumeration.nextElement();
                        this.put(k, hashtable.get(k));
                    }
                    ((JSlider)propertyChangeEvent.getSource()).setLabelTable(this);
                }
            }
        }
        SmartHashtable smartHashtable = new SmartHashtable(this, n, n2);
        if (this.getLabelTable() != null && this.getLabelTable() instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)this.getLabelTable()));
        }
        this.addPropertyChangeListener(smartHashtable);
        return smartHashtable;
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : JSlider.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    public int getExtent() {
        return this.getModel().getExtent();
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    boolean getSnapToValue() {
        return this.snapToValue;
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    protected String paramString() {
        String string = this.paintTicks ? "true" : "false";
        String string2 = this.paintTrack ? "true" : "false";
        String string3 = this.paintLabels ? "true" : "false";
        String string4 = this.isInverted ? "true" : "false";
        String string5 = this.snapToTicks ? "true" : "false";
        String string6 = this.snapToValue ? "true" : "false";
        String string7 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return String.valueOf(super.paramString()) + ",isInverted=" + string4 + ",majorTickSpacing=" + this.majorTickSpacing + ",minorTickSpacing=" + this.minorTickSpacing + ",orientation=" + string7 + ",paintLabels=" + string3 + ",paintTicks=" + string + ",paintTrack=" + string2 + ",snapToTicks=" + string5 + ",snapToValue=" + string6;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = JSlider.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void setExtent(int n) {
        this.getModel().setExtent(n);
    }

    public void setInverted(boolean bl) {
        boolean bl2 = this.isInverted;
        this.isInverted = bl;
        this.firePropertyChange("inverted", bl2, this.isInverted);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public void setLabelTable(Dictionary dictionary) {
        Dictionary dictionary2 = this.labelTable;
        this.labelTable = dictionary;
        this.updateLabelUIs();
        this.firePropertyChange("labelTable", dictionary2, this.labelTable);
        if (dictionary != dictionary2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMajorTickSpacing(int n) {
        int n2 = this.majorTickSpacing;
        this.majorTickSpacing = n;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", n2, this.majorTickSpacing);
        if (this.majorTickSpacing != n2 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public void setMaximum(int n) {
        int n2 = this.getModel().getMaximum();
        this.getModel().setMaximum(n);
        this.firePropertyChange("maximum", new Integer(n2), new Integer(n));
    }

    public void setMinimum(int n) {
        int n2 = this.getModel().getMinimum();
        this.getModel().setMinimum(n);
        this.firePropertyChange("minimum", new Integer(n2), new Integer(n));
    }

    public void setMinorTickSpacing(int n) {
        int n2 = this.minorTickSpacing;
        this.minorTickSpacing = n;
        this.firePropertyChange("minorTickSpacing", n2, this.minorTickSpacing);
        if (this.minorTickSpacing != n2 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this.changeListener);
        }
        this.sliderModel = boundedRangeModel;
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : new Integer(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : new Integer(boundedRangeModel.getValue()));
            }
        }
        this.firePropertyChange("model", boundedRangeModel2, this.sliderModel);
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        if (n2 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n != n2) {
            this.revalidate();
        }
    }

    public void setPaintLabels(boolean bl) {
        boolean bl2 = this.paintLabels;
        this.paintLabels = bl;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", bl2, this.paintLabels);
        if (this.paintLabels != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setPaintTicks(boolean bl) {
        boolean bl2 = this.paintTicks;
        this.paintTicks = bl;
        this.firePropertyChange("paintTicks", bl2, this.paintTicks);
        if (this.paintTicks != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setPaintTrack(boolean bl) {
        boolean bl2 = this.paintTrack;
        this.paintTrack = bl;
        this.firePropertyChange("paintTrack", bl2, this.paintTrack);
        if (this.paintTrack != bl2) {
            this.repaint();
        }
    }

    public void setSnapToTicks(boolean bl) {
        boolean bl2 = this.snapToTicks;
        this.snapToTicks = bl;
        this.firePropertyChange("snapToTicks", bl2, this.snapToTicks);
    }

    void setSnapToValue(boolean bl) {
        boolean bl2 = this.snapToValue;
        this.snapToValue = bl;
        this.firePropertyChange("snapToValue", bl2, this.snapToValue);
    }

    public void setUI(SliderUI sliderUI) {
        super.setUI(sliderUI);
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n2), new Integer(boundedRangeModel.getValue()));
        }
    }

    public void setValueIsAdjusting(boolean bl) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl2 = boundedRangeModel.getValueIsAdjusting();
        this.nonValueChange = true;
        boundedRangeModel.setValueIsAdjusting(bl);
        this.nonValueChange = false;
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    protected void updateLabelUIs() {
        if (this.getLabelTable() == null) {
            return;
        }
        Enumeration enumeration = this.getLabelTable().keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.getLabelTable().get(enumeration.nextElement());
            if (!(v instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)v;
            jComponent.updateUI();
            jComponent.setSize(jComponent.getPreferredSize());
        }
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!JSlider.this.nonValueChange) {
                JSlider.this.fireStateChanged();
            }
        }
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJSlider() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSlider.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JSlider.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSlider.this.getValue());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSlider.this.getMaximum());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSlider.this.getMinimum());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JSlider.this.setValue(number.intValue());
                return true;
            }
            return false;
        }
    }
}

