/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.ByteCode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import uk.co.visualisationsystems.QuickFire.ByteCode.ClassBuilder;
import uk.co.visualisationsystems.QuickFire.ByteCode.ConstantPoolEntry;

public class ConstantPool {
    private ClassBuilder classBuilder;
    Vector vector;

    ConstantPool(ClassBuilder classBuilder) {
        this.classBuilder = classBuilder;
        this.vector = new Vector();
    }

    int getIndex(ConstantPoolEntry constantPoolEntry) {
        int n = this.vector.indexOf(constantPoolEntry);
        if (n == -1) {
            System.out.println("ConstantPool.getIndex() entry=" + constantPoolEntry);
        } else {
            ++n;
        }
        return n;
    }

    ConstantPoolEntry getExistingEntry(ConstantPoolEntry constantPoolEntry) {
        int n = this.vector.indexOf(constantPoolEntry);
        ConstantPoolEntry constantPoolEntry2 = n != -1 ? (ConstantPoolEntry)this.vector.elementAt(n) : null;
        return constantPoolEntry2;
    }

    void addEntry(ConstantPoolEntry constantPoolEntry) {
        if (this.getExistingEntry(constantPoolEntry) == null) {
            this.vector.addElement(constantPoolEntry);
        } else {
            System.out.println("addEntry() - ignoring duplicate constant");
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.vector.size();
        dataOutputStream.writeShort(n + 1);
        int n2 = 0;
        while (n2 < n) {
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.vector.elementAt(n2);
            constantPoolEntry.write(dataOutputStream);
            ++n2;
        }
    }
}

