#include "h.h"
#include "blist.hh"
#include <stdio.h>
#include "win\h2.h"
#include "win\listview.hh"
#ifndef __MINGW32__
#include <commctrl.h>
#endif

const int LIST_BLOCKED = 1;
const int LIST_HOST = 2;
const int LIST_PORT = 3;
const int LIST_PATH = 4;
const int LIST_BODY = 5;
const int LIST_MAX = 5;

void ListInitialize()
{
   hlst = CreateWindow(WC_LISTVIEW, "list",
		       WS_VISIBLE | WS_CHILD | WS_VSCROLL | 
		       LVS_NOLABELWRAP | LVS_SINGLESEL | LVS_REPORT,
		       0, 0, 400, 300,
		       hwnd, NULL, hInstance, NULL);
   
   HIMAGELIST hil = ImageList_Create(GetSystemMetrics(SM_CXSMICON),
				     GetSystemMetrics(SM_CYSMICON),
				     TRUE, 1, 1);
   HICON hi = LoadIcon(NULL, IDI_HAND);
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_EXCLAMATION);
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   ListView_SetImageList(hlst, hil, LVSIL_SMALL);
   
   LV_COLUMN lvc;
   lvc.mask = LVCF_FMT | LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH;
   lvc.fmt = LVCFMT_LEFT;
   lvc.cx = GetSystemMetrics(SM_CXSMICON)+3;

   lvc.pszText = "";
   lvc.iSubItem = 0;
   ListView_InsertColumn(hlst, 0, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_RIGHT;   
   lvc.iSubItem = LIST_BLOCKED;
   lvc.pszText = "Blocked";
   ListView_InsertColumn(hlst, LIST_BLOCKED, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_LEFT;   
   lvc.iSubItem = LIST_HOST;
   lvc.pszText = "Hostname";
   ListView_InsertColumn(hlst, LIST_HOST, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_RIGHT;   
   lvc.iSubItem = LIST_PORT;
   lvc.pszText = "Port";
   ListView_InsertColumn(hlst, LIST_PORT, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_LEFT;   
   lvc.iSubItem = LIST_PATH;
   lvc.pszText = "Path";
   ListView_InsertColumn(hlst, LIST_PATH, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_LEFT;   
   lvc.iSubItem = LIST_BODY;
   lvc.pszText = "Body";
   ListView_InsertColumn(hlst, LIST_BODY, &lvc);
   
   set_fullrow(hlst);
}

void ListResize()
{
   for (int i = 0; i <= LIST_MAX; i++) {
      ListView_SetColumnWidth(hlst, i, LVSCW_AUTOSIZE);
      int c1 = ListView_GetColumnWidth(hlst, i);
      ListView_SetColumnWidth(hlst, i, LVSCW_AUTOSIZE_USEHEADER);
      int c2 = ListView_GetColumnWidth(hlst, i);
      if (c2 < c1)
	 ListView_SetColumnWidth(hlst, i, c1);
   }
}

void ListSetItem(int idx, int access, const char *host, const char *path, int port, const char *body)
{
   LV_ITEM lvi;
   lvi.mask = 0;
   lvi.iItem = idx;
   bool ret = ListView_GetItem(hlst, &lvi);
   if (!ret)
     ListView_DeleteItem(hlst, idx);

   lvi.mask = LVIF_TEXT | LVIF_STATE | LVIF_IMAGE;
   lvi.iItem = idx;
   lvi.state = 0;
   lvi.stateMask = 0;
   lvi.iSubItem = 0;
   lvi.iImage = access ? 0 : 1;
//   sprintf(s, "%i.", idx);
   lvi.pszText = "";
   if (ret)
     ListView_SetItem(hlst, &lvi);
   else
     ListView_InsertItem(hlst, &lvi); 
   
   lvi.mask = LVIF_TEXT | LVIF_STATE;

   char s[100];
   sprintf(s, "%i", access);
   lvi.pszText = s;
   lvi.iSubItem = LIST_BLOCKED;
   ListView_SetItem(hlst, &lvi);
   
   lvi.iSubItem = LIST_HOST;
   lvi.pszText = (char *) host;
   ListView_SetItem(hlst, &lvi);
   
   lvi.pszText = (char *) path;
   lvi.iSubItem = LIST_PATH;
   ListView_SetItem(hlst, &lvi);

   if (!port || port == 80)
     lvi.pszText = "";
   else {
      sprintf(s, "%i", port);
      lvi.pszText = s;
   }
   lvi.iSubItem = LIST_PORT;
   ListView_SetItem(hlst, &lvi);
  
   lvi.pszText = (char *) body;
   lvi.iSubItem = LIST_BODY;
   ListView_SetItem(hlst, &lvi);
}

void ListClear()
{
   ListView_DeleteAllItems(hlst);
}
