VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{28FDFE2B-68C4-11D4-92BF-8364E6807441}#6.0#0"; "SCGRID.OCX"
Begin VB.Form frmProducts 
   Caption         =   "Northwind Products"
   ClientHeight    =   3810
   ClientLeft      =   1965
   ClientTop       =   3105
   ClientWidth     =   8805
   LinkTopic       =   "Form1"
   ScaleHeight     =   3810
   ScaleWidth      =   8805
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   360
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   8805
      _ExtentX        =   15531
      _ExtentY        =   635
      ButtonWidth     =   2408
      ButtonHeight    =   582
      Appearance      =   1
      Style           =   1
      TextAlignment   =   1
      ImageList       =   "iml16"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   4
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "New product "
            Key             =   "newrow"
            Object.ToolTipText     =   "New product"
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Delete      "
            Key             =   "delete"
            Object.ToolTipText     =   "Delete row"
            ImageIndex      =   2
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Cancel      "
            Key             =   "cancel"
            Object.ToolTipText     =   "Cancel edit"
            ImageIndex      =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Refresh      "
            Key             =   "refresh"
            Object.ToolTipText     =   "Refresh grid"
            ImageIndex      =   4
         EndProperty
      EndProperty
      Begin VB.CommandButton cmdQuit 
         Caption         =   "&Quit"
         Height          =   300
         Left            =   6120
         TabIndex        =   5
         Top             =   15
         Width           =   1335
      End
   End
   Begin MSComctlLib.ImageList iml16 
      Left            =   5640
      Top             =   2940
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   5
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmProducts.frx":0000
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmProducts.frx":015C
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmProducts.frx":02B8
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmProducts.frx":0414
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmProducts.frx":0570
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.TextBox Text1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0FFFF&
      Height          =   495
      Left            =   3480
      MultiLine       =   -1  'True
      TabIndex        =   3
      Text            =   "frmProducts.frx":08C4
      Top             =   3000
      Visible         =   0   'False
      Width           =   1215
   End
   Begin MSComctlLib.ProgressBar prgBar1 
      Height          =   240
      Left            =   30
      TabIndex        =   2
      Top             =   3540
      Visible         =   0   'False
      Width           =   1395
      _ExtentX        =   2461
      _ExtentY        =   423
      _Version        =   393216
      Appearance      =   0
      Scrolling       =   1
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   1
      Top             =   3495
      Width           =   8805
      _ExtentX        =   15531
      _ExtentY        =   556
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   2
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   8643
            MinWidth        =   8643
         EndProperty
      EndProperty
   End
   Begin prjSCGrid.SCGrid SCGrid1 
      Height          =   2895
      Left            =   0
      TabIndex        =   0
      Top             =   360
      Width           =   8775
      _ExtentX        =   15478
      _ExtentY        =   5106
      DefaultHeight   =   19
      DefaultWidth    =   100
      Cols            =   10
      FixedCols       =   1
      FixedRows       =   1
      BackColor       =   -2147483636
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      UseMask         =   2
      MaskColor       =   12632256
      ShowSplit       =   -1  'True
      SelectMode      =   0
      Redraw          =   0   'False
      VSCCode         =   99999999
   End
   Begin VB.Image imgCoche 
      Height          =   270
      Left            =   1080
      Picture         =   "frmProducts.frx":08CA
      Top             =   3300
      Visible         =   0   'False
      Width           =   405
   End
End
Attribute VB_Name = "frmProducts"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private cn As New ADODB.Connection
Private rs As New ADODB.Recordset

Private blnNewRow As Boolean
Private blnFieldChanged As Boolean
Private blnError As Boolean


Private Sub cmdQuit_Click()

Dim iRow As Integer
    
    With SCGrid1
        iRow = .CurrentRow
        
        If blnFieldChanged Then
            If continueMaj(iRow) Then Exit Sub
        End If
    End With
    Unload Me
End Sub

Private Sub Form_Load()
    
    If Not initDatabase Then Exit Sub
    initGrid
    initVariables
    
    SCGrid1.ADORefresh
    SCGrid1.Redraw = True
    
    StatusBar1.Panels(2).Text = SCGrid1.Rows & " product(s)"
End Sub

Private Sub Form_Resize()

    If WindowState = vbMinimized Then Exit Sub
    
    SCGrid1.Width = Width - 140
    SCGrid1.Height = Height - SCGrid1.Top - 715
End Sub

Private Sub Form_Unload(Cancel As Integer)
    
    If rs.State = adStateOpen Then rs.Close
    If cn.State = adStateOpen Then cn.Close
    Set rs = Nothing
    Set cn = Nothing
End Sub

Private Sub SCGrid1_AfterEdit(ByVal Row As Integer, ByVal Col As Integer)
    
    blnError = Not validateFields(Row, Col)
End Sub

Private Sub SCGrid1_BeforeEdit(ByVal Row As Integer, ByVal Col As Integer)

    Set SCGrid1.CellPicture(Row, -1) = imgCoche.Picture
End Sub

Private Sub SCGrid1_CellChange(ByVal Row As Integer, ByVal Col As Integer, bCancel As Boolean)

Dim CRow As Integer

    ' after this event CurrentRow will become the previous row
    ' and Row the new current row
    
    With SCGrid1
        CRow = SCGrid1.CurrentRow
        
        If CRow = Row Then
            If Col < 0 Then
                If Not .CellPicture(Row, -1) Is Nothing Then
                    If Not blnError Then
                    ' row is validated
                        Set .CellPicture(Row, -1) = Nothing
                        .CurrentCol = 1
                        Exit Sub
                    End If
                End If
            End If
        Else
            If blnError Then
                bCancel = True
                Exit Sub
            End If
            If CRow >= 0 Then Set .CellPicture(CRow, -1) = Nothing
        End If
        
        If Row >= 0 And Col < 0 Then
            .CurrentPos Row, 1
            .EnterEdit
        End If
    End With
End Sub

Private Sub SCGrid1_CellClick(ByVal Row As Integer, ByVal Col As Integer)
    
    ' sort rows by the specified column
    If Row = -1 And (Col = 1 Or Col = 2 Or Col = 5 Or Col = 10) Then
        If Not blnFieldChanged Then
            If SCGrid1.CurrentRow >= 0 Then _
                Set SCGrid1.CellPicture(SCGrid1.CurrentRow, -1) = Nothing
            If SCGrid1.SortCriteria(Col) = scAsc Then
                SCGrid1.SortCriteria(Col) = scDesc
            Else
                SCGrid1.SortCriteria(Col) = scAsc
            End If
            SCGrid1.SortOrder(Col) = 1
            SCGrid1.Sort
            initVariables
        End If
    End If
End Sub

Private Sub SCGrid1_CellOut(ByVal Row As Integer, ByVal Col As Integer)

    If Row = -1 Then
        Select Case Col
        Case 1, 2, 5
            StatusBar1.Panels(2).Text = ""
        End Select
    End If
End Sub

Private Sub SCGrid1_CellOver(ByVal Row As Integer, ByVal Col As Integer)

    If Row = -1 Then
        Select Case Col
        Case 1, 2
            StatusBar1.Panels(2).Text = "Click to sort using alpha-numeric"
        Case 5
            StatusBar1.Panels(2).Text = "Click to sort using numeric"
        End Select
    End If
End Sub

Private Sub SCGrid1_KeyUp(KeyCode As Integer, Shift As Integer)

    If KeyCode = 27 Then cancelEdit (SCGrid1.CurrentRow)
    If Not SCGrid1.IsEditMode Then
        Select Case KeyCode
        Case 46
            deleteRow (SCGrid1.CurrentRow)
        Case 32
            SCGrid1.EnterEdit
        End Select
    End If
End Sub

Private Sub SCGrid1_Scroll()

    Text1.Visible = False
End Sub

Private Sub SCGrid1_ScrollTrackRow(ByVal Row As Integer)

    If SCGrid1.FirstRow = Row Then
        Text1.Visible = False
    Else
        Text1.Top = 0.5 * SCGrid1.Height * SCGrid1.FirstRow / SCGrid1.Rows + 600
        Text1.Left = Me.Width - 2000
        Text1.Text = SCGrid1.Text(Row, 1)
        Text1.Visible = True
    End If
End Sub

Private Sub SCGrid1_TextChange(ByVal Row As Integer, ByVal Col As Integer)
    
    blnFieldChanged = True
End Sub

Private Sub SCGrid1_ValidateRow()
    
    If blnFieldChanged Then
        If blnError Then Exit Sub
        If Not validateRow Then blnError = True ' validate current row
    Else
        If blnNewRow Then
            blnNewRow = False
            SCGrid1.DeleteRows (SCGrid1.CurrentRow)
        End If
    End If
End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)
    
Dim iRow As Integer
    
    DoEvents
    Select Case Button.Key
    Case "newrow"
        newRow
    Case "delete"
        deleteRow (SCGrid1.CurrentRow)
    Case "cancel"
        cancelEdit (SCGrid1.CurrentRow)
    Case "refresh"
        refreshRows
    End Select
End Sub





' *********************************************************
'                   P R O C E D U R E S
' *********************************************************

Private Sub cancelEdit(iRow As Integer)
    
    If iRow < 0 Then Exit Sub
    
    If blnNewRow Then
        SCGrid1.DeleteRows (iRow)
    Else
        If blnFieldChanged Then SCGrid1.ADOGetRow (iRow)
        Set SCGrid1.CellPicture(iRow, -1) = Nothing
    End If
    
    SCGrid1.ExitEdit
    SCGrid1.CurrentRow = -1
    initVariables
    cmdQuit.SetFocus
End Sub

Private Function continueMaj(ByVal iRow As Integer) As Boolean
    Dim rep As Integer
    
    continueMaj = True
    rep = MsgBox("Voulez-vous enregistrer les modifications apportes  " _
        & SCGrid1.Text(iRow, 1) & "?", _
        vbQuestion + vbYesNoCancel)
    If rep = vbCancel Then Exit Function
    
    SCGrid1.ExitEdit
    If rep = vbYes Then
        If Not validateRow Then Exit Function
    End If
    ' rep = vbNo
    SCGrid1.ADOGetRow iRow
    initVariables
    continueMaj = False
End Function

Private Sub deleteRow(iRow As Integer)
    
    If iRow < 0 Then Exit Sub
    
    If blnNewRow Or SCGrid1.CellPicture(iRow, -1) Is Nothing Then Exit Sub

    If SCGrid1.ADODelete(iRow) = adRecDBDeleted Then
        
        SCGrid1.DeleteRows iRow
        StatusBar1.Panels(2).Text = "Record deleted"
        initVariables
    End If
End Sub

Private Function initDatabase() As Boolean
    
    On Error GoTo Handle_Error
    With SCGrid1
        cn.Open frmMain.Adodc1.ConnectionString
        rs.Open "select * from products", cn, adOpenKeyset, adLockOptimistic
        Set .DataSource = rs.DataSource
        
        .ADOConnection = cn.ConnectionString
        .ADOSource(2) = "select * from suppliers order by 2"
        .ADOSource(3) = "select * from categories order by 2"
        .ColFormat(5) = "$ 0.00"
    End With
    On Error GoTo 0
    initDatabase = True
    Exit Function
    
Handle_Error:
    On Error GoTo 0
    MsgBox Err.Description, vbCritical
End Function

Private Sub initGrid()

Dim i As Integer
    
    With SCGrid1
        '************************************ specific ***
        .DefaultTextAlign = scWordBreak + scWordEllipsis
        .AutoSizeRows 2
        
        .ColWidth(-1) = 30
        .ColMode(-1) = scCommandButton
        
        For i = 0 To .Cols - 1
            .TextAlignment(-1, i) = scTxtCenter + scTxtVCenter
            .CellFontBold(-1, i) = True
            .CellMode(-1, i) = scCommandButton
            .ColMode(i) = scTextBox
        Next i
        
        .ColMode(0) = scCellFixed
        .ColMode(2) = scComboListBox
        .ColMode(3) = scComboListBox
        .ColMode(9) = scCheckBox
        
        .HideCol 0
        .ColTextAlign(5) = scTxtRight
        .ColTextAlign(6) = scTxtRight
        .ColTextAlign(7) = scTxtRight
        .ColTextAlign(8) = scTxtRight
        
        ' set the sort parameter
        .SortType(1) = scAlphaNum
        .SortType(2) = scAlphaNum
        .SortType(5) = scNumeric
        '************************************ specific ***
    End With ' SCGrid1
End Sub

Private Sub initVariables()

    blnNewRow = False
    blnFieldChanged = False
    blnError = False
End Sub

Private Sub newRow()

Dim iRow As Integer

    If blnNewRow Then Exit Sub
    
    With SCGrid1
        iRow = .CurrentRow
        
        If blnFieldChanged Then
            If continueMaj(iRow) Then Exit Sub
        End If

        iRow = .Rows
        .Rows = .Rows + 1
        
        .TextAlignment(iRow, 9) = scTxtCenter
        .CellPictureAlignment(iRow, -1) = scPicCenter + scPicVCenter
        
        If .CurrentRow >= 0 Then _
            Set .CellPicture(.CurrentRow, -1) = Nothing
        Set .CellPicture(iRow, -1) = imgCoche.Picture
        If Not .IsVisibleRow(iRow) Then .LastRow = iRow
        .CurrentPos iRow, 1
        .EnterEdit
    End With
    blnNewRow = True
End Sub

Private Sub refreshRows()

Dim iRow As Integer
    
    iRow = SCGrid1.CurrentRow
    
    If blnFieldChanged Then
        If continueMaj(iRow) Then Exit Sub
    End If
    If iRow >= 0 Then Set SCGrid1.CellPicture(iRow, -1) = Nothing

    initVariables
    SCGrid1.CurrentRow = -1
    SCGrid1.ADORefresh
    StatusBar1.Panels(2).Text = SCGrid1.Rows & " product(s)"
End Sub

Private Function validateFields(iRow As Integer, iCol As Integer) As Boolean
    
    If Not blnFieldChanged Then
        validateFields = True
        Exit Function
    End If
    '************************************ specific ***
    validateFields = False
    Select Case iCol
    Case 1, 4
        If SCGrid1.Text(iRow, iCol) = "" Then
            MsgBox SCGrid1.Text(-1, iCol) & " is empty. "
            Exit Function
        End If
    Case 5 To 8
        If Not IsNumeric(SCGrid1.Text(iRow, iCol)) Then
            MsgBox SCGrid1.Text(-1, iCol) & " isn't numeric. "
            Exit Function
        End If
    Case 10
        If Not IsDate(SCGrid1.Text(iRow, iCol)) Then
            MsgBox SCGrid1.Text(-1, iCol) & " isn't a date format. "
            Exit Function
        End If
    End Select
    validateFields = True
    '************************************ specific ***
End Function

Private Function validateRow() As Boolean

Dim i As Integer
Dim iRow As Integer
    
    iRow = SCGrid1.CurrentRow
    
    ' validate data
    For i = 0 To SCGrid1.Cols - 1
        If Not validateFields(iRow, i) Then
            SCGrid1.CurrentCol = i
            SCGrid1.EnterEdit
            Exit Function
        End If
    Next i

    If blnNewRow Then
        ' insert new product
        If SCGrid1.ADOInsert(iRow) <> adRecOK Then Exit Function
        StatusBar1.Panels(2).Text = "Record inserted"
    Else
        ' update product
        If SCGrid1.ADOUpdate(iRow) <> adRecOK Then Exit Function
        StatusBar1.Panels(2).Text = "Record updated"
    End If

    validateRow = True
    initVariables
End Function

