VERSION 5.00
Object = "{1AB5D90C-10FD-4BCA-8B77-B7E2704A34AA}#11.0#0"; "FlexGridEditor.ocx"
Begin VB.Form frmGridDemo 
   Caption         =   "FlexGridEditor Demo"
   ClientHeight    =   8670
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8070
   LinkTopic       =   "Form1"
   ScaleHeight     =   8670
   ScaleWidth      =   8070
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraAction 
      Height          =   615
      Left            =   6720
      TabIndex        =   26
      Top             =   7920
      Width           =   1215
      Begin VB.CommandButton cmdExit 
         Caption         =   "E&xit"
         Height          =   300
         Left            =   120
         TabIndex        =   16
         Top             =   200
         Width           =   975
      End
   End
   Begin VB.Frame fraContent 
      Caption         =   "Manual Input"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   7905
      Left            =   120
      TabIndex        =   17
      Top             =   0
      Width           =   7815
      Begin VB.Frame fraSearch 
         Caption         =   "Search Column"
         Height          =   1095
         Left            =   120
         TabIndex        =   32
         Top             =   6660
         Width           =   7575
         Begin VB.CommandButton cmdSearch 
            Caption         =   "&Search"
            Height          =   300
            Left            =   6480
            TabIndex        =   15
            Top             =   240
            Width           =   975
         End
         Begin VB.TextBox txtSearchtxt 
            Height          =   285
            Left            =   2760
            TabIndex        =   14
            Top             =   240
            Width           =   3615
         End
         Begin VB.TextBox txtSearchCol 
            Height          =   285
            Left            =   720
            TabIndex        =   13
            Top             =   240
            Width           =   855
         End
         Begin VB.Label lblSearchResult 
            BorderStyle     =   1  'Fixed Single
            Height          =   375
            Left            =   120
            TabIndex        =   35
            Top             =   600
            Width           =   7335
            WordWrap        =   -1  'True
         End
         Begin VB.Label lblSearchfor 
            Caption         =   "Search for"
            Height          =   255
            Left            =   1680
            TabIndex        =   34
            Top             =   240
            Width           =   975
         End
         Begin VB.Label lblColumnSearch 
            Caption         =   "Column"
            Height          =   255
            Left            =   120
            TabIndex        =   33
            Top             =   240
            Width           =   615
         End
      End
      Begin VB.Frame fraCompare 
         Caption         =   "Data Manipulation"
         Height          =   1335
         Left            =   120
         TabIndex        =   29
         Top             =   5280
         Width           =   7575
         Begin VB.ListBox lstDataType 
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   300
            ItemData        =   "frmGridDemo.frx":0000
            Left            =   1680
            List            =   "frmGridDemo.frx":0002
            TabIndex        =   11
            Top             =   200
            Width           =   1215
         End
         Begin VB.CommandButton cmdCompare 
            Caption         =   "C&ompare"
            Height          =   300
            Left            =   3000
            TabIndex        =   12
            Top             =   200
            Width           =   975
         End
         Begin VB.TextBox txtColCompare 
            Height          =   300
            Left            =   720
            TabIndex        =   10
            Top             =   200
            Width           =   855
         End
         Begin VB.Label lblResult 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Arial Unicode MS"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   615
            Left            =   120
            TabIndex        =   31
            Top             =   600
            Width           =   7335
            WordWrap        =   -1  'True
         End
         Begin VB.Label lblColCompare 
            Caption         =   "Column"
            Height          =   255
            Left            =   120
            TabIndex        =   30
            Top             =   200
            Width           =   615
         End
      End
      Begin FlexGridEditor.DataEditFlexGrid dfgData 
         Height          =   3375
         Left            =   120
         TabIndex        =   0
         Top             =   240
         Width           =   7575
         _ExtentX        =   13361
         _ExtentY        =   5953
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Frame fraCurrentLoc 
         Caption         =   "Current Location"
         Height          =   855
         Left            =   3120
         TabIndex        =   22
         Top             =   4380
         Width           =   4575
         Begin VB.Label lblCurrentValue 
            BorderStyle     =   1  'Fixed Single
            Caption         =   "Current Value:"
            BeginProperty Font 
               Name            =   "Arial Unicode MS"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   270
            Left            =   120
            TabIndex        =   25
            Top             =   480
            Width           =   4335
         End
         Begin VB.Label lblRow 
            BorderStyle     =   1  'Fixed Single
            Caption         =   "Row:"
            BeginProperty Font 
               Name            =   "Arial Unicode MS"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   270
            Left            =   2310
            TabIndex        =   24
            Top             =   195
            Width           =   2140
         End
         Begin VB.Label lblCol 
            BorderStyle     =   1  'Fixed Single
            Caption         =   "Col:"
            BeginProperty Font 
               Name            =   "Arial Unicode MS"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   270
            Left            =   120
            TabIndex        =   23
            Top             =   195
            Width           =   2140
         End
      End
      Begin VB.Frame fraCellNatvigation 
         Caption         =   "Cell Movement"
         Height          =   855
         Left            =   120
         TabIndex        =   21
         Top             =   4380
         Width           =   2895
         Begin VB.CommandButton cmdMove 
            Caption         =   "&Move to"
            Height          =   300
            Left            =   1800
            TabIndex        =   9
            Top             =   440
            Width           =   975
         End
         Begin VB.TextBox txtRow 
            Height          =   300
            Left            =   960
            TabIndex        =   8
            Top             =   440
            Width           =   735
         End
         Begin VB.TextBox txtCol 
            Height          =   300
            Left            =   120
            TabIndex        =   7
            Top             =   440
            Width           =   735
         End
         Begin VB.Label lblRowMove 
            Caption         =   "Row"
            Height          =   255
            Left            =   960
            TabIndex        =   28
            Top             =   200
            Width           =   555
         End
         Begin VB.Label lblColMove 
            Caption         =   "Column"
            Height          =   255
            Left            =   120
            TabIndex        =   27
            Top             =   200
            Width           =   555
         End
      End
      Begin VB.Frame fraGridAction 
         Caption         =   "Grid Action"
         Height          =   615
         Left            =   5280
         TabIndex        =   20
         Top             =   3720
         Width           =   2415
         Begin VB.CommandButton cmdLoadData 
            Caption         =   "&Load Data"
            Height          =   300
            Left            =   1200
            TabIndex        =   6
            Top             =   200
            Width           =   1095
         End
         Begin VB.CommandButton cmdClear 
            Caption         =   "Cl&ear"
            Height          =   300
            Left            =   120
            TabIndex        =   5
            Top             =   200
            Width           =   975
         End
      End
      Begin VB.Frame fraCellAction 
         Caption         =   "Cell Action"
         Height          =   615
         Left            =   2520
         TabIndex        =   19
         Top             =   3720
         Width           =   2655
         Begin VB.TextBox txtValue 
            Height          =   300
            Left            =   120
            TabIndex        =   3
            Top             =   200
            Width           =   1335
         End
         Begin VB.CommandButton cmdChange 
            Caption         =   "&Change"
            Height          =   300
            Left            =   1560
            TabIndex        =   4
            Top             =   200
            Width           =   975
         End
      End
      Begin VB.Frame fraRecordAction 
         Caption         =   "Record Actions"
         Height          =   615
         Left            =   120
         TabIndex        =   18
         Top             =   3720
         Width           =   2295
         Begin VB.CommandButton cmdDelete 
            Caption         =   "&Delete"
            Height          =   300
            Left            =   1200
            TabIndex        =   2
            Top             =   200
            Width           =   975
         End
         Begin VB.CommandButton cmdAdd 
            Caption         =   "&Add"
            Height          =   300
            Left            =   120
            TabIndex        =   1
            Top             =   200
            Width           =   975
         End
      End
   End
End
Attribute VB_Name = "frmGridDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Dear Friend in Visual Basic                                                                     '
'                                                                                                 '
' This is the first edition of FlexGridEditor                                                     '
' FlexGridEditor is a full-featured ActiveX grid control. It has ActiveX Data Objects support, a  '
' text box, a date and time picker, checkbox, richtextbox, command button and resizable columns   '
' functionality. It also has the ability to EnterCell and LeaveCell events, to edit cells with a  '
' drop-down list and user defined entries or using pre-defined data format. FlexGridEditor is a   '
' standalone unbound grid for user editing cell value. In addition, unfixed cells always start    '
' with 1 and fixed cells always start with 0.                                                     '
'                                                                                                 '
'*  FlexGridEditor OCX Control shareware Copyright by Transcendent Technology Solution Company    '
'                                                                                                 '
' You are free to use this code within your own applications, but you are expressly forbidden     '
' from selling or otherwise distributing this source code without prior written consent. This     '
' includes both posting free demo projects made from this code as well as reproducing the code in '
' text or html format.                                                                            '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                                                                                                 '
' I would like to get your comments or suggestions. We are trying to make the best.               '
' So please help us with your feed back.                                                          '
' My e-mail is enquiry@transcendent.com.hk                                                        '
'                                                                                                 '
' Transcendent Technology Solution Company web site                                               '
' http://www.transcendent.com.hk                                                                  '
'                                                                                                 '
' Feel free to use this program in anyway you want.                                               '
' This code is provided as is without any warranty on any kind etc.                               '
' Please send us your feed back for the first edition.                                            '
' enquiry@transcendent.com.hk                                                                     '
' 27/05/2002                                                                                      '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Option Explicit

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'*************************************************************************************************'
'* The upper limit for the FlexGridEditor is 350000 cells. That is the total number of cells     *'
'* including header cannot exceed 350000. All properties of the grid must be assigned through    *'
'* coding and all pre-assigned values of property page will be overrided. The maximum length of  *'
'* each cell is 255 characters including special characters.                                     *'
'*                                                                                               *'
'* Predefined control will be shown if a control object is assigned to the column when entering  *'
'* cell. The control can be invisible if the user press ESC key and visible again if the user    *'
'* press F2 key. User can navigate between cells by pressing Return key, Up arrow, Down arrow,   *'
'* Left arrow and right arrow if available.                                                      *'
'*                                                                                               *'
'* When using RichTextBox, user can press Ctl and Enter Key at the same to move to next line.    *'
'*                                                                                               *'
'* Up and Down arrow are not available for combo box and list box because they are used to select*'
'* list items.                                                                                   *'
'*                                                                                               *'
'* Up arrow, Down arrow, Left arrow and Right arrow are not available for command button and     *'
'* checkbox because they cannot be inputted.                                                     *'
'*                                                                                               *'
'* Up arrow, Down arrow, Left arrow and Right arrow are also not available for datetimepicker    *'
'* because they are used to change date value.                                                   *'
'*                                                                                               *'
'*************************************************************************************************'
'*                                                                                               *'
'*************************************************************************************************'
'* STEPS TO SETUP GRID WITH SPECIFIC CONTROL(S)                                                  *'
'*                                                                                               *'
'* 1. Assign Cols value to grid                                                                  *'
'*                                                                                               *'
'* 2. CreateColumnDataType for each column                                                       *'
'*                                                                                               *'
'* 3. BuildGridColumns to prepare background control setting and assign column caption to grid   *'
'*                                                                                               *'
'* 4. Assign RowHeight value to adjust row height if needed.                                     *'
'*                                                                                               *'
'* 5. Assign ColWidth value to adjust column width if needed                                     *'
'*                                                                                               *'
'* 6. Assign BackColor value to change background colour of the grid                             *'
'*                                                                                               *'
'* 7. Assign Rows value or DataSource to grid to make it having designated size for data editing.*'
'*    If the user is enable to add new record(s) to the grid, then the AllowAddNew property      *'
'*    should be set to True. One blank row will be added to grid if AllowAddNew is set to True   *'
'*    before assigning DataSource to grid.                                                       *'
'*                                                                                               *'
'*************************************************************************************************'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Private Sub cmdAdd_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'Add one new record after the current record.                                                  '
   'The Row property will return the current row value.                                           '
   'Row value cannot greater than total number of rows in the grid or smaller than 0.             '
   'The last optional parameter is the number of rows will be inserted next to the selected row.  '
   'The default value is 1.                                                                       '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me
      .dfgData.Add .dfgData.Row
   End With
End Sub

Private Sub cmdChange_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'The Col and Row return current column and current row value and                               '
   'use TextMatrix to change value of the current cell.                                           '
   'Row value cannot greater than total number of rows in the grid or smaller than 1.             '
   'Col value cannot greater than total number of columns in the grid or smaller than 1.          '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me.dfgData
      .TextMatrix(.Row, .Col) = Me.txtValue.Text
      Me.lblCurrentValue.Caption = "Current Value: " & .TextMatrix(.Row, .Col)
   End With
End Sub

Private Sub cmdClear_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'Clear the grid and the underneath control(s).                                                 '
   'You have to re-build the grid again before use.                                               '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me.dfgData
      .Clear
   End With
End Sub

Private Sub cmdCompare_Click()
   Dim lngCnt As Long
   Dim SelectedType As ManipulateType
   Dim Success As Boolean
   Dim MaxValue As String
   Dim MinValue As String
   Dim TotalAmount As String
   
   lngCnt = 0
   Success = False
   With Me
      .lblResult.Caption = ""
      If Trim(.txtColCompare.Text) <> "" And Trim(.txtColCompare.Text) <> vbNullString Then
         If IsNumeric(.txtColCompare.Text) Then
            For lngCnt = 0 To .lstDataType.ListCount - 1
               If .lstDataType.Selected(lngCnt) Then
                  Select Case UCase(Trim(.lstDataType.List(lngCnt)))
                     Case "STRING"
                        SelectedType = mtString
                     Case "NUMERIC"
                        SelectedType = mtNumeric
                     Case "DATE"
                        SelectedType = mtDate
                  End Select
                  Exit For
               End If
            Next lngCnt
            
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'Find maximum value for selected column with selected comparison type.               '
            'First parameter   = selected column number                                          '
            'Second parameter  = manipulate type i.e. compare by string, numeric or date value   '
            'Third parameter   = return boolean value indicating whether comparison is performed '
            '                    but not necessary to indicate any matched data is hit. If       '
            '                    irrelevant data is found, the data is skipped.                  '
            'Return parameter  = return maximum value in string data type                        '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'The default value return for string, numeric and date are empty string, 0 and vbnull'
            'respectivetly.                                                                      '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            MaxValue = .dfgData.Maximum(.txtColCompare, SelectedType, Success)
            If Success Then
               .lblResult.Caption = "Find maximum is success and maximum is " & MaxValue & ". "
            Else
               .lblResult.Caption = "Find maximum is failed and default maximum is " & MaxValue & ". "
            End If
            
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'Find minimum value for selected column with selected comparison type.               '
            'First parameter   = selected column number                                          '
            'Second parameter  = manipulate type i.e. compare by string, numeric or date value   '
            'Third parameter   = return boolean value indicating whether comparison is performed '
            '                    but not necessary to indicate any matched data is hit. If       '
            '                    irrelevant data is found, the data is skipped.                  '
            'Return parameter  = return minimum value in string data type                        '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'The default value return for string, numeric and date are empty string, 0 and vbnull'
            'respectivetly.                                                                      '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            MinValue = .dfgData.Minimum(.txtColCompare, SelectedType, Success)
            If Success Then
               .lblResult.Caption = .lblResult.Caption & "Find minimum is success and minimum is " _
                                  & MinValue & ". "
            Else
               .lblResult.Caption = .lblResult.Caption & "Find minimum is failed and default minimum is " _
                                  & MinValue & ". "
            End If
            
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'Find total value of numeric data for selected column.                               '
            'First parameter   = selected column number                                          '
            'Second parameter  = return boolean value indicating whether comparison is performed '
            '                    but not necessary to indicate any matched data is hit. If       '
            '                    irrelevant data is found, the data is skipped.                  '
            'Return parameter  = return total value in double data type                          '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            'The default value return is 0.                                                      '
            ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
            TotalAmount = .dfgData.Summation(.txtColCompare, Success)
            If Success Then
               .lblResult.Caption = .lblResult.Caption & "Find total is success and total is " _
                                  & TotalAmount & ". "
            Else
               .lblResult.Caption = .lblResult.Caption & "Find total is failed and default total is " _
                                  & TotalAmount & ". "
            End If
         End If
      End If
   End With
End Sub

Private Sub cmdDelete_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'Delete the current record.                                                                    '
   'The Row property will return the current row value.                                           '
   'Row value cannot greater than total number of rows in the grid or smaller than 1.             '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me
      .dfgData.Delete .dfgData.Row
   End With
End Sub

Private Sub cmdExit_Click()
   Unload Me
End Sub

Private Sub cmdLoadData_Click()
   SetGridAppearance
   GetData
End Sub

Private Sub cmdMove_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'Move current cell position                                                                    '
   'Both value must be numeric.                                                                   '
   'Row value cannot greater than total number of rows in the grid or smaller than 1.             '
   'Col value cannot greater than total number of columns in the grid or smaller than 1.          '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me
      If Trim(.txtCol.Text) <> "" And Trim(.txtCol.Text) <> vbNullString Then
         If Trim(.txtRow.Text) <> "" And Trim(.txtRow.Text) <> vbNullString Then
            If IsNumeric(.txtCol.Text) And IsNumeric(.txtRow.Text) Then
               .dfgData.Col = CInt(.txtCol)
               .dfgData.Row = CInt(.txtRow)
            End If
         End If
      End If
   End With
End Sub

Private Sub cmdSearch_Click()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This method is used to find match for the selected column. If no match record found, the      '
   'default value is zero. Otherwise, the row position will be return and the arrow will point to '
   'the match record.                                                                             '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Dim lngRtn As Long
   
   lngRtn = 0
   With Me
      .lblSearchResult.Caption = ""
      If (Trim(.txtSearchCol) <> "") And (Trim(.txtSearchCol) <> vbNullString) Then
         If (Trim(.txtSearchtxt) <> "") And (Trim(.txtSearchtxt) <> vbNullString) Then
            If IsNumeric(Trim(.txtSearchCol)) Then
               lngRtn = .dfgData.SearchCol(Trim(.txtSearchCol), Trim(.txtSearchtxt))
               If (lngRtn = 0) Then
                  .lblSearchResult.Caption = "No match record found."
               Else
                  .lblSearchResult.Caption = "The match record is at row " & lngRtn & "."
               End If
            End If
         End If
      End If
   End With
End Sub

Private Sub dfgData_AdvanceToNextCell(Cancel As Boolean)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This property is used to indicate whether move to next cell when the user presses             '
   'enter or arrow keys if available.                                                             '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Cancel = False
End Sub

Private Sub dfgData_ButtonClick(ByVal ButtonIndex As Integer)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event is raised when command in the grid is clicked. The ButtonIndex indicates index of  '
   'the button in an array. For example, there are twenty columns in a grid and three columns use '
   'command button as column control and Column numbers are 4, 8, 12. Then the ButtonIndex will be'
   '0, 1, 2 recpectively.                                                                         '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Dim frmObj As frmSearch
   
   Set frmObj = Nothing
   With Me.dfgData
      Set frmObj = New frmSearch
      frmObj.Show vbModal
      If Not frmObj.Cancel Then
         If Trim(frmObj.txtInput(0).Text) <> "" And Trim(frmObj.txtInput(0).Text) <> vbNullString Then
            .TextMatrix(.Row, .Col) = Trim(frmObj.txtInput(0).Text)
            .TextMatrix(.Row, .Col + 1) = Trim(frmObj.txtInput(1).Text)
         End If
      End If
      If Not (frmObj Is Nothing) Then
         Unload frmObj
      End If
      Set frmObj = Nothing
   End With
End Sub

Private Sub dfgData_DateBoxCloseUp()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event will be fired when date picker is closed up.                                       '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
End Sub

Private Sub dfgData_DateBoxDropDown()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event will be fired when date picker is drop down.                                       '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
End Sub

Private Sub dfgData_DatePickerCallbackKeyDown(ByVal KeyCode As Integer, ByVal Shift As Integer, ByVal CallbackField As String, CallbackDate As Date)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event will be fired when a key is pressed while the cursor is inside a callback field.   '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
End Sub

Private Sub dfgData_EditorChange()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event will be fired when change event of datepicker or richtextbox or textbox is fired.  '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
End Sub

Private Sub dfgData_EditorValidate(Cancel As Boolean)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event will be fired when validate event of textbox is fired.                             '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
End Sub

Private Sub dfgData_ErrInfo(ByVal ErrNum As Long, ByVal ErrSource As String, _
                            ByVal ErrDesc As String, ByVal ErrHelpFile As String, _
                            ByVal ErrHelpContext As String)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This event provides all information of captured error(s) if possible.                         '
   'This event will be fired when each error object captured.                                     '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Debug.Print "Error occurs at grid" & vbCrLf
   Debug.Print "Detailed information of captured error" & vbCrLf
   Debug.Print "Error number" & vbTab & ":" & ErrNum & vbCrLf
   Debug.Print "Error source" & vbTab & ":" & ErrSource & vbCrLf
   Debug.Print "Error description" & vbTab & ":" & ErrDesc & vbCrLf
   Debug.Print "Error help file" & vbTab & ":" & ErrHelpFile & vbCrLf
   Debug.Print "Error help context" & vbTab & ":" & ErrHelpContext & vbCrLf
End Sub

Private Sub dfgData_RowColChange()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'Get the current cell position and current cell value by Col, Row and TextMatrix properties.   '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   With Me
      .lblCol.Caption = "Col: " & .dfgData.Col
      .lblRow.Caption = "Row: " & .dfgData.Row
      .lblCurrentValue.Caption = "Current Value: " & .dfgData.TextMatrix(.dfgData.Row, .dfgData.Col)
   End With
End Sub

Private Sub dfgData_UseAdvanceToNextCell(Use As Boolean)
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'This property is used to indicate whether use the same setting of AdvanceToNextCell of the    '
   'grid after command button is clicked and the grid gets focus again.                           '
   'THIS PROPERTY IS ONLY AVALIABLE FOR COMMAND BUTTON.                                           '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Use = True
End Sub

Private Sub SetGridAppearance()
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   'You need to give total number columns before assign column control to column. Then you need   '
   'to BuildGridColumns to initialize all controls. You can adjust column width after defined     '
   'number of columns used in the grid and before BuildGridColumns.                               '
   ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   Dim lngCnt As Long
   lngCnt = 0
   
   With Me
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'The value of Cols and Rows will be total number of columns and rows shown in the grid      '
      'including header. For example, you needs to show a table with ten columns and eight        '
      'records, then the value of Cols and Rows will be 11 and 9 respectively. The Col and Row    '
      'value of the right-bottom  corner cell will be 10 and 8 repesctively.                      '
      '                                                                                           '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'Give the size of the grid first before assign column data type.                            '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.Cols = 11
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'First parameter   = which column that you assign value to                                  '
      'Second parameter  = column caption                                                         '
      'Third parameter   = control type with be used                                              '
      'Fourth parameter  = Item to be list in combo box or list box or mask for masked edit box   '
      '                    or command button caption. The items to be displayed should be         '
      '                    separated by pipeline character for combo box and list box and no      '
      '                    conversion will be done on alphabet!                                   '
      'Fifth parameter   = whether this column will be hidden.                                    '
      'Sixth parameter   = column alignment                                                       '
      'Seventh parameter = maximum length for input field                                         '
      'Eight parameter   = whether column will adjust by width of header caption or content of    '
      '                    the column.                                                            '
      'Nineth parameter  = indicate whether mask will be used for masked edit box. False - use    '
      '                    Format property; True - use Mask property                              '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      For lngCnt = 1 To 10
         Select Case lngCnt
            Case 1
               .dfgData.CreateColumnDataType(lngCnt, "ID", fcCommandButton, _
                                                    "ID Search", False, fcCenter, 0, faContent) = False
            Case 2
               .dfgData.CreateColumnDataType(lngCnt, "Name", fcTextBox, "", _
                                                    False, fcLeft, 0, faContent) = False
            Case 3
               .dfgData.CreateColumnDataType(lngCnt, "Date of birth", fcDatePicker, _
                                                    "", False, fcLeft, 0, faHeader) = False
            Case 4
               .dfgData.CreateColumnDataType(lngCnt, "HKID No", fcMaskedEditBox, _
                                                    "&&&&&&&(&)", False, fcRight, _
                                                    11, faContent) = True
            Case 5
               .dfgData.CreateColumnDataType(lngCnt, "Department ID", fcComboBox, _
                                                    "MainBranch|HK Branch|KLN Branch|NT Branch", _
                                                    False, fcLeft, 0, faContent) = False
            Case 6
               .dfgData.CreateColumnDataType(lngCnt, "Grade", fcListBox, _
                                                    "Senior|General|Jounior", False, _
                                                    fcLeft, 0, faContent) = False
            Case 7
               .dfgData.CreateColumnDataType(lngCnt, "MPF Exempted", fcCheckBox, "", _
                                                    False, fcCenter, 0, faHeader) = False
            Case 8
               .dfgData.CreateColumnDataType(lngCnt, "Employment Remark", fcRichTextBox, _
                                                    "", False, fcLeft, 255, faHeader) = False
            Case 9
               .dfgData.CreateColumnDataType(lngCnt, "Create Date", fcNil, "", False, _
                                                    fcLeft, 0, faNil) = False
            Case 10
               .dfgData.CreateColumnDataType(lngCnt, "Telephone No", fcTextBox, "", _
                                                    False, fcRight, 30, faContent) = False
         End Select
      Next
      
      ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'First parameter  = new row height value                                                     '
      'Second parameter = scale font size of the control according to new row height               '
      'Thrid parameter  = whether column header use this row height                                '
      ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.RowHeight 290, False, False
      .dfgData.BuildGridColumns
      
      ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'The Col value cannot be negative and not greater than total number of colmuns.              '
      ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      For lngCnt = 0 To 10
         Select Case lngCnt
            Case 0
               .dfgData.ColWidth(lngCnt) = 245
            Case 1
               .dfgData.ColWidth(lngCnt) = 1400
            Case 2
               .dfgData.ColWidth(lngCnt) = 2000
            Case 8
               .dfgData.ColWidth(lngCnt) = 3000
            Case Else
               .dfgData.ColWidth(lngCnt) = 1200
         End Select
      Next
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'If you want to add record the grid by using Add property, you have change AllowAddNew to   '
      'True before.                                                                               '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.AllowAddNew = True
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'There are two colours you can choose, then they will be background colour alternatively.   '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.BackColor(0) = Cyan
      .dfgData.BackColor(1) = InfoBackground
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'Use DateFormat to change the date format of date picker.                                   '
      'This format will be used for date datatype.                                                '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.DateFormat = "yyyy/MM/dd"
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'This event indicates whether the control raise error when error(s) is detect.              '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.RaiseError = False
      
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      'This event indicates whether the control show the error messages in message box when error '
      'is captured.                                                                               '
      '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
      .dfgData.ShowErrMessage = False
   End With
End Sub

Private Sub GetData()
   Dim blnRtn As Boolean
   Dim rsTemp As ADODB.Recordset
   Dim cnnObj As ADODB.Connection
   Dim strSql As String
   
   blnRtn = True
   strPath = ""
   strSql = ""
   Set cnnObj = Nothing
   Set rsTemp = Nothing
   
   strPath = App.Path
   If Right(strPath, 1) <> "\" Then
      strPath = strPath & "\"
   End If
   strPath = strPath & "demo.mdb"
   If Dir(strPath) <> "" Then
      OpenConnection strPath, cnnObj, blnRtn
      If blnRtn Then
         strSql = "select * from staff order by id asc"
         Set rsTemp = New ADODB.Recordset
         rsTemp.CursorLocation = adUseServer
         rsTemp.Open strSql, cnnObj, adOpenDynamic, adLockOptimistic, adCmdText
         If Not rsTemp.EOF Then
            rsTemp.MoveFirst
            Set Me.dfgData.DataSource(rsTemp) = cnnObj
         End If
         If Not (rsTemp Is Nothing) Then
            On Error Resume Next
            If rsTemp.State <> adStateClosed Then
               rsTemp.Close
            End If
            On Error GoTo 0
         End If
         Set rsTemp = Nothing
         If Not (cnnObj Is Nothing) Then
            On Error Resume Next
            If cnnObj.State <> adStateClosed Then
               cnnObj.Close
            End If
            On Error GoTo 0
         End If
         Set cnnObj = Nothing
      End If
   Else
      MsgBox "Cannot connect to database because demo database is not found!"
   End If
End Sub

Private Sub BuildListBox()
   With Me
      .lstDataType.Clear
      .lstDataType.AddItem "String"
      .lstDataType.AddItem "Numeric"
      .lstDataType.AddItem "Date"
      .lstDataType.Selected(0) = True
      .lstDataType.Refresh
   End With
End Sub

Private Sub Form_Load()
   SetGridAppearance
   BuildListBox
End Sub

Private Sub txtCol_LostFocus()
   With Me
      .txtCol.Text = Trim(.txtCol.Text)
   End With
End Sub

Private Sub txtColCompare_Change()
   With Me
      .txtColCompare.Text = Trim(.txtColCompare.Text)
   End With
End Sub

Private Sub txtRow_LostFocus()
   With Me
      .txtRow.Text = Trim(.txtRow.Text)
   End With
End Sub

Private Sub txtSearchCol_LostFocus()
   With Me
      .txtSearchCol.Text = Trim(.txtSearchCol.Text)
   End With
End Sub

Private Sub txtSearchtxt_LostFocus()
   With Me
      .txtSearchtxt.Text = Trim(.txtSearchtxt.Text)
   End With
End Sub

Private Sub txtValue_LostFocus()
   With Me
      .txtValue.Text = Trim(.txtValue.Text)
   End With
End Sub
