Attribute VB_Name = "ICON_Handles"
Option Explicit

'Used by SHGetFileInfo
Private Const SHGFI_ICON = &H100
Private Const SHGFI_DISPLAYNAME = &H200
Private Const SHGFI_TYPENAME = &H400
Private Const SHGFI_ATTRIBUTES = &H800
Private Const SHGFI_ICONLOCATION = &H1000
Private Const SHGFI_EXETYPE = &H2000
Private Const SHGFI_SYSICONINDEX = &H4000
Private Const SHGFI_LINKOVERLAY = &H8000
Private Const SHGFI_SELECTED = &H10000
Private Const SHGFI_LARGEICON = &H0
Private Const SHGFI_SMALLICON = &H1
Private Const SHGFI_OPENICON = &H2
Private Const SHGFI_SHELLICONSIZE = &H4
Private Const SHGFI_PIDL = &H8
Private Const SHGFI_USEFILEATTRIBUTES = &H10

Declare Function SHGetFileInfo Lib "Coredll" ( _
    ByVal pszPath As String, _
    ByVal dwFileAttributes As Long, _
    ByVal psfi As String, _
    ByVal cbFileInfo As Integer, _
    ByVal uFlags As Integer) As Long

Declare Function DefWindowProc Lib "Coredll" Alias "DefWindowProcW" ( _
    ByVal hwnd As Long, _
    ByVal wMsg As Long, _
    ByVal wParam As Long, _
    ByVal lParam As Long) As Long

Declare Function ExtractIconEx Lib "Coredll" Alias "ExtractIconExW" ( _
  ByVal lpszFile As String, _
  ByVal nIconIndex As Long, _
  ByRef phiconLarge As Long, _
  ByRef phiconSmall As Long, _
  ByVal nIcons As Long) As Integer
  
Declare Function DestroyIcon Lib "Coredll" ( _
    ByVal hIcon As Long) As Long

Public Function GetHiconFromAppTitle() As Long
'Uses the value entered on Application=>Title of the project properties
'This sould be a file name but does not need to exist:
'Only the extension is important
Dim SHFileInfoW As String
    SHFileInfoW = Space(346)
    
    Call SHGetFileInfo(App.Title, 0, _
        SHFileInfoW, _
        LenB(SHFileInfoW), _
        SHGFI_USEFILEATTRIBUTES + SHGFI_ICON + SHGFI_SMALLICON)
    
    GetHiconFromAppTitle = BinaryStringToLong(MidB(SHFileInfoW, 1, 4))
End Function

Public Function GetSmallHiconFromRes(FileIn As String, Ix As Long) As Long
Dim SmallIcon As Long
    Call ExtractIconEx(FileIn, Ix, vbNull, SmallIcon, 1)
    GetSmallHiconFromRes = SmallIcon
End Function

Public Function GetLargeHiconFromRes(FileIn As String, Ix As Long) As Long
Dim LargeIcon As Long
    Call ExtractIconEx(FileIn, Ix, LargeIcon, vbNull, 1)
    GetLargeHiconFromRes = LargeIcon
End Function

