/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.Hex;

public final class FastStringBuffer {
    private static final int ABSOLUTE_MAX_SOURCE_COLS = 100;
    private static final int SUGGESTED_MAX_SOURCE_COLS = 64;
    static final String needingEscape = "\b\t\n\f\r\"\\";
    private int maxCapacity;
    private int offset;
    private int lastChar;
    private char[] value;
    public static final int NOT_A_CHAR = 0;
    public static final int NOTACHAR = 0;
    private static char[] displayLiteral;
    private static char[] logicalLiteral;

    static {
        logicalLiteral = new char[]{'\r', '\n', '\t', '\'', '\\'};
        displayLiteral = new char[]{'r', 'n', 't', '\'', '\\'};
    }

    /*
     * Unable to fully structure code
     */
    public static FastStringBuffer textToSource(String text, boolean hasEscapes, String indentString) {
        source = new FastStringBuffer(text.length() * 2 + 2);
        source.append("\"");
        colCount = 0;
        block12: for (i = 0; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (ch != '\\' || !hasEscapes || i + 2 >= text.length()) ** GOTO lbl-1000
            digit = text.charAt(i + 2);
            switch (text.charAt(i + 1)) {
                case '0': {
                    if ((digit == 'x' || digit == 'X') && i + 3 < text.length()) {
                        digit = text.charAt(i + 3);
                    }
                }
                case 'U': 
                case 'u': {
                    if (digit >= '0' && digit <= '9') {
                        source.append(ch);
                        continue block12;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ("\b\t\n\f\r\"\\".indexOf(ch) < 0) ** GOTO lbl56
                    source.append("\\");
                    switch (ch) {
                        case '\b': {
                            source.append('b');
                            break;
                        }
                        case '\t': {
                            source.append('t');
                            break;
                        }
                        case '\n': {
                            source.append('n');
                            break;
                        }
                        case '\f': {
                            source.append('f');
                            break;
                        }
                        case '\r': {
                            source.append('r');
                            break;
                        }
                        case '\\': {
                            source.append('\\');
                            if (hasEscapes && i + 1 < text.length() && text.charAt(i + 1) == '\\') {
                                source.append(text.charAt(++i));
                                break;
                            }
                            ** GOTO lbl58
                        }
                        default: {
                            source.append(FastStringBuffer.stringFromChar(ch));
                            break;
                        }
                    }
                    ** GOTO lbl58
lbl56:
                    // 1 sources

                    source.append(FastStringBuffer.stringFromChar(ch));
lbl58:
                    // 3 sources

                    if (i >= text.length() - 1 || ++colCount <= 64 || (!(breakHere = Character.isWhitespace(ch)) || colCount <= 64) && colCount <= 100) continue block12;
                    source.append("\" +\n");
                    source.append(indentString);
                    source.append("\"");
                    colCount = 0;
                }
            }
        }
        source.append("\"");
        return source;
    }

    public static FastStringBuffer textToSource(String text, boolean hasEscapes) {
        return FastStringBuffer.textToSource(text, hasEscapes, "    ");
    }

    public static FastStringBuffer sourceToText(String source) {
        int len;
        FastStringBuffer text = new FastStringBuffer();
        FastStringBuffer input = new FastStringBuffer(source);
        if (input.charAt(0) == '\"') {
            input.removeCharAt(0);
        }
        if ((len = input.length()) > 0 && input.charAt(len - 1) == '\"') {
            input.removeCharAt(len - 1);
        }
        char ch = input.firstChar();
        while (ch != '\u0000') {
            if (ch == '\\') {
                ch = input.parseBackSlash();
            }
            text.append(ch);
            ch = input.nextChar();
        }
        return text;
    }

    public static String stringFromChar(char c2) {
        char cLog = FastStringBuffer.literalToDisplay(c2);
        String s2 = cLog != '\u0000' ? "\\".concat(String.valueOf(cLog)) : (c2 < ' ' ? FastStringBuffer.charToUnicodeEscape(c2) : new String(new char[]{c2}));
        return s2;
    }

    public static char charFromString(String s2) {
        char c2 = '\u0000';
        if (s2 != null && s2.length() >= 0) {
            if (s2.length() == 1) {
                c2 = s2.charAt(0);
            } else {
                FastStringBuffer fsb = new FastStringBuffer(s2);
                c2 = fsb.firstChar();
                if (c2 == '\\') {
                    c2 = fsb.parseBackSlash();
                }
            }
        }
        return c2;
    }

    private static char literalToDisplay(char c2) {
        for (int i2 = 0; i2 < logicalLiteral.length; ++i2) {
            if (c2 != logicalLiteral[i2]) continue;
            return displayLiteral[i2];
        }
        return '\u0000';
    }

    private static char displayToLiteral(char c2) {
        for (int i2 = 0; i2 < displayLiteral.length; ++i2) {
            if (c2 != displayLiteral[i2]) continue;
            return logicalLiteral[i2];
        }
        return '\u0000';
    }

    public static String charToUnicodeEscape(char ch) {
        char[] hexChars = new char[]{'\\', 'u', Hex.chars[ch >> 12 & 0xF], Hex.chars[ch >> 8 & 0xF], Hex.chars[ch >> 4 & 0xF], Hex.chars[ch & 0xF]};
        return new String(hexChars, 0, 6);
    }

    /*
     * Unable to fully structure code
     */
    public FastStringBuffer normalizeDelimiters(String delimiters) {
        result = new FastStringBuffer(this.lastChar + 1);
        c = this.firstChar();
        while (c != '\u0000') {
            if (c != '\\') ** GOTO lbl19
            oldoffset = this.offset;
            cVal = this.parseBackSlash();
            if (delimiters.indexOf(cVal) >= 0) {
                cLog = FastStringBuffer.literalToDisplay(cVal);
                if (cLog != '\u0000') {
                    result.append('\\');
                    result.append(cLog);
                } else {
                    result.append(cVal);
                }
            } else {
                this.offset = oldoffset;
lbl19:
                // 2 sources

                result.append(c);
            }
            c = this.nextChar();
        }
        return result;
    }

    public static FastStringBuffer expandDelimiters(String sourceString, String delimiters) {
        int len = sourceString == null ? 0 : sourceString.length();
        FastStringBuffer result = new FastStringBuffer(len);
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = sourceString.charAt(i2);
            if (delimiters.indexOf(c2) >= 0) {
                result.append(FastStringBuffer.charToUnicodeEscape(c2));
                continue;
            }
            result.append(c2);
        }
        return result;
    }

    public FastStringBuffer parseLiteral() {
        return this.parseLiteral(this.currentChar(), false);
    }

    public FastStringBuffer parseLiteral(char delimiter, boolean allowDouble) {
        FastStringBuffer rsb = new FastStringBuffer();
        char c2 = this.nextChar();
        while (c2 != '\u0000') {
            if (c2 == delimiter) {
                if (!allowDouble || this.peekNextChar() != c2) break;
                rsb.append(c2);
                this.nextChar();
            } else {
                if (c2 == '\\') {
                    c2 = this.parseBackSlash();
                }
                rsb.append(c2);
            }
            c2 = this.nextChar();
        }
        return rsb;
    }

    public char parseBackSlash() {
        int maxChars;
        int radix;
        char c2 = this.nextChar();
        char cVal = FastStringBuffer.displayToLiteral(c2);
        if (cVal != '\u0000') {
            return cVal;
        }
        switch (c2) {
            case 'U': 
            case 'u': {
                radix = 16;
                maxChars = 4;
                break;
            }
            case '0': {
                radix = 8;
                maxChars = 3;
                c2 = this.peekNextChar();
                if (c2 == 'x' || c2 == 'X') {
                    radix = 16;
                    maxChars = 2;
                    ++this.offset;
                    break;
                }
                this.priorChar();
                break;
            }
            default: {
                return c2;
            }
        }
        FastStringBuffer s2 = new FastStringBuffer(maxChars);
        for (int i2 = 0; i2 < maxChars; ++i2) {
            c2 = Character.toUpperCase(this.nextChar());
            if (!Character.isDigit(c2) && (radix == 8 && c2 > '7' || radix == 16 && (c2 < 'A' || c2 > 'F'))) {
                this.priorChar();
                break;
            }
            s2.append(c2);
        }
        return (char)Integer.parseInt(s2.toString(), radix);
    }

    public String toString() {
        return new String(this.value, 0, this.lastChar + 1);
    }

    public FastStringBuffer substring(int startPos, int endPos) {
        if (startPos < 0) {
            startPos = 0;
        }
        if (endPos > this.lastChar) {
            endPos = this.lastChar;
        }
        FastStringBuffer fsb = startPos >= endPos ? new FastStringBuffer() : new FastStringBuffer(this.value, startPos, endPos - startPos);
        return fsb;
    }

    public int lastIndexOf(FastStringBuffer subStr, int fromIndex) {
        char[] v1 = this.value;
        char[] v2 = subStr.value();
        int max = this.lastChar + 1 - subStr.length();
        block0: for (int i2 = fromIndex; i2 >= 0; --i2) {
            int n2 = subStr.length();
            int j2 = i2;
            int k2 = 0;
            while (n2-- != 0) {
                if (v1[j2++] == v2[k2++]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public int indexOf(FastStringBuffer subStr, int fromIndex) {
        int i2;
        char[] v1 = this.value;
        char[] v2 = subStr.value();
        int max = this.lastChar + 1 - subStr.length();
        int n2 = i2 = fromIndex < 0 ? 0 : fromIndex;
        while (i2 <= max) {
            block2: {
                int n3 = subStr.length();
                int j2 = i2;
                int k2 = 0;
                while (n3-- != 0) {
                    if (v1[j2++] == v2[k2++]) continue;
                    break block2;
                }
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int IndexOfSubString(FastStringBuffer subStr, int fromIndex) {
        return this.indexOf(subStr, fromIndex);
    }

    public FastStringBuffer insert(int offset, char c2) {
        this.makeroom(1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.lastChar + 1 - offset);
        this.value[offset] = c2;
        ++this.lastChar;
        return this;
    }

    public FastStringBuffer insert(int offset, boolean b2) {
        return this.insert(offset, String.valueOf(b2));
    }

    public FastStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.lastChar) {
            this.outOfBounds(offset);
        }
        int len = str.length;
        this.makeroom(len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.lastChar + 1 - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.lastChar += len;
        return this;
    }

    public FastStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.lastChar) {
            this.outOfBounds(offset);
        }
        int len = str.length();
        this.makeroom(len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.lastChar + 1 - offset);
        str.getChars(0, len, this.value, offset);
        this.lastChar += len;
        return this;
    }

    public FastStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public FastStringBuffer append(char[] str, int offset, int len) {
        this.makeroom(len);
        System.arraycopy(str, offset, this.value, this.lastChar + 1, len);
        this.lastChar += len;
        return this;
    }

    public FastStringBuffer append(char[] str) {
        int len = str.length;
        this.makeroom(len);
        System.arraycopy(str, 0, this.value, this.lastChar + 1, len);
        this.lastChar += len;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer fsb) {
        if (fsb == null) {
            return this;
        }
        int len = fsb.lastChar + 1;
        this.makeroom(len);
        fsb.getChars(0, len, this.value, this.lastChar + 1);
        this.lastChar += len;
        return this;
    }

    public final FastStringBuffer append(String str) {
        int len;
        if (str == null) {
            str = String.valueOf(str);
        }
        if (this.lastChar + (len = str.length()) > this.maxCapacity) {
            this.makeroom(len);
        }
        str.getChars(0, len, this.value, this.lastChar + 1);
        this.lastChar += len;
        return this;
    }

    public FastStringBuffer append(char c2, int appendCount) {
        this.makeroom(appendCount);
        ++appendCount;
        while (--appendCount > 0) {
            this.value[++this.lastChar] = c2;
        }
        return this;
    }

    public final FastStringBuffer append(char c1, char c2, char c3, char c4, char c5) {
        if (this.lastChar + 5 > this.maxCapacity) {
            this.makeroom(5);
        }
        this.value[++this.lastChar] = c1;
        this.value[++this.lastChar] = c2;
        this.value[++this.lastChar] = c3;
        this.value[++this.lastChar] = c4;
        this.value[++this.lastChar] = c5;
        return this;
    }

    public final FastStringBuffer append(char c1, char c2, char c3, char c4) {
        if (this.lastChar + 4 > this.maxCapacity) {
            this.makeroom(4);
        }
        this.value[++this.lastChar] = c1;
        this.value[++this.lastChar] = c2;
        this.value[++this.lastChar] = c3;
        this.value[++this.lastChar] = c4;
        return this;
    }

    public final FastStringBuffer append(char c2) {
        if (this.lastChar + 1 > this.maxCapacity) {
            this.makeroom(1);
        }
        this.value[++this.lastChar] = c2;
        return this;
    }

    public FastStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public void replaceCharAt(int index, char c2) {
        if (index < 0 || index > this.lastChar) {
            this.outOfBounds(index);
        }
        this.value[index] = c2;
    }

    public void removeChars(int removeCount) {
        this.removeCharsAt(this.offset, removeCount);
    }

    public void removeCharsAt(int index, int removeCount) {
        if (index < 0 || index + removeCount > this.lastChar) {
            this.outOfBounds(index);
        }
        if (index < this.lastChar + 1 - removeCount) {
            System.arraycopy(this.value, index + removeCount, this.value, index, this.lastChar + 1 - index - removeCount);
        }
        this.offset = index - removeCount;
        this.lastChar -= removeCount;
    }

    public void removeChar() {
        this.removeCharAt(this.offset);
    }

    public void removeCharAt(int index) {
        if (index < 0 || index > this.lastChar) {
            this.outOfBounds(index);
        }
        int len = this.lastChar - index;
        if (index < this.lastChar && len > 0) {
            System.arraycopy(this.value, index + 1, this.value, index, len);
        }
        this.offset = index - 1;
        --this.lastChar;
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index > this.lastChar) {
            this.outOfBounds(index);
        }
        this.value[index] = ch;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin > this.lastChar) {
            this.outOfBounds(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.lastChar + 1) {
            this.outOfBounds(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public char peekNextChar() {
        if (this.offset < -1 || this.offset >= this.lastChar) {
            return '\u0000';
        }
        return this.value[this.offset + 1];
    }

    public char priorChar() {
        if (this.offset < 1 || this.offset >= this.lastChar) {
            return '\u0000';
        }
        return this.value[--this.offset];
    }

    public char nextChar() {
        if (this.offset < -1 || this.offset >= this.lastChar) {
            return '\u0000';
        }
        return this.value[++this.offset];
    }

    public char currentChar() {
        if (this.offset < 0 || this.offset > this.lastChar) {
            return '\u0000';
        }
        return this.value[this.offset];
    }

    public char lastChar() {
        if (this.lastChar < 0) {
            return '\u0000';
        }
        this.offset = this.lastChar;
        return this.value[this.offset];
    }

    public char firstChar() {
        if (this.lastChar < 0) {
            return '\u0000';
        }
        this.offset = 0;
        return this.value[0];
    }

    public char charAt(int index) {
        if (index < 0 || index > this.lastChar) {
            this.outOfBounds(index);
        }
        this.offset = index;
        return this.value[index];
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            this.outOfBounds(newLength);
        }
        if (this.lastChar < newLength) {
            this.makeroom(newLength - this.lastChar);
            while (this.lastChar < newLength) {
                this.value[++this.lastChar] = '\u0000';
            }
        }
        this.lastChar = newLength - 1;
    }

    private final void outOfBounds(int length) {
        throw new StringIndexOutOfBoundsException(length);
    }

    public final void makeroom(int needed) {
        int minCapacity = this.lastChar + needed;
        if (minCapacity > this.maxCapacity) {
            int newCapacity = (this.maxCapacity + 1 + 1) * 2;
            if (minCapacity + 1 > newCapacity) {
                newCapacity = minCapacity + 1;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.lastChar + 1);
            this.value = newValue;
            this.maxCapacity = this.value.length - 1;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int offset() {
        return this.offset;
    }

    public int capacity() {
        return this.value.length;
    }

    public final int getLength() {
        return this.lastChar + 1;
    }

    public final int length() {
        return this.lastChar + 1;
    }

    public char[] getValue() {
        return this.value;
    }

    public char[] value() {
        return this.value;
    }

    public void empty() {
        for (int i2 = 0; i2 < this.lastChar; ++i2) {
            this.value[i2] = '\u0000';
        }
        this.lastChar = -1;
        this.offset = 0;
    }

    public FastStringBuffer(char c2, int nChars) {
        this(nChars);
        for (int i2 = 0; i2 < nChars; ++i2) {
            this.value[i2] = c2;
        }
        this.lastChar = nChars - 1;
        this.maxCapacity = this.value.length - 1;
    }

    public FastStringBuffer(char[] cArray, int offset, int len) {
        this(len + 16);
        this.append(cArray, offset, len);
        offset = 0;
        this.lastChar = len - 1;
        this.maxCapacity = this.value.length - 1;
    }

    public FastStringBuffer(char[] cArray) {
        this(cArray.length + 16);
        this.append(cArray);
        this.offset = 0;
        this.lastChar = cArray.length - 1;
        this.maxCapacity = this.value.length - 1;
    }

    public FastStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
        this.offset = 0;
        this.lastChar = str.length() - 1;
        this.maxCapacity = this.value.length - 1;
    }

    public FastStringBuffer(int length) {
        this.value = new char[length];
        this.offset = 0;
        this.lastChar = -1;
        this.maxCapacity = this.value.length - 1;
    }

    public FastStringBuffer() {
        this(16);
    }
}

