/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class IntlMenuItem
extends JMenuItem {
    private String textWithMnemonic;

    public IntlMenuItem() {
        this(null, null);
        this.setRequestFocusEnabled(false);
    }

    public IntlMenuItem(Icon icon) {
        this(null, icon);
        this.setRequestFocusEnabled(false);
    }

    public IntlMenuItem(String s2) {
        this(s2, null);
    }

    public IntlMenuItem(String s2, Icon icon) {
        super(DBUtilities.excludeMnemonicSymbol(s2), icon);
        if (DBUtilities.containsMnemonic(s2)) {
            this.setTextWithMnemonic(s2);
        }
    }

    public IntlMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
    }

    public void setTextWithMnemonic(String text) {
        String oldText = this.textWithMnemonic;
        if (oldText != text) {
            this.textWithMnemonic = text;
            this.setText(DBUtilities.excludeMnemonicSymbol(text));
            this.setMnemonic(DBUtilities.extractMnemonicChar(text));
            this.firePropertyChange("textWithMnemonic", oldText, text);
        }
    }

    public String getTextWithMnemonic() {
        return this.textWithMnemonic;
    }
}

