/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBPlainDocument;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.FontChooser;
import com.borland.dbswing.IntlSwingSupport;
import com.borland.dbswing.JdbEditorPane;
import com.borland.dbswing.JdbTextArea;
import com.borland.dbswing.JdbTextField;
import com.borland.dbswing.JdbTextPane;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemEditMaskState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class DBTextDataBinder
implements DocumentListener,
FocusListener,
MouseListener,
KeyListener,
AccessListener,
DataChangeListener,
NavigationListener,
UndoableEditListener,
PropertyChangeListener,
HyperlinkListener,
ColumnAware,
Designable,
Serializable {
    public static Action UNDO_ACTION = new UndoAction();
    public static Action REDO_ACTION;
    public static Action CUT_ACTION;
    public static Action COPY_ACTION;
    public static Action PASTE_ACTION;
    public static Action CLEARALL_ACTION;
    public static Action SELECTALL_ACTION;
    public static Action FONTDIALOG_ACTION;
    public static Action FOREGROUNDCOLOR_ACTION;
    public static Action BACKGROUNDCOLOR_ACTION;
    public static Action LOADFILE_ACTION;
    public static Action LOADURL_ACTION;
    public static Action SAVEFILE_ACTION;
    private static FileFilter HTMLFileFilter;
    private static FileFilter RTFFileFilter;
    private static FileFilter TextFileFilter;
    private static FileFilter SerFileFilter;
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String clearAllAction = "clear-all";
    public static final String selectAllAction = "select-all";
    public static final String loadURLAction = "load-URL";
    public static final String loadFileAction = "load-file";
    public static final String saveFileAction = "save-file";
    public static final String fontDialogAction = "font-dialog";
    public static final String foregroundColorDialogAction = "foreground-color-dialog";
    public static final String backgroundColorDialogAction = "background-color-dialog";
    public static final String nextRowAction = "next-row";
    public static final String priorRowAction = "prior-row";
    public static final String postDataAction = "post-data";
    public static final String cancelPostAction = "cancel-post";
    public static final String insertRowAction = "insert-row";
    public static final String deleteRowAction = "delete-row";
    private transient JTextComponent.KeyBinding[] fieldKeyBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 0, true), "next-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 0, true), "prior-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 0, true), "post-data"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(27, 0, true), "cancel-post"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2, true), "insert-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 2, true), "delete-row")};
    private transient JTextComponent.KeyBinding[] areaKeyBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 2, true), "next-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 2, true), "prior-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 2, true), "post-data"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(27, 0, true), "cancel-post"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2, true), "insert-row"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 2, true), "delete-row")};
    private Action[] textDataBinderActions = new Action[]{new NextRowAction(), new PriorRowAction(), new PostDataAction(), new CancelPostAction(), new InsertRowAction(), new DeleteRowAction()};
    private JTextComponent textComponent;
    private Document document;
    DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    boolean ignoreValueChange;
    private boolean textModified = false;
    private JPopupMenu menu;
    private boolean enablePopup = true;
    private boolean enableClearAll = true;
    private boolean enableFontChange = true;
    private boolean enableColorChange = true;
    private boolean enableURLLoading = true;
    private boolean enableFileLoading = true;
    private boolean enableFileSaving = true;
    private boolean enableUndoRedo = true;
    private boolean enableURLCache = true;
    private boolean postOnFocusLost = true;
    private boolean postOnRowPosted = true;
    UndoManager undoManager = new UndoManager();
    static UndoManager focusedUndoManager;
    static DBTextDataBinder focusedDataBinder;
    private static final String keymapName = "DBTextDataBinder keymap";
    private static IntlSwingSupport intlSwingSupport;
    private static JFileChooser fileChooser;
    private Point point = new Point();
    private static boolean ignoreURLChange;
    private String columnNameURL;
    private DataRow locateRow;
    private boolean rebuildMenu = true;
    private Column oldURLColumn;
    private Component oldTextComponent;
    private boolean nextFocusOnEnter = true;
    private boolean rebindColumnProperties;
    static boolean ignoreModelChange;
    private ItemEditMask ems;
    private ItemEditMaskState state;
    private boolean displayMode;
    private Variant maskVariant;
    private boolean focusLost;
    private ColumnPaintListener columnPaintListener;
    private DBCustomPaintSite customPaintSite;
    private boolean dataSetEventsEnabled = true;
    static Class class$com$borland$dbswing$DBTextDataBinder;

    public DBTextDataBinder() {
    }

    public DBTextDataBinder(JTextComponent textComponent) {
        this.setJTextComponent(textComponent);
    }

    public void setJTextComponent(JTextComponent textComponent) {
        if (this.textComponent != null && this.textComponent != textComponent) {
            this.textComponent.removePropertyChangeListener(this);
            this.textComponent.removeFocusListener(this);
            this.textComponent.removeMouseListener(this);
            JTextComponent.removeKeymap(keymapName);
            if (this.textComponent instanceof JEditorPane && !(this.textComponent instanceof JTextPane)) {
                ((JEditorPane)this.textComponent).removeHyperlinkListener(this);
            }
        }
        this.textComponent = textComponent;
        if (textComponent == null) {
            this.setDocument(null);
        } else {
            textComponent.addPropertyChangeListener(this);
            textComponent.addFocusListener(this);
            textComponent.addMouseListener(this);
            textComponent.addKeyListener(this);
            Keymap originalKeymap = textComponent.getKeymap();
            Keymap textDataBinderKeymap = JTextComponent.addKeymap(keymapName, originalKeymap);
            JTextComponent.loadKeymap(textDataBinderKeymap, textComponent instanceof JTextField ? this.fieldKeyBindings : this.areaKeyBindings, TextAction.augmentList(textComponent.getActions(), this.textDataBinderActions));
            textComponent.setKeymap(textDataBinderKeymap);
            this.setDocument(textComponent.getDocument());
            if (textComponent instanceof JEditorPane && !(textComponent instanceof JTextPane)) {
                ((JEditorPane)textComponent).addHyperlinkListener(this);
            }
        }
    }

    public JTextComponent getJTextComponent() {
        return this.textComponent;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentListener(this);
            this.document.removeUndoableEditListener(this);
            this.undoManager.discardAllEdits();
        }
        this.document = document;
        if (document != null) {
            document.addDocumentListener(this);
            document.addUndoableEditListener(this);
        }
        this.rebuildMenu = true;
        this.bindColumnProperties();
    }

    public Document getDocument() {
        return this.document;
    }

    void bindDocument(Document document, boolean bind) {
        if (bind) {
            document.addDocumentListener(this);
            document.addUndoableEditListener(this);
        } else {
            document.removeDocumentListener(this);
            document.removeUndoableEditListener(this);
        }
    }

    public void setEnablePopupMenu(boolean enablePopup) {
        this.enablePopup = enablePopup;
    }

    public boolean isEnablePopupMenu() {
        return this.enablePopup;
    }

    public void setPostOnFocusLost(boolean postOnFocusLost) {
        this.postOnFocusLost = postOnFocusLost;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setPostOnRowPosted(boolean postOnRowPosted) {
        this.postOnRowPosted = postOnRowPosted;
    }

    public boolean isPostOnRowPosted() {
        return this.postOnRowPosted;
    }

    public void postText() {
        block2: {
            try {
                this.postText2();
            }
            catch (Exception e2) {
                DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, e2);
                if (this.textComponent == null) break block2;
                this.textComponent.requestFocus();
            }
        }
    }

    public void postText2() throws Exception {
        if (this.isTextModified() && this.columnAwareSupport.isValidDataSetState()) {
            this.ignoreValueChange = true;
            if (this.columnAwareSupport.getColumn().getDataType() == 17) {
                this.bindDocument(this.document, false);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.document);
                oos.flush();
                oos.close();
                byte[] b2 = baos.toByteArray();
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b2));
                this.columnAwareSupport.setObject((Document)ois.readObject());
                baos = null;
                this.bindDocument(this.document, true);
            } else {
                String text = null;
                if (this.ems != null) {
                    if (this.maskVariant == null) {
                        this.maskVariant = new Variant();
                    }
                    try {
                        if (!this.ems.isComplete(this.state)) {
                            throw new InvalidFormatException(Res.bundle.getString(23));
                        }
                        this.ems.getFinalValue(this.state, this.maskVariant);
                        this.columnAwareSupport.setVariant(this.maskVariant);
                        this.document.remove(0, this.document.getLength());
                        this.document.insertString(0, this.columnAwareSupport.getFormattedString(), null);
                        this.displayMode = true;
                    }
                    catch (Exception e2) {
                        if (e2 instanceof InvalidFormatException) {
                            this.state.cursorPos = ((InvalidFormatException)e2).getErrorOffset();
                        }
                        this.updateSelection();
                        this.ignoreValueChange = false;
                        ValidationException.invalidFormat(e2, null, null);
                    }
                } else {
                    text = this.document.getText(0, this.document.getLength());
                    this.columnAwareSupport.setFromString2(text, this.textComponent, this.columnAwareSupport);
                    this.document.remove(0, this.document.getLength());
                    this.document.insertString(0, this.expandDateYear(this.columnAwareSupport), null);
                }
                if (this.textComponent != null) {
                    this.textComponent.setCaretPosition(0);
                    if (!this.focusLost && this.textComponent instanceof JTextField) {
                        this.textComponent.moveCaretPosition(this.document.getLength());
                        if (this.ems != null) {
                            this.ems.move(this.state, 35);
                        }
                    }
                }
            }
            this.ignoreValueChange = false;
            this.setTextModified(false);
        }
        if (this.customPaintSite != null) {
            this.customPaintSite.firePainting(this.textComponent, this, this.columnPaintListener);
        }
    }

    public void updateText() {
        if (this.ignoreValueChange) {
            return;
        }
        if (this.customPaintSite != null) {
            this.customPaintSite.firePainting(this.textComponent, this, this.columnPaintListener);
        }
        this.ignoreValueChange = true;
        try {
            if (this.columnAwareSupport.isValidDataSetState()) {
                if (this.columnAwareSupport.getColumn().getDataType() == 17) {
                    if (this.textComponent != null) {
                        Column columnURL;
                        if (this.columnNameURL != null && (columnURL = this.columnAwareSupport.dataSet.hasColumn(this.columnNameURL)) != null && !this.columnAwareSupport.dataSet.isNull(this.columnNameURL) && this.columnAwareSupport.dataSet.isNull(this.columnAwareSupport.columnName)) {
                            ((JEditorPane)this.textComponent).setPage(this.columnAwareSupport.dataSet.getString(this.columnNameURL));
                        } else {
                            Object object = this.columnAwareSupport.dataSet.getObject(this.columnAwareSupport.columnName);
                            if (object instanceof Document) {
                                try {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
                                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                                    oos.writeObject(this.columnAwareSupport.dataSet.getObject(this.columnAwareSupport.columnName));
                                    oos.flush();
                                    oos.close();
                                    byte[] b2 = baos.toByteArray();
                                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b2));
                                    this.textComponent.setDocument((Document)ois.readObject());
                                    baos = null;
                                }
                                catch (Exception e2) {
                                    DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, e2);
                                }
                            } else if (!ignoreModelChange) {
                                this.textComponent.setDocument(this.textComponent.getUI().getEditorKit(this.textComponent).createDefaultDocument());
                            }
                        }
                    }
                } else {
                    this.document.remove(0, this.document.getLength());
                    this.document.insertString(0, this.expandDateYear(this.columnAwareSupport), null);
                    if (this.ems != null) {
                        this.displayMode = true;
                    }
                }
                if (this.textComponent != null) {
                    this.textComponent.setCaretPosition(0);
                }
            }
        }
        catch (Exception e3) {
            DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, e3);
        }
        this.setTextModified(false);
        this.ignoreValueChange = false;
    }

    protected String expandDateYear(DBColumnAwareSupport columnAwareSupport) {
        String formattedValue;
        Column column = columnAwareSupport.getColumn();
        if (column != null && column.getEditMask() == null && column.getFormatter().getFormatObj() instanceof DateFormat) {
            String oldPattern = column.getFormatter().getPattern();
            String widePattern = null;
            int yearMaskIndex = -1;
            yearMaskIndex = DBUtilities.yearMaskPos(oldPattern);
            if (yearMaskIndex != -1) {
                int yearMaskCount = 1;
                int patternLength = oldPattern.length();
                while (yearMaskIndex + yearMaskCount < patternLength && oldPattern.charAt(yearMaskIndex + yearMaskCount) == 'y') {
                    ++yearMaskCount;
                }
                if (yearMaskCount < 4) {
                    widePattern = String.valueOf(new StringBuffer(String.valueOf(oldPattern.substring(0, yearMaskIndex))).append("yyyy").append(yearMaskIndex + yearMaskCount < patternLength ? oldPattern.substring(yearMaskIndex + yearMaskCount) : ""));
                }
            }
            if (widePattern != null) {
                column.getFormatter().setPattern(widePattern);
            }
            formattedValue = column.format(columnAwareSupport.getVariant());
            if (widePattern != null) {
                column.getFormatter().setPattern(oldPattern);
            }
        } else {
            formattedValue = columnAwareSupport.getFormattedString();
        }
        return formattedValue;
    }

    private static JFileChooser createFileChooser(FileFilter[] fileFilters) {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
        }
        fileChooser.resetChoosableFileFilters();
        for (int i2 = 0; i2 < fileFilters.length; ++i2) {
            fileChooser.addChoosableFileFilter(fileFilters[i2]);
        }
        fileChooser.setFileFilter(fileFilters[0]);
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        return fileChooser;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener(this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener(this);
            this.bindColumnProperties();
        }
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        if (columnName != null) {
            this.bindColumnProperties();
        }
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void setColumnNameURL(String columnNameURL) {
        this.columnNameURL = columnNameURL;
    }

    public String getColumnNameURL() {
        return this.columnNameURL;
    }

    protected JPopupMenu createPopupMenu() {
        JMenuItem menuItem;
        if (this.menu != null && !this.rebuildMenu) {
            return this.menu;
        }
        this.menu = new JPopupMenu();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (this.textComponent.isEditable()) {
            menuItem = this.menu.add(CUT_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(43));
        }
        menuItem = this.menu.add(COPY_ACTION);
        menuItem.setIcon(null);
        menuItem.setText(Res.bundle.getString(44));
        if (this.textComponent.isEditable()) {
            menuItem = this.menu.add(PASTE_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(45));
        }
        this.menu.addSeparator();
        if (this.textComponent.isEditable() && this.enableClearAll) {
            menuItem = this.menu.add(CLEARALL_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(46));
        }
        menuItem = this.menu.add(SELECTALL_ACTION);
        menuItem.setText(Res.bundle.getString(47));
        if ((this.enableFontChange || this.enableColorChange) && this.textComponent.isEditable() && this.textComponent instanceof JEditorPane && (((JEditorPane)this.textComponent).getEditorKit() instanceof StyledEditorKit || ((JEditorPane)this.textComponent).getEditorKit() instanceof RTFEditorKit) && (this.columnAwareSupport.dataSet == null || this.columnAwareSupport.columnName == null || this.columnAwareSupport.columnOrdinal != -1 && this.columnAwareSupport.getColumn().getDataType() == 17)) {
            if (this.enableFontChange) {
                this.menu.addSeparator();
                menuItem = this.menu.add(FONTDIALOG_ACTION);
                menuItem.setIcon(null);
                menuItem.setText(Res.bundle.getString(50));
            }
            if (this.enableColorChange) {
                if (!this.enableFontChange) {
                    this.menu.addSeparator();
                }
                menuItem = this.menu.add(FOREGROUNDCOLOR_ACTION);
                menuItem.setIcon(null);
                menuItem.setText(Res.bundle.getString(72));
                menuItem = this.menu.add(BACKGROUNDCOLOR_ACTION);
                menuItem.setIcon(null);
                menuItem.setText(Res.bundle.getString(73));
            }
        }
        boolean loadMenuAdded = false;
        if (this.textComponent instanceof JEditorPane && !(this.textComponent instanceof JTextPane) || this.enableFileLoading && this.textComponent.isEditable() && !(this.textComponent instanceof JTextField)) {
            if (this.textComponent instanceof JTextArea || this.textComponent instanceof JTextPane) {
                this.menu.addSeparator();
                menuItem = this.menu.add(LOADFILE_ACTION);
                menuItem.setIcon(null);
                menuItem.setText(Res.bundle.getString(52));
                loadMenuAdded = true;
            } else {
                this.menu.addSeparator();
                JMenu loadSubMenu = new JMenu(Res.bundle.getString(51));
                if (this.textComponent.isEditable() && this.enableFileLoading) {
                    if (this.enableURLLoading) {
                        menuItem = loadSubMenu.add(LOADURL_ACTION);
                        menuItem.setIcon(null);
                        menuItem.setText(Res.bundle.getString(53));
                        loadMenuAdded = true;
                    }
                    menuItem = loadSubMenu.add(LOADFILE_ACTION);
                    menuItem.setIcon(null);
                    menuItem.setText(Res.bundle.getString(55));
                    this.menu.add(loadSubMenu);
                    loadMenuAdded = true;
                } else if (this.enableURLLoading) {
                    menuItem = this.menu.add(LOADURL_ACTION);
                    menuItem.setIcon(null);
                    menuItem.setText(Res.bundle.getString(56));
                    loadMenuAdded = true;
                }
            }
        }
        if ((this.textComponent instanceof JTextArea || this.textComponent instanceof JEditorPane) && this.enableFileSaving) {
            if (!loadMenuAdded) {
                this.menu.addSeparator();
            }
            menuItem = this.menu.add(SAVEFILE_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(54));
        }
        if (this.textComponent.isEditable() && this.enableUndoRedo) {
            this.menu.addSeparator();
            menuItem = this.menu.add(UNDO_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(48));
            menuItem = this.menu.add(REDO_ACTION);
            menuItem.setIcon(null);
            menuItem.setText(Res.bundle.getString(49));
        }
        this.rebuildMenu = false;
        return this.menu;
    }

    public void setEnableClearAll(boolean enableClearAll) {
        this.enableClearAll = enableClearAll;
        this.rebuildMenu = true;
    }

    public boolean isEnableClearAll() {
        return this.enableClearAll;
    }

    public void setEnableColorChange(boolean enableColorChange) {
        this.enableColorChange = enableColorChange;
        this.rebuildMenu = true;
    }

    public boolean isEnableColorChange() {
        return this.enableColorChange;
    }

    public void setEnableFontChange(boolean enableFontChange) {
        this.enableFontChange = enableFontChange;
        this.rebuildMenu = true;
    }

    public boolean isEnableFontChange() {
        return this.enableFontChange;
    }

    public void setEnableUndoRedo(boolean enableUndoRedo) {
        this.enableUndoRedo = enableUndoRedo;
        this.rebuildMenu = true;
    }

    public boolean isEnableUndoRedo() {
        return this.enableUndoRedo;
    }

    public void setEnableURLLoading(boolean enableURLLoading) {
        this.enableURLLoading = enableURLLoading;
        this.rebuildMenu = true;
    }

    public boolean isEnableURLLoading() {
        return this.enableURLLoading;
    }

    public void setEnableURLAutoCache(boolean enableURLCache) {
        this.enableURLCache = enableURLCache;
    }

    public boolean isEnableURLAutoCache() {
        return this.enableURLCache;
    }

    public void setNextFocusOnEnter(boolean nextFocusOnEnter) {
        this.nextFocusOnEnter = nextFocusOnEnter;
    }

    public boolean isNextFocusOnEnter() {
        return this.nextFocusOnEnter;
    }

    public void setEnableFileLoading(boolean enableFileLoading) {
        this.enableFileLoading = enableFileLoading;
    }

    public boolean isEnableFileLoading() {
        return this.enableFileLoading;
    }

    public void setEnableFileSaving(boolean enableFileSaving) {
        this.enableFileSaving = enableFileSaving;
    }

    public boolean isEnableFileSaving() {
        return this.enableFileSaving;
    }

    public boolean isTextModified() {
        return this.textModified;
    }

    public void setTextModified(boolean textModified) {
        this.textModified = textModified;
    }

    private void displayPopup(Point point) {
        if (this.enablePopup) {
            this.createPopupMenu().show(this.textComponent, point.x, point.y);
        }
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
        if (e2.getPropertyName().equals("document")) {
            this.setDocument((Document)e2.getNewValue());
        }
    }

    public void insertUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    public void removeUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    public void changedUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    private void textModified(DocumentEvent e2) {
        if (!this.ignoreValueChange && !this.isTextModified() && this.columnAwareSupport.isValidDataSetState()) {
            this.ignoreValueChange = true;
            try {
                this.columnAwareSupport.dataSet.startEdit(this.columnAwareSupport.getColumn());
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, ex);
            }
            if (this.customPaintSite != null) {
                this.customPaintSite.fireEditing(this.textComponent, this, this.columnPaintListener);
            }
            this.ignoreValueChange = false;
            this.setTextModified(true);
        }
    }

    public void focusGained(FocusEvent e2) {
        this.updateUndoRedoMenu();
        CLEARALL_ACTION.setEnabled(this.textComponent.isEditable());
        CUT_ACTION.setEnabled(this.textComponent.isEditable());
        PASTE_ACTION.setEnabled(this.textComponent.isEditable());
        FONTDIALOG_ACTION.setEnabled(((FontDialogAction)FONTDIALOG_ACTION).isActionAvailable(this.textComponent));
        FOREGROUNDCOLOR_ACTION.setEnabled(((ForegroundColorDialogAction)FOREGROUNDCOLOR_ACTION).isActionAvailable(this.textComponent));
        BACKGROUNDCOLOR_ACTION.setEnabled(((BackgroundColorDialogAction)BACKGROUNDCOLOR_ACTION).isActionAvailable(this.textComponent));
        LOADURL_ACTION.setEnabled(((LoadURLAction)LOADURL_ACTION).isActionAvailable(this.textComponent));
        LOADFILE_ACTION.setEnabled(((LoadFileAction)LOADFILE_ACTION).isActionAvailable(this.textComponent));
        SAVEFILE_ACTION.setEnabled(((SaveFileAction)SAVEFILE_ACTION).isActionAvailable(this.textComponent));
        focusedUndoManager = this.undoManager;
        focusedDataBinder = this;
    }

    public void focusLost(FocusEvent e2) {
        if (this.postOnFocusLost && this.isTextModified()) {
            this.focusLost = true;
            this.postText();
            this.focusLost = false;
        }
    }

    public void mouseClicked(MouseEvent e2) {
        if (this.ems != null && this.textComponent != null) {
            if (this.displayMode) {
                this.state = this.ems.prepare(this.columnAwareSupport.getVariant());
                this.updateDisplay();
                this.textComponent.setCaretPosition(0);
                this.textComponent.moveCaretPosition(this.document.getLength());
                this.ems.move(this.state, 35);
                this.displayMode = false;
                return;
            }
            this.state.cursorPos = this.textComponent.viewToModel(e2.getPoint());
            this.updateSelection();
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.textComponent.requestFocus();
            this.focusGained(null);
            this.displayPopup(e2.getPoint());
        }
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.textComponent.requestFocus();
            this.focusGained(null);
            this.displayPopup(e2.getPoint());
        }
    }

    public void keyTyped(KeyEvent e2) {
        if (this.ems != null) {
            char ch = e2.getKeyChar();
            if (ch >= '\u0000' && ch < ' ') {
                if (ch == '\b') {
                    e2.consume();
                }
                return;
            }
            if (this.displayMode) {
                this.state = this.ems.prepare(null);
                this.ems.move(this.state, 36);
                this.updateDisplay();
                this.displayMode = false;
            } else {
                this.deleteSelection(true);
            }
            this.ems.insert(this.state, ch);
            this.updateDisplay(false);
            e2.consume();
        }
    }

    private void deleteSelection(boolean preserveAtCursor) {
        int selStart = this.textComponent.getSelectionStart();
        int selEnd = this.textComponent.getSelectionEnd();
        int nChars = selEnd - selStart;
        if (nChars > 1 || !preserveAtCursor) {
            this.ems.delete(this.state, selStart, nChars);
        }
    }

    private void updateSelection() {
        this.textComponent.setCaretPosition(this.state.cursorPos);
        if (this.state.cursorPos + 1 <= this.document.getLength()) {
            this.textComponent.moveCaretPosition(this.state.cursorPos + 1);
        }
    }

    private void updateDisplay() {
        this.updateDisplay(true);
    }

    private void updateDisplay(boolean ignore) {
        if (ignore) {
            this.ignoreValueChange = true;
        }
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, this.state.displayString.toString(), null);
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
        }
        if (ignore) {
            this.ignoreValueChange = false;
        }
        this.updateSelection();
    }

    public void keyPressed(KeyEvent e2) {
        if (this.ems != null) {
            switch (e2.getKeyCode()) {
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    this.endDisplayMode();
                    this.ems.move(this.state, e2.getKeyCode());
                    this.updateSelection();
                    break;
                }
                case 8: {
                    if (this.displayMode) {
                        this.endDisplayMode();
                        this.ems.delete(this.state, this.state.cursorPos, 1);
                        this.updateDisplay(false);
                        break;
                    }
                    this.endDisplayMode();
                    if (!this.ems.move(this.state, 37)) break;
                    this.updateSelection();
                    this.deleteSelection(false);
                    this.updateDisplay(false);
                    break;
                }
                case 127: {
                    this.endDisplayMode();
                    this.updateSelection();
                    this.deleteSelection(false);
                    this.ems.move(this.state, 39);
                    this.updateDisplay(false);
                    break;
                }
                case 9: 
                case 10: {
                    if (e2.getKeyCode() == 10 && e2.isControlDown()) {
                        this.endDisplayMode();
                        e2.consume();
                    }
                    return;
                }
                case 113: {
                    if (!this.displayMode) break;
                    this.endDisplayMode();
                    e2.consume();
                    break;
                }
                case 27: {
                    this.updateText();
                }
            }
            if (e2.isControlDown() && e2.getKeyCode() == 86 || e2.isShiftDown() && e2.getKeyCode() == 155) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable content = clipboard.getContents(this);
                if (content != null) {
                    try {
                        String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                        if (data.length() > 0) {
                            this.deleteSelection(true);
                        }
                        int end = data.length();
                        for (int i2 = 0; i2 < end; ++i2) {
                            this.ems.insert(this.state, data.charAt(i2));
                        }
                        this.updateDisplay();
                    }
                    catch (Exception ex) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                e2.consume();
                return;
            }
            e2.consume();
        }
    }

    private void endDisplayMode() {
        if (this.displayMode) {
            this.state = this.ems.prepare(this.columnAwareSupport.getVariant());
            this.ems.move(this.state, 35);
            this.updateDisplay();
            this.displayMode = false;
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateText();
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow && !this.ignoreValueChange) {
            this.updateText();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
        if (this.postOnRowPosted) {
            try {
                this.postText2();
            }
            catch (Exception e2) {
                if (this.textComponent != null) {
                    this.textComponent.requestFocus();
                }
                throw e2;
            }
        }
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldTextComponent != null) {
            DBRuntimeSupport.getInstance().removeComponent(this.oldTextComponent);
            this.oldTextComponent = null;
        }
        if (this.textComponent != null && this.textComponent.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            this.updateText();
            if (this.columnAwareSupport.isValidDataSetState()) {
                DBRuntimeSupport.getInstance().addComponent(this.textComponent, this);
                this.oldTextComponent = this.textComponent;
                Column column = this.columnAwareSupport.getColumn();
                if (this.textComponent instanceof JTextField && ((JTextField)this.textComponent).getHorizontalAlignment() == (DBUtilities.is1pt3() ? 10 : 2)) {
                    ((JTextField)this.textComponent).setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), true));
                }
                if (this.isDefaultProperty(this.textComponent.getBackground()) && column.getBackground() != null) {
                    this.textComponent.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.textComponent.getForeground()) && column.getForeground() != null) {
                    this.textComponent.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.textComponent.getFont()) && column.getFont() != null) {
                    this.textComponent.setFont(column.getFont());
                }
                this.columnPaintListener = column.getColumnPaintListener();
                if (this.columnPaintListener != null && this.customPaintSite == null) {
                    this.customPaintSite = new DBCustomPaintSite(this.textComponent);
                    this.updateText();
                }
                if (column.getDataType() == 16 && this.textComponent != null && (this.textComponent instanceof JTextField || this.textComponent instanceof JTextArea)) {
                    if (!(this.textComponent.getDocument() instanceof DBPlainDocument)) {
                        try {
                            String content = this.textComponent.getDocument().getText(0, this.textComponent.getDocument().getLength());
                            this.ignoreValueChange = true;
                            this.textComponent.setDocument(new DBPlainDocument());
                            this.textComponent.getDocument().insertString(0, content, null);
                            this.ignoreValueChange = false;
                        }
                        catch (BadLocationException e2) {
                            DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, e2);
                            this.textComponent.setDocument(new DBPlainDocument());
                        }
                    }
                    DBPlainDocument document = (DBPlainDocument)this.textComponent.getDocument();
                    if (column.getPrecision() > 0 && document.getMaxLength() != column.getPrecision()) {
                        document.setMaxLength(column.getPrecision());
                    }
                    if (column.getEditMask() != null && this.textComponent instanceof JTextField) {
                        this.ems = column.getEditMasker();
                    }
                    this.updateText();
                } else if (column.getEditMask() != null && this.textComponent instanceof JTextField) {
                    this.ems = column.getEditMasker();
                    this.updateText();
                }
                if (this.textComponent.isEditable() && !column.isEditable()) {
                    this.textComponent.setEditable(false);
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }

    public void undoableEditHappened(UndoableEditEvent e2) {
        if (this.document instanceof HTMLDocument && this.textComponent != null && !this.textComponent.isEditable()) {
            return;
        }
        this.undoManager.addEdit(e2.getEdit());
        this.updateUndoRedoMenu();
    }

    void updateUndoRedoMenu() {
        UNDO_ACTION.setEnabled(this.undoManager.canUndo() && this.textComponent.isEditable());
        REDO_ACTION.setEnabled(this.undoManager.canRedo() && this.textComponent.isEditable());
    }

    public void hyperlinkUpdate(HyperlinkEvent e2) {
        if (e2.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            ((JEditorPane)this.textComponent).setCursor(Cursor.getPredefinedCursor(12));
        } else if (e2.getEventType() == HyperlinkEvent.EventType.EXITED) {
            ((JEditorPane)this.textComponent).setCursor(Cursor.getPredefinedCursor(0));
        } else if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL currentPage = ((JEditorPane)this.textComponent).getPage();
            Frame frame = DBUtilities.getFrame(this.textComponent);
            frame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.columnNameURL != null && e2.getDescription().charAt(0) != '#') {
                    if (this.locateRow == null || this.locateRow.hasColumn(this.columnNameURL) == null) {
                        this.locateRow = new DataRow(this.columnAwareSupport.dataSet, this.columnNameURL);
                    }
                    this.locateRow.setString(this.columnNameURL, e2.getURL().toString());
                    if (!this.columnAwareSupport.dataSet.locate(this.locateRow, 32)) {
                        if (this.enableURLCache && this.columnAwareSupport.dataSet.isEnableInsert()) {
                            this.columnAwareSupport.dataSet.insertRow(false);
                        }
                        ((JEditorPane)this.textComponent).setPage(e2.getURL());
                        ignoreURLChange = true;
                        this.columnAwareSupport.dataSet.setString(this.columnNameURL, e2.getURL().toString());
                        ignoreURLChange = false;
                    } else if (this.columnAwareSupport.dataSet.isNull(this.columnAwareSupport.columnName)) {
                        ((JEditorPane)this.textComponent).setPage(e2.getURL());
                    }
                } else {
                    ((JEditorPane)this.textComponent).setPage(e2.getURL());
                }
            }
            catch (Exception ex) {
                DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.textComponent, ex);
            }
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        UNDO_ACTION.putValue("SmallIcon", new ImageIcon(UNDO_ACTION.getClass().getResource("image/undo.gif")));
        REDO_ACTION = new RedoAction();
        REDO_ACTION.putValue("SmallIcon", new ImageIcon(REDO_ACTION.getClass().getResource("image/redo.gif")));
        CUT_ACTION = new DefaultEditorKit.CutAction();
        CUT_ACTION.putValue("SmallIcon", new ImageIcon((class$com$borland$dbswing$DBTextDataBinder == null ? (class$com$borland$dbswing$DBTextDataBinder = DBTextDataBinder.class$("com.borland.dbswing.DBTextDataBinder")) : class$com$borland$dbswing$DBTextDataBinder).getResource("image/cut.gif")));
        COPY_ACTION = new DefaultEditorKit.CopyAction();
        COPY_ACTION.putValue("SmallIcon", new ImageIcon((class$com$borland$dbswing$DBTextDataBinder == null ? (class$com$borland$dbswing$DBTextDataBinder = DBTextDataBinder.class$("com.borland.dbswing.DBTextDataBinder")) : class$com$borland$dbswing$DBTextDataBinder).getResource("image/copy.gif")));
        PASTE_ACTION = new DefaultEditorKit.PasteAction();
        PASTE_ACTION.putValue("SmallIcon", new ImageIcon((class$com$borland$dbswing$DBTextDataBinder == null ? (class$com$borland$dbswing$DBTextDataBinder = DBTextDataBinder.class$("com.borland.dbswing.DBTextDataBinder")) : class$com$borland$dbswing$DBTextDataBinder).getResource("image/paste.gif")));
        CLEARALL_ACTION = new ClearAllAction();
        CLEARALL_ACTION.putValue("SmallIcon", new ImageIcon(CLEARALL_ACTION.getClass().getResource("image/clearAll.gif")));
        SELECTALL_ACTION = new SelectAllAction();
        FONTDIALOG_ACTION = new FontDialogAction();
        FONTDIALOG_ACTION.putValue("SmallIcon", new ImageIcon(FONTDIALOG_ACTION.getClass().getResource("image/font.gif")));
        FOREGROUNDCOLOR_ACTION = new ForegroundColorDialogAction();
        FOREGROUNDCOLOR_ACTION.putValue("SmallIcon", new ImageIcon(FOREGROUNDCOLOR_ACTION.getClass().getResource("image/fgcolor.gif")));
        BACKGROUNDCOLOR_ACTION = new BackgroundColorDialogAction();
        BACKGROUNDCOLOR_ACTION.putValue("SmallIcon", new ImageIcon(BACKGROUNDCOLOR_ACTION.getClass().getResource("image/bgcolor.gif")));
        LOADFILE_ACTION = new LoadFileAction();
        LOADFILE_ACTION.putValue("SmallIcon", new ImageIcon(LOADFILE_ACTION.getClass().getResource("image/loadFile.gif")));
        LOADURL_ACTION = new LoadURLAction();
        LOADURL_ACTION.putValue("SmallIcon", new ImageIcon(LOADURL_ACTION.getClass().getResource("image/loadURL.gif")));
        SAVEFILE_ACTION = new SaveFileAction();
        SAVEFILE_ACTION.putValue("SmallIcon", new ImageIcon(SAVEFILE_ACTION.getClass().getResource("image/saveFile.gif")));
        HTMLFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.toUpperCase().endsWith("HTML") || fileName.toUpperCase().endsWith("HTM");
            }

            public String getDescription() {
                return Res.bundle.getString(59);
            }
        };
        RTFFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.toUpperCase().endsWith("RTF");
            }

            public String getDescription() {
                return Res.bundle.getString(61);
            }
        };
        TextFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.toUpperCase().endsWith("TXT");
            }

            public String getDescription() {
                return Res.bundle.getString(60);
            }
        };
        SerFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.toUpperCase().endsWith("SER");
            }

            public String getDescription() {
                return Res.bundle.getString(62);
            }
        };
        intlSwingSupport = new IntlSwingSupport();
        ignoreURLChange = false;
        ignoreModelChange = false;
    }

    static class DBCustomPaintSite
    implements CustomPaintSite {
        private Color background;
        private Color foreground;
        private Font font;
        private int alignment;
        private int hAlignment;
        private Insets margin;
        private Color defaultForeground;
        private Color defaultBackground;
        private Font defaultFont;
        private int defaultAlignment;
        private Insets defaultMargins;
        private JTextComponent textComponent;

        public DBCustomPaintSite(JTextComponent textComponent) {
            this.initDefaults(textComponent);
        }

        void initDefaults(JTextComponent textComponent) {
            this.background = this.defaultBackground = textComponent.getBackground();
            this.foreground = this.defaultForeground = textComponent.getForeground();
            this.font = this.defaultFont = textComponent.getFont();
            if (textComponent instanceof JTextField) {
                this.hAlignment = this.defaultAlignment = ((JTextField)textComponent).getHorizontalAlignment();
            }
            this.margin = this.defaultMargins = textComponent.getMargin();
            this.textComponent = textComponent;
        }

        void updateComponent() {
            if (this.background != this.defaultBackground) {
                this.textComponent.setBackground(this.background);
            }
            if (this.foreground != this.defaultForeground) {
                this.textComponent.setForeground(this.foreground);
            }
            if (this.font != this.defaultFont) {
                this.textComponent.setFont(this.font);
            }
            if (this.hAlignment != this.defaultAlignment && this.textComponent instanceof JTextField) {
                ((JTextField)this.textComponent).setHorizontalAlignment(this.hAlignment);
            }
            if (this.margin != this.defaultMargins || !this.margin.equals(this.defaultMargins)) {
                this.textComponent.setMargin(this.margin);
            }
        }

        void fireEditing(JTextComponent textComponent, DBTextDataBinder binder, ColumnPaintListener columnPaintListener) {
            this.reset();
            columnPaintListener.editing(binder.columnAwareSupport.dataSet, binder.columnAwareSupport.getColumn(), this);
            this.updateComponent();
        }

        void firePainting(JTextComponent textComponent, DBTextDataBinder binder, ColumnPaintListener columnPaintListener) {
            this.reset();
            Variant variantValue = binder.columnAwareSupport.getVariant();
            Variant variantCopy = (Variant)variantValue.clone();
            columnPaintListener.painting(binder.columnAwareSupport.dataSet, binder.columnAwareSupport.getColumn(), binder.columnAwareSupport.dataSet.getRow(), variantValue, this);
            if (variantCopy != null && !variantCopy.equals(variantValue)) {
                binder.ignoreValueChange = true;
                try {
                    textComponent.setText(binder.columnAwareSupport.getColumn().format(variantValue));
                }
                catch (Exception e2) {
                    DBExceptionHandler.handleException(binder.columnAwareSupport.dataSet, textComponent, e2);
                }
                binder.ignoreValueChange = false;
            }
            this.updateComponent();
        }

        public void reset() {
            this.setBackground(this.defaultBackground);
            this.setForeground(this.defaultForeground);
            this.setFont(this.defaultFont);
            if (this.textComponent instanceof JTextField) {
                this.hAlignment = this.defaultAlignment;
            }
            this.margin = this.defaultMargins;
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setForeground(Color foregound) {
            this.foreground = this.foreground;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setAlignment(int alignment) {
            this.alignment = alignment;
            this.convertAlignment(alignment);
        }

        public int getAlignment() {
            return this.alignment;
        }

        private void convertAlignment(int alignment) {
            this.hAlignment = DBUtilities.convertJBCLToSwingAlignment(alignment, true);
        }

        public void setItemMargins(Insets margin) {
            this.margin = margin;
        }

        public Insets getItemMargins() {
            return this.margin;
        }

        public boolean isTransparent() {
            return false;
        }

        public Component getSiteComponent() {
            return this.textComponent;
        }
    }

    static abstract class DBTextAction
    extends TextAction {
        JTextComponent target;

        public DBTextAction(String actionName) {
            super(actionName);
        }

        protected final DBTextDataBinder getDBTextDataBinder(ActionEvent e2) {
            this.target = this.getTextComponent(e2);
            if (focusedDataBinder != null && focusedDataBinder.getJTextComponent() == this.target) {
                return focusedDataBinder;
            }
            if (this.target != null) {
                if (this.target instanceof JdbTextField) {
                    return ((JdbTextField)this.target).getDataBinder();
                }
                if (this.target instanceof JdbTextArea) {
                    return ((JdbTextArea)this.target).getDataBinder();
                }
                if (this.target instanceof JdbTextPane) {
                    return ((JdbTextPane)this.target).getDataBinder();
                }
                if (this.target instanceof JdbEditorPane) {
                    return ((JdbEditorPane)this.target).getDataBinder();
                }
            }
            return null;
        }
    }

    public static class BackgroundColorDialogAction
    extends TextAction {
        public BackgroundColorDialogAction() {
            super(DBTextDataBinder.backgroundColorDialogAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/bgcolor.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (this.isActionAvailable(target)) {
                Color selectedColor = null;
                selectedColor = JColorChooser.showDialog(target, Res.bundle.getString(71), null);
                if (selectedColor != null) {
                    EditorKit editorKit;
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setBackground(attr, selectedColor);
                    int selStart = target.getSelectionStart();
                    int selEnd = target.getSelectionEnd();
                    if (selStart != selEnd) {
                        StyledDocument doc = (StyledDocument)target.getDocument();
                        doc.setCharacterAttributes(selStart, selEnd - selStart, attr, false);
                    } else if (target instanceof JEditorPane && (editorKit = ((JEditorPane)target).getEditorKit()) instanceof StyledEditorKit) {
                        MutableAttributeSet inputAttributes = ((StyledEditorKit)editorKit).getInputAttributes();
                        inputAttributes.addAttributes(attr);
                    }
                }
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target.isEditable() && target.getDocument() instanceof StyledDocument;
        }
    }

    public static class ForegroundColorDialogAction
    extends TextAction {
        public ForegroundColorDialogAction() {
            super(DBTextDataBinder.foregroundColorDialogAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/fgcolor.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (this.isActionAvailable(target)) {
                Color selectedColor = null;
                selectedColor = JColorChooser.showDialog(target, Res.bundle.getString(71), null);
                if (selectedColor != null) {
                    EditorKit editorKit;
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setForeground(attr, selectedColor);
                    int selStart = target.getSelectionStart();
                    int selEnd = target.getSelectionEnd();
                    if (selStart != selEnd) {
                        StyledDocument doc = (StyledDocument)target.getDocument();
                        doc.setCharacterAttributes(selStart, selEnd - selStart, attr, false);
                    } else if (target instanceof JEditorPane && (editorKit = ((JEditorPane)target).getEditorKit()) instanceof StyledEditorKit) {
                        MutableAttributeSet inputAttributes = ((StyledEditorKit)editorKit).getInputAttributes();
                        inputAttributes.addAttributes(attr);
                    }
                }
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target.isEditable() && target.getDocument() instanceof StyledDocument;
        }
    }

    public static class FontDialogAction
    extends TextAction {
        FontChooser fontChooser = new FontChooser();

        public FontDialogAction() {
            super(DBTextDataBinder.fontDialogAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/font.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (this.isActionAvailable(target)) {
                this.fontChooser.setFrame(DBUtilities.getFrame(target));
                int selStart = target.getSelectionStart();
                int selEnd = target.getSelectionEnd();
                if (this.fontChooser.showDialog()) {
                    EditorKit editorKit;
                    Font selectedFont = this.fontChooser.getSelectedFont();
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setFontFamily(attr, selectedFont.getFontName());
                    StyleConstants.setFontSize(attr, selectedFont.getSize());
                    if (selStart != selEnd) {
                        StyledDocument doc = (StyledDocument)target.getDocument();
                        doc.setCharacterAttributes(selStart, selEnd - selStart, attr, false);
                    } else if (target instanceof JEditorPane && (editorKit = ((JEditorPane)target).getEditorKit()) instanceof StyledEditorKit) {
                        MutableAttributeSet inputAttributes = ((StyledEditorKit)editorKit).getInputAttributes();
                        inputAttributes.addAttributes(attr);
                    }
                }
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target.isEditable() && target.getDocument() instanceof StyledDocument;
        }
    }

    public static class DeleteRowAction
    extends DBTextAction {
        public DeleteRowAction() {
            super(DBTextDataBinder.deleteRowAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/delete.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DataSet dataSet;
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null && (dataSet = dataBinder.columnAwareSupport.dataSet) != null && dataSet.isEditable() && dataSet.isEnableDelete()) {
                boolean readOnly = false;
                if (dataSet instanceof StorageDataSet) {
                    readOnly = ((StorageDataSet)dataSet).isReadOnly();
                }
                if (!readOnly) {
                    try {
                        if (!dataSet.isEmpty()) {
                            dataSet.deleteRow();
                        }
                    }
                    catch (DataSetException ex) {
                        DBExceptionHandler.handleException(dataSet, this.target, ex);
                    }
                }
            }
        }
    }

    public static class InsertRowAction
    extends DBTextAction {
        public InsertRowAction() {
            super(DBTextDataBinder.insertRowAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/insert.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DataSet dataSet;
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null && (dataSet = dataBinder.columnAwareSupport.dataSet) != null && dataSet.isEditable() && dataSet.isEnableInsert() && !dataSet.isEditingNewRow()) {
                try {
                    dataSet.insertRow(true);
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(dataSet, this.target, ex);
                }
            }
        }
    }

    public static class CancelPostAction
    extends DBTextAction {
        public CancelPostAction() {
            super(DBTextDataBinder.cancelPostAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/cancel.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null && dataBinder.isTextModified()) {
                dataBinder.updateText();
            }
            if (this.target != null) {
                this.target.setCaretPosition(0);
                this.target.moveCaretPosition(this.target.getDocument().getLength());
            }
        }
    }

    public static class PostDataAction
    extends DBTextAction {
        public PostDataAction() {
            super(DBTextDataBinder.postDataAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/post.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null) {
                try {
                    dataBinder.postText2();
                    if (dataBinder.isNextFocusOnEnter() && this.target instanceof JTextField) {
                        FocusManager.getCurrentManager().focusNextComponent(this.target);
                    }
                }
                catch (Exception ex) {
                    DBExceptionHandler.handleException(dataBinder.columnAwareSupport.dataSet, this.target, ex);
                }
            }
        }
    }

    public static class PriorRowAction
    extends DBTextAction {
        public PriorRowAction() {
            super(DBTextDataBinder.priorRowAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/prior.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null && dataBinder.columnAwareSupport.dataSet != null) {
                try {
                    dataBinder.columnAwareSupport.dataSet.prior();
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(dataBinder.columnAwareSupport.dataSet, this.target, ex);
                }
            }
        }
    }

    public static class NextRowAction
    extends DBTextAction {
        public NextRowAction() {
            super(DBTextDataBinder.nextRowAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/next.gif")));
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null && dataBinder.columnAwareSupport.dataSet != null) {
                try {
                    dataBinder.columnAwareSupport.dataSet.next();
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(dataBinder.columnAwareSupport.dataSet, this.target, ex);
                }
            }
        }
    }

    public static class SaveFileAction
    extends TextAction {
        public SaveFileAction() {
            super(DBTextDataBinder.saveFileAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/saveFile.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (this.isActionAvailable(target)) {
                JFileChooser fileChooser = null;
                String contentType = "text/plain";
                if (target instanceof JTextArea) {
                    fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter});
                    fileChooser.setDialogTitle(Res.bundle.getString(64));
                } else if (target instanceof JTextPane) {
                    fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter, SerFileFilter});
                    fileChooser.setDialogTitle(Res.bundle.getString(69));
                } else if (target instanceof JEditorPane) {
                    contentType = ((JEditorPane)target).getContentType();
                    if (contentType.equals("text/rtf")) {
                        fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter, RTFFileFilter, SerFileFilter});
                        fileChooser.setDialogTitle(Res.bundle.getString(66));
                    } else if (contentType.equals("text/html")) {
                        fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter, HTMLFileFilter, SerFileFilter});
                        fileChooser.setDialogTitle(Res.bundle.getString(67));
                    } else {
                        fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter});
                        fileChooser.setDialogTitle(Res.bundle.getString(64));
                    }
                }
                if (fileChooser.showSaveDialog(target) == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (file != null) {
                        int response;
                        if (file.exists() && (response = JOptionPane.showConfirmDialog(target, Res.bundle.getString(70), "", 2)) != 0) {
                            return;
                        }
                        Frame frame = DBUtilities.getFrame(target);
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        if (file.getName().toUpperCase().endsWith("SER")) {
                            try {
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                                if (focusedDataBinder != null && focusedDataBinder.getJTextComponent() == target) {
                                    focusedDataBinder.bindDocument(target.getDocument(), false);
                                }
                                objectOutputStream.writeObject(target.getDocument());
                                if (focusedDataBinder != null && focusedDataBinder.getJTextComponent() == target) {
                                    focusedDataBinder.bindDocument(target.getDocument(), true);
                                }
                                objectOutputStream.flush();
                                objectOutputStream.close();
                            }
                            catch (Exception ex) {
                                DBExceptionHandler.handleException(null, target, ex);
                            }
                        } else if (contentType.equals("text/rtf") && !file.getName().toUpperCase().endsWith("TXT")) {
                            try {
                                FileOutputStream outputStream = new FileOutputStream(file);
                                ((JEditorPane)target).getEditorKit().write(outputStream, target.getDocument(), 0, target.getDocument().getLength());
                                outputStream.flush();
                                ((OutputStream)outputStream).close();
                            }
                            catch (Exception ex) {
                                DBExceptionHandler.handleException(null, target, ex);
                            }
                        } else {
                            try {
                                FileWriter writer = new FileWriter(file);
                                if (file.getName().toUpperCase().endsWith("TXT")) {
                                    writer.write(target.getDocument().getText(0, target.getDocument().getLength()));
                                } else {
                                    target.write(writer);
                                }
                                ((Writer)writer).flush();
                                ((Writer)writer).close();
                            }
                            catch (Exception ex) {
                                DBExceptionHandler.handleException(null, target, ex);
                            }
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    target.repaint();
                }
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target instanceof JTextArea || target instanceof JEditorPane;
        }
    }

    public static class LoadFileAction
    extends TextAction {
        public LoadFileAction() {
            super(DBTextDataBinder.loadFileAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/loadFile.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (this.isActionAvailable(target)) {
                JFileChooser fileChooser = null;
                if (target instanceof JTextArea) {
                    fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter});
                    fileChooser.setDialogTitle(Res.bundle.getString(63));
                } else if (target instanceof JTextPane) {
                    fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter, SerFileFilter});
                    fileChooser.setDialogTitle(Res.bundle.getString(68));
                } else if (target instanceof JEditorPane) {
                    fileChooser = DBTextDataBinder.createFileChooser(new FileFilter[]{TextFileFilter, HTMLFileFilter, RTFFileFilter, SerFileFilter});
                    fileChooser.setDialogTitle(Res.bundle.getString(65));
                }
                if (fileChooser.showOpenDialog(target) == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (file != null && file.exists()) {
                        Frame frame = DBUtilities.getFrame(target);
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        if (target instanceof JTextArea || target instanceof JTextPane) {
                            if (target instanceof JTextPane && file.getName().toUpperCase().endsWith("SER")) {
                                try {
                                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                                    Object object = objectInputStream.readObject();
                                    if (object instanceof StyledDocument) {
                                        ((JTextPane)target).setStyledDocument((StyledDocument)object);
                                    } else {
                                        JOptionPane.showMessageDialog(target, Res.bundle.getString(74), "", 0);
                                    }
                                    objectInputStream.close();
                                }
                                catch (Exception ex) {
                                    DBExceptionHandler.handleException(null, target, ex);
                                }
                            } else {
                                try {
                                    BufferedReader reader = new BufferedReader(new FileReader(file));
                                    JTextField temp = new JTextField();
                                    temp.read(reader, file.getCanonicalPath());
                                    try {
                                        String content = temp.getDocument().getText(0, temp.getDocument().getLength());
                                        target.getDocument().remove(0, target.getDocument().getLength());
                                        target.getDocument().insertString(0, content, null);
                                    }
                                    catch (BadLocationException ex) {
                                        DBExceptionHandler.handleException(ex);
                                    }
                                    ((Reader)reader).close();
                                }
                                catch (Exception ex) {
                                    DBExceptionHandler.handleException(null, target, ex);
                                }
                            }
                        } else if (file.getName().toUpperCase().endsWith("SER")) {
                            try {
                                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                                Object object = objectInputStream.readObject();
                                if (object instanceof HTMLDocument) {
                                    ((JEditorPane)target).setContentType("text/html");
                                    target.setDocument((Document)object);
                                } else if (object instanceof PlainDocument || object instanceof StyledDocument) {
                                    ((JEditorPane)target).setContentType("text/plain");
                                    target.setDocument((Document)object);
                                } else {
                                    JOptionPane.showMessageDialog(target, Res.bundle.getString(74), null, 1);
                                }
                                objectInputStream.close();
                            }
                            catch (Exception ex) {
                                DBExceptionHandler.handleException(null, target, ex);
                            }
                        } else {
                            try {
                                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                                String type = URLConnection.guessContentTypeFromStream(inputStream);
                                if (type == null) {
                                    ((InputStream)inputStream).mark(5);
                                    int c1 = ((InputStream)inputStream).read();
                                    int c2 = ((InputStream)inputStream).read();
                                    int c3 = ((InputStream)inputStream).read();
                                    int c4 = ((InputStream)inputStream).read();
                                    int c5 = ((InputStream)inputStream).read();
                                    ((InputStream)inputStream).reset();
                                    type = c1 == 123 && c2 == 92 && c3 == 114 && c4 == 116 && c5 == 102 ? "text/rtf" : "text/plain";
                                }
                                ((JEditorPane)target).setContentType(type);
                                Document document = ((JEditorPane)target).getEditorKit().createDefaultDocument();
                                ignoreModelChange = true;
                                target.setDocument(document);
                                ignoreModelChange = false;
                                if (type.equals("text/rtf")) {
                                    ((JEditorPane)target).getEditorKit().read(inputStream, document, 0);
                                } else {
                                    try {
                                        BufferedReader inputStreamReader = new BufferedReader(new InputStreamReader(inputStream));
                                        document.putProperty("IgnoreCharsetDirective", new Boolean(true));
                                        ((JEditorPane)target).getEditorKit().read(inputStreamReader, document, 0);
                                        ((Reader)inputStreamReader).close();
                                    }
                                    catch (Exception ex) {
                                        DBExceptionHandler.handleException(null, target, ex);
                                    }
                                }
                                ((InputStream)inputStream).close();
                            }
                            catch (Exception ex) {
                                DBExceptionHandler.handleException(null, target, ex);
                            }
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        JOptionPane.showMessageDialog(target, Res.bundle.getString(75), "", 0);
                    }
                }
                target.repaint();
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target.isEditable() && target instanceof JTextArea || target instanceof JEditorPane;
        }
    }

    public static class LoadURLAction
    extends DBTextAction {
        public LoadURLAction() {
            super(DBTextDataBinder.loadURLAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/loadURL.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (this.isActionAvailable(this.target)) {
                String promptString = Res.bundle.getString(57);
                StringBuffer widePrompt = new StringBuffer(Math.max(60, promptString.length()));
                widePrompt.append(promptString);
                for (int i2 = widePrompt.length(); i2 < widePrompt.capacity(); ++i2) {
                    widePrompt.append(' ');
                }
                String url = JOptionPane.showInputDialog(this.target, widePrompt.toString(), Res.bundle.getString(58), 3);
                if (url == null) {
                    return;
                }
                Frame frame = DBUtilities.getFrame(this.target);
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                }
                try {
                    ((JEditorPane)this.target).setPage(url);
                    if (dataBinder != null && dataBinder.columnAwareSupport.dataSet != null && dataBinder.columnNameURL != null && dataBinder.columnAwareSupport.dataSet.hasColumn(dataBinder.columnNameURL) != null) {
                        ignoreURLChange = true;
                        dataBinder.columnAwareSupport.dataSet.setString(dataBinder.columnNameURL, url);
                        ignoreURLChange = false;
                    }
                }
                catch (Exception ex) {
                    DBExceptionHandler.handleException(null, this.target, ex);
                }
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        public boolean isActionAvailable(JTextComponent target) {
            return target != null && target instanceof JEditorPane && !(target instanceof JTextPane);
        }
    }

    public static class SelectAllAction
    extends TextAction {
        public SelectAllAction() {
            super(DBTextDataBinder.selectAllAction);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.setCaretPosition(0);
                target.moveCaretPosition(target.getDocument().getLength());
            }
        }
    }

    public static class ClearAllAction
    extends TextAction {
        public ClearAllAction() {
            super(DBTextDataBinder.clearAllAction);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null && target.isEditable()) {
                try {
                    target.getDocument().remove(0, target.getDocument().getLength());
                }
                catch (BadLocationException ex) {
                    DBExceptionHandler.handleException(null, target, ex);
                }
            }
        }
    }

    public static class RedoAction
    extends DBTextAction {
        public RedoAction() {
            super(DBTextDataBinder.redoAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/redo.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null) {
                try {
                    if (focusedUndoManager.canRedo()) {
                        focusedUndoManager.redo();
                        UNDO_ACTION.setEnabled(focusedUndoManager.canUndo());
                        REDO_ACTION.setEnabled(focusedUndoManager.canRedo());
                    }
                }
                catch (CannotRedoException ex) {
                    this.target.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoAction
    extends DBTextAction {
        public UndoAction() {
            super(DBTextDataBinder.undoAction);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("image/undo.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            DBTextDataBinder dataBinder = this.getDBTextDataBinder(e2);
            if (dataBinder != null) {
                try {
                    if (focusedUndoManager.canUndo()) {
                        focusedUndoManager.undo();
                        UNDO_ACTION.setEnabled(focusedUndoManager.canUndo());
                        REDO_ACTION.setEnabled(focusedUndoManager.canRedo());
                    }
                }
                catch (CannotUndoException ex) {
                    this.target.getToolkit().beep();
                }
            }
        }
    }
}

