/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBDataBinder;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class DBSliderDataBinder
implements ChangeListener,
PropertyChangeListener,
DBDataBinder,
AccessListener,
DataChangeListener,
NavigationListener,
ColumnAware,
Designable,
Serializable {
    private JSlider slider;
    private JSlider oldSlider;
    private BoundedRangeModel boundedRangeModel;
    private int mode = 0;
    DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    private boolean ignoreValueChange;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public DBSliderDataBinder() {
    }

    public DBSliderDataBinder(JSlider slider) {
        this.setJSlider(slider);
    }

    public void setJSlider(JSlider slider) {
        if (this.slider != null && this.slider != slider) {
            this.slider.removePropertyChangeListener(this);
        }
        this.slider = slider;
        if (slider == null) {
            this.setBoundedRangeModel(null);
        } else {
            slider.addPropertyChangeListener(this);
            this.setBoundedRangeModel(slider.getModel());
        }
    }

    public JSlider getJSlider() {
        return this.slider;
    }

    public void setBoundedRangeModel(BoundedRangeModel boundedRangeModel) {
        if (this.boundedRangeModel != null) {
            this.boundedRangeModel.removeChangeListener(this);
        }
        this.boundedRangeModel = boundedRangeModel;
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this);
        }
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.boundedRangeModel;
    }

    public void setUnknownDataValueMode(int mode) {
        this.mode = mode;
    }

    public int getUnknownDataValueMode() {
        return this.mode;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener(this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener(this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
        if (e2.getPropertyName().equals("model")) {
            this.setBoundedRangeModel((BoundedRangeModel)e2.getNewValue());
        }
    }

    public void stateChanged(ChangeEvent e2) {
        if (!this.ignoreValueChange && !this.boundedRangeModel.getValueIsAdjusting() && this.columnAwareSupport.isValidDataSetState()) {
            this.columnAwareSupport.setFromString(String.valueOf(this.boundedRangeModel.getValue()).concat(""), this.slider);
        }
    }

    private void updateSliderState() {
        this.ignoreValueChange = true;
        if (this.columnAwareSupport.isValidDataSetState()) {
            int value = this.columnAwareSupport.getVariant().getAsInt();
            if (value >= this.boundedRangeModel.getMinimum() && value <= this.boundedRangeModel.getMaximum()) {
                this.boundedRangeModel.setValue(value);
            } else if (this.mode == 1 && this.slider != null && !this.columnAwareSupport.getVariant().isUnassignedNull()) {
                this.slider.setEnabled(false);
            } else if (this.mode == 2 && !this.columnAwareSupport.isNull()) {
                this.columnAwareSupport.resetValue();
            } else {
                this.boundedRangeModel.setValue(value);
            }
        } else if (this.boundedRangeModel != null) {
            this.boundedRangeModel.setValue(this.boundedRangeModel.getValue());
        }
        this.ignoreValueChange = false;
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateSliderState();
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateSliderState();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldSlider != null) {
            DBRuntimeSupport.getInstance().removeComponent(this.oldSlider);
            this.oldSlider = null;
        }
        if (this.slider != null && this.slider.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            this.updateSliderState();
            if (this.columnAwareSupport.isValidDataSetState()) {
                DBRuntimeSupport.getInstance().addComponent(this.slider, this);
                this.oldSlider = this.slider;
                Column column = this.columnAwareSupport.getColumn();
                if (this.isDefaultProperty(this.slider.getBackground()) && column.getBackground() != null) {
                    this.slider.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.slider.getForeground()) && column.getForeground() != null) {
                    this.slider.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.slider.getFont()) && column.getFont() != null) {
                    ((JComponent)this.slider).setFont(column.getFont());
                }
                if (this.slider.getMinimum() == 0 && column.getMinValue() != null && column.getMinValue().getType() == 4) {
                    this.slider.setMinimum(column.getMinValue().getInt());
                }
                if (this.slider.getMaximum() == 0 && column.getMaxValue() != null && column.getMaxValue().getType() == 4) {
                    this.slider.setMaximum(column.getMaxValue().getInt());
                }
                if (this.slider.isEnabled() && !column.isEditable()) {
                    this.slider.setEnabled(false);
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            if (this.mode == 1) {
                this.slider.setEnabled(false);
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }
}

