/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBDataBinder;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBListModel;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class DBListDataBinder
implements ListSelectionListener,
AccessListener,
PropertyChangeListener,
NavigationListener,
DataChangeListener,
ColumnAware,
DBDataBinder,
Designable,
Serializable {
    private JList jList;
    private JList oldJList;
    private ListSelectionModel listSelectionModel;
    private ListModel listModel;
    private DBListModel dbListModel;
    private int mode = 0;
    private DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    private boolean ignoreValueChange;
    private DataSetView dataSetView;
    private DataRow locateRow;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public DBListDataBinder() {
    }

    public DBListDataBinder(JList jList) {
        this.setJList(jList);
    }

    public void setJList(JList jList) {
        if (this.jList != null && this.jList != jList) {
            this.jList.removePropertyChangeListener(this);
        }
        this.jList = jList;
        if (jList == null) {
            this.setListSelectionModel(null);
            this.setListModel(null);
        } else {
            jList.addPropertyChangeListener(this);
            this.setListSelectionModel(jList.getSelectionModel());
            this.setListModel(jList.getModel());
        }
    }

    public JList getJList() {
        return this.jList;
    }

    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.removeListSelectionListener(this);
        }
        this.listSelectionModel = listSelectionModel;
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
        }
        this.bindColumnProperties();
    }

    public ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
        this.dbListModel = null;
        if (listModel instanceof DBListModel) {
            this.dbListModel = (DBListModel)listModel;
        }
        this.dataSetView = null;
        this.locateRow = null;
        this.bindColumnProperties();
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener(this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener(this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void setUnknownDataValueMode(int mode) {
        this.mode = mode;
    }

    public int getUnknownDataValueMode() {
        return this.mode;
    }

    public void valueChanged(ListSelectionEvent e2) {
        if (!this.ignoreValueChange && !e2.getValueIsAdjusting()) {
            int index = this.listSelectionModel.getMinSelectionIndex();
            if (index == -1) {
                index = e2.getFirstIndex();
            }
            this.columnAwareSupport.lazyOpen();
            if (this.dbListModel != null) {
                this.columnAwareSupport.setVariant(this.dbListModel.getVariantElementAt(index));
            } else {
                this.columnAwareSupport.setObject(this.listModel.getElementAt(index));
            }
        }
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateSelectedListValue();
    }

    private void updateSelectedListValue() {
        int newIndex = -1;
        if (!this.columnAwareSupport.isValidDataSetState()) {
            this.ignoreValueChange = true;
            if (this.listSelectionModel != null) {
                this.listSelectionModel.clearSelection();
            }
            this.ignoreValueChange = false;
            return;
        }
        if (this.dbListModel != null) {
            try {
                if (this.dataSetView == null) {
                    this.dataSetView = this.dbListModel.getDataSet().cloneDataSetView();
                }
                if (this.locateRow == null) {
                    this.locateRow = new DataRow((DataSet)this.dataSetView, this.dbListModel.getColumnName());
                }
                this.locateRow.setVariant(this.dbListModel.getColumnName(), this.columnAwareSupport.getVariant());
                if (this.dataSetView.locate(this.locateRow, 32)) {
                    newIndex = this.dataSetView.getRow();
                }
            }
            catch (DataSetException e2) {
                DBExceptionHandler.handleException(this.dataSetView, e2);
            }
        } else if (this.listModel != null) {
            int lastRow = this.listModel.getSize();
            Object locateValue = this.columnAwareSupport.getVariant().getAsObject();
            for (int index = 0; index < lastRow; ++index) {
                if (!this.listModel.getElementAt(index).equals(locateValue)) continue;
                newIndex = index;
                break;
            }
        }
        this.ignoreValueChange = true;
        if (newIndex == -1) {
            if (this.mode == 2 && !this.columnAwareSupport.isNull()) {
                this.columnAwareSupport.lazyOpen();
                this.columnAwareSupport.resetValue();
            } else if (this.mode == 1) {
                if (this.jList != null && !this.columnAwareSupport.getVariant().isUnassignedNull()) {
                    this.jList.setEnabled(false);
                }
            } else {
                this.listSelectionModel.clearSelection();
            }
        } else {
            if (this.mode == 1 && this.jList != null && !this.jList.isEnabled()) {
                this.jList.setEnabled(true);
            }
            this.listSelectionModel.setSelectionInterval(newIndex, newIndex);
            if (this.jList != null) {
                this.jList.ensureIndexIsVisible(newIndex);
            }
        }
        this.ignoreValueChange = false;
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateSelectedListValue();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            this.listSelectionModel.clearSelection();
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
        if (e2.getPropertyName().equals("selectionModel")) {
            this.setListSelectionModel((ListSelectionModel)e2.getNewValue());
        } else if (e2.getPropertyName().equals("model")) {
            this.setListModel((ListModel)e2.getNewValue());
        }
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldJList != null) {
            DBRuntimeSupport.getInstance().removeComponent(this.oldJList);
            this.oldJList = null;
        }
        if (this.jList != null && this.jList.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            this.updateSelectedListValue();
            if (this.columnAwareSupport.isValidDataSetState()) {
                DBRuntimeSupport.getInstance().addComponent(this.jList, this);
                this.oldJList = this.jList;
                Column column = this.columnAwareSupport.getColumn();
                if (this.isDefaultProperty(this.jList.getBackground()) && column.getBackground() != null) {
                    this.jList.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.jList.getForeground()) && column.getForeground() != null) {
                    this.jList.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.jList.getFont()) && column.getFont() != null) {
                    this.jList.setFont(column.getFont());
                }
                if (this.jList.isEnabled() && !column.isEditable()) {
                    this.jList.setEnabled(false);
                }
            }
        }
    }
}

