// DOZE - a Win32 batch utility to cause a batch sleep for a specified period of time.

// Copyright (C) 2000 Clem Dye

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include <stdio.h>
#include <windows.h>

void main(int argc, char *argv[], char *envp[])
{
	char cLit_Value[8];
	long lDoze_Time = 10;	// Define a default value to use if we're executed without a command-line argument.
	long lArg_Doze_Time;	// Used to get a command-line doze value, if supplied.

	if (argc > 1)		// We're only interested in the first argument, even if others are present.
	{
		lArg_Doze_Time = atol(argv[1]);
		if (lArg_Doze_Time == 0) // We didn't find any numeric data in the argument ...
		{
			lArg_Doze_Time = lDoze_Time;
			printf("Invalid command-line argument - using default doze value (%d seconds).\n", lArg_Doze_Time);
		}
		if (lArg_Doze_Time < 0) // We can't sleep for a negative amount of time!
		{	
			printf("Negative doze value detected (%d) ... correcting.\n", lArg_Doze_Time);
			lArg_Doze_Time = lArg_Doze_Time * -1;
		}
		lDoze_Time = lArg_Doze_Time;
	}

	if (lDoze_Time == 1)
		strcpy(cLit_Value,"second\0");
	else
		strcpy(cLit_Value,"seconds\0");

	printf("Dozing for %d %s .....\n", lDoze_Time, cLit_Value);

	Sleep (lDoze_Time * 1000);

	exit(0);
}
