// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : sir.c
// Description  : replace insert strings from sgrep output files
//                into original files
// Written by   : Bill Buckels
// Date Written : 1994
// Revision     : 1.1 First Release
//                2.0 Added Support For Long FileNames and logfile - Feb 2000
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <dos.h>

#define TRUE  1
#define FALSE 0

void nocr(char *buffer)
{
  int i;
  for(i = 0;buffer[i] != 0;i++)
  {
    if(buffer[i] == 13 || buffer[i] == 10)buffer[i] = 0;
  }
  
}


void WriteLog(char *found, int flen, char *replaced, int rlen, FILE *fp)
{
  if(fp == NULL)return;
  if (replaced != NULL) {
    if (!strcmp(&found[13], replaced))
      return;
  }
  fwrite(found, flen, 1, fp);
  fputc(13, fp);
  fputc(10, fp);
  if(replaced == NULL) 
  {
    return;
  }
  fwrite(found, 13, 1, fp);
  fwrite(replaced, rlen, 1, fp);
  fputc(13, fp);
  fputc(10, fp);
  return;
}


int main(int argc, char **argv)
{
  int i;
  char buffer[512], buffer2[512], buffer3[512], scratch[512];
  char logname[_MAX_PATH];
  char *ptr,*ptr2;
  long linenumbers[512],ltemp,lctr;
  unsigned ctr,linectr,tempctr,limit,j;
  unsigned DONE = FALSE;
  char filespec[_MAX_PATH];
  struct _finddata_t wildcard;
  long findhandle;
  
  // just call him sir
  FILE *script, *dict, *outfile, *fp, *fp2, *fp3;
  

  puts("SIR(C) CopyLeft Bill Buckels 1994-2000. All Rights Reversed.");

  if(argc != 2)
  {
    puts("Usage is \"SIR [sgrep.grp]");
    return 0;
  }
  
  // open the script
  if((script = fopen(argv[1], "r")) == NULL)
  {
    perror(argv[1]);
    return 0;
  }
  
  // added for SLM
  strcpy(logname, argv[1]);
  for(j = 0;logname[j] != 0;j++) 
  {
    if(logname[j] == '.') 
    {
      logname[j] = 0;
      strcat(logname, ".log");
      break;
    }
  }
  fp3 = fopen(logname, "ab");
  
  printf("Now Processing script %s\n", argv[1]);
  
  if(fgets(buffer, 512, script) == NULL)
  {
    perror(argv[1]);
    fcloseall();
    return 0;
  }
  
  DONE = FALSE;
  for(;;)
  {
    if(DONE == TRUE)break;
    if(buffer[0] == 32)
    {
      perror(argv[1]);
      fcloseall();
      return 0;
    }
    nocr(buffer);

    // skip files
    while ((findhandle = _findfirst(buffer,&wildcard)) < 1l) {
      printf("Skipping : %s\n", buffer);
      for (;;) {
        if (fgets(buffer, 512, script) == NULL) DONE = TRUE;
        if (buffer[0] != 32) {
          nocr(buffer);
          break;
        }
      }
    }
    _findclose(findhandle);
    if (DONE == TRUE) break;

    remove("$$$$$$$$.SIR");
    if(rename(buffer, "$$$$$$$$.SIR"))
    {
      perror(buffer);
      fcloseall();
      return 0;
    }
    if((fp = fopen("$$$$$$$$.SIR", "r")) == NULL)
    {
      rename("$$$$$$$$.SIR", buffer);
      perror(buffer);
      fcloseall();
      return 0;
    }
    if((outfile = fopen(buffer, "wb")) == NULL)
    {
      rename("$$$$$$$$.SIR", buffer);
      perror(buffer);
      fcloseall();
      return 0;
    }
    lctr = 0L;
    
    printf("Changing : %s\n", buffer);
    WriteLog(buffer, strlen(buffer), NULL, 0, fp3);
    
    
    // get the first line to change
    if(fgets(buffer2, 512, script) == NULL)
    {
      perror(buffer);
      fcloseall();
      return 0;
    }
    nocr(buffer2);
    strcpy(scratch, buffer2);
    ltemp = atol(scratch);             // get the first line to change
    lctr = 0L;
    ptr = (char *)&buffer2[13];        // point to the correct row
    // everything is ok so change the file
    for(;;)
    {
      // if we are finished writing break... assume that
      // the next entry is a file name
      if((fgets(buffer3, 512, fp)) == NULL)
      {
        fclose(outfile);
        fclose(fp);
        remove("$$$$$$$$.SIR");
        break;
      }
      nocr(buffer3);
      lctr++;
      if(lctr == ltemp)
      {
        if(strlen(ptr) > 0) 
        {
          fwrite(ptr, strlen(ptr), 1, outfile);
          fputc(13, outfile);
          fputc(10, outfile);
          WriteLog(buffer2, strlen(buffer2), buffer3, strlen(buffer3), fp3);
        }
        // get the next line to change
        if(fgets(buffer2, 512, script) == NULL)
        {
          DONE = TRUE;
          ltemp = 0L;
        }
        else
        {
          nocr(buffer2);
          strcpy(scratch, buffer2);
          ltemp = atol(scratch);
          strcpy(buffer, buffer2);
          ptr = (char *)&buffer2[13];  // point to the correct row
        }
      }
      else
      {
        // if the line number is not a match
        // put back the original
        nocr(buffer3);
        if(strlen(buffer3) > 0)
          fwrite(buffer3, strlen(buffer3), 1, outfile);
        fputc(13, outfile);
        fputc(10, outfile);
      }
    }
  }
  
  fcloseall();
  puts("Have a nice dos!");
  return 0;
}
