// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : sum.c
// Description  : A filter that adds columns from the console
//                or from redirected input.
//
// Written by   : Bill Buckels
// Date Written : 1995
// Revision     : 2.0 March 2000
// ------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
  float sum, temp;
  char buffer[128];
  long tst,cnt;
  int i;
  
  
  if(argc > 1)
  {
    puts("SUM(C) CopyLeft Bill Buckels 1995-2000. All Rights Reversed");
    puts("Purpose : add columns from the console or from redirected input");
    puts("Usage 1 : console : Enter Numbers, Enter Blank or \"=\" for sum.");
    puts("Usage 2 : file    : \"sum < numbers.txt\"");
    return 1;
  }
  
  sum = (float)0;
  cnt = 0L;
  
  for(;;)
  {
    if(gets(buffer) == NULL)break;
    if(buffer[0] == '=' || buffer[0] == 0)break;
    temp = (float)atof(buffer);
    sum += temp;
    cnt += 1;
  }
  
  tst = (long)sum;
  
  if(tst < sum)
  {
    sprintf(buffer, "Sum     = %f", sum);
    for(;;)
    {
      i = strlen(buffer) - 1;
      if(buffer[i] != 48)break;
      buffer[i] = 0;
    }
  }
  else
  {
    sprintf(buffer, "Sum     = %ld", tst);
  }
  puts(buffer);
  
  if(cnt == 0)return 0;
  
  
  printf("Divisor = %ld\n", cnt);
  sum /= cnt;
  tst = (long)sum;
  
  if(tst < sum)
  {
    sprintf(buffer, "Average = %f", sum);
    for(;;)
    {
      i = strlen(buffer) - 1;
      if(buffer[i] != 48)break;
      buffer[i] = 0;
    }
  }
  else
  {
    sprintf(buffer, "Average = %ld", tst);
  }
  puts(buffer);
  
  return 0;
  
}
