Attribute VB_Name = "Module2"
'FILE: dxtables.bas
'
'Termination mask defines for use with ATDX_TERMMSK( )
 
Global Const TM_NORMTERM = &H0              ' Normal Termination
Global Const TM_MAXDTMF = &H1               ' Max Number of Digits Recd
Global Const TM_MAXSIL = &H2                ' Max Silence
Global Const TM_MAXNOSIL = &H4              ' Max Non-Silence
Global Const TM_LCOFF = &H8                 ' Loop Current Off
Global Const TM_IDDTIME = &H10              ' Inter Digit Delay
Global Const TM_MAXTIME = &H20              ' Max Function Time Exceeded
Global Const TM_DIGIT = &H40                ' Digit Mask or Digit Type Term.
Global Const TM_PATTERN = &H80              ' Pattern Match Silence Off
Global Const TM_USRSTOP = &H100             ' Function Stopped by User
Global Const TM_EOD = &H200                 ' End of Data Reached on Playback
Global Const TM_TONE = &H2000               ' Tone On/Off Termination
Global Const TM_ERROR = &H80000             ' I/O Device Error

Global Const IO_DEV = &H0                   ' play/record from a file
Global Const IO_MEM = &H8                   ' play/record from memory
Global Const IO_UIO = &H10                  ' play/record using user I/O functions

'Defines for the TPT
 
Global Const DX_MAXDTMF = 1                 ' Maximum Number of Digits Received
Global Const DX_MAXSIL = 2                  ' Maximum Silence
Global Const DX_MAXNOSIL = 3                ' Maximum Non-Silence
Global Const DX_LCOFF = 4                   ' Loop Current Off
Global Const DX_IDDTIME = 5                 ' Inter-Digit Delay
Global Const DX_MAXTIME = 6                 ' Function Time
Global Const DX_DIGMASK = 7                 ' Digit Mask Termination
Global Const DX_PMOFF = 8                   ' Pattern Match Silence On
Global Const DX_PMON = 9                    ' Pattern Match Silence Off
Global Const DX_DIGTYPE = 11                ' Digit Type Termination
Global Const DX_TONE = 12                   ' Tone On/Off Termination

'Defines for TPT Termination Flags
 
Global Const TF_EDGE = &H0
Global Const TF_LEVEL = &H1
Global Const TF_CLREND = &H2
Global Const TF_CLRBEG = &H4
Global Const TF_USE = &H8
Global Const TF_SETINIT = &H10
Global Const TF_10MS = &H20
Global Const TF_FIRST = TF_CLREND

Global Const TF_MAXDTMF = (TF_LEVEL Or TF_USE)
Global Const TF_MAXSIL = (TF_EDGE Or TF_USE)
Global Const TF_MAXNOSIL = (TF_EDGE Or TF_USE)
Global Const TF_LCOFF = (TF_LEVEL Or TF_USE Or TF_CLREND)
Global Const TF_IDDTIME = (TF_EDGE)
Global Const TF_MAXTIME = (TF_EDGE)
Global Const TF_DIGMASK = (TF_LEVEL)
Global Const TF_PMON = (TF_EDGE)
Global Const TF_DIGTYPE = (TF_LEVEL)
Global Const TF_TONE = (TF_LEVEL Or TF_USE Or TF_CLREND)

'Defines for the DV_TPT data for DX_TONE terminator
 
Global Const DX_TONEON = &H1
Global Const DX_TONEOFF = &H0


