#!/usr/local/bin/perl
#-----------------------------------------------------------------------

#-----------------------------------------------------------------------
sub get_input_parameters
{

   $Sport = $q->param("Sport");
   $StatsGames = $q->param("StatsGames");
   $MaxGames   = $q->param("MaxGames");
   if (!MaxGames) { $MaxGames = 100; }
   $StatsTeams = $q->param("StatsTeams");
   $StatsPitchers = $q->param("StatsPitchers");

   if ($q->param("place"))   { $levex = 1; $levels[$q->param("place")-1]   = "place"; }
   if ($q->param("odds"))    { $levex = 1; $levels[$q->param("odds")-1]    = "odds"; }
   if (!$levex) { $levels[0] = "nogroup"; }

   for($i=1;$q->param("Data$i");$i++)
   {
      $what[$i-1]  = $q->param("Data$i");
      $bold[$i-1]  = $q->param("D${i}Bold");
      $color[$i-1] = $q->param("Color${i}");
      $def[$i-1]   = $q->param("D${i}Def");
      $newl[$i-1]  = $q->param("D${i}New");
   }

   $teams_file = "${Sport}_teams.txt";

   $ShowInCols = 0;
   if (($q->param("Show")) eq "C")
   {
      $ShowInCols = 1;
   }

   # For testing
   # $levels[0] = "cover";
   # $levels[1] = "place";
   # $what[0] = "won";
   # $what[1] = "lost";
}

#-----------------------------------------------------------------------
sub get_teams
{

   if (!open(TEAMS,"<${basedir}$teams_file"))
   {
      print "File ${basedir}$teams_file not opened"; 
      exit(0); 
   }

   my $sn = 0;
   while($tmp=<TEAMS>)
   {
      chomp($tmp);
      ($id,$name,$brief,$league,$cover,$cdate) = split(/\s*\|\s*/,$tmp);

      $team{$id}{name}   = $name;
      $team{$id}{brief}  = $brief;
      $team{$id}{league} = $league;
      $team{$id}{cover}  = $cover;
      $team{$id}{cdate}  = $cdate;
      $team{$id}{sn}     = $sn;
      $team_name{$name}  = $id;
      # print "$id|$name|$brief|$league|$cover|$cdate\n";
      $sn++;
   }
   close(TEAMS);
   $team{0}{name} = "Combined";
}

#-----------------------------------------------------------------------
sub print_start_of_games_table
{

   if ($StatsGames)
   {
      print <<START_GAMES;
<table $TableWidth cellspacing="$CellSpacing" class="ResultTable">
  <col width="16%" align="center">
  <col width="28%">
  <col width="18%">
  <col width="9%" align="center">
  <col width="9%" align="center">
  <col width="10%" align="center">
  <col width="10%" align="center">
  <caption class="ResultCaption">
      Games found (<font color="red">Major League Baseball</font>)
  </caption>
  <tr class="ResultHeadRow">
    <th class="ResultHeadCell">
      Date
    </th>
    <th class="ResultHeadCell">
      Teams
    </th>
    <th class="ResultHeadCell">
      Pitchers
    </th>
    <th class="ResultHeadCell">
      Score
    </th>
    <th class="ResultHeadCell">
      Total Score
    </th>
    <th class="ResultHeadCell">
      Line
    </th>
    <th class="ResultHeadCell">
      Total Line
    </th>
  </tr>
START_GAMES
   }
}

#-----------------------------------------------------------------------
sub print_games_table_row
{
   if ($StatsGames && $Count<$MaxGames)
   {
      $ShowCount++;
      if ($away_won)
      {
         $show_away_name  = "<font color=\"black\"><b>$away_name</b></font>";
         $show_away_score = "<font color=\"blue\">$away_score</font>";
      }
      else
      {
         $show_away_name  = $away_name;
         if ($home_won) { $show_away_score = "<font color=\"red\">$away_score</font>"; }
         else { $show_away_score = "<font color=\"green\">$away_score</font>"; }
      }
      if ($home_won)
      {
         $show_home_name  = "<font color=\"black\"><b>$home_name</b></font>";
         $show_home_score = "<font color=\"blue\">$home_score</font>";
      }
      else
      {
         $show_home_name = $home_name;
         if ($away_won) { $show_home_score = "<font color=\"red\">$home_score</font>"; }
         else { $show_home_score = "<font color=\"green\">$home_score</font>"; }
      }
      $a_hand = uc($away_hand);
      $h_hand = uc($home_hand);
      print <<GAME;
   <tr class="ResultRow">
     <td class="$CellStyle">
         <font color="blue">$dt <b>$mo_name</b> $yr</font>
       <br>
       <b>$weekday</b>
     </td>
     <td class="$CellStyle">
       $away_league &nbsp; $show_away_name<br>
       $home_league &nbsp; $show_home_name
     </td>
     <td class="$CellStyle">
       $away_pitcher -$a_hand<br>
       $home_pitcher -$h_hand
     </td>
     <td class="$CellStyle">
       $show_away_score<br>
       $show_home_score
     </td>
     <td class="$CellStyle">
       $total_score
     </td>
     <td class="$CellStyle">
       $away_line<br>
       $home_line
     </td>
     <td class="$CellStyle">
       $total_line<br>
       $over_under
     </td>
   </tr>
GAME
   }
}

#-----------------------------------------------------------------------
sub print_end_of_games_table
{
   if ($StatsGames)
   {
      if ($ShowCount!=$Count)
      {
print <<END_GAMES;
  <tr class="ResultBottomRow">
    <td class="ResultBottomCell" colspan="7" align="left">$ShowCount of Total $Count games found are listed</td>
  </tr>
</table>
END_GAMES
      }
      else
      {
print <<END_GAMES;
  <tr class="ResultBottomRow">
    <td class="ResultBottomCell" colspan="7" align="left">$Count games are found</td>
  </tr>
</table>
END_GAMES
      }
   }
}

1;

#-----------------------------------------------------------------------
#   EOF
