#!/usr/local/bin/perl
#-----------------------------------------------------------------------

#-----------------------------------------------------------------------
sub show_score
{
   my ($title,$elem) = @_;
print <<SHOW_SCORE;
  <tr>
    <td  class="$title">Score is equal to</td>
    <td  class="$elem"><input type="text" name="AwayScore" size=4></td>
    <td  class="$title">Score is equal to</td>
    <td  class="$elem"><input type="text" name="HomeScore" size=4></td>
  </tr>
SHOW_SCORE
}

#-----------------------------------------------------------------------
sub show_score_range
{
   my ($title,$elem) = @_;
print <<SHOW_SCORE_RANGE;
  <tr>
    <td  class="$title">Or Score is from</td>
    <td  class="$elem"><input type="text" name="AwayScoreFrom" size=4> <b>to</b> <input type="text" name="AwayScoreTo" size=4></td>
    <td  class="$title">Or Score  is from</td>
    <td  class="$elem"><input type="text" name="HomeScoreFrom" size=4> <b>to</b> <input type="text" name="HomeScoreTo" size=4></td>
  </tr>
SHOW_SCORE_RANGE
}

#-----------------------------------------------------------------------
sub show_data
{
   my ($i,$class,$par) = @_;
   my $CheckedDef    = "";
   my $CheckedNew    = "";
   my $CheckedBold   = "";
   my $SelectedBlack = "";
   my $SelectedRed   = "";
   my $SelectedGreen = "";
   my $SelectedBlue  = "";

   # my $Data  = $q->param("Data$i");
   # my $Color = $q->param("Color$i");
   # if ($Data)  { $tmp = "Selected$Data";  $$tmp = "selected"; }
   # if ($Color) { $tmp = "Selected$Color"; $$tmp = "selected"; }

   if ($par eq "Off") { $SelectedOff = "selected"; }
   elsif ($par eq "Def") { $SelectedDef = "selected"; }
   elsif ($par eq "Count") { $SelectedCount = "selected"; }
   elsif ($par eq "WLT") { $SelectedWLT = "selected"; }
   elsif ($par eq "PCT") { $SelectedPCT = "selected"; }
   elsif ($par eq "ScoreTotal") { $SelectedTotal = "selected"; }

   if ($q->param("Def$i"))  { $CheckedDef  = "checked"; }
   if ($q->param("New$i"))  { $CheckedNew  = "checked"; }
   if ($q->param("Bold$i")) { $CheckedBold = "checked"; }
print <<SHOW_DATA;
    <td  class="Title">Then</td>
    <td colspan="2" class="$class">
      <select name="Data${i}" size="1" style="font-family: arial, tahoma, verdana, sans-serif, helvetica; font-size: 8pt">
        <option value="" $SelectedNone>None</option>
        <option value="off"    $SelectedOff>Offensive Power</option>
        <option value="def"    $SelectedDef>Defensive Power</option>
        <option value="count"  $SelectedCount>Game Count</option>
        <option value="wlt"    $SelectedWLT>WLT</option>
        <option value="pct"    $SelectedPCT>PCT</option>
        <option value="total"  $SelectedTotal>Average Total Score</option>
      </select>
      &nbsp;&nbsp; then place
      <input type="checkbox" name="D${i}Def" value="1"  $CheckedDef>"-"&nbsp;or
      <input type="checkbox" name="D${i}New" value="1"  $CheckedNew>New Line&nbsp;&nbsp;(if in Rows)<br>
      <input type="checkbox" name="D${i}Bold" value="1" $CheckedBold>Bold
      &nbsp;&nbsp; Color &nbsp;
      <select name="Color${i}" size="1" style="font-family: arial, tahoma, verdana, sans-serif, helvetica; font-size: 8pt">
        <option value="black" $SelectedBlack>Black</option>
        <option value="red"   $SelectedRed>Red</option>
        <option value="green" $SelectedGreen>Green</option>
        <option value="blue"  $SelectedBlue>Blue</option>
      </select>
    </td>
  </tr>
SHOW_DATA
}

#-----------------------------------------------------------------------
sub set_selected
{
   my ($level) = @_;

   $Selected0 = ""; 
   $Selected1 = ""; 
   $Selected2 = ""; 
   $Selected3 = ""; 

   if ($level==1) { $Selected1 = "selected"; }
   elsif ($level==2) { $Selected2 = "selected"; }
   elsif ($level==3) { $Selected3 = "selected"; }
   
}

#-----------------------------------------------------------------------
sub get_teams_select
{
   my ($teams) = @_;
   my $select = "";
   if (!open(TEAMS,"<$teams")) { return(""); }
   while($tmp=<TEAMS>)
   {
      chomp($tmp);
      ($id,$name,$brief,$league,$cover,$cdate) = split(/\s*\|\s*/,$tmp);

      $select .= "<option value=\"$id\">$name<br>\n";
   }
   close(TEAMS);
   return($select);
}

#-----------------------------------------------------------------------
sub get_teams_checkboxes
{
   my ($teams) = @_;
   my $checkboxes = "";
   if (!open(TEAMS,"<$teams")) { return(""); }
   while($tmp=<TEAMS>)
   {
      chomp($tmp);
      ($id,$name,$brief,$league,$cover,$cdate) = split(/\s*\|\s*/,$tmp);

      $checkboxes .= "      <input type=\"checkbox\" name=\"team_$id\" value=\"1\" checked>$brief\n";
   }
   close(TEAMS);
   return($checkboxes);
}

#-----------------------------------------------------------------------
sub build_selection
{
   my ($ListOfYears) = @_;

   my $i;
   $Selection = "PLAYED ";
   $ind = 0;
   if (!$q->param("AllYears"))
   {
      $it = 0;
      for ($i=0;$i<@$ListOfYears;$i++)
      {
         if ($q->param("Year$i"))
         {
            if (!$it) { $Selection .= " (";  }
            if ($it)  { $Selection .= " <font color=blue>OR</font> "; }
            $Selection .= "Year=<font color=green>".$ListOfYears->[$i]."</font>";
            $it = 1;
            $ind = 1;
         }
      }
      if ($it)
      {
         $Selection .= ") ";
      }
   }

   my @HomeTeamID     = $q->param("HomeTeamID");
   my @VisitorTeamID  = $q->param("VisitorTeamID");
   @SearchHomeID1 = @HomeTeamID;
   @SearchVisitorID1 = @VisitorTeamID;
   $SelectionTeam1 = "";
   $tind = 0;
   if (scalar(@HomeTeamID)>1 || $HomeTeamID[0])
   {
      $SearchTeams = 1;
      $it = 0;
      foreach $id (@HomeTeamID)
      {
         if ($it) { $SelectionTeam1 .= " <font color=blue>OR</font> "; }
         else { $SelectionTeam1 .= "("; }
         $SelectionTeam1 .= "Home Team = <font color=green>".$team{$id}{name}."</font>";
         $it = 1;
      }
      if ($it) { $SelectionTeam1 .= ")"; $tind = 1; }
   }
   else { $NotHomeTeamID1 = 1; }
   if (scalar(@VisitorTeamID)>1 || $VisitorTeamID[0])
   {
      $SearchTeams = 1;
      $it = 0;
      if ($tind) { $SelectionTeam1 .= " <font color=blue>AND</font> "; }
      foreach $id (@VisitorTeamID)
      {
         if ($it) { $SelectionTeam1 .= " <font color=blue>OR</font> "; }
         else { $SelectionTeam1 .= "("; }
         $SelectionTeam1 .= "Visitor Team = <font color=green>".$team{$id}{name}."</font>";
         $it = 1;
      }
      if ($it) { $SelectionTeam1 .= ")"; $tind = 1; }
   }
   else { $NotVisitorTeamID1 = 1; }
   $tind = 0;
   if ($q->param("HomeOrAway"))
   {
      @VisitorTeamID  = $q->param("HomeTeamID");
      @HomeTeamID  = $q->param("VisitorTeamID");
      @SearchHomeID2 = @HomeTeamID;
      @SearchVisitorID2 = @VisitorTeamID;
      $SelectionTeam2 = "";
      if (scalar(@HomeTeamID)>1 || $HomeTeamID[0])
      {
         $SearchTeams = 1;
         $it = 0;
         foreach $id (@HomeTeamID)
         {
            if ($it) { $SelectionTeam2 .= " <font color=blue>OR</font> "; }
            else { $SelectionTeam2 .= "("; }
            $SelectionTeam2 .= "Home Team = <font color=green>".$team{$id}{name}."</font>";
            $it = 1;
         }
         if ($it) { $SelectionTeam2 .= ")"; $tind = 1; }
      }
      else { $NotHomeTeamID2 = 1; }
      if (scalar(@VisitorTeamID)>1 || $VisitorTeamID[0])
      {
         $SearchTeams = 1;
         $it = 0;
         if ($tind) { $SelectionTeam2 .= " <font color=blue>AND</font> "; }
         foreach $id (@VisitorTeamID)
         {
            if ($it) { $SelectionTeam2 .= " <font color=blue>OR</font> "; }
            else { $SelectionTeam2 .= "("; }
            $SelectionTeam2 .= "Visitor Team = <font color=green>".$team{$id}{name}."</font>";
            $it = 1;
         }
         if ($it) { $SelectionTeam2 .= ")"; }
      }
      else { $NotVisitorTeamID2 = 1; }
   }
   if ($SelectionTeam1 && $SelectionTeam2)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " (($SelectionTeam1) <font color=blue>OR</font> ($SelectionTeam2)) ";
      $ind = 1;
   }
   if ($SelectionTeam1 && !$SelectionTeam2)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " ($SelectionTeam1) ";
      $ind = 1;
   }
   if (!$SelectionTeam1 && $SelectionTeam2)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " ($SelectionTeam2) ";
      $ind = 1;
   }
   $AwayLeague = $q->param("AwayLeague");
   if ($AwayLeague eq "A")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Team is <font color=green>AL Team</font> ";
      $ind = 1;
   }
   elsif ($AwayLeague eq "N")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Team is <font color=green>NL Team</font> ";
      $ind = 1;
   }
   $HomeLeague = $q->param("HomeLeague");
   if ($HomeLeague eq "A")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Team is <font color=green>AL Team</font> ";
      $ind = 1;
   }
   elsif ($HomeLeague eq "N")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Team is <font color=green>NL Team</font> ";
      $ind = 1;
   }
   $League = $q->param("League");
   if ($League eq "I")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game is <font color=green>InterLeague Game</font> ";
      $ind = 1;
   }
   elsif ($League eq "L")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game is <font color=green>League Game</font> ";
      $ind = 1;
   }
   $AwayWon  = $q->param("AwayWon");
   $AwayLost = $q->param("AwayLost");
   $Tie = $q->param("Tie");
   if ($AwayWon && !$AwayLost)
   {
      $CheckAwayWon = 1;
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      if ($Tie) { $Selection .= "("; }
      $Selection .= " Visitor Team won ";
      if ($Tie) { $Selection .= " OR was Push) "; }
      $ind = 1;
   }
   if (!$AwayWon && $AwayLost)
   {
      $CheckHomeWon = 1;
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      if ($Tie) { $Selection .= "("; }
      $Selection .= " Visitor Team lost ";
      if ($Tie) { $Selection .= " OR was Push) "; }
      $ind = 1;
   }
   $HomeWon  = $q->param("HomeWon");
   $HomeLost = $q->param("HomeLost");
   if ($HomeWon && !$HomeLost)
   {
      $CheckHomeWon = 1;
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      if ($Tie) { $Selection .= "("; }
      $Selection .= " Home Team won ";
      if ($Tie) { $Selection .= " OR was Push) "; }
      $ind = 1;
   }
   if (!$HomeWon && $HomeLost)
   {
      $CheckAwayWon = 1;
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      if ($Tie) { $Selection .= "("; }
      $Selection .= " Home Team lost ";
      if ($Tie) { $Selection .= " OR was Push) "; }
      $ind = 1;
   }
   if ($Tie && ((!$HomeWon && !$HomeLost) || (!$AwayWon && !$AwayLost)))
   {
      $TieOnly = 1;
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " was Push ";
   }
   $AwayFav = $q->param("AwayFav");
   $HomeFav = $q->param("HomeFav");
   $AwayDog = $q->param("AwayDog");
   $HomeDog = $q->param("HomeDog");
   if ($AwayFav && !$HomeFav)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Team was Favorite ";
      $ind = 1;
   }
   if (!$AwayFav && $HomeFav)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Team was Favorite ";
      $ind = 1;
   }
   if ($AwayDog && !$HomeDog)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Team was Underdog ";
      $ind = 1;
   }
   if (!$AwayDog && $HomeDog)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Team was Underdog ";
      $ind = 1;
   }
   $AwayLine = $q->param("AwayLine");
   if ($AwayLine)
   {
      if (!is_numeric($AwayLine))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Line is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Line is equal to <font color=green>$AwayLine</font>";
      $ind = 1;
   }
   $HomeLine = $q->param("HomeLine");
   if ($HomeLine)
   {
      if (!is_numeric($HomeLine))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Line is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Line is equal to <font color=green>$HomeLine</font>";
      $ind = 1;
   }
   $AwayLineFrom = $q->param("AwayLineFrom");
   if ($AwayLineFrom)
   {
      if (!is_numeric($AwayLineFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Line From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Line is from <font color=green>$AwayLineFrom</font>";
      $ind = 1;
   }
   $AwayLineTo = $q->param("AwayLineTo");
   if ($AwayLineTo)
   {
      if (!is_numeric($AwayLineTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Line To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Line is up to <font color=green>$AwayLineTo</font>";
      $ind = 1;
   }
   $HomeLineFrom = $q->param("HomeLineFrom");
   if ($HomeLineFrom)
   {
      if (!is_numeric($HomeLineFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Line From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Line is from <font color=green>$HomeLineFrom</font>";
      $ind = 1;
   }
   $HomeLineTo = $q->param("HomeLineTo");
   if ($HomeLineTo)
   {
      if (!is_numeric($HomeLineTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Line To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Line is up to <font color=green>$HomeLineTo</font>";
      $ind = 1;
   }
   $AwayScore = $q->param("AwayScore");
   if ($AwayScore)
   {
      if (!is_numeric($AwayScore))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Score is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Score is equal to <font color=green>$AwayScore</font>";
      $ind = 1;
   }
   $HomeScore = $q->param("HomeScore");
   if ($HomeScore)
   {
      if (!is_numeric($HomeScore))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Score is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Score is equal to <font color=green>$HomeScore</font>";
      $ind = 1;
   }
   $AwayScoreFrom = $q->param("AwayScoreFrom");
   if ($AwayScoreFrom)
   {
      if (!is_numeric($AwayScoreFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Score From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Score is from <font color=green>$AwayScoreFrom</font>";
      $ind = 1;
   }
   $AwayScoreTo = $q->param("AwayScoreTo");
   if ($AwayScoreTo)
   {
      if (!is_numeric($AwayScoreTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Visitor Score To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Score is up to <font color=green>$AwayScoreTo</font>";
      $ind = 1;
   }
   $HomeScoreFrom = $q->param("HomeScoreFrom");
   if ($HomeScoreFrom)
   {
      if (!is_numeric($HomeScoreFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Score From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Score is from <font color=green>$HomeScoreFrom</font>";
      $ind = 1;
   }
   $HomeScoreTo = $q->param("HomeScoreTo");
   if ($HomeScoreTo)
   {
      if (!is_numeric($HomeScoreTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Home Score To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Score is up to <font color=green>$HomeScoreTo</font>";
      $ind = 1;
   }
   $Pitcher = uc($q->param("Pitcher"));
   if ($Pitcher)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Pitcher is <font color=green>$Pitcher</font>";
      $ind = 1;
   }
   $HomePitcher = uc($q->param("HomePitcher"));
   if ($HomePitcher)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Pitcher is like <font color=green>$HomePitcher</font>";
      $ind = 1;
   }
   $AwayPitcher = uc($q->param("AwayPitcher"));
   if ($AwayPitcher)
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Away Pitcher is like <font color=green>$AwayPitcher</font>";
      $ind = 1;
   }
   $AwayHand = $q->param("AwayHand");
   if ($AwayHand eq "r")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Pitcher Hand is <font color=green>Right</font> ";
      $ind = 1;
   }
   elsif ($AwayHand eq "l")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Visitor Pitcher Hand is <font color=green>Left</font> ";
      $ind = 1;
   }
   $HomeHand = $q->param("HomeHand");
   if ($HomeHand eq "r")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Pitcher Hand is <font color=green>Right</font> ";
      $ind = 1;
   }
   elsif ($HomeHand eq "l")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Home Pitcher Hand is <font color=green>Left</font> ";
      $ind = 1;
   }
   $Mon = $q->param("Mon");
   $Tue = $q->param("Tue");
   $Wed = $q->param("Wed");
   $Thu = $q->param("Thu");
   $Fri = $q->param("Fri");
   $Sat = $q->param("Sat");
   $Sun = $q->param("Sun");
   if (!$Mon || !$Tue || !$Wed || !$Thu || !$Fri || !$Sat || !$Sun)
   {
      $wd = 0;
      if ($Mon)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         $Selection .= " on <font color=green>Monday</font> ";
         $wd = 1;
      }
      if ($Tue)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Tuesday</font> ";
         $wd = 1;
      }
      if ($Wed)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Wednesday</font> ";
         $wd = 1;
      }
      if ($Thu)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Thursday</font> ";
         $wd = 1;
      }
      if ($Fri)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Friday</font> ";
         $wd = 1;
      }
      if ($Sat)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Saturday</font> ";
         $wd = 1;
      }
      if ($Sun)
      {
         $CheckWeekdays = 1;
         if (!$wd && $ind) { $Selection .= " <font color=blue>AND</font> "; }
         if (!$wd) { $Selection .= " Teams played "; }
         if ($wd) { $Selection .= " OR "; }
         $Selection .= " on <font color=green>Sunday</font> ";
         $wd = 1;
      }
   }
   $StartDate = $q->param("StartDate");
   $EndDate   = $q->param("EndDate");
   if ($StartDate)
   {
      $StartSec = convert_date($StartDate);
      if (!$StartSec)
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Start Date is not a date !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Date is greater or equal than <font color=green>$StartDate</font>";
      $ind = 1;
   }
   if ($EndDate)
   {
      $EndSec = convert_date($EndDate);
      if (!$EndSec)
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, End Date is not a date !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Date is less or equal than <font color=green>$EndDate</font>";
      $ind = 1;
   }
   $StartTime = $q->param("StartTime");
   $EndTime   = $q->param("EndTime");
   if ($StartTime)
   {
      if (!is_time($StartTime))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Start Time is invalid !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Time is greater than <font color=green>$StartTime</font>";
      $ind = 1;
   }
   if ($EndTime)
   {
      if (!is_time($EndTime))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, End Time is invalid !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Time is less than <font color=green>$EndTime</font>";
      $ind = 1;
   }
   $TotalLine = $q->param("TotalLine");
   if ($TotalLine)
   {
      if (!is_numeric($TotalLine))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Total Line is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Total Line is equal to <font color=green>$TotalLine</font>";
      $ind = 1;
   }
   $TotalLineFrom = $q->param("TotalLineFrom");
   if ($TotalLineFrom)
   {
      if (!is_numeric($TotalLineFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Total Line From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Total Line is more than or equal to <font color=green>$TotalLineFrom</font>";
      $ind = 1;
   }
   $TotalLineTo = $q->param("TotalLineTo");
   if ($TotalLineTo)
   {
      if (!is_numeric($TotalLineTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Total Line To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Total Line is less than or equal to <font color=green>$TotalLineTo</font>";
      $ind = 1;
   }
   $RealTotal = $q->param("RealTotal");
   if ($RealTotal)
   {
      if (!is_numeric($RealTotal))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Real Total Score is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Total Score is equal to <font color=green>$RealTotal</font>";
      $ind = 1;
   }
   $RealTotalFrom = $q->param("RealTotalFrom");
   if ($RealTotalFrom)
   {
      if (!is_numeric($RealTotalFrom))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Real Total Score From is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Total Score is more than or equal to <font color=green>$RealTotalFrom</font>";
      $ind = 1;
   }
   $RealTotalTo = $q->param("RealTotalTo");
   if ($RealTotalTo)
   {
      if (!is_numeric($RealTotalTo))
      {
         $q->redirect("error.pl?Mes=".URLEncode("Sorry, Real Total Score To is not a number !"))
      }
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Game Total Score is less than or equal to <font color=green>$RealTotalTo</font>";
      $ind = 1;
   }
   $TotalPref = $q->param("Total");
   if ($TotalPref eq "O")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Real Total Score is <font color=red>OVER</font> than Total Line ";
      $ind = 1;
   }
   elsif ($TotalPref eq "U")
   {
      if ($ind) { $Selection .= " <font color=blue>AND</font> "; }
      $Selection .= " Real Total Score is <font color=red>UNDER</font> than Total Line ";
      $ind = 1;
   }
   if ($Selection eq "PLAYED ") { $Selection = "ALL GAMES"; }

   return($Selection);
}

#-----------------------------------------------------------------------
sub URLEncode
{
   my ($param) = @_;
   my (%escapes);
   my $eparam = $param;
   for (0..255)
   {
      $escapes{chr($_)} = sprintf("%%%02X", $_);
   }
   $eparam =~ s/([\x00-\x20\"\'#%;:\&\+\-\*\=\/.<>?{}|\\^~`\[\]\x7F-\xFF])/$escapes{$1}/g;
   return ($eparam);
}

#-----------------------------------------------------------------------
sub is_numeric
{
   return(1);
}

#-----------------------------------------------------------------------
sub is_time
{
   return(1);
}

#-----------------------------------------------------------------------
sub convert_date
{
   my ($date) = @_;

   ($mm,$dd,$yy) = ($date =~ /(\d+)\/(\d+)\/(\d+)/);
   if (!$mm) { ($mm,$dd,$yy) = ($date =~ /(\d+)\.(\d+)\.(\d+)/); }
   if (!$dd || !$mm) { return(0); }
   if ($yy<50) { $yy+=2000; }
   elsif ($yy<100) { $yy+=1900; }
   $yy -= 1900;
   return(timelocal(0,0,0,$dd,$mm-1,$yy));
}

1;

#-----------------------------------------------------------------------
#   EOF
