/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import main.AboutDialog;
import main.EnterLicenseDataDialog;
import main.LicenseDialog;
import main.LikeCD;
import main.MultiFileDialog;
import main.OptionsDialog;

public class LikeCDFrame
extends JFrame
implements Runnable {
    private MultiFileDialog fileDialog1;
    private MultiFileDialog fileDialog2;
    private LikeCD likeCD;
    boolean frameSizeAdjusted = false;
    JLabel homepage = new JLabel();
    JLabel JLabel1 = new JLabel();
    JTextField fileField1 = new JTextField();
    JButton browseButton1 = new JButton();
    JLabel JLabel2 = new JLabel();
    JTextField fileField2 = new JTextField();
    JButton browseButton2 = new JButton();
    JLabel formatLabel1 = new JLabel();
    JLabel formatLabel2 = new JLabel();
    JLabel time = new JLabel();
    JButton startButton = new JButton();
    JButton licenseButton = new JButton();
    JButton collectEnvironmentDataButton = new JButton();
    JButton optionsButton = new JButton();
    JButton aboutButton = new JButton();
    JScrollPane JScrollPane1 = new JScrollPane();
    JEditorPane results = new JEditorPane();

    public LikeCDFrame(LikeCD likeCD) {
        this.getContentPane().setLayout(null);
        this.setSize(732, 486);
        this.setVisible(false);
        this.setResizable(false);
        this.homepage.setText("Home Page: www.pskonsult.se/VerifyCD");
        this.getContentPane().add(this.homepage);
        this.homepage.setBounds(8, 460, 400, 24);
        this.homepage.setFont(new Font("SansSerif", 0, 12));
        this.JLabel1.setText("Sound Stream 1");
        this.getContentPane().add(this.JLabel1);
        this.JLabel1.setBounds(36, 44, 100, 24);
        this.getContentPane().add(this.fileField1);
        this.fileField1.setBounds(140, 44, 384, 24);
        this.browseButton1.setText("Browse");
        this.browseButton1.setActionCommand("...");
        this.getContentPane().add(this.browseButton1);
        this.browseButton1.setBounds(536, 44, 84, 24);
        this.JLabel2.setText("Sound Stream 2");
        this.getContentPane().add(this.JLabel2);
        this.JLabel2.setBounds(36, 86, 100, 24);
        this.getContentPane().add(this.fileField2);
        this.fileField2.setBounds(140, 86, 384, 24);
        this.browseButton2.setText("Browse");
        this.browseButton2.setActionCommand("...");
        this.getContentPane().add(this.browseButton2);
        this.browseButton2.setBounds(536, 86, 84, 24);
        this.getContentPane().add(this.formatLabel1);
        this.formatLabel1.setBounds(36, 68, 571, 17);
        this.getContentPane().add(this.formatLabel2);
        this.formatLabel2.setBounds(36, 110, 571, 17);
        this.time.setText("0:00:000");
        this.getContentPane().add(this.time);
        this.time.setFont(new Font("Dialog", 1, 24));
        this.time.setBounds(36, 156, 256, 41);
        this.startButton.setText("Start");
        this.startButton.setActionCommand("Start");
        this.getContentPane().add(this.startButton);
        this.startButton.setFont(new Font("Dialog", 1, 18));
        this.startButton.setBounds(591, 156, 105, 36);
        this.licenseButton.setText("Set New License Key");
        this.getContentPane().add(this.licenseButton);
        this.licenseButton.setFont(new Font("Dialog", 1, 12));
        this.licenseButton.setBounds(7, 8, 170, 26);
        this.collectEnvironmentDataButton.setText("Collect Environment Data");
        this.getContentPane().add(this.collectEnvironmentDataButton);
        this.collectEnvironmentDataButton.setFont(new Font("Dialog", 1, 12));
        this.collectEnvironmentDataButton.setBounds(187, 8, 230, 26);
        this.optionsButton.setText("Options");
        this.getContentPane().add(this.optionsButton);
        this.optionsButton.setFont(new Font("Dialog", 1, 12));
        this.optionsButton.setBounds(427, 8, 99, 26);
        this.aboutButton.setText("About");
        this.getContentPane().add(this.aboutButton);
        this.aboutButton.setFont(new Font("Dialog", 1, 12));
        this.aboutButton.setBounds(536, 8, 90, 26);
        this.JScrollPane1.setOpaque(true);
        this.getContentPane().add(this.JScrollPane1);
        this.JScrollPane1.setBounds(36, 204, 660, 252);
        this.JScrollPane1.getViewport().add(this.results);
        this.results.setBounds(0, 0, 657, 249);
        this.results.setFont(new Font("Monospaced", 0, 12));
        SymAction symAction = new SymAction();
        this.browseButton1.addActionListener(symAction);
        this.browseButton2.addActionListener(symAction);
        this.startButton.addActionListener(symAction);
        this.licenseButton.addActionListener(symAction);
        this.collectEnvironmentDataButton.addActionListener(symAction);
        this.aboutButton.addActionListener(symAction);
        this.optionsButton.addActionListener(symAction);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        this.fileDialog1 = new MultiFileDialog(this);
        this.fileDialog2 = new MultiFileDialog(this);
        this.setTitle();
        this.likeCD = likeCD;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar jMenuBar = this.getRootPane().getJMenuBar();
        int n = 0;
        if (jMenuBar != null) {
            n = jMenuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height + n);
    }

    void browseButton1_actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = "";
            try {
                string = LikeCD.getProperty("defaultDir1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.trim().equals("")) {
                this.fileDialog1.setDirectory(this.fileDialog2.getDirectory());
            } else {
                this.fileDialog1.setDirectory(new File(string));
            }
            this.fileDialog1.show();
            if (this.fileDialog1.wasCancelled()) break block6;
            try {
                this.fileField1.setText(new File(this.fileDialog1.getSelectedFilesAsString()).getAbsolutePath());
            }
            catch (Exception exception) {}
        }
    }

    void browseButton2_actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = "";
            try {
                string = LikeCD.getProperty("defaultDir2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.trim().equals("")) {
                this.fileDialog2.setDirectory(this.fileDialog1.getDirectory());
            } else {
                this.fileDialog2.setDirectory(new File(string));
            }
            this.fileDialog2.show();
            if (this.fileDialog2.wasCancelled()) break block6;
            try {
                this.fileField2.setText(new File(this.fileDialog2.getSelectedFilesAsString()).getAbsolutePath());
            }
            catch (Exception exception) {}
        }
    }

    void startButton_actionPerformed(ActionEvent actionEvent) {
        String string = ((JButton)actionEvent.getSource()).getText();
        if (string.equals("Start")) {
            this.results.setText("");
            this.resultAppendLine("Starting...");
            this.likeCD = new LikeCD();
            this.likeCD.setFile1(LikeCDFrame.makeFileArrayFromSemicolonList(this.fileField1.getText()));
            this.likeCD.setFile2(LikeCDFrame.makeFileArrayFromSemicolonList(this.fileField2.getText()));
            this.likeCD.setLikeCDFrame(this);
            this.startButton.setText("Stop");
            new Thread(this).start();
        } else if (string.equals("Stop")) {
            this.likeCD.setStop();
            this.startButton.setText("Start");
        } else if (string.equals("Close")) {
            System.exit(0);
        }
    }

    void licenseButton_actionPerformed(ActionEvent actionEvent) {
        new LicenseDialog(this).setVisible(true);
    }

    void collectEnvironmentDataButton_actionPerformed(ActionEvent actionEvent) {
        new EnterLicenseDataDialog(this).setVisible(true);
    }

    void aboutButton_actionPerformed(ActionEvent actionEvent) {
        new AboutDialog(this).setVisible(true);
    }

    void optionsButton_actionPerformed(ActionEvent actionEvent) {
        new OptionsDialog(this).setVisible(true);
    }

    public void setFinished() {
        this.startButton.setText("Start");
    }

    public void setTime(String string, String string2) {
        this.time.setText(string + " / " + string2);
    }

    public void setFormat1(String string) {
        this.formatLabel1.setText(string);
    }

    public void setFormat2(String string) {
        this.formatLabel2.setText(string);
    }

    public void resultAppendLine(String string) {
        this.results.setText(this.results.getText() + string + "\n");
    }

    public void run() {
        this.likeCD.start();
    }

    void LikeCDFrame_windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    static File[] makeFileArrayFromSemicolonList(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<File> arrayList = new ArrayList<File>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new File(stringTokenizer.nextToken().trim()));
        }
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public void setTitle() {
        try {
            String string = LikeCD.getLogInfo(LikeCD.getKey())[3];
            String string2 = string.equals("1") ? "light" : (string.equals("2") ? "normal" : (string.equals("3") ? "professional" : "demo"));
            this.setTitle("VerifyCD " + LikeCD.versionString + "(" + string2 + ") licensed to: " + LikeCD.getLogInfo(LikeCD.getKey())[1]);
        }
        catch (Exception exception) {
            this.setTitle("VerifyCD " + LikeCD.versionString);
        }
    }

    static {
        try {
            UIManager.setLookAndFeel("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        }
        catch (Exception exception) {}
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == LikeCDFrame.this) {
                LikeCDFrame.this.LikeCDFrame_windowClosing(windowEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LikeCDFrame.this.browseButton1) {
                LikeCDFrame.this.browseButton1_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.browseButton2) {
                LikeCDFrame.this.browseButton2_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.startButton) {
                LikeCDFrame.this.startButton_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.licenseButton) {
                LikeCDFrame.this.licenseButton_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.collectEnvironmentDataButton) {
                LikeCDFrame.this.collectEnvironmentDataButton_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.optionsButton) {
                LikeCDFrame.this.optionsButton_actionPerformed(actionEvent);
            } else if (object == LikeCDFrame.this.aboutButton) {
                LikeCDFrame.this.aboutButton_actionPerformed(actionEvent);
            }
        }
    }
}

