/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.WeakHashMap;

public class Database {
    static EC_IdxReader Enzymes = null;
    static EC_IdxReader Compounds = null;
    static IdxReader De = null;
    static IdxReader An = null;
    static SwissReader Swiss = null;
    static WeakHashMap aboutMap = null;
    static WeakHashMap deMap = null;

    static String AnSearch(String x) {
        try {
            String hec;
            if (An == null) {
                An = new IdxReader("An.idx", "AN");
            }
            if ((hec = An.getDataLine(x)) == null) {
                return null;
            }
            int p = hec.lastIndexOf(124);
            if (p > 0) {
                return hec.substring(p + 1);
            }
        }
        catch (IOException exc) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(exc.getMessage()) + " in database.");
        }
        return null;
    }

    static void addAboutHash(String key, Strings result) {
        if (aboutMap == null) {
            aboutMap = Database.makeHashMap();
        }
        if (result != null) {
            aboutMap.put(key, result);
        }
    }

    static void addDeHash(String key, Strings result) {
        if (deMap == null) {
            deMap = Database.makeHashMap();
        }
        if (result != null) {
            deMap.put(key, result);
        }
    }

    public static Strings getAbout(String what) {
        try {
            Strings r = null;
            r = Database.lookAboutHash(what);
            if (r != null) {
                return r;
            }
            if (Enzymes == null) {
                Enzymes = new EC_IdxReader("Enzymes.idx", "CA");
            }
            if (Compounds == null) {
                Compounds = new EC_IdxReader("Compounds.idx", "ID");
            }
            if ((r = Enzymes.getAbout(what)) == null) {
                r = Compounds.getAbout(what);
            }
            Database.addAboutHash(what, r);
            return r;
        }
        catch (IOException exc) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(exc.getMessage()) + " in database.");
        }
    }

    public static Strings getAbout(scNode what) {
        try {
            String key = what.Label();
            Strings r = Database.lookAboutHash(key);
            if (r != null) {
                return r;
            }
            if (Enzymes == null) {
                Enzymes = new EC_IdxReader("Enzymes.idx", "CA");
            }
            if (Compounds == null) {
                Compounds = new EC_IdxReader("Compounds.idx", "ID");
            }
            r = what.is == scNode.CA ? Compounds.getAbout(key) : (what.is == scNode.ID ? Enzymes.getAbout(key) : Database.getAbout(key));
            Database.addAboutHash(key, r);
            return r;
        }
        catch (IOException exc) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(exc.getMessage()) + " in database.");
        }
    }

    public static Strings getDescription(String EC) {
        Debug d = new Debug();
        Strings r = Database.lookDeHash(EC);
        if (r != null) {
            d.print(String.valueOf(EC) + "hashed.");
            return r;
        }
        try {
            if (De == null) {
                De = new IdxReader("De.idx", "");
            }
            r = De.getAbout(EC);
            d.print(String.valueOf(EC) + "loaded.");
            Database.addDeHash(EC, r);
        }
        catch (IOException iOException) {
            return null;
        }
        return r;
    }

    public static Strings getInformation(String what) {
        return Database.getInformation(what, 0);
    }

    public static Strings getInformation(String what, int filter) {
        if (Swiss == null) {
            Swiss = new SwissReader("enzyme.dat");
        }
        Strings r = Swiss.getAbout(what, filter);
        return r;
    }

    static Strings lookAboutHash(String key) {
        if (aboutMap != null) {
            return (Strings)aboutMap.get(key);
        }
        return null;
    }

    static Strings lookDeHash(String key) {
        if (deMap != null) {
            return (Strings)deMap.get(key);
        }
        return null;
    }

    public static void make() {
        try {
            if (Enzymes == null) {
                Enzymes = new EC_IdxReader("Enzymes.idx", "CA");
            }
            if (Compounds == null) {
                Compounds = new EC_IdxReader("Compounds.idx", "ID");
            }
            if (De == null) {
                De = new IdxReader("De.idx", "DE");
            }
        }
        catch (IOException exc) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(exc.getMessage()) + " in database.");
        }
    }

    static WeakHashMap makeHashMap() {
        return new WeakHashMap();
    }
}

