// PirateStopExampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include <atlbase.h>
#include "PirateStopExample.h"
#include "PirateStopExampleDlg.h"

//
// Add the PirateStop header file:
//
#include "IPStop.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//
// Global Functions
//
void KRqsort (long array[], long left, long right);
void swap (long v[], long i, long j);


//
// Add the PirateStop global variables:
//
BSTR*		pBstrProductName = NULL;
BSTR*		pBstrProductVersion = NULL;
BSTR*		pBstrVendorName = NULL;
BSTR*		pBstrVendorRefURL = NULL;
void		(*gpSwap)(long v[], long i, long j);
CComBSTR	gBstrProductName("PirateStop Example");
CComBSTR	gBstrProductVersion("2.7");
CComBSTR	gBstrVendorName("Your Company");
CComBSTR	gBstrVendorRefURL("http://www.yourreferralwebsite.com/hostip.txt");


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CPirateStopExampleDlg dialog



CPirateStopExampleDlg::CPirateStopExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPirateStopExampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPirateStopExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPirateStopExampleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedButton1)
END_MESSAGE_MAP()


// CPirateStopExampleDlg message handlers

BOOL CPirateStopExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPirateStopExampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPirateStopExampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPirateStopExampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CPirateStopExampleDlg::OnBnClickedButton1()
{
// TODO: Add your control notification handler code here

//
// Declare the PirateStop interface class:
//
CIPStop		IPStop;

long		rc;


GetDlgItem(IDC_BUTTON1)->EnableWindow(0);
										// Disable the button.

// Pass the name of your software product to PirateStop:
pBstrProductName = &gBstrProductName.m_str;
rc = IPStop.SetProductName (pBstrProductName);
if (rc != 0)
  {
  MessageBox ("SetProductName failed.", "PirateStop Example", 
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }


// Pass the version of software product to PirateStop:
pBstrProductVersion = &gBstrProductVersion.m_str;
rc = IPStop.SetProductVersion (pBstrProductVersion);
if (rc != 0)
  {
  MessageBox ("SetProductVersion failed.", "PirateStop Example", 
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }


// Pass the name of your company to PirateStop:
pBstrVendorName = &gBstrVendorName.m_str;
rc = IPStop.SetVendorName (pBstrVendorName);
if (rc != 0)
  {
  MessageBox ("SetVendorName failed.", "PirateStop Example", 
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }

// Pass to PirateStop the URL of your referral website:
pBstrVendorRefURL = &gBstrVendorRefURL.m_str;
rc = IPStop.SetVendorRefURL (pBstrVendorRefURL);
if (rc != 0)
  {
  MessageBox ("Set referral site IP address failed.", "PirateStop Example", 
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }

// Activate or validate the customer:
rc = IPStop.Validate();
if (rc == 0)
  {
  MessageBox ("Valid Certificate found.", "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  }

else if (rc == 1)
  {
  MessageBox ("Activation was successful.", "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  }

else if (rc == 101)
  {
  MessageBox ("Activation failed.", "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;	// Or, if you make use of the validadion characters, you could
				// let your program continue, and subsequently crash.  It's
				// probably a little less traceable by a hacker that way.
  }

else if (rc == 102)
  {
  MessageBox ("Certificate is invalid.", "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }

else
  {
  char	tempStr[128];

  sprintf (tempStr, "%s%s%d", "Validation failed, program not run.\n",
														   "Result code: ", rc);
  MessageBox (tempStr, "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
  goto exit;
  }

MessageBox ("PirateStop Example ran successfully.", "PirateStop Example",
										MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);

exit:
CDialog::OnOK();
return;
}

//
// See the KRqsort function below for examples of how the validation
// character string can be used to protect your code.
//
// Call KRqsort;
//
// long	sortThis[100];
// KRqsort (sortThis, 0, 99);

// Note: The basic version doesn't exercise the validadion characters.

//
// The following code illustrates some ways to use the validation
// character string to further protect your software product.  It's
// a simple quicksort routine (courtesy of Kernighan and Ritchie) 
// with some additional code lines added to provide protection.
//
void KRqsort (long array[], long left, long right)
{
long	idx;
long	last;

//
// This is the simplest kind of use of the validation characters.
// If the character at index 41 in the string is not '6', as it
// should be in this case, we exit the function.  Some other 
// options would be to display an error message, free some memory
// you've allocated, or to set a flag so the program could crash 
// later, either with an error message or not.
//
if ((char)(*pBstrVendorRefURL)[41] != '6')
  {
  return;
  }

if (left >= right)
  return;

swap (array, left, (left + right)/2);
last = left;

//
// Here is a more sophisticated use of the validation characters.  Without
// having the validation string, this will give hackers real trouble.
// It's bad enough if you're looking at the source code and know what it's
// supposed to be doing, but, in general, hackers will be looking at assembly
// code, and may not have a clue what the code is supposed to be doing.
//
// The following switch statement tests the character at index 25 in the
// validation string.  There are five choices for the correct "for" loop.
// Which one is correct?  (Note, you could make all the choices bogus --
// which might confuse a hacker who makes the assumption that one of the
// options must be correct.)
//
// The more choices you code, the more difficult it will be for hackers.
//
switch ((char)(*pBstrVendorRefURL)[25])
  {
  case 'N':
	for (idx = left; idx <= right; ++idx)
	  {
	  if (array[idx] < array[right-idx])
		swap(array, ++last, idx);
	  }
	break;

  case 'S':
	for (idx = left+1; idx < right; ++idx)
	  {
	  if (array[idx] < array[left])
		swap(array, last++, idx);
	  }
	break;
    
  case '2':
	for (idx = left+1; idx <= right; ++idx)
	  {
	  if (array[idx] < array[left++])
		swap(array, --right, idx);
	  }
	break;

  case 'L':
	for (idx = left+1; idx <= right; ++idx)
	  {
	  if (array[idx] < array[left])
		swap(array, ++last, idx);
	  }
	break;

  case 'H':
	for (idx = left+1; idx <= right; ++idx)
	  {
	  if (array[idx] < array[right-last])
		swap(array, last++, idx);
	  }
	break;
  }

//
// This is a little more cryptic, and illustrates another way to make life
// difficult for a hacker.  You can use the validation characters singly or in
// combination to modify the addresses of functions you call in your program.
// Of course, make sure the function address is correct when you call the
// function.  The following statement calls the swap function.  The pointer was
// set up in the constructor for this dialog.
// 
(*((void (*)(long[], long, long))((char*)gpSwap -
							 (*pBstrVendorRefURL)[14] *
							 (*pBstrVendorRefURL)[17] *
							 (*pBstrVendorRefURL)[54])))(array, left, last);
KRqsort (array, left, last-1);
KRqsort (array, last+1, right);
}


void swap (long v[], long i, long j)
{
long	temp;

temp = v[i]; v[i] = v[j]; v[j] = temp;
}
