;
;
; PMODE/W Assembly Startup for CC386.EXE (c) Kirill Jo$$ :-)
;
;
;

PROGRAM_STACK EQU 40*1024h	; Stack size

;	This is equ copy from C0DOS.ASM :-)

segment _TEXT class=CODE align=16 use32
[extern __argv]
[extern __argc]
[extern __environ]
[extern _main]
segment cstartup class=INITDATA align=4 use32
InitStart:
segment _STARTUPEND_ class=INITDATA align=4 use32
InitEnd:
segment crundown class=EXITDATA align=4 use32
ExitStart:
segment _RUNDOWNEND_ class=EXITDATA align=4 use32
ExitEnd:
segment cppinit class=CPPINIT align=4 use32
CppStart:
		dd	cpproutine,130
segment _CPPEND_ class=CPPINIT align=4 use32
CppEnd:
segment cppexit class=CPPEXIT align=4 use32
CpprStart:
		dd	cpproutine,130
segment _CPPREND_ class=CPPEXIT align=4 use32
CpprEnd:
segment _DATA class=DATA align=4 use32
segment _BSS class=BSS align=4 use32
BssStart:
segment _BSSEND class=BSS align=4 use32
BssEnd:
segment _STACK class=STACK align=16 stack use32
		times PROGRAM_STACK resb 1
stack_offset:
                ENDS


group DGROUP _TEXT cstartup _STARTUPEND_ crundown _RUNDOWNEND_ cppinit _CPPEND_ _DATA _BSS _BSSEND _STACK

[global __rexit]
[global __stacktop]
[global __pspseg]
[global __linear]
[global __rmseg]


segment _DATA
banner  db 'Startup for DOS/4GW & PMODE/W (c) Kirill Joss. 1997',10,13,36
	db "Copyright (c) 1997 LADsoft C runtime library"
	db " (i386/DOS PMODE/W)"
	align 4
__linear	dd	0
__stacktop	dd	0
stackpos	resb	6
__pspseg	dw	0
__rmseg		dw	0


segment _TEXT

..start:
        jmp short real_start
;
;	You can delete 'WATCOM', 
;		but it NOT work with Watcom Debbuger & DOS/4G or DOS/4GW :)
;
		db 'WATCOM', 0 	; The "WATCOM" string is needed in
				; order to run under DOS/4G and WatcomDebug.

;
; CODE
;

;
; Entry To ASM Code (_main)
; In:
;   CS - Code Selector    Base: 00000000h - Limit: 4G
;   DS - Data Selector    Base: 00000000h - Limit: 4G
;   ES - PSP Selector     Base: PSP Seg   - Limit: 100h
;   FS - ?
;   GS - ?
;   SS - Data Selector    Base: 00000000h - Limit: 4G
;   ESP -> STACK segment
;   Direction Flag - ?
;   Interrupt Flag - ?
;   All Other Registers Are Undefined!
;
real_start:
	mov	[__stacktop],esp
        sti                             ; Set The Interrupt Flag
        cld                             ; Clear The Direction Flag

	mov 	[__pspseg], es		; Save psp seg

        cli        
	mov 	eax,ds
	mov	es,eax
	mov 	fs,eax
	mov	gs,eax
        sti

%ifdef COPYRIGHT			; JOS
	mov edx,banner
	mov ah,9
	int 21h
%endif
;
; Clear BSS
;
	mov	edi,BssStart
	mov	ecx,BssEnd
	sub	ecx,edi
	sub	eax,eax
	cld
	rep	stosb
;
; Execute startup routines
;
	push 	ds			; reset es to ds
	pop 	es
	mov	ecx,InitStart
	mov	edx,InitEnd
	call	sexproc			; good name : SEXproc
	cld
;
; Execute C++ class initializers
;
	mov	ecx,CppStart
	mov	edx,CppEnd
	call	sexproc			; good name : SEXproc
	cld
;
;
; Call main
;
	push	dword [__environ]
        push    dword [__argv]
	push	dword [__argc]
%ifdef DEBUG
		extrn monitor_init:proc
		call monitor_init
%endif
	call	_main
	add	esp,12

; exit/abort comes here
;
__rexit:
	push	eax		; saving C return code
;
; Execute C++ class rundown routines
;
	mov	ecx,CpprStart
	mov	edx,CpprEnd
	call	sexproc
	cld
;
; Execute rundown routines
;
	mov	ecx,ExitStart
	mov	edx,ExitEnd
	call	sexproc
exitpos:
	pop	eax
	mov	ah,4ch
	int	21h
;
; Handle startup/rundown routines
;
sexproc:
		cmp	ecx,edx		
		jz	short sexpdone	
		mov	edi,ecx
		sub	ebx,ebx
		sub	eax,eax
spl2:
		cmp	edi,edx
		jz	short spo
		test	dword [edi+4],-1
		jz	short spl3
		cmp	eax,[edi+4]
		jnc	short spl3
		mov	ebx,edi
		mov	eax,[edi+4]
spl3:
		add	edi,8
		jmp	spl2
spo:
		or	ebx,ebx
		jz	short sexpdone
		mov	dword [ebx+4],0
		push	edx
		push	ecx
		call	dword [ebx]
		pop	ecx
		pop	edx
		jmp	sexproc
sexpdone:
		ret

; This is called as the first thing from the C++ main routine
cpproutine:
		ret