#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 > vehicleExp  -- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gDollarSign,gPrevCard,gDistanceFormat
  put "vehicleExp" into gStack
  if the short name of this stack <> gStack then exit openStack
  put "Expense" && gDollarSign into field "ExpenseLabel"
  put gDistanceFormat into field "milesLabel"
  put gDistanceFormat into temp
  if temp is "miles" then put "mile" into temp
  put gDollarSign & "/" & temp into field "perMileLabel"
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on checkCompleted
  if the number of cards = 1 and field "vehicle" is empty then exit checkCompleted
  if field "vehicle" is empty OR field "date" is empty OR field "expense amount" is empty then
    answer warning "This record is missing vehicle or expense information" & return & \
        "and will not be included in any report."  with "Fix later" or "Delete Record" or "Fix now"
    unlock screen
    if it is "fix now" then
      if field "vehicle" is empty then send mouseUp to button "select vehicle"
      if field "date" is empty then send mouseUp to button "choose"
      if field "expense" is empty then send mouseUp to button "select expense"
      if field "expense amount" is empty then send mouseUp to field "expense amount"
      exit to metaCard
    end if
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        clearCardOne
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  put 1 into field "record"
  -- put ".33" into field "$/mile"
end clearCardOne

on adjustTime dir,whichFld,whichNum
  global gStartDate,gStack
  if field "date" is empty then
    put the long date into field "date"
  end if
  put field "date" into gStartDate
  if field whichFld is empty then
    put the time into field whichFld
  end if
  
  if whichNum is "min" then
    put 5 into znum
  else
    put 4 into znum
  end if
  
  repeat while the mouse is "down"
    put field whichFld into temp
    convert temp to dateitems
    if dir is "up" then
      add 1 to item znum of temp
    else
      subtract 1 from item znum of temp
    end if
    if item 4 of temp is 24 then adjustDate "up"
    if item 4 of temp is 23 AND item 5 of temp is 60 then adjustDate "up"
    if item 4 of temp is 0 AND item 5 of temp is -1 then adjustDate "down"
    if item 4 of temp is -1 then adjustDate "down"
    convert temp to short time
    put temp into field whichFld
    wait 20 ticks
  end repeat
end adjustTime

on adjustDate which
  global gStartDate
  put gStartDate into temp
  convert temp to dateItems
  if which is "up" then
    add 1 to item 3 of temp
  else
    subtract 1 from item 3 of temp
  end if
  convert temp to long date
  put temp into field "date"
end adjustDate

on addExpenses
  global gDollarSign
  
  put 0 into zdollars
  put field "expense notes" into temp
  repeat with i = 1 to the number of words of temp
    put word i of temp into zword
    if char 1 of zWord is "#" then next repeat
    if validateNumber(zword) is a number then
      add validateNumber(zword) to zdollars
    end if
  end repeat
  
  if field "amount" is empty and zdollars = 0 then
    exit addExpenses
  end if
  
  if gDollarSign = "$" then set the numberformat to 0.00
  put validateNumber(field "amount") into zAmount
  repeat with x =  length(gDollarSign) down to 1
    if char x of zAmount is char x of gDollarSign then -- delete $ signs
      delete char x of zAmount
    end if
  end repeat
  put item 2 of field "expense" into zExpenseAmount
  
  if zDollars <> 0 AND field "amount" <> empty then
    answer question "Add all amounts to Expense Amount?" with \
        "All" or "Just Miles" or "Just Notes" or "Cancel"
    if it is "Cancel" then
      exit to metacard
    end if
  else
    if field "amount" <> empty then
      put gDollarSign & (zExpenseAmount + zAmount) into field "expense amount"
    else
      put gDollarSign & (zExpenseAmount + zDollars)  into field "expense amount"
    end if
  end if
  if it is "Just Miles" then
    put gDollarSign & (zExpenseAmount + zAmount) into field "expense amount"
  end if
  if it is "Just Notes" then
    put gDollarSign & (zExpenseAmount + zDollars)  into field "expense amount"
  end if
  if it is "All" then
    put gDollarSign & (zDollars + zExpenseAmount + zAmount) into field "expense amount"
  end if
end addExpenses

on newExpense zStack
  global gDollarSign
  put field "expense amount" of stack zStack into zword
  ask "Enter an expense amount." with zWord
  if it is empty then exit newExpense
  put it into zword
  if gDollarSign = "$" then set the numberformat to 0.00
  if char 1 of zWord is "-" then
    put true into dontAdd
    delete char 1 of zword
  else
    put false into dontAdd
  end if
  if not (zword is a number) then
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zword is a number) AND (char 1 of zword <> ".") then
        delete char 1 of zword
      end if
    end repeat
    if not (zword is a number) then
      answer error "Problem converting to a number. Please try again."
      put empty into field "expense amount" of stack zStack
      exit newExpense
    else
      add 0 to zword
    end if
  else
    add 0 to zword
  end if
  if dontAdd then
    put gDollarSign & "-" & zword into field "expense amount" of stack zStack
  else
    put gDollarSign & zword into field "expense amount" of stack zStack
  end if
end newExpense

on openCard
  if the short name of this stack is "vehicleExp" then
    saveData
  end if
end openCard

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "vehicleExp" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w         دyy 
Burlywood    white        
       ^ Vehicle Expense Tracker      W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica  
 U Arial 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
       	@                  i        
   date label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      setarrows
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
          l            Date 
   time label            ~            Time 
   	HM label         X  4            	H      M 
   label3           < l            Vehicle 
  Z milesLabel            D            Miles 
  ^ 
perMileLabel          P  @            $/mile 
  ` label5            D            Amount 
  a label5b          B  8            x 
  b label5c            8            = 
   label6           < j            	Odometer 
  O label8           p l            Expense 
  W 
ExpenseLabel           p z            
Expense $ 
  S label9                        Expense Notes 
   recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	record # 
   date  	x  Mon mouseUp
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "date"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "date"
  end if
end mouseUp
        
             
   time  
x   on mouseUp
  put "time" into whichField
  put "" into altField
  put "time" into prompt
  put "" into defaultTime
  put false into OKtoEmpty
  
  setTime whichfield,prompt,altField,defaultTime,OKtoEmpty
end mouseUp
          N           
   vehicle  	x   Bon mouseUp
  send mouseUp to button "select vehicle"
end mouseUp
        
 Q            
   mileage  	x  on mouseUp
  ask "Enter the current mileage of this vehicle." with validateNumber(field "mileage")
  if the result is "cancel" then exit mouseUp
  put checkNumber(it) into temp
  if temp is empty then exit mouseUp
  put temp into field "mileage"
end mouseUp
         Q            
   record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *          1    First @V  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat      * ,  ?         	   	  o    Prev @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat     * ,  @         	      Next @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat   ?  * ,  A         	      Last @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat   e  * ,  B         	      New Ex  on mouseUp
  global gRegistered,gDperMile
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel  "Register"
    exit mouseUp
  end if
  
  if  field "vehicle" is empty then
    answer information "You need to choose or create a vehicle " & return & \
        "for this record before creating another."
    send mouseUp to button "select vehicle"
    exit mouseUp
  end if
  
  checkCompleted
  answer question "Do you want a new blank record or" & return & " another record for this vehicle?" \
      with "Blank Record" or "Same Vehicle"
  put it into which
  unlock screen
  lock screen
  lock messages
  put field "vehicle" into zProjectName
  
  if which is "blank record" then
    go last
    create card
    put the number of this card into field "record"
    send mouseUp to button "select vehicle"
  end if
  
  if which is "Same Vehicle" then
    go last
    create card
    put zProjectName into field "vehicle"
    put the number of this card into field "record"
  end if
  
  put the long date into field "date"
  put the time into field "time"
  put gDperMile into field "$/mile"
  setArrows
  unlock screen with visual plain
end mouseUp
           ک Wheat    & A             	        Delete Ex  on mouseUp
  if the number of cards = 1 then
    if field "date" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  answer question "Delete all records, old records or just this one?" with "All" or "Older" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  if it is "Older" then
    ask "Delete records older than what date?" with field "date"
    if it is empty or it is not a date then exit mouseUp
    unlock screen
    put it into theDate
    convert theDate to seconds
    lock screen
    repeat with i = the number of cards of stack "autoexp" down to 2
      set cursor to busy
      put field "date" of card i into zdate
      convert zdate to seconds
      if zdate < theDate then  delete card i
    end repeat
    
    go card 1
    put field "date" of card 1 into zdate
    convert zdate to seconds
    if zdate < theDate then
      if the number of cards of stack "autoexp" is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards of stack "autoexp" down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    saveData
    setArrows
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
      put the long date into field "date"
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           ک Wheat   C& A             	        Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
 -- if the loc of stack zFindStack = it then
    add 220 to item 1 of it
    add 75 to item 2 of it
    set the loc of stack zFindStack to it
 -- end if
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
           ک Wheat    @ A              	        Sort Ex  don mouseUp
  if field "date" is empty then
    answer information "No records to sort."
    exit mouseUp
  end if
  answer question "Sort records by date or vehicle?" with  "Cancel" or "Vehicle"  or "Date"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field "time"  of card i into startTime
    put field "date"  of card i into startDate
    convert startDate to dateItems
    convert startTime to dateItems
    put item 4 to 5 of startTime into item 4 to 5 of startDate
    repeat with n = 1 to 5
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  
  sort this stack by field "Start items"
  if it is "Vehicle" then
    sort this stack by field "Vehicle"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           ک Wheat   C@ A              	        Import Ex  on mouseUp
  global gStack
  put the number of cards into znum
  if (the number of cards = 1) and (field "Vehicle" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  importRecords firstCard, renumberTasks -- in this script
  setArrows
  saveData
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a vehicle expense records file to import." with "vehexp_records.txt"
  if the result is "Cancel" then exit importRecords
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 3 of temp <> "Vehicle" then
      unlock screen with visual plain
      answer error "This is not a valid vehicle expense records file. Try again."
      close file fileName
      exit to metacard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "Date"
      put item 2 of zline into field "Time"
      put item 3 of zline into field "Vehicle"
      put item 4 of zline into field "mileage"
      put item 5 of zline into field "Expense"
      put item 6 of zline into field "Expense amount"
      put item 7 of zline into field "miles"
      put item 8 of zline into field "$/mile"
      put item 9 of zline into field "amount"
      put item 10 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "expense Notes"
      
      checkList "Projects","Vehicle","Vehicles" --  whichList,whichField,whichStack
      
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
    sort  field "projects" of stack "Vehicles"
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
  
  answer question "Do you want to import vehicle service records? " with "Yes" or "Help" or "No"
  unlock screen
  if it is "Help" then
    answer information "If you have just imported records for vehicles" & return & \
        "that are new to this version of Vehicle Expense Tracker," & return & \
        "then this step is necessary. Otherwise, if the vehicle " & return & \
        "service records already exist, then you can skip this step. "
    answer question "Do you want to import vehicle service records? " with "Yes" or "No"
  end if
  if it is "No" then exit importRecords
  unlock screen
  if it is "Yes" then
    put empty into replaceRecords
    if field "vehicle" of card 1 of stack "vehicledb" is not empty then
      answer question "Do you want to replace old service records?" with "Yes" or "No" or "Cancel"
      if the result is "Cancel" then exit importRecords
      put it into replaceRecords
    end if
    answer file "Select a vehicle service records file to import." with "service_records.txt"
    if the result is "Cancel" then exit importRecords
    put it into fileName
    open file fileName for read
    if the result is empty then
      read from file fileName until eof
      put it into temp
      if word 1 of temp <> "Vehicle" then
        answer error "This is not a valid service records file."
        close file fileName
        exit importRecords
      end if
      
      put the number of lines of temp into znum
      lock messages
      lock recent
      lock screen
      go last card of stack "vehicledb"
      put the number of cards of stack "vehicledb" into firstcard
      if replaceRecords is "Yes" then
        repeat with x = firstcard down to 2
          delete card x of stack "vehicledb"
        end repeat
        put 1 into firstCard
        put empty into field "Projects" of stack "Vehicles"
      end if
      
      repeat with i = 2 to znum
        set cursor to busy
        if line i of temp is empty then next repeat
        set the itemDelimiter to tab
        put false into zduplicate
        if replaceRecords is "No" then
          repeat with x = 1 to firstcard
            if item 1 of line i of temp is field "description" of card x of stack "vehicledb" then
              put true into zduplicate
              exit repeat
            end if
          end repeat
        end if
        if zduplicate then next repeat
        create card
        put line i of temp into zline
        put item 1 of zline into field "Vehicle"
        put item 2 of zline into field "Description"
        put item 3 of zline into field "origMileage"
        put item 4 of zline into field "oclocation"
        put item 5 of zline into field "ocdate"
        put item 6 of zline into field "ocmileage"
        put item 7 of zline into field "tulocation"
        put item 8 of zline into field "tudate"
        put item 9 of zline into field "tumileage"
        put item 10 of zline into field "bslocation"
        put item 11 of zline into field "bsdate"
        put item 12 of zline into field "bsmileage"
        put item 13 of zline into field "tslocation"
        put item 14 of zline into field "tsdate"
        put item 15 of zline into field "tsmileage"
        put item 16 of zline into field "trlocation"
        put item 17 of zline into field "trdate"
        put item 18 of zline into field "trmileage"
        put item 19 of zline into tNotes
        repeat while offset(" | ",tnotes) > 0
          put offset(" | ",tnotes) into firstChar
          put firstChar + 2 into lastChar
          put return into char  firstChar to lastChar of tnotes
        end repeat
        put tnotes into field "Notes"
        
        if offset(field "Vehicle", field "Projects" of stack "Vehicles") = 0 then
          put the number of lines of field "Projects" of stack "Vehicles" + 1into zlines
          put field "Vehicle" into line zlines of field "Projects" of stack "Vehicles"
        end if
        
        add 1 to firstCard
      end repeat
      close file fileName
      sort field "Projects" of stack "Vehicles"
      toplevel "vehicleExp"
      set the defaultStack to "vehicleExp"
    else
      answer "There was a problem opening this file." & return & the result & return & sysError()
    end if
    close file fileName
  end if
end  importRecords
           ک Wheat    U A              	        Export Ex  on mouseUp
  global gElapsed,gDollarSign,gDistanceFormat
  
  if the number of cards is 1 and field "vehicle" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  put it into exportWhich
  put empty into whichProject
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or vehicle records?" with "New" or "Old" or "Vehicle" or "Cancel"
    if it is "Cancel" then exit mouseUp
    put it into exportWhich
    if exportWhich is "vehicle" then
      answer "Export records for vehicle" && field "vehicle" & "?" with "OK" or "Help" or "Cancel"
      if it is "Cancel" then exit mouseUp
      if it is "Help" then
        answer "You can only export project records from a record for that vehicle."
        exit mouseUp
      end if
      put field "vehicle" into whichProject
      put empty into whichDate
      ask file "Save records as... " with whichProject&"_vehexp_records.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "vehexp_records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "vehexp_records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_vehexp_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  unlock screen
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    write "Date" & tab & "Time" & tab & "Vehicle" & tab & "Mileage" & tab \
        & "Expense Type" & tab & "Expense Total" & tab & gDistanceFormat & tab & gDollarSign & "/" & gDistanceFormat & tab\
        & "Amount" & tab & "Expense notes" & return to file fileName
    repeat with i = 1 to the number of cards
      set cursor to busy
      go card i
      put true into exportRecord
      if whichProject <> empty then
        if  field "Vehicle" <> whichProject then
          put false into exportRecord
        end if
      end if
      if whichDate<> empty then
        put field "date" into startDate
        convert startDate to seconds
        if exportWhich is "New" then
          if startDate <= whichDate then
            put false into exportRecord
          end if
        else -- exportWhich is "old"
          if startDate >= whichDate then
            put false into exportRecord
          end if
        end if
      end if
      if exportRecord then
        put false into noRecords
        
        put field "expense notes" into enotes
        repeat while offset(return,enotes) > 0
          put " | " into char offset(return,enotes) of enotes
        end repeat
        
        write field "Date" & tab & field "Time" & tab & field "Vehicle" & tab & field "Mileage" & tab \
            & field "Expense" & tab & field "Expense amount" & tab & field "Miles" & tab & field "$/mile" & tab\
            & field "Amount" & tab & enotes & return to file fileName
      end if
    end repeat
    setarrows
    saveData
    unlock screen with visual plain
    close file fileName
    
    if  noRecords then
      answer information "No records were found to export."
    end if
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
  
  answer information "You should also export the, " & return & "vehicle service records?" with "OK" or "Cancel"
  if it is "Cancel" then exit mouseUp
  put the short date into whichDate
  repeat while offset("/",whichDate) > 0
    put "_" into char offset("/",whichDate) of whichDate
  end repeat
  ask file "Save vehicle service records as... " with "veh_service_records_" &whichDate &".txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    write "Vehicle" & tab & "Vehicle Description" & tab & "Original Mileage" & tab &\
        "Oil Change Location" & tab & "Oil Change Date" & tab & "Oil Change Mileage" & tab & \
        "Tune Up Location" & tab & "Tune Up Date" & tab & "Tune Up Mileage" & tab &\
        "Brake Service Location" & tab & "Brake Service Date" & tab & "Brake Service Mileage" & tab &\
        "Transmission Location" & tab & "Transmission Date" & tab & "Transmission Mileage" & tab &\
        "Tire Rotation Location" & tab & "Tire Rotation Date" & tab & "Tire Rotation Mileage" & tab \
        & "Service notes" & return to file fileName
    
    repeat with i = 1 to the number of cards of stack "vehicledb"
      
      put field  "notes" of card i of stack "vehicledb" into enotes
      repeat while offset(return,enotes) > 0
        put " | " into char offset(return,enotes) of enotes
      end repeat
      
      write field "vehicle" of card i of stack "vehicledb" & tab & field "description" of card i of stack "vehicledb" & tab & field "origmileage" of card i of stack "vehicledb" & tab \
          & field "oclocation" of card i of stack "vehicledb" & tab & field "ocdate" of card i of stack "vehicledb" & tab & field "ocmileage" of card i of stack "vehicledb" & tab\
          & field "tulocation" of card i of stack "vehicledb" & tab & field "tudate" of card i of stack "vehicledb" & tab & field "tumileage" of card i of stack "vehicledb" & tab\
          & field "bslocation" of card i of stack "vehicledb" & tab & field "bsdate" of card i of stack "vehicledb" & tab & field "bsmileage" of card i of stack "vehicledb" & tab\
          & field "tslocation" of card i of stack "vehicledb" & tab & field "tsdate" of card i of stack "vehicledb" & tab & field "tsmileage" of card i of stack "vehicledb" & tab\
          & field "trlocation" of card i of stack "vehicledb" & tab & field "trdate" of card i of stack "vehicledb" & tab & field "trmileage" of card i of stack "vehicledb" & tab\
          & enotes & return to file fileName
    end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
           ک Wheat   CU A              	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
   ک Wheat    j A              	       d Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "aHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "vehicle tracker", helpStack, zStack
end mouseUp
   ک Wheat   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
   ک Wheat     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
   ک Wheat   C A              	       f Expense Report Ex   on mouseUp
  lock screen
  checkCompleted
  checkData
  if the openStacks contains "vreports" then close stack "vreports"
  go stack "vreports"
  setLoc "vreports"
  unlock screen with visual plain
end mouseUp
   ک Wheat                  		        Today Ex  
 >on mouseUp
  put the long date into field "date"
end mouseUp
   ک Wheat    c 
 (              	       	 Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
   ک Wheat     
 (              	       
 Choose Ex  
xon mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat     
 2              	        Now Ex  
 _on mouseUp
  put the time into field "time"
  put the long date into field "date"
end mouseUp
   ک Wheat   ? 
 "              	        Edit Ex  
 7on mouseUp
  send mouseUp to field "time"
end mouseUp
   ک Wheat   c 
 "              	       = Go To ex  on mouseUp
  global gCallStack, gButton,gWhichCard
  put the short name of me into gButton
  put the short name of this stack into gCallStack
  checkCompleted
  answer question "Do you want to go to the first or last" & return &\
      "record for a specific vehicle?" with "Cancel" or "First" or "Last"
  if it is "Cancel" then exit mouseUp
  else put it into gWhichCard
  modal stack "vehicles"
end mouseUp
           ک Wheat    G : 9      Go To         	        Select Vehicle ex   on mouseUp
  global gCallStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gCallStack
  modal stack "vehicles"
end mouseUp
           ک Wheat     : e      Add/Select         	        Edit Ex  
 :on mouseUp
  send mouseUp to field "mileage"
end mouseUp
   ک Wheat   a > "              	       P Select Expense ex   yon mouseUp
  global gCallStack
  put the short name of this stack into gCallStack
  modal stack "aExpenses"
end mouseUp
   ک Wheat    j n       Add/Select Expense         
	       X Edit Ex  
 Aon mouseUp
  send mouseUp to field "expense amount"
end mouseUp
   ک Wheat   e s                	       e Service Record Ex  Non mouseUp
  lock screen
  checkCompleted
  if the openStacks contains "vehicledb" then close stack "vehicledb"
  put true into zflag
  repeat with i = 1 to the number of cards of stack "vehicledb"
    if field "vehicle" of card i of stack "vehicledb" is field "vehicle" then
      go card i of stack "vehicledb"
      topLevel "vehicledb"
      setLoc "vehicledb"
      put false into zflag
      exit repeat
    end if
  end repeat
  if zflag then
    lock screen
    put field "vehicle" into zvehicle
    topLevel "vehicledb"
    setLoc "vehicledb"
    if field "vehicle" of card 1 of stack "vehicledb" is not empty then
      create card
    end if
    put zvehicle into field "vehicle" of stack "vehicledb"
    put zvehicle into field "description" of stack "vehicledb"
  end if
  unlock screen with visual plain
end mouseUp















   ک Wheat                   	           	D                   P !     Y  ~ >           > ~ ~     <      ?           ?                             	D                   k !     Y  ~ >           > ~ ~     <      ?           ?                         
 UpSH A :on mouseDown
  adjustTime "up","time","hr"
end mouseDown
   ک Wheat @ P                	        DnSH A <on mouseDown
  adjustTime "down","time","hr"
end mouseDown
   ک Wheat @ P )               	        UpSM A ;on mouseDown
  adjustTime "up","time","min"
end mouseDown
   ک Wheat @ k                	        DNSM A =on mouseDown
  adjustTime "down","time","min"
end mouseDown
   ک Wheat @ k )               	     
   start items  !h            t                
  Q expense  	x   yon mouseUp
  global gCallStack
  put the short name of this stack into gCallStack
  modal stack "aexpenses"
end mouseUp
        
             
  T expense notes  )h         
               U    	`    @      
  Y expense amount  	x   Aon mouseUp
 newExpense the short name of this stack
end mouseUp
                     
  [ miles  	x  on mouseUp
  global gDollarSign
  ask "Enter a number of miles." with field "miles"
  if the result is "cancel" then exit mouseUp
  if it is empty then
    put empty into field "miles"
    put empty into field "amount"
    exit mouseUp
  end if
  put validateNumber(it) into zmiles
  if zmiles is not a number then
    answer error "Enter numbers only. Please try again."
  else
    put zmiles into field  "miles"
    if field "$/mile" is empty then exit mouseUp
    put validateNumber(field "$/mile") into temp
    if gDollarSign = "$" then set the numberformat to 0.00
    put gDollarSign & (temp * zmiles) into field "amount"
    addExpenses
  end if
end mouseUp
        
  8           
  ] $/mile  	x   on mouseUp
  global gDollarSign,gDperMile
  ask "Enter a number of " & gDollarSign & "s per mile." with field "$/mile"
  if the result is "cancel" then exit mouseUp
  if it is empty then exit mouseUp
  put checkNumber(it) into gDperMile
  if gDperMile is empty then exit mouseUp
  
  if gDollarSign = "$" then set the numberformat to 0.00
  answer question "Change all records?" with "Yes" or "Just this one"
  if it is "Yes" then
    push card
    lock screen
    lock messages
    repeat with i = 1 to the number of cards
      go card i
      set cursor to busy
      put gDperMile into field "$/mile"
      if field "miles" is not empty then
        put gDollarSign & (gDperMile * field "miles") into field "amount"
        addExpenses
      end if
    end repeat
    pop card
    unlock screen with visual plain
  else
    put gDperMile into field "$/mile"
    if field "miles" is not empty then
      put gDollarSign & (gDperMile * field "miles") into field "amount"
      addExpenses
    end if
  end if
end mouseUp
        U  0                 
  _ amount  	h           O             c Total ex   &on mouseUp
  addExpenses
end mouseUp
   ک Wheat    j        Total Expenses         	        
Main Menu }    ^on menuPick which
checkCompleted
  set cursor to watch
  goSBTrackerStack which
end menuPick
   ک Wheat    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
(Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        	vehicles  on openCard
  global gProject
  if field "projects" = empty then exit openCard
  if gProject is empty then
    set the hilitedlines of field "projects" to 1
    put 1 into gProject
  else
    set the hilitedlines of field "projects" to gProject
  end if
end openCard

on arrowKey which
  global gProject
  put the number of lines of field "projects" into numLines
  if which is "up" then
    if gProject is 1 then
      put numLines into gProject
    else
      subtract 1 from gProject
    end if
  end if
  if which is "down" then
    if gProject is numLines then
      put 1 into gProject
    else
      add 1 to gProject
    end if
  end if
  set the hilitedlines of field "projects" to gProject
end arrowKey
           دyy 
Burlywood    # _^,         	Vehicles      U Arial   U Arial   U 
Helvetica  
 U Arial  	 U Arial   U Arial   U 
Helvetica  
 U 
Helvetica  
 W 
Helvetica   W Arial   W 
Helvetica       	@          ^,                    
   projectsbg  	h          6                    	`    @   7      Create Vehicle Ex 
 on mouseUp
  global gProject,gCallStack
  put 32 into maxLength
  ask "Enter the name of the new vehicle identifier."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a vehicle identifier that is" && maxLength && "characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is it then
      answer information "You have already created this vehicle identifier."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "projects" + 1 into temp
  put it into newProject
  put newProject into line temp of field "projects"
  sort field "projects"
  
  lock screen
  lock messages
  go first card of stack "vehicledb"
  if field "vehicle" of card 1 of stack "vehicledb" is not empty then
    create card
  end if
  put newProject into field "vehicle"
  put newProject into field "description"
  if gCallStack is "vehicleExp" then
    answer "Would you like to fill in the service record for this vehicle?" with "Yes" or "No"
    if it is "Yes" then
      close stack "vehicles"
      exit to metaCard
    end if
  end if
  close stack "vehicledb"
  topLevel "vehicles"
  unlock screen
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "projects" of stack "vehicles"
    if line i of field "projects" of stack "vehicles" is newProject then
      set the hilitedLines of field "projects" of stack "vehicles" to i
      put i into gProject
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           ک Wheat     d s             	        Delete Vehicle Ex  on mouseUp
  global gProject,gStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a vehicle identifier to delete."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into temp
  answer warning "Are you sure you want to delete vehicle identifier " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gProject of field "projects"
  put empty into gProject
  
  if the number of cards of stack "vehicledb" = 1 then
    if field "vehicle" of card 1 of stack "vehicledb" is temp then
      put the number of field "description" of stack "vehicledb" into firstfield
      repeat with i = firstfield to the number of fields of stack "vehicledb"
        put empty into field i of card 1 of stack "vehicledb"
      end repeat
    end if
  else
    repeat with i = 1 to the number of cards of stack "vehicledb"
      if field "vehicle" of card i of stack "vehicledb" is temp then
        delete card i of stack "vehicledb"
        exit repeat
      end if
    end repeat
  end if
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat      s             	        Choose Vehicle Mx  on mouseUp
  global gProject,gCallStack,gProjectName,gButton
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create a vehicle identifier."
      send mouseUp to button "Create Project"
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select or create a vehicle identifier."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into gProjectName
  
  send chooseProject to field "projects"
end mouseUp
   ک Wheat     9 q %            	        
Close Window Ex   Xon mouseUp
  global gDontSave
  put true into gDontSave
  close this stack
end mouseUp
   ک Wheat      s             	     
   instruction 	          F (           9Create a vehicle identifier or select one from the list   &and then click a button on the right. 
   	projects  	x  
on mouseUp
  global gProject
  put word 2 of the clickLine into gProject
end mouseUp

on mouseDoubleDown
  global gProject,gCallStack,gProjectName,gButton
  put word 2 of the clickLine into gProject
  put line gProject of field "projects" into gProjectName
  if gProjectName is empty then exit to metaCard
  chooseProject
end mouseDoubleDown

on chooseProject
  global gProject,gStack,gProjectName,gButton,gWhichCard,gCallStack,gDontSave
  put true into gDontSave
  lock screen
  put line gProject of field "projects" into gProjectName
  close this stack
  if gButton is "project" then
    put gProjectName into field "project" of stack gCallStack
    set the disabled of button "vehicle" of group "sort" of stack gCallStack to true
    set the hilite of button "all projects" of stack "vreports" to false
    set the hilite of button "date" of stack "vreports" to true
    exit chooseProject
  end if
  if gButton is "Select Vehicle" then
    if field "vehicle" of stack gCallStack is not empty then
      unlock screen with visual plain
      answer "Are you sure you want to change the vehicle on this record" \
          & return & "or would you like to create a new record?" \
          with "Change" or "New Record" or "Cancel"
      if it is "Cancel" then exit to metacard
      if it is "Change" then put gProjectName into field "vehicle" of stack gCallStack
      if it is "New Record" then
        lock screen
        go last card of stack gCallStack
        create card
        put gProjectName into field "vehicle" of stack gCallStack
        put the number of this card into field "record" of stack gCallStack
        put the long date into field "date" of stack gCallStack
        put the time into field "time" of stack gCallStack
        send setArrows to stack gCallStack
        unlock screen with visual plain
      end if
    else
      put gProjectName into field "vehicle" of stack gCallStack
    end if
  else -- go to record
    if gWhichCard is "Last" then
      repeat with i = the number of cards of stack gCallStack down to 1
        if field "vehicle" of card i of stack gCallStack is gProjectName then
          go card i of stack gCallStack
          if gCallStack is "autoexp" then
            send setArrows to stack gCallStack
          end if
          exit repeat
        end if
      end repeat
    else
      repeat with i = 1 to the number of cards of stack gCallStack
        if field "vehicle" of card i of stack gCallStack is gProjectName then
          go card i of stack gCallStack
          if gCallStack is "autoexp" then
            send setArrows to stack gCallStack
          end if
          exit repeat
        end if
      end repeat
    end if
  end if
  put empty into gProject
  unlock screen with visual plain
end chooseProject
        	 6                    	`    @   7      Service Record Ex  ,on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create a vehicle identifier."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a vehicle identifier."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into origProject
  
  put true into zflag
  repeat with i = 1 to the number of cards of stack "vehicledb"
    if field "vehicle" of card i of stack "vehicledb" is origProject then
      go card i of stack "vehicledb"
      show stack "vehicledb"
      put false into zflag
      exit repeat
    end if
  end repeat
  if zflag then
    lock screen
    go stack "vehicledb"
    create card
    put origProject into field "vehicle"
    put origProject into field "description"
  end if
end mouseUp
   ک Wheat      s             	        Modify Vehicle Ex  on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a vehicle identifier."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into origProject
  
  put 32 into maxLength
  ask "Enter the new name for this project." with origProject
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  put it into gProjectName
  put gProjectName into line gProject of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is gProjectName then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit repeat
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack gStack
    if field "vehicle" of card i of stack gStack is origProject then
      put gProjectName into field "vehicle" of card i of stack gStack
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack "vehicledb"
    if field "vehicle" of card i of stack "vehicledb" is origProject then
      put gProjectName into field "vehicle" of card i of stack "vehicledb"
      if field "description" of card i of stack "vehicledb" is origProject then
        put gProjectName into field "description" of card i of stack "vehicledb"
      end if
      exit repeat
    end if
  end repeat
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat      s             	        Import/Export Ex   on mouseUp
  put "projects" into zfield
  put "vehicles" into what
  put "a vehicle" into zstack
  put "vehicles.txt" into fileName
  
  importExport zfield,what,zstack,filename
end mouseUp
   ک Wheat      s             	        aHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
end closeStack

on closeCard
  -- trap
end closeCard

  w        Black دyy 
Burlywood ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       	Tutorial   	@          w       Vehicle Tracker   	@          w      ( About Expense Notes   	@          w    ) About Expenses   	@          w    * About Vehicles   	@          w    - Adding a New Expense Type   	@          w    / Adding a New Record   	@          w    . Adding a New Vehicle   	@          w    0 Adding Expenses   	@          w    1 Adjusting the Date   	@          w    2 Adjusting the Time   	@          w    3 Background Color   	@          w     Button Colors   	@          w    6 Changing Expense Types   	@          w    7 Changing Vehicles   	@          w    : Choose Date   	@          w    ; Choose Expense   	@          w    < Choose Vehicle   	@          w    @ Create Expense   	@          w    C Create Report   	@          w    B Create Vehicle   	@          w    D Default Settings   	@          w    F Delete Expense   	@          w    G Delete Vehicle   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    K Edit Expense $   	@          w    L 
Edit Time   	@          w    M Exporting Records   	@          w     
First Record   	@          w     Font   	@          w     Go To   	@          w    U Help   	@          w    V Highlight Color   	@          w     Home   	@          w    W Importing Records   	@          w     Keyboard Shortcuts   	@          w       Last Record   	@          w    Z Look and Feel   	@          w    \ Modify Expense   	@          w    ] Modify Vehicle   	@          w    _ Monetary Symbol   	@          w     Next Record   	@          w    a No Expense   	@          w    b 	Now Time   	@          w     Preferences   	@          w       Prev Record   	@          w     	Printing   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Service Records   	@          w      v Sorting Records   	@          w    y Time Format   	@          w    z 
Today's Date   	@          w     Total Expenses   	@          w     Vehicle Reports   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !             help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         Preferences 
  @          
  @          GThere are several preferences you can set for Vehicle Expense Tracker. 
 @        Black    F   `To access the Preferences window, click the Prefs button in the Vehicle Expense Tracker window. 
       @
  @      @ 
     ^   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  
         bThe Distance Format defaults to Miles, but if you can change that to Kilometers here if you wish. 
       
      
      N  You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   IYou can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the Vehicle Expense Tracker window and in reports. 
       
      
      
  @      
    8   The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U  
         WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <         Vehicle Tracker 
  @          
  @          WThe Vehicle Tracker window is where you will add all your vehicle expense information. 
 @        Black    V   Each "record" in Vehicle Tracker consists of the name of the vehicle, the current odometer reading, the date and time, plus any expenses and notes.  You can add new records or edit the information for any record at any time.    Dates and Times 
  @          
  @          sThe Date, Time and Vehicle fields are required. No reports will be generated for records missing this information. 
       
      
      
     	 
      
 @        Black   
      X  sThe Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. To enter the current date, click on the Today button. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Date label. 
       
      
      Z
     b 
     f H
      
      7
      
      
  @       
     
     N
    f 
    k   
        The Time field is automatically filled in. If it is incorrect for some reason, you can click on the field, or the Edit button, to enter another time. To enter the current time, click on the Now button. You may also adjust the time by using the small up and down arrows.  
       
      
      j
     r 
     v H
      
      M  
         	Vehicles 
  @          
  @          Click the Add/Select  button to add, modify, delete or select a previously entered vehicle identifier. Be sure to click the Choose Vehicle button after adding or selecting a vehicle. For more information see About Vehicles. 
       

     
 
      g
     | 
 @        Black   
      F
  @         
         Adding Expenses 
  @          
  @         HClick the Add/Select Expense button to add, delete, modify or select a previously entered expense type. Each expense type can have a specific amount of money (the Expense Amount) that will be added to the Expense $ field. You may create several expense types with the same names, but different amounts. Commas are converted to semicolons. Be sure to click the Choose Expense button after adding or selecting an expense type. You can clear a previously entered expense type by clicking the No Expense button. A record can have expense notes and amounts without having an expense type. 
       

     
 
      
      
      
    h 
    v s
     

     	
  @      K  qAn expense type may or may not have a fixed amount (an Expense Amount). For instance, an oil change may generally be the same amount, so you would want to enter that amount when prompted to do so after clicking Create Expense. On the other hand, an expense type such as Tune Up would not have a fixed amount, so you would enter the amount into the expense notes field. 
       7
     7 
     F 
      
        You may also want to add notes about the expense and the amount of other expenses. To add multiple expenses, just list them in the Expense Notes field with their amounts, then click on the Total Expenses button. The total will appear in the Expense $ field. You may edit the Expense $ field directly, by clicking the field or the Edit button. To subtract a number in the Expense Notes field, put a minus sign ("-") before the number. Here are some correct examples: 
       
      

      -
      
      &
      	
      P
    J 
    N  !   $123.50 books -33.50 discount  ,   stamps 34.20 envelopes 5.79 rebate -1.00    pNumbers need to have a space before and after them. Avoid using dollar signs. Here are some incorrect examples: 
  @        2
     2 *
     \ 	
     e 
    $123.50books     -$33.50 discount     stamps USD34.20    If you want to use a number in the Expense Notes field that does not get added to the Expense $ field, precede the number with the # character (i.e., item #12345). 
       #
     # 

     0 &
     V 	
     _ D  
        You may use the mileage calculator to figure out a Mileage Amount for tax or reimbursement purposes. Just click the Miles field, enter a number and the Mileage Amount will be calculated for you. You can change the $/mile amount by clicking the $/mile field and entering a new number. 
       3
     3 
     A 3
     t 
     y 
      
      M
      
      !  
        After adding numbers to the Expense Notes field, click the Total Expenses button to get a total in the Expense $ field. If there is no mileage Amount, then any Expense Amount will be added to the total. If there is a Mileage Amount, then you will be asked if you want Just Notes, Just Miles or All expenses added to the Expense Amount. If you click All, both the Expense Notes total and the Mileage Amount will be added to the Expense Amount  and entered into the Expense $ field. 
       
      

     ) 
     ; 
     I 
     g 	
     p 0
      
      ^
     
    # 
    % 
    ) 
    @ 
    N 
    ] 
    a 

    k 
    r 
    s 
    x 
     
     
     
     
     	
       
         You can save or print out reports on any Vehicle by clicking the Expense Report button. See Vehicle Reports for more information. 
       @
     @ 
     O 

  @      \ 
     k   
         0Adding, Deleting, Searching and Sorting Records 
  @        /  Click on the New button to create a new record. You will be asked if you want to duplicate some or all of the information on the current record. The choices are: "Same Vehicle" and "Blank Record". Blank Record copies none of the information from the current record. Same Vehicle copies just the vehicle identifier from the current record. The current date and time are automatically filled in. Edit the new record with new vehicle and expense information, as you wish. 
       

     
 
      
      

      8
    	 

       <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
        You can sort records by clicking the Sort button. You will be asked if you want to sort by Date, Activity, or Project. If you choose Activity or Project, all records will be sorted by date first and then by either Activity or Project. All records are renumbered after sorting. 
       %
     % 
     ) 2
     [ 
     _ 
     a 
     i 
     n 
     u   
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are several reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b =  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    V3) If you wanted to export the records to a spreadsheet or a word processing program.    There are two separate files exported. The first is called veh_exp_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       ;
 @      Red  ; 
     N S
 @      Blue   (   The second file which contains all your vehicle service record information and is called service_records.txt. This step is optional and you can change the name or location of this file as well.  
       Y
 @      Red  Y 
     l V   You can export only records for a specific vehicle, or records that are newer or older than a certain date. See Exporting Records for more information. 
       p
  @      p 
        
         Other Buttons 
  @        
  You can use the arrow buttons to go to the first, previous, next or last record. The number of the current record appears in the Record # field. The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. You can also go directly to any record by clicking on the record number field. A dialog will ask you what record number to go to. 
  @        P
     P 1
      
      
      
      
      
      4
      
      
      
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format and Monetary Symbol. For more information see Preferences. 
       
      
     	 
  @       
     1 
  @       
        
 @        Black      To register Small Business Tracker, click the Register button. Read the instructions for getting a registration number. When you receive your number, fill in your full name and the registration number. You will then be able to continue using the software. 
       .
     . 
     6   
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    fThe Service button takes you to the Service Records window. For more information see Service Records. 
       
      
      
  @      $ 
     : 
  @      U 
     d    The Report button exports all records for the current vehicle to a text file. You can archive this file or print it from a text editing program. 
       
      
     
   
         mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d  
         The Quit button saves the data and quits the program. If there is not a Quit button you may quit by using the Control + Q key combination (or command + q on the Macintosh). 
       
      
        
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
               Service Records 
  @          
  @         {Click the Service Record button in the Vehicle Expense Tracker window. Here you can keep track of the location, date and odometer reading (mileage) of the last time your vehicle received any of the following services: Last Oil Change, Last Tune Up, Brake Service, Automatic Transmission Service and Tire Rotation. You can also keep other notes about your vehicle in this window. 
       

     
 
      
 @      Red  ' 
     E 
      _
    9 A   ^Choose a vehicle by clicking the Add/Delete button.  For more information see About Vehicles. 
       !
     ! 

     + 	
     4 
  @      N    Choose a date for each service by clicking the Today or Choose button above the middle field in each row. See Choose Date for more information.  
       /
     / 
     > ,
     j 
  @      n 
     y   
         `You can enter the Location and Odometer reading (mileage) directly into the fields in each row. 
       
      
      
      
     ' 8  
           	Tutorial 
  @          
  @          YHere's a quick tutorial for those just getting started with the Vehicle Expense Tracker. 
 @        Black    X   Each "record" in the Vehicle Expense Tracker consists of the name of the date, time, vehicle identifier, current odometer reading, mileage calculator, plus any expenses and notes.     To create a new record: 
  @           To add a new record, click on the New button. The current date and time will automatically be filled in. If you wish to change these, click the Edit or Choose buttons. 
       "
     " 
     % k
      
      
      
      	  
         Add or select a vehicle identifier by clicking the Add/Select button. Click Create Vehicle to enter a new vehicle identifier. Click Choose Vehicle to enter the vehicle identifier in the Vehicle Expense window.  
       3
     3 

     = 
     L 
     Z *
      
      (
 @      Red   
        
         If you have several vehicles and many records, you may want to use the Go To button to go directly to a vehicle's last expense record. 
       G
     G 
     L :  
         Each vehicle also has a Service Record where you can record the last location, date and mileage (odometer reading) for a variety of services. Click the Service button to access the Service Record window. 
       
      
      
 @      Red     
         Adding Expenses: 
  @          
  @         2To add an expense, click on the Add/Select Expense button. Click Create Expense. Enter the name for the type of expense such as Gas, Oil Change, etc. After entering the name of the type of expense, you will be asked if there is a set amount associated with this type of expense. If there is not, enter 0.  
        
       
     2 
     A 
     O   
         You may create several expense types with the same names, but different amounts. Commas are converted to semicolons. After entering a new expense type, click Choose Expense to transfer it to the Vehicle Expense window. 
       
      
      
 @      Red   
  @       
        An expense type may or may not have a fixed amount. For instance, an oil change may generally be the same amount, so you would want to enter that amount when prompted to do so after clicking Create Expense. On the other hand, an expense type such as Gas would not have a fixed amount, so you would enter the amount into the expense notes field. For more information see About Expense Notes. 
       
      
      
  @     r   !If you get reimbursed on a per mile basis, you may use the mileage calculator to compute the money owed to you. Just click the Miles field, fill in a number and a total will be entered into the Amount field. You can change the /mile amount by clicking the field and entering a new number. 
       
      
      >
      
      
      
      8  
        After adding numbers to the Expense Notes field, click the Total Expenses button to get a total in the Expense $ field. If there is no mileage Amount, then any Expense Amount will be added to the total. If there is a Mileage Amount, then you will be asked if you want Just Notes, Just Miles or All expenses added to the Expense Amount. If you click All, both the Expense Notes total and the Mileage Amount will be added to the Expense Amount  and entered into the Expense $ field. 
       
      

     ) 
     ; 
     I 
     g 	
     p 0
      
      ^
     
    # 
    % 
    ) 
    @ 
    N 
    ] 
    a 

    k 
    r 
    s 
    x 
     
     
     
     
     	
        Other features: 
  @          
  @         qYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open A&E Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q v
      
      
      
      4
     
     
      
    $ /
 @      Blue S X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         SSort all the records by clicking the Sort button. You can sort by Date or Vehicle. 
       %
     % 
     ) 
     B 
     F 
     J    Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Vehicle Expense Tracker at any time. You will want to export your data when updating to a newer version of Vehicle Expense Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
      
      d
    J 
    Q +
  @     | 
     
  @      
       
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @          To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _    You can save or print out reports on any Vehicle by clicking the Expense Report button. See Vehicle Reports for more information. 
       @
     @ 
     O 

  @      \ 
     k    The Save button saves your data. All records are saved automatically when going to another record or when you Quit or close the program. You can also use the Control + q (or Command + q on the Macintosh) key combination to quit the program. 
       
      
      f
     n 
     r ~  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               About Help 
  @        
  
  @          )Welcome to Vehicle Expense Tracker Help. 
 @        Black    
      
 @        Black      Included in the Vehicle Expense Tracker Help System, is an extensive Help Index. Listed in the index are all the features, fields and buttons of Vehicle Expense Tracker. (Buttons are things you click on and fields contain text.) 
       
 @      Red   #
     3 
 @        Black  E 

     O B
      
      D  You can also click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

     ! 
 @      Blue   Y
    A W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R    Each "record" in Vehicle Tracker consists of the name of the vehicle, the current odometer, the date and time, plus any expenses and notes.  You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   MThe Vehicle Tracker window is where you add Vehicle and Expense information. 
       
  @       
      
     , 
     4    bThe Service Records window is where you can keep track of the last time you service your vehicle. 
       
  @       
      N   The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program. You can also change the monetary symbol if you want it to be different than $. 
       
  @       
         jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      Vehicle Reports 
  @          
  @          XThe Vehicle Report window is where you can generate several different types of reports. 
 @        Black    W   kEasily create Expense reports by clicking the Expense Report button in the Vehicle Expense Tracker window. 
       .
     . 
     < 
 @      Red  J     NThe Vehicle, Date, Odometer, Expense and Amount are included in all reports.    
         lYou may specify a Start Date, End Date, Vehicle or Expense Type  before clicking the Create Report button.  
       
      

      
      !
     ? 
     U 

     b 
     j   
         vThe list can be sorted by clicking one of the Sort By radio buttons. The choices are Date, Vehicle and Expense Type.  
       .
     . 
     5 
     T 
     b 
     f    Click any line in  the report to go directly to the record. If you click a line in the report and nothing happens, you need to click the line with the vehicle's date and expense description.    The font face, size, line height and tab stops of the list can be modified by clicking the Font button in the Vehicle Expense Report window. See Font  for more information. 
       [
     [ 
     _ 
 @      Red  n 
      
 @      Blue   
         \You can print the report by clicking the Print button in the Vehicle Expense Report window. 
       )
     ) 
     . 
 @      Red  =    To save the report as a text file for importing into another program click the Save as... button in the Vehicle Expense Report window. 
       O
     O 

     Y 
 @      Red  h   
 @        Black          Total Expenses 
  @          
         Each expense type can have a specific amount of money (the Expense Amount) that will be added to the Expense $ field. You may also want to add notes about the expense and the amount of other expenses.  
       ;
     ; 
     I -
     v S  2To add multiple expenses, just list them in the Expense Notes field with their amounts, then click on the Total Expenses button. The total will appear in the Expense $ field. You may edit the Expense $ field directly, by clicking the field or the Edit button. For more information see About Expense Notes. 
       0
     0 

     = -
     j 
     x &
      	
      
      	
      .
      
      "
  @        
        You may use the mileage calculator to figure out a Mileage Amount for tax or reimbursement purposes. Just click the Miles field, enter a number and the Mileage Amount will be calculated for you. You can change the $/mile amount by clicking the $/mile field and entering a new number. 
       3
     3 
     A 3
     t 
     y 
      
      M
      
      !  
        After adding numbers to the Expense Notes field, click the Total Expenses button to get a total in the Expense $ field. If there is no mileage Amount, then any Expense Amount will be added to the total. If there is a Mileage Amount, then you will be asked if you want Just Notes, Just Miles or All expenses added to the Expense Amount. If you click All, both the Expense Notes total and the Mileage Amount will be added to the Expense Amount  and entered into the Expense $ field. 
       
      

     ) 
     ; 
     I 
     g 	
     p 0
      
      ^
     
    # 
    % 
    ) 
    @ 
    N 
    ] 
    a 

    k 
    r 
    s 
    x 
     
     
     
     
     	
         ( About Expense Notes 
  @           You can add notes about the expense and the amount of other expenses. To add multiple expenses, just list them in the Expense Notes field with their amounts, then click on the Total Expenses button. The total will appear in the Expense $ field. 
       v
     v 

      -
      
      &
      	
        When you click the Total Expenses button, if the expense type has an associated amount (or Expense Amount), you will be asked if you want to add the amounts (numbers) in the Expense Notes field to the Expense Amount. If you choose Just Notes, only the numbers in the Expense Notes field will be added to the Expense $ field. If you choose Yes, the numbers in the Expense Notes field will be added to the Expense $ field. If you choose No, just the Expense Amount will be added to the Expense $ field. 
       
      
     ! 
      

      ,
      

      C
    4 	
    = 
    S 
    V >
     	
     
     
     /
     

        UYou may edit the Expense $ field directly, by clicking the field or the Edit button. 
       
      	
      .
     H 
     L    {To subtract a number in the Expense Notes field, put a minus sign ("-") before the number. Here are some correct examples: 
       
      
     ) Q "    $123.50 books -33.50 discount  -    stamps 34.20 envelopes 5.79 rebate -1.00    Numbers need to have a space before and after them. Avoid using dollar signs or equal symbols. Here are some incorrect examples: 
  @        ^
     ^ 
     m 	
     v 
     $123.50books      -$33.50 discount      stamps USD34.20    If you want to use a number in the Expense Notes field that does not get added to the Expense $ field, precede the number with the # character (i.e., item #12345). 
       #
     # 

     0 &
     V 	
     _ D   When Expense Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. 
         
        You may use the mileage calculator to figure out a Mileage Amount for tax or reimbursement purposes. Just click the Miles field, enter a number and the Mileage Amount will be calculated for you. You can change the $/mile amount by clicking the $/mile field and entering a new number. 
       3
     3 
     A 3
     t 
     y 
      
      M
      
      !  
        After adding numbers to the Expense Notes field, click the Total Expenses button to get a total in the Expense $ field. If there is no mileage Amount, then any Expense Amount will be added to the total. If there is a Mileage Amount, then you will be asked if you want Just Notes, Just Miles or All expenses added to the Expense Amount. If you click All, both the Expense Notes total and the Mileage Amount will be added to the Expense Amount  and entered into the Expense $ field. 
       
      

     ) 
     ; 
     I 
     g 	
     p 0
      
      ^
     
    # 
    % 
    ) 
    @ 
    N 
    ] 
    a 

    k 
    r 
    s 
    x 
     
     
     
     
     	
          xx    	Printing 
  @           To print out Vehicle expenses, click the Expense Report button in the Vehicle Expense Tracker window. Choose from the available options and click Create Report. Then click the Print button in the Vehicle Report window.   
 @        Black    )
 @        Black  ) 
 @        Black  7 
 @      Red  F 
 @        Black  ] 5
 @        Black   

 @        Black   
 @        Black   
 @        Black   
 @      Red   
 @        Black   
  
 @        Black      The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p   
 @        Black      To print out a Vehicle service record, go to a record for the desired vehicle, click the Service Record button and then click the Print button in the Service Records window.  
 @        Black    Y
 @        Black  Y 
 @        Black  g 
 @        Black   
 @        Black   
 @      Red   
 @        Black   	  M Exporting Records 
  @          3You can export the records to a text file by clicking the Export button. You will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       :
     : 
     @ .
     n 
     y 	
      
      
      
      $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or Project records. If you click the Project button, only records for the project on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T 
     ` 
     g 
      
      M   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
          <There are several reasons you might want to export records: 
  @        ; 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.   83) If you wanted to export the records to a spreadsheet or a word processing program. When Expense Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. If you import into a word processor, you may want to remove these characters. 
       V
 @      Blue  V 
      N   Exported Records files: 
  @         There are two separate files exported. The first is called veh_exp_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       ;
 @      Red  ; 
  @      C 
     N n
  @       '  
  @          The second file, which contains all your vehicle service records, is called service_records.txt. This step is optional and you can change the name or location of this file as well. If you are updating to a newer version, this step is important. 
       L
  @      L 
     _   JTo import or export a list of vehicles, click the Add/Select Expense button and then the Import/Export  button. If you choose Import, you will be asked to locate an vehicles.txt file. If you choose Export, save the vehicles.txt file to your computer so that you can then import it into a newer version of Vehicle Expense Tracker. 
       2
     2 
     D 
     X 
     Y 
     g 
     ~ 
      !
 @      Red   
      
      
      
 @      Red   
      f  
          
          W Importing Records 
  @          You can import previously exported records by clicking the Import button in the Vehicle Expense Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. You then will be asked to locate a veh_exp_records.txt file to import. You will also be asked if you want to import service records. If you answer Yes, you be asked to locate a service_record.txt file to import. This step is optional. 
       ;
     ; 
     A 
 @      Red  P 
  @      _ 
     n )
      
      *
      
      O
 @      Red  
  @     ! 
    , ]
     
     
  @      
     '   When updating to a newer version of the program, you should export all your expense records and service records and then import them into the new version.    ,See Exporting Records for more information. 
       
  @       
          0 Adding Expenses 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can add as many expense types as you want. You can also modify and delete expense types.   yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
    O 
    ] 
     q 
   4 
   6 *
    ` 

    j 
    p   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers.  
       %
     % 
     7 3
     j 
     x {
      	
      $
     

   - -
    Z 1  You can list additional expenses in the Expense Notes field. Then add the expenses in the Expense Notes field to the Expense $ field by clicking the Total Expenses button (between the Expense Notes and Expense $ fields). For more information see About Expense Notes. 
       (
     ( 

     5 %
     Z 

     g 
     u 	
     ~ 
      
      S
  @       
    	          Keyboard Shortcuts 
  @          
  @          /Almost every button has a keyboard equivalent. 
 @        Black    .  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    *Vehicle Expense Tracker window shortcuts: 
 @        Black    
      
 	GoTo - g  Add/Select - a  Add/Select Expense - x  Total Expenses - t  Next record - Right arrow  Previous record - Left arrow  New - n  Delete - d  Service Record - e  Report - r  	Quit - q  	Save - s    "Service Records window shortcuts: 
       ! Add/Delete - a  	Help - h  
Expenses - e  Report - r  	Quit - q  	Save - s    Vehicles window shortcuts: 
        Choose Vehicle - v  Create Vehicle - r  Service Record - s  Modify Vehicle - m  Delete Vehicle - d  Import/Export - i  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Add/Expense window shortcuts: 
        Choose Expense - x  Create Expense - r  Modify Expense - m  No Expense - n  Delete Expense - d  Import/Export - i  Close Window - c  'Move up in list of Expenses - Up arrow  +Move down in list of Expenses - Down arrow    Help window shortcuts: 
        About Help - a  Vehicle Tracker - v  Keyboard Shortcuts- k  
Tutorial - t  Service Records - r  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help = s  Close Window - c         g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button if it is available. You can always type Control + Q (or Command + Q on the Macintosh) to quit. 
       ?
     ? 
     C 
 @        Black  _ J         Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
        You can also set the tab stops of the list text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      !
     @ 
     G 
     \ 
     _ *
      
      
      
      
 @      Blue n O  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H   
             
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )         . Adding a New Vehicle 
  @          WTo add a new vehicle identifier, click the Add/Select button. Next click the Create Vehicle button. Enter the vehicle identifier for the vehicle. The maximum length for vehicle identifiers is 32 characters. To transfer the new vehicle identifier to the current record, click the Choose Vehicle button. For more information see About Vehicles. 
       
      
      
     + 

     5 
     M 
     [ 
     n 
     u 
     v 

      )
      
      
      

      (
      
      
      

      !
     
    % "
  @     G         / Adding a New Record 
  @          To add a new record, click the New button in the Vehicle Expense Tracker window. The choices are: "Same Vehicle" and "Blank Record". Blank Record copies none of the information from the current record. Same Vehicle copies just the vehicle identifier from the current record. The current date and time are automatically filled in. Edit the new record with new vehicle and expense information, as you wish. 
       
      
     " 
  @      1 
     O 5
      

      8
      

              z 
Today's Date 
  @           YTo easily enter today's date into a record, click the Today button above the Date field. 
       6
     6 
     ; 
     L 
     Q    [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S     h 	Record # 
  @          "Each Record in Vehicle Expense Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       5
  @      5 6
     k <
      
      <
  @       
      
  @       
     
  @      
     
  @      
         The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	   { Visual Effects 
  @          ;In some earlier versions of this program, there was a visual effect that helped to indicate the movement from one record to another when using the arrow buttons. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
      
     
     
     
     
  @     ' 
    9    See also Record #. 
       	
 @      Blue  	 	  * About Vehicles 
  @           You can enter any number of vehicles into Vehicle Expense Tracker. Vehicle identifiers are limited to 32 characters, but commas and other special characters are permitted.    To choose a vehicle, click the Add/Select  button. Then select a vehicle identifier and click the Choose Vehicle button. You may also double-click on the vehicle identifier. 
       
      
     * 
     B 
     H 
     I 

     S 
     b 
     p +
      
      
      

        To create a vehicle identifier, click the Add/Select button. Then click the Create Vehicle button and enter a name. The maximum length for vehicle identifiers is 32 characters. To transfer the new vehicle identifier to the current record, click the Choose Vehicle button. 
       
      
     
 
     * 

     4 
     L 
     [ 0
      
      
      
      '
      
      
      

      "
      
       To modify a vehicle identifier, click the Add/Select button. Then select a vehicle identifier to modify and click the Modify Vehicle button. You will be asked for a new vehicle identifier. All records with the old vehicle identifier will be updated with the new name. 
       
      
      
     * 

     4 
     K 
     R 
     S 

     ] 
     v 
      %
      
      
      

      
  @       
 @      Blue   
 @      Blue   
 @      Blue   

  @       "
    
    To delete a vehicle identifier, click the Add/Select button. Then select a vehicle identifier to delete and click the Delete Vehicle button. 
       
      
      
     * 

     4 
     K 
     R 
     S 

     ] 
     v 
        #To import or export a list of vehicles, click the Import/Export  button. If you choose Import, you will be asked to locate an vehicles.txt file. If you choose Export, save the vehicles.txt file to your computer so that you can then import it into a newer version of Vehicle Expense Tracker. 
       2
     2 
     @ 
     W 
     ] !
 @      Red  ~ 
      
      
      
 @      Red   
      f  
 @      Red         ) About Expenses 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can create as many expense types as you want. You can also modify and delete expense types.   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. For more information see About Expense Notes. 
       %
     % 
     7 3
     j 
     x {
      	
      $
      

    - w
  @      
       yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p   >To modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. All records with the old expenses name will be updated with the new name. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 =
     t 
      l
      
      
  @       I
    A 
    / 
    5   If you have previously entered an expense type and notes and then want to clear the expense type but not the notes, click the Add/Select Expense button. Then click the No Expense button. To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       ~
     ~ 
      
      

      N
      
       To delete an expense type, click the Add/Select Expense button. Then select an expense type to delete and click the Delete Expense button. You will no longer be able to create expense reports for that expense type. For more information see Expense Reports. 
       $
     $ 
     7 =
     t 
      n
  @       
        "To import or export a list of expenses, click the Import/Export  button. If you choose Import, you will be asked to locate an expenses.txt file. If you choose Export, save the expenses.txt file to your computer so that you can then import it into another module of this productivity suite. 
       2
     2 
     @ 
     W 
     ] !
 @      Red  ~ 
      
      
      
 @      Red   
      e    : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6       1 Adjusting the Date 
  @           The Date can be adjusted several ways. If you want to enter today's date, click the Today button above the Date field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y O
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %     < Choose Vehicle 
  @          
To choose a vehicle identifier, click the Add/Select button. Then select a vehicle identifier and click the Choose Vehicle button. You may also double-click on the vehicle identifier to add it directly to the current record. For more information see About Vehicles. 
       )
     ) 
     5 
     K 
     ] 
     l 
     z *
      
      D
  @               6 Changing Expense Types 
  @          To add an expense type to the current record, click the Add/Select Expense button. Then select the name of the expense type and click the Choose Expense button. You may also double-click on the expense name which will automatically add it to the current record. 
       8
     8 
     J @
      
      m  >To modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. All records with the old expenses name will be updated with the new name. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 =
     t 
      l
     
     5
    % 
    
    
     $
    / 
    5          Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        2 Adjusting the Time 
  @           The Time can be adjusted several ways. If you want to enter the current time, click the Now button above the time field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       X
     X 
     [ O
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.     - Adding a New Expense Type 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can add as many expense types as you want. You can also modify and delete expense types.   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type to add it directly to the current record. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. For more information see About Expense Notes. 
       %
     % 
     7 3
     j 
     x 
     	
    % $
    I 

    V w
  @        yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p         y Time Format 
  @           In the Preferences window, you can set the Time Format to either 24 Hr or AM/PM. Times previously entered will not be modified, but all new times entered will be in the new format. 
       
  @       
      
     + 
     7 }        v Sorting Records 
  @           You can sort records by clicking the Sort button in the Vehicle Expense Tracker window. You will be asked if you want to sort by Date or Vehicle. If you choose Vehicle, all records will be sorted by date first. All records are renumbered after sorting. 
       %
     % 
     ) 
  @      7 
     V +
      
      
      
      
  @       ?
      +         Go To 
  @           You can go directly to the last record for a particular vehicle by clicking the Go To button. You will need to click a vehicle identifier and then click the Choose Vehicle button (or just double-click on the vehicle identifier). 
       O
     O 
     U H
      
      9    o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S    ~You can go directly to the last record for a particular vehicle by clicking the Go To button. For more information see Go To. 
       O
     O 
     U "
 @ 	     Blue  w 
     |     n Save Record 
  @           You can save all the data in the Vehicle Expense Tracker by clicking the Save button. All data is saved automatically when going to another record or when closing the window. 
       !
 @      Red  ! 
     8 
     I 
     M a         Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C     Home 
  @           VClicking the Home button takes you to the Home window and closes the current window.  
       

     
 
      D         Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
           b 	Now Time 
  @           You can easily enter the current time by clicking the Now button. This button also enters the current date into the date field. 
       6
     6 
     9 F        a No Expense 
  @        
  If you have previously entered an expense type and notes and then want to clear the expense type but not the notes, click the Add/Select Expense button. Then click the No Expense button. To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       ~
     ~ 
      
      

      N
      
              Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           _ Monetary Symbol 
  @          In the Preferences window, you can set the Monetary Symbol to something other than the dollar sign ($). Click the Prefs button in the A&E Tracker window, then click the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the A&E Tracker window above the Expense $ field and in all invoices and reports. 
       
  @       
      
     + 
     : 8
     r 
     w 
  @       
      
      
      
 @      Red J 
    \ 
    g 	
    p '        ] Modify Vehicle 
  @          5To modify a vehicle identifier, click the Add/Select button. Then select a vehicle identifier to modify and click the Modify Vehicle button. You will be asked for a new vehicle identifier. All records with the old vehicle identifier will be updated with the new name. For more information see About Vehicles. 
       *
     * 

     4 
     K 
     ] 
     v 
      %
      
      
  @       
 @      Blue   
  @       $
     
  @     %         \ Modify Expense 
  @          STo modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. All records with the old expense name and amount will be updated with the new name and amount. 
       %
     % 
     7 =
     t 
      l
      
      
     
     4
     
     	
  @      ^        Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the A&E Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
  @      ^ 
     p 
      
      F        U Help 
  @           sClicking the Help button at the bottom of the Service Reports window takes you to the Service Reports help topic.  
       

     
 
      
  @      . 
     D 
  @      V 
     e 
  
         zClicking the Help button at the bottom of the Vehicle Expense Tracker window takes you to the Vehicle Tracker help topic. 
       

     
 
      
 @      Red  . 
  @      = 
     L 
  @      ^ 
     m   
         jClicking the Help button at the bottom of the Preferences window takes you to the Preferences help topic. 
       

     
 
      
  @      . 
     @ 
 @      Blue  R 
     ]    There are Help button in a few other places which give you a quick hint about the functionality or limitations of that feature.   L 
Edit Time 
  @        	   The Time can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       X
     X 
     [ W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.     K Edit Expense $ 
  @           You can add an amount to the Expense $ field directly by clicking the Edit button or directly on the field. This will replace any previous amount. 
       
      	
     &  
     F 
     J H   2See also About Expense Notes and Adding Expenses. 
       	
  @      	 
      
  @      ! 
     0         I 
Edit Date 
  @        	   The Date can be adjusted several ways. If you want to enter today's date, click the Today button above the date field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y O
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %     H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         G Delete Vehicle 
  @          To delete a vehicle identifier, click the Add/Select button. Then select a vehicle identifier to delete and click the Delete Vehicle button. The service record for the vehicle will be deleted. You will no longer be able to create records or reports for that vehicle. 
       *
     * 

     4 
     K 
     ] 
     u 
      	
 @      Blue   4
      A
     
    	         F Delete Expense 
  @          To delete an expense type, click the Add/Select Expense button. Then select an expense type to delete and click the Delete Expense button. You will no longer be able to create expense reports for that expense type. For more information see Expense Reports. 
       %
     % 
     7 =
     t 
      n
  @       
              D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     C Create Report 
  @        
   QTo generate a report, click the Report button. For more information see Reports. 
       
      
     & "
  @      H 
     O         B Create Vehicle 
  @          GTo create a vehicle identifier, click the Add/Select button. Then click the Create Vehicle button and enter a vehicle identifier. The maximum length for vehicle identifiers is 32 characters. To transfer the new vehicle identifier to the current record, click the Choose Vehicle button. For more information see About Vehicles. 
       *
     * 

     4 
     L 
     Z 
     n 
      
      
      (
      
      "
     
     "
  @     7         @ Create Expense 
  @          yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p    )For more information see About Expenses. 
       
  @       
     '         ; Choose Expense 
  @          To choose an expense type, click the Add/Select Expense button. Select an expense type and then click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. 
       $
     $ 
     7 3
     j 
     x {
      	
      $
      

    - ]   AFor more information see About Expenses and About Expense Notes. 
       
  @       
     ' 
  @      , 
     ?         7 Changing Vehicles 
  @          To add a new vehicle identifier to the current record, click the Add/Select button. Then select the new vehicle identifier and then click the Choose Vehicle button. You may also double-click on the vehicle identifier to add the vehicle to the current record. 
       A
     A 

     K 
     h 
     z 
      
      *
      
      *  To change vehicle identifiers, click the Add/Select button. If you want to modify an existing vehicle identifier, select the vehicle identifier to be changed, click the Modify Vehicle button and enter a new vehicle identifier. The maximum length for vehicle identifiers is 32 characters. To transfer the new vehicle identifier to the current record, click the Choose Vehicle button. 
       )
     ) 

     3 +
     ^ 
     p 

     } 
      
      
      
      
      
      
     (
    4 
    F "
    h 
    v            Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
   ک Wheat      a             	        Service Records Ex   Non mouseUp
  lock screen
  push card
  go card "Service records"
end mouseUp
   ک Wheat    p  l             		        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
   ک Wheat      ~             	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
   ک Wheat     " P             	        Vehicle Tracker Ex   Non mouseUp
  lock screen
  push card
  go card "Vehicle Tracker"
end mouseUp
   ک Wheat    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
   ک Wheat     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
   ک Wheat     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
   ک Wheat     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
           ک Wheat     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Vehicle Expense Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
   ک Wheat     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
   ک Wheat     y             	           K          g          K           j          K                    K        
   T    
  ! index  	x  Ton mouseUp
  if the optionKey is down then
    # sort this stack by line 1 of field "main"
    # go card "help index"
    # put empty into field "Index"
    # repeat with i = 1 to the number of cards
      # set the name of card i to line 1 of field "main" of card i
      # put line 1 of field "main" of card i & return after field "index"
    # end repeat
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Expense Notes  About Expenses  About Help  About Vehicles  Adding a New Expense Type  Adding a New Record  Adding a New Vehicle  Adding Expenses  Adjusting the Date  Adjusting the Time  Background Color  Button Colors  Changing Expense Types  Changing Vehicles  Choose Date  Choose Expense  Choose Vehicle  Create Expense  Create Report  Create Vehicle  Default Settings  Delete Expense  Delete Vehicle  Deleting Records  
Edit Date  Edit Expense $  
Edit Time  Exporting Records  
First Record  Font  Go To  Help  Highlight Color  Home  Importing Records  Keyboard Shortcuts  Last Record  Look and Feel  Modify Expense  Modify Vehicle  Monetary Symbol  Next Record  No Expense  	Now Time  Preferences  Prev Record  	Printing  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Service Records  Sorting Records  Time Format  
Today's Date  Total Expenses  	Tutorial  Vehicle Reports  Vehicle Tracker  Visual Effects         	`    @ _ Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    Reindex EpNon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put  line 1 of field "main" of card i & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp

          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	           K        ^             K        m  q       
aExpenses  	
on openCard
  global gExpense
  if field "expenses" = empty then exit openCard
  if gExpense is empty then
    set the hilitedlines of field "expenses" to 1
    put 1 into gExpense
  end if
  set the hilitedlines of field "expenses" to gExpense
end openCard

on arrowKey which
  global gExpense
  put the number of lines of field "expenses" into numLines
  if which is up then
    if gExpense is 1 then
      put numLines into gExpense
    else
      subtract 1 from gExpense
    end if
  end if
  if which is down then
    if gExpense is numLines then
      put 1 into gExpense
    else
      add 1 to gExpense
    end if
  end if
  set the hilitedlines of field "expenses" to gExpense
end arrowKey

on selectExpense
  global gExpense,gCallStack,gDollarSign,gDontSave
  put true into gDontSave
  if  line gExpense of field "expenses" is empty then
    set the hilitedlines of field "expenses" to 0
    exit to metaCard
  end if
  lock screen
  close stack "aexpenses"
  go stack gCallStack
  if gCallStack is "vreports" then
    put (line gExpense of field "expenses" of stack "aexpenses") into field "expense" of stack gCallStack
    set the disabled of button "expense type" of group "sort" of stack "vreports" to true
    set the hilite of button "all expenses" of stack "vreports" to false
    set the hilite of button "date" of stack "vreports" to true
  else
    if field "expense" of stack gCallStack is not empty then
      answer "Are you sure you want to replace the expense type on this record?" with "Yes" or "Cancel"
      if it is "Cancel" then
        exit selectExpense
      end if
    end if
    put (line gExpense of field "expenses" of stack "aexpenses") into field "expense" of stack gCallStack
    if (item 2 of line gExpense of field "expenses" of stack "aexpenses")  <> empty then
      put gDollarSign & (item 2 of line gExpense of field "expenses" of stack "aexpenses")  \
          into field "expense amount" of stack gCallStack
    end if
    addExpenses
  end if
  put empty into gExpense
  unlock screen with visual plain
end selectExpense

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on checkFocus
  global gExpense
  
  if word 3 of the focusedObject is the id of button "Create Expense" then
    send mouseUp to button "Create Expense"
  else
    if gExpense is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Expense"
    end if
  end if
end checkFocus
   دyy 
Burlywood    # _^,         	Expenses      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica       	@          ^,                    
   expensesbg  	h          6                    	`    @   7      Create Expense Ex  on mouseUp
  global gExpense,gDollarSign
  put 25 into maxLength
  ask "Enter the type of the new expense."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this expense that is "&maxLength&" characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)>maxLength then exit mouseUp
  end if
  put it into newExpense
  unlock screen
  repeat until offset(comma,newExpense)=0
    put ";" into char offset(comma,newExpense) of newExpense
  end repeat
  
  if gDollarSign = "$" then set the numberformat to 0.00
  ask "If there is a fixed amount for this expense, " & return & "enter it here."
  if it is not empty then
    put it into zdollars
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zdollars is a number) AND (char 1 of zdollars <> ".") then
        delete char 1 of zdollars
      end if
    end repeat
    put (the number of chars of zdollars) into lastChar
    if not(char lastChar of zdollars is a number) then
      delete char lastChar of zdollars
    end if
    if not(zdollars is a number) then
      answer error "Problem converting field Expense Amount to a number."
    else
      put zdollars + 0.00 into item 2 of newExpense
    end if
  end if
  unlock screen
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is newExpense then
      answer information "You have already created this expense type."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "expenses" + 1 into temp
  put newExpense into line temp of field "expenses"
  sort field "expenses"
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is newExpense then
      set the hilitedLines of field "expenses" to i
      put i into gExpense
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           ک Wheat     c              	        Delete Expense Ex  on mouseUp
  global gExpense, gStack
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select an Expense to delete."
      exit mouseUp
    end switch
  end if
  put line gExpense of field "expenses" of stack "expenses" into temp
  answer warning "After deleting this expense type, you will no longer " & return & "be able to generate reports on " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gExpense of field "expenses" of stack "expenses"
  put empty into gExpense
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat                   	        Choose Expense Mx  on mouseUp
  global gExpense
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "First create an Expense."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select or create an Expense."
      exit mouseUp
    end switch
  end if
  selectExpense
end mouseUp
   ک Wheat     8  %            		        No Expense Ex  on mouseUp
  global gExpense,gStack
  global gDontSave
  put true into gDontSave
  put empty into field "expense" of stack gStack
  put empty into gExpense
  close this stack
  if gStack is "vehicleExp" then
    send mouseUp to button "total" of stack gStack
  end if
end mouseUp
   ک Wheat                   	     
   instruction 	         
 J (           ;Create an expense or select one from the list on the left   &and then click a button on the right.    
Close Window Ex   Xon mouseUp
  global gDontSave
  put true into gDontSave
  close this stack
end mouseUp
   ک Wheat                   	        Modify Expense Ex  
on mouseUp
  global gExpense,gDollarSign
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select an Expense."
      exit mouseUp
    end switch
  end if
  put line gExpense of field "expenses" into origExpense
  
  put 25 into maxLength
  ask "Enter the new name for this expense." with item 1 of origExpense
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this expense that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  put it into checkItems
  repeat until offset(comma,checkItems)=0
    put ";" into char offset(comma,checkItems) of checkItems
  end repeat
  --  put checkItems into expense
  
  if gDollarSign = "$" then set the numberformat to 0.00
  ask "If there is a fixed amount for this expense, " & return & "enter it here." with item 2 of origExpense
  if it is not empty then
    put it into zdollars
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zdollars is a number) AND (char 1 of zdollars <> ".") then
        delete char 1 of zdollars
      end if
    end repeat
    put (the number of chars of zdollars) into lastChar
    if not(char lastChar of zdollars is a number) then
      delete char lastChar of zdollars
    end if
    if not(zdollars is a number) then
      answer error "Problem converting field Expense Amount to a number."
      exit  mouseUp
    end if
    put zdollars + 0.00 into item 2 of checkItems
  end if
  
  put checkItems into line gExpense of field "expenses"
  put checkItems into newExpense
  repeat with i = 1 to the number of cards of stack "vehicleExp"
    if field "expense" of card i of stack "vehicleExp" is origExpense then
      put newExpense into field "expense" of card i of stack "vehicleExp"
      send mouseUp to button "total" of stack "vehicleExp"
    end if
  end repeat
  
  sort field "expenses"
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is checkItems then
      set the hilitedLines of field "expenses" to i
      put i into gExpense
      exit mouseUp
    end if
  end repeat
end mouseUp
   ک Wheat                   	     
   	expenses  	x   on mouseUp
  global gExpense
  put word 2 of the clickLine into gExpense
end mouseUp

on mouseDoubleDown
  global gExpense,gStack
  selectExpense
  put empty into gExpense
end mouseDoubleDown
         6             Brake Service  
Fuel Stop  Oil Change  Tire Rotation  Transmission Service  Tune Up       	`    @   7      Import/Export Ex   on mouseUp
  put "expenses" into zfield
  put "expenses" into what
  put "an Expenses" into zstack
  put "expenses.txt" into fileName
  
  importExport zfield,what,zstack,filename
end mouseUp
   ک Wheat                   	        
vehicledb  
on enterDate whichField
  if field whichField is empty then
    put the date into temp
  else
    put field whichField into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then
    put empty into field whichField
    exit enterDate
  end if
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit enterDate
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit enterDate
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit enterDate
      end if
    else
      put it into temp
      convert temp to short date
      put temp into field whichField
    end if
  else
    put it into temp
    convert temp to short date
    put temp into field whichField
  end if
end enterDate
  w         دyy 
Burlywood    white        
          Service Records      U 
Helvetica  
 U 
Helvetica   W 
Helvetica  	 U monaco   U 
helvetica       	@                  i           7 Select Project ex    on mouseUp
  global gCallStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gCallStack
  lock messages
  go stack "vehicles"
  show stack "vehicles"
end mouseUp
           ک Wheat            Add/Delete/Choose         	     
   label1           	              Vehicle Description 
   label2            x            Original Odometer 
  1 	oc label            N l            Last Oil Change 
  : label4           h < D            	Location 
  / label5          0 < L            	Odometer 
  < 	oc label            z l            
Last Tune Up 
  @ label7           h h D            	Location 
  ? label8          0 h L            	Odometer 
  D 	oc label             l            Brake Service 
  H label10           h  D            	Location 
  G label11          0  L            	Odometer 
  L 	oc label             l            
Transmission 
  P label12           h  D            	Location 
  O label14          0  L            	Odometer 
  T 	oc label             l            Tire Rotation 
  X label16           h  D            	Location 
  W label17          0  L            	Odometer 
  [ notes label            l            Notes 
   description  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        
            
   origMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
         d           
  9 ocLocation  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        l P `             2 Today Ex  
 Aon mouseUp
  put the short date into field "ocdate"
end mouseUp
   ک Wheat     = (              	       4 Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "ocdate" into gStartDate
  put "ocdate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat     = 2              	     
  5 ocDate  	x    9on mouseUp
  enterDate the short name of me
end mouseUp
         P `           
  0 
ocMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
       4 P L           
  ; tuLocation  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        l | `             A Today Ex  
 Aon mouseUp
  put the short date into field "tudate"
end mouseUp
   ک Wheat     i (              	       B Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "tudate" into gStartDate
  put "tudate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat     i 2              	     
  = tuDate  	x    9on mouseUp
  enterDate the short name of me
end mouseUp
         | `           
  > 
tuMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
       4 | L           
  C bsLocation  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        l  `             I Today Ex  
 Aon mouseUp
  put the short date into field "bsdate"
end mouseUp
   ک Wheat      (              	       J Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "bsdate" into gStartDate
  put "bsdate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat      2              	     
  E bsDate  	x    9on mouseUp
  enterDate the short name of me
end mouseUp
          `           
  F 
bsMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
       4  L           
  K tsLocation  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        l  `             Q Today Ex  
 Aon mouseUp
  put the short date into field "tsdate"
end mouseUp
   ک Wheat      (              	       R Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "tsdate" into gStartDate
  put "tsdate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat      2              	     
  M tsDate  	x    9on mouseUp
  enterDate the short name of me
end mouseUp
          `           
  N 
tsMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
       4  L           
  S trLocation  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        l  `             Y Today Ex  
 Aon mouseUp
  put the short date into field "trdate"
end mouseUp
   ک Wheat      (              	       Z Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  --  subtract 40 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "trdate" into gStartDate
  put "trdate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat      2              	     
  U trDate  	x    9on mouseUp
  enterDate the short name of me
end mouseUp
          `           
  V 
trMileage  )x    Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
       4  L              Help Ux   Don mouseUp
  lock screen
  get the loc of this stack
  put "aHelp" into whichStack
  if the loc of stack whichStack = it then
    add 395 to item 1 of it
    set the loc of stack whichStack to it
  end if
  go card "Service records" of stack whichStack
  show stack whichStack
  unlock screen with visual plain
end mouseUp
   ک Wheat     A             	       ( 
Close Window Ex    son mouseUp
  lock screen
  close this stack
  go stack "vehicleExp"
  unlock screen with visual plain
end mouseUp
   ک Wheat    T t             	        Save Ux    *on mouseUp
  save this stack
end mouseUp
   ک Wheat   < H             	        Print Ux   on mouseUp
  if (the platform contains "Mac") or (the platform contains "Win") then
    answer printer
    if the result is "Cancel" then
      exit to metaCard
    end if
    --  set the printrotated to true
    set the printmargins to 50,50,50,50
    open printing with dialog
    if the result is "Cancel" then
      exit to metaCard
    end if
  else
    answer "Printing not supported"
    exit to metaCard
  end if
  lock screen
  put the height of this stack into zheight
  set the height of this stack to 720
  put the rect of field "notes" into rrect
  set the rect of field "notes" to 7,292,391,712
  print this card
  close printing
  set the rect of field "notes" to rrect
  set the height of this stack to zheight
  unlock screen
end mouseUp
   ک Wheat     f             	     
   start items  !h            t           
  ^ vehicle  !`        < h                
  \ notes  )h          8$H l            ]    	`    @ o%  j   a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   دyy 
Burlywood    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
   ک Wheat    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
   ک Wheat     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@  ک Wheat      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   دyy 
Burlywood   @  d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
            d  z                
     @       0              #Add all amounts to Expense Amount?   z icon BP on mouseUp
end mouseUp
   ک Wheat      , (         	      Cancel D`  ک Wheat      6 L            	      Just Notes D`  ک Wheat     6 a            	      Just Miles D`  ک Wheat   
 6 ]            	      All D`  ک Wheat    6 /            	      y D`  ک Wheat     4 '            	      x D`  ک Wheat    i 4 '            	      w D`  ک Wheat      4 )            	      	vReports  
on keyDown which
  if commandKey() AND which is "q" then
    save this stack
    quit
  end if
  if commandKey() AND which is "w" then
    close this stack
  end if
  pass keyDown
end keyDown

function checkItems cardNum
  if field "project" of card cardNum of stack "records" is empty \
      OR field "task" of card cardNum of stack "records" is empty \
      OR field "elapsed" of card cardNum of stack "records" is empty then
    return true
  else
    return false
  end if
end checkItems

on collectExpenseData cardnum,invoice
  global gExpenses,gDollars,gStack,gNotes,gDollarSign,gSubTotal
  
  if gDollars is "$" then set numberformat to 0.00
  put field "date" of card cardNum of stack "vehicleExp"  into zDate
  convert zDate to abbr date
  delete item 3 of zDate
  put field "vehicle" of card cardNum of stack "vehicleExp" into zProject
  put validateNumber(field "expense amount" of card cardNum of stack "vehicleExp") into expAmount
  
  # repeat with x = 1 to length(expAmount)
    # if char x of expAmount is "-" then
      # put true into dontAdd
      # delete char x of expAmount
      # exit repeat
    # else
      # put false into dontAdd
    # end if
  # end repeat
  
  # if (char 1 of expAmount is not a number) AND (char 1 of expAmount is not ".") then -- delete $ signs
    # repeat with x = 1 to length(gDollarSign)
      # delete char x of expAmount
    # end repeat
  # end if
  if expAmount is empty then exit collectExpenseData
  
  # if dontAdd then
    # put gDollarSign & "-" & expAmount into  zExpenseTotal
    # subtract expAmount from gSubTotal
    # subtract expAmount from gExpenses
  # else
    put gDollarSign & expAmount into  zExpenseTotal
    add expAmount to gExpenses
    add expAmount to gSubTotal
--  end if
  put item 1 of  field "expense" of card cardNum of stack "vehicleExp" into  zExpense
  
  put field "mileage" of card cardNum of stack "vehicleExp" into zMileage
  put field "miles" of card cardNum of stack "vehicleExp" into zMiles
  put field "$/mile" of card cardNum of stack "vehicleExp" into z$Mile
  put field "amount" of card cardNum of stack "vehicleExp" into zMilesAmount
  
  if field "project" is empty then
    if field "expense" is empty then
      put zProject & tab & zDate & tab & zMileage & tab & zExpense & tab & zExpenseTotal & tab & tab & cardNum & return into temp
    else
      put zProject & tab & zDate & tab & zMileage & tab & zExpenseTotal & tab & tab & cardNum & return into temp
    end if
  else -- specific vehicle
    if field "expense" is empty then
      put zDate & tab & tab & zMileage & tab & zExpense & tab & zExpenseTotal & tab & tab & cardNum & return into temp
    else
      put zDate & tab & tab & zMileage & tab & zExpenseTotal & tab & tab & cardNum & return into temp
    end if
  end if
  
  if zMiles is not empty then
    put "Mileage is " & zMiles & " at " & z$Mile & " = " & zMilesAmount & return after temp
  end if
  
  if field "expense notes" of card cardNum of stack "vehicleExp"  <> empty then
    put  "Expense Notes = " & field "expense notes" of card cardNum of stack "vehicleExp" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "voutput"
end collectExpenseData

on createLines
  global gNotes
  repeat while the number of chars of gNotes > 0
    put 100 into tooLong
    put char 1 to tooLong of gNotes into temp2
    if offset(return,temp2) = 0 then
      repeat while the number of chars of temp2 > 0
        if char tooLong of temp2 <> space then
          delete char tooLong of temp2
          subtract 1 from tooLong
        else
          exit repeat
        end if
      end repeat
    else
      put offset(return,temp2) - 1 into tooLong
    end if
    if length(gNotes) < 100 then
      put gNotes after temp
      exit repeat
    end if
    if tooLong < 1 then
      delete char 1 of gNotes
    else
      put char 1 to tooLong of temp2 & return after temp
      delete char 1 to tooLong of gNotes
    end if
  end repeat
  put temp into gNotes
end createLines

on checkTime
  set the hilite of button "all dates" to false
  put field "start"  into startTime
  put field "end"  into endTime
  if startTime is empty or endTime is empty then exit checkTime
  convert startTime to dateItems
  convert endTime to dateItems
  
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    subtract 1 from item 1 of endTime
  end if
  
  repeat with i = 1 to 5
    if (item i of startTime > item i of endTime) then
      abort
      exit to metaCard
    end if
  end repeat
end checkTime

on abort
  global gStartDate, gEndDate, gDateField, gDateStack
  
  if gDateField is "start" then
    put gStartDate into field "start"
  else
    put gEndDate into field "end"
  end if
  answer error "The end date is before the start date. " & return & "Please enter a new date."
end abort

function spaces howmany
  repeat with i = 1 to howmany
    put space after temp
  end repeat
  return temp
end spaces

function roundoff numb
  set the numberFormat to 0.000
  put offset(".",numb) into decPos
  put char 1 to decPos of numb into zwhole
  put char decPos  to length(numb) of numb into zparts
  put field "roundoff" into z
  put z/2 into x
  put 0 into y
  put 0 into n
  repeat while y < 1.000
    add x to y
    if zparts < y then
      return (zwhole + (y-x))
    end if
    add x to y
    add 1 to n
  end repeat
  return (zwhole + 1)
end roundoff

function daysofmonth zmonth, zyear
  put "1,3,5,7,8,10,12" into longMonth
  repeat with i = 1 to the number of items of longMonth
    if item i of longMonth is zmonth then
      return 31
    end if
  end repeat
  if zmonth = 2 then -- Feb
    if zyear/4 = trunc(zyear/4) then
      return 29
    else
      return 28
    end if
  else -- all other months
    return 30
  end if
end daysofmonth
  w        Black دyy 
Burlywood ffffff      white       	darkgray    
          Vehicle Reports    
  U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial       	P Ion closeCard
  global gDontSave
  put true into gDontSave
end closeCard
                  D  E                      V  W  d  e  \  ]  _       Create Report Mx  $jon mouseUp
  global  gExpenses,gDollars,gStack,gRegistered,gDollarSign,gSubTotal,gVehicleTabs
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    close this stack
    go stack "Register"
    exit mouseUp
  end if
  put 0 into gExpenses
  put 0 into gDollars
  lock screen
  
  if gVehicleTabs is empty then
    set the tabstops of field "report" of stack "voutput" to "150,240,300,460"
  else
    set the tabstops of field "report" of stack "voutput" to gVehicleTabs
  end if
  
  if NOT the hilite of button "all dates" then
    put field "start" of stack "vreports" into startDate
    if startDate is not a date or startDate is empty then
      ask "Enter a valid Start Date." with the short date
      if it is empty then exit mouseUp
      put it into field "start" of stack "vreports"
      put it into startDate
      if startDate is not a date then exit mouseUp
    end if
    
    put field "end" into endDate
    if endDate is not a date or endDate is empty then
      ask "Enter a valid End Date." with the short date
      if it is empty then exit mouseUp
      put it into field "end" of stack "vreports"
      put it into endDate
      if endDate is not a date then exit mouseUp
    end if
    
    convert startDate to seconds
    convert endDate to seconds
    if endDate < startDate then
      ask "Enter an End Date that is later than the Start Date." with the short date
      if it is empty then exit mouseUp
      put it into field "end" of stack "vreports"
      put it into endDate
      if endDate is not a date then exit mouseUp
    end if
  end if
  
  if field "project" is empty and not the hilite of button "all projects" then
    answer information "Report on one specific or all vehicles?" with "Specific" or "All Vehicles"
    if it is "All Vehicles" then
      set the hilite of button "all projects" to true
      put "All" into whichProject
    else
      send mouseUp to button "Select Vehicle"
      exit mouseUp
    end if
  else
    if the hilite of button "all projects" then
      put "All" into whichProject
    else
      put field "project" into whichProject
    end if
  end if
  
  if  field "expense" is empty AND not the hilite of button "all expenses" then
    answer information "Report on one specific or all expenses?" with "Specific" or "All Expenses"
    if it is "All Expenses" then
      set the hilite of button "all expenses" to true
      set the disabled of button "expense type" of group "sort" to false
      put "All" into whichExpense
    else
      send mouseUp to button "Select Expense"
      exit mouseUp
    end if
  else
    if  field "expense" is not empty then
      put field "expense" into whichExpense
    else
      put "All" into whichExpense
    end if
  end if
  
  convert endDate to long date
  convert startDate to long date
  put empty into field "report" of stack "voutput"
  
  if field "project" is empty then
    if field "expense" is empty then
      put "Report for All Vehicles and All Expenses" &return & return after field "report" of stack "voutput"
      put  "Vehicle" & tab & "Date" & tab & "Odometer" & tab & "Expense"  & tab & "Amount" & return & return after field "report" of stack "voutput"
    else
      put "Report for All Vehicles with " & field "expense" & " expenses" &return & return after field "report" of stack "voutput"
      put  "Vehicle" & tab & "Date" & tab  & "Odometer" & tab & "Amount" & return & return after field "report" of stack "voutput"
    end if
  else -- specific vehicle
    if field "expense" is empty then
      put "Report for vehicle" && field "project" & "  and All Expenses" &return & return after field "report" of stack "voutput"
      put  "Date" & tab & tab & "Odometer" & tab & "Expense"  & tab & "Amount" & return & return after field "report" of stack "voutput"
    else
      put "Report for vehicle" && field "project" & "  with " & field "expense" & " expenses" &return & return after field "report" of stack "voutput"
      put  "Date" & tab & tab & "Odometer" & tab & "Amount" & return & return after field "report" of stack "voutput"
    end if
  end if
  
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  if sortBy is "Date" then put "start date" into sortBy
  if sortBy is "Expense Type" then put "expense" into sortBy
  if sortBy is "" then
    answer error "Please specify a sort order first."
    exit to metaCard
  end if
  
  put true into nodata
  convert startDate to seconds
  convert endDate to seconds
  
  repeat with i = 1 to the number of cards of stack "vehicleExp"
    set cursor to busy
    if checkItems(i) then next repeat
    
    put field "date" of card i of stack "vehicleExp" into theDate
    convert theDate to seconds
    if NOT the hilite of button "all dates" then
      if (theDate < startDate) or (theDate > endDate) then next repeat
    end if
    put field "vehicle" of card i of stack "vehicleExp" into theProject
    if (theProject <> whichProject) AND (whichProject <> "all") then next repeat
    
    put field "expense" of card i of stack "vehicleExp" into theExpense
    if (theExpense <> whichExpense) AND (whichExpense <> "all") then next repeat
    
    put theDate & tab & theProject & tab & theExpense & tab & tab & i into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
  end repeat
  
  if nodata then
    answer information "There were no records found for this period."
  else
    set the itemDelimiter to tab
    sort lines of zSorter by item 1 of each
    if sortBy is "vehicle" then
      sort lines of zSorter by item 2 of each
    end if
    if sortBy is "expense" then
      sort lines of zSorter by item 3 of each
    end if
    
    set the numberFormat to 0.00
    put false into invoice
    put item 5 of line 1 of zSorter into cardNum
    put field "date" of card cardNum of stack "vehicleExp" into zDate
    put field "vehicle" of card cardNum of stack "vehicleExp" into zProject
    put field "expense" of card cardNum of stack "vehicleExp" into zExpense
    put 0 into gSubTotal
    
    repeat with n = 1 to the number of lines of zSorter
      set the itemDelimiter to tab
      put item 5 of line n of zSorter into cardNum
      
      if the hilite of button "Vehicle" then
        put field "vehicle" of card cardNum of stack "vehicleExp" into theProject
        if theProject <> zProject then
          put tab  & tab & "Totals for " & zProject & ":" & tab & gDollarSign & gSubTotal  & tab & \
              return after field "report" of stack "voutput"
          put  makeLine(60,"=")  & return  & return after field "report" of stack "voutput"
          put theProject into zProject
          put 0 into gSubTotal
        end if
      end if
      
      if the hilite of button "Expense Type" then
        put field "expense" of card cardNum of stack "vehicleExp" into theExpense
        if theExpense <> zExpense then
          set the itemDelimiter to comma
          put tab  & tab & "Totals for " & item 1 of zExpense & ":" & tab & gDollarSign & gSubTotal  & tab & \
              return after field "report" of stack "voutput"
          put  makeLine(60,"=")   & return  & return after field "report" of stack "voutput"
          put theExpense into zExpense
          put 0 into gSubTotal
          set the itemDelimiter to tab
        end if
      end if
      
      collectExpenseData cardNum, invoice
      
    end repeat
    
    if the hilite of button "Vehicle" then
      put tab & tab & "Totals for " & zProject & ":" & tab & gDollarSign & gSubTotal  & return  & return after field "report" of stack "voutput"
      put  makeLine(60,"=")   & return  & return after field "report" of stack "voutput"
    end if
    
    if the hilite of button "Expense Type" then
      set the itemDelimiter to comma
      put tab & tab & "Totals for " & item 1 of zExpense & ":" & tab & gDollarSign & gSubTotal  & return  & return after field "report" of stack "voutput"
      put  makeLine(60,"=")   & return  & return after field "report" of stack "voutput"
    end if
    
    set the numberFormat to 0.00
    put gDollarSign  & gDollars into zdollars
    put gDollarSign  & gExpenses && "Expenses" into zExpenses
    if the hilite of button "all expenses" then -- AND the hilite of button "all projects" then
      put tab & tab & "Total Expenses:" & tab & gDollarSign  & gExpenses  &  return  & return after field "report" of stack "voutput"
    else
      put  tab & "Total Expenses:" & tab & tab & gDollarSign  & gExpenses  &  return  & return after field "report" of stack "voutput"
    end if
    setHeight "voutput"
    if the openStacks contains "voutput" then close stack "voutput"
    go stack "voutput"
    setLoc "voutput"
    set the vScroll of field "report" of stack "voutput" to 0
  end if
end mouseUp

function checkItems cardNum
  if field "vehicle" of card cardNum of stack "vehicleExp" is empty OR \
      field "expense amount" of card cardNum of stack "vehicleExp" is empty then
    --  field "expense" of card cardNum of stack "vehicleExp" is empty OR \
        return true
  else
    return false
  end if
end checkItems

function makeLine znum,zchar
  repeat with i = 1 to znum
    put space & zchar after temp
  end repeat
  return temp
end makeLine
   ک Wheat                  	     
   Start  	x  on mouseUp
  global gDateField,gDateStack
  global gStartDate
  put field "start" into gStartDate
  
  if field "start" is empty then
    ask "Enter a Start Date" with the date
  else
    ask "Enter a Start Date" with field "start"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "start"
  end if
  
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "start"
    end if
  else
    put it into field "start"
  end if
  if field "end" is not empty then
    put "start" into gDateField
    checkTime
  end if
end mouseUp
        
 z b                      
   End  	x  pon mouseUp
  global gDateField,gDateStack,gEndDate

  put field "end" into gEndDate
  
  if field "end" is empty then
    ask "Enter an End Date" with the date
  else
    ask "Enter an End Date" with field "end"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "end"
  end if
  
  if it is not a date then
    ask "You entered an invalid End Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid End Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "end"
    end if
  else
    put it into field "end"
  end if
  put "end" into gDateField
  checkTime
end mouseUp
        
  b                   Select Vehicle ex   :on mouseUp
  send mouseUp to field "project"
end mouseUp
           ک Wheat    c       Select Vehicle         	        Select Expense Ex   :on mouseUp
  send mouseUp to field "expense"
end mouseUp
           ک Wheat                  		     
   project  	x   on mouseUp
  global gCallStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gCallStack
  go stack "vehicles"
  show stack "vehicles"
end mouseUp
         z               
All Expenses @e   non mouseUp
  put empty into field "expense"
  set the disabled of button "expense type" to false
end mouseUp
   ک Wheat      4      All          	       
All projects @e   yon mouseUp
  put empty into field "project"
  set the disabled of button "vehicle" of group "sort" to false
end mouseUp
   ک Wheat     ~ 4      All          	    
   
instruction2 	          h I           To create a report, select a start date, an end date, select a Vehicle and Expense (optional), choose a Sort Order, then click on Create Report.   D Edit Ex  
 8on mouseUp
  send mouseUp to field "Start"
end mouseUp
   ک Wheat    | g (              	       E Edit Ex  
 6on mouseUp
  send mouseUp to field "end"
end mouseUp
   ک Wheat    |  (              	       V Today Ex  
 on mouseUp
  global gStartDate,gDateField
  put field "start" into gStartDate
  if field "end" is empty then
    put the date into field "end"
  end if
  put the date into field "Start"
  put "start" into gDateField
  checkTime
end mouseUp
   ک Wheat    R g (              	       W Today Ex  
 on mouseUp
  global gEndDate,gDateField
  put field "end" into gEndDate
  put "End" into gDateField
  put the date into field "end"
  checkTime
end mouseUp
   ک Wheat    R  (              	       \ Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "aHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "vehicle reports", helpStack, zStack
end mouseUp
   ک Wheat    
 H             	       ] 
Close Window Ex   on mouseUp
  global gDontSave
  put true into gDontSave
  lock screen
  close this stack
  goStack "vehicleExp"
  unlock screen with visual plain
end mouseUp
   ک Wheat    [              	       _ Save Ux   @on mouseUp
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat   < H              	       d Choose Ex  
|on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "start" into gStartDate
  put "start" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Start Date"
  modal stack "dates"
end mouseUp
   ک Wheat    p } 4              	       e Choose Ex  
won mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "end" into gStartDate
  put "end" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose an End Date"
  modal stack "dates"
end mouseUp
   ک Wheat    p  4              	        sort   i        $  | Y   Date @D    ک Wheat    (  @              	     Vehicle @D    ک Wheat    ( L              	      
Expense Type @D    ک Wheat    ( t              	      Sort Order  D    ک Wheat    (  t              	   
    startDate label 	          c d            Start Date 
   endDate label 	           d            	End Date    
All Dates @E   Ton mouseUp
  put empty into field "start"
  put empty into field "end"
end mouseUp
   ک Wheat      P              	     
   expense  	x   yon mouseUp
  global gCallStack
  put the short name of this stack into gCallStack
  modal stack "aexpenses"
end mouseUp
                       K voutput   on closeCard
  if the visible of group "font" then hide group "font"
  global gDontSave
  put true into gDontSave
end closeCard
  w        Black دyy 
Burlywood ffffff      white       	darkgray    
 ?         Vehicle Expense Report    K  U Arial   U Arial   W Arial   U 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica   U 
AGaramond   U AGaramond Bold   U AGaramond SemiboldItalic   U Arial Black   U 	Percival   U 	Palatino   U OldCentury   U 	New York   U Poster  
 U AGaramond SemiboldItalic   U AGaramond SemiboldItalic   U AGaramond Bold   U Arial  	 U Arial   U Arial   U Arial   U Block   U Chicago   U Chicago   U 	Charcoal  
 U 	Charcoal   U 	Charcoal   U AGaramond Semibold   U AGaramond Italic   U AGaramond BoldItalic  
 U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond Semibold   U Arial Black   U 
.Keyboard   U Andale Mono   U AGaramond Italic   U 
Arial Narrow   U 
AGaramond   U AGaramond Bold   U Block   U Bookman Old Style   U Broadway BT   U 	Capitals   U 	Capitals   U Block  
 U Block  
 U 
Calligrapher  
 U 	Capitals   U Cornerstone   U Geneva   U GarthGraphic ExtraBold   U Herald   U Impact   U Metro   U 
Arial Narrow   U Andale Mono  	 U 
AGaramond   U 
AGaramond   U 
Helvetica   U Arial Rounded MT Bold   U Arial Black  	 U Arial Black   U Andale Mono   U AGaramond Italic   U 
AGaramond   U AGaramond SemiboldItalic  
 U B Friz Quadrata Bold  
 U CB Helvetica Condensed Bold   U CB Helvetica Condensed Bold   U AGaramond SemiboldItalic       	@          ?&            -  7  K   print   	@            
   report 	x  
 )on mouseUp
  goReportLine 7
end mouseUp
        
 *x 
 
 
 
     ,          	`    @ #  v 
   report )h         
 
 
 
    @   All Project Report - page 3    KActivity Notes = brother ad code changes, add new ad & button to all pages    6Sunday, October 22	SmallBusinessDepot	Daily News	1.00    >Monday, October 23	SmallBusinessDepot	Misc. Site Changes	1.50  &Activity Notes = remove brother blurb    7Tuesday, October 24	SmallBusinessDepot	Daily News	0.00    6Totals for this report:	$1550.00	31.00 Billable Hours    		0 Non-Billable Hours       - size   a          Z
  . short  )h  
          <           %button "Close Window"	52,410,186,431  $button "Save as..."	201,410,306,431  button "Font"	321,410,405,431  button "Print"	420,410,504,431  field "report"	10,24,564,400   /    	`    @ k   : 
  0 long  )h  
         <           %button "Close Window"	52,519,186,540  $button "Save as..."	201,519,306,540  button "Font"	321,519,405,540  button "Print"	420,519,504,540  field "report"	10,24,564,508   1    	`    @    :   2 putLong Ex  
-on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 4
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field 1 & tab & the rect of field 1 after field whichField
end mouseUp
   ک Wheat    \ :              	       3 setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ک Wheat    \ :              	       4 	putShort Ex  
.on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 4
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field 1 & tab & the rect of field 1 after field whichField
end mouseUp
   ک Wheat     \ :              	       5 	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ک Wheat   ? \ :              	        
Close Window Ex   on mouseUp
  global gDontSave
  put true into gDontSave
  lock screen
  close this stack
  goStack "vreports"
  unlock screen with visual plain
end mouseUp
   ک Wheat    4              	        Save as... Ex  on mouseUp
  put the short date into temp
  repeat while offset("/",temp)>0
    put "_" into char offset("/",temp) of temp
  end repeat
  put "vehicle_report_" & temp & ".txt" into temp
  ask file "Save this report as..." with temp
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    put field "report" into temp
    set itemdelimiter to tab
    repeat with i = 2 to the number of lines of temp
      delete item 6 to 7 of line i of temp
      write line i of temp & return to file filename
    end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   ک Wheat     i             	        Font Ex  ~on mouseUp
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  show group "font"
  unlock screen with visual barn door open
end mouseUp
   ک Wheat   A T             	        Print Ex   &on mouseUp
  printReport
end mouseUp
   ک Wheat    T             	       7 font   a           8 font bg E`  ک Wheat                  	       9 bgrect   K@              v   
  : fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats   ;    	`    @       < Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
   ک Wheat    `              	     
  = inst 	                      +Pick a font face and size for your report.   > sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K  ? 9 pt @D  ک Wheat     8              	     @ 10 pt @D  ک Wheat     8              	    A 11 pt @D  ک Wheat     8              	     B 12 pt @D  ک Wheat     8              	     C 14 pt @D  ک Wheat     8              	     D 16 pt @D  ک Wheat     8              	   
  E 
instruction2 	         {  ,           KAfter making changes to the font or size, you may need to adjust the tabs. 
  F label2 
         T             Line Height 
  G lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
        '            13   H Tabs Ex   on mouseUp
  global gVehicleTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    put "150,240,300,460" into gVehicleTabs
    set the tabstops of field "report" to gVehicleTabs
    break
    
  case "Custom"
    if gContactTabs is empty then put the tabstops of field "report" into gVehicleTabs
    ask "Set the tab stops of the report field to" with gVehicleTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gVehicleTabs
    end if
  end switch
end mouseUp
   ک Wheat   a `              	       I 
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
   ک Wheat   = `              	     
  K instruction 	  
                    5Click an item name in the list to go to that record.  