#include <stdio.h>
#include <string.h>
#include <winsock.h>

#include "ansiterm.h"

#define STRNCHATTITLE "NChat 0.1.0 alpha-2"
#define STRNCHATTITLE2 "pre-release 7b from Jun.1999"

#define SIZEOFNICKNAME	32
#define SIZEOFHOSTNAME	256
#define SIZEOFPORTNAME	32
#define SIZEOFHOSTADDR	32
#define SIZEOFMESSAGE	4096
#define SIZEOFBUFFER	4096

#define DEFAULTNICKNAME "user"
#define DEFAULTPORT "8000"

#define PRINTSOCKERR(S) fprintf(stderr,"\n\a error %d: %s\n",WSAGetLastError(),S)
#define PRINTERROR(S) fprintf(stderr,"\n\a error: %s\n",S)
#define PRINTDEBUG(S) // fprintf(stdout,S)
#define PRINTDEBUGI(I) // fprintf(stdout,"%i",I)

#define TERM_MAINWIN_INIT() atputs ( &term, "[2;22r[m" )
#define TERM_MAINWIN_SAVE() atputs ( &term, "[s" )
#define TERM_MAINWIN_RESTORE() atputs ( &term, "[2;22r[m[u" )
#define TERM_PROMPT() atputs ( &term, "[24;25r[01;40;37m[0J> " );

int parselocation ( char *, char *, char * );
void term_init ( void );
void print_cmdlinehelp ( void );
void print_help ( void );

ANSITERM term;

int main ( int argc, char * * argv )
  {
    int	len;		// length of sockaddr
    int	result;		// result
    int	quit;		// flag: quit
    int	rc_connected;	// flag: remote client connected (... to local server)
    int	lc_connected;	// flag: local client connected (... to remote server)
    int go_connect;	// flag: go to make connection to remote server
    char *arg;		// cmdline argument

    WORD wsaVerReq;
    WSADATA wsaData;
    WSADATA * pwsaData;

    char rbuffer[SIZEOFBUFFER];		// recv buffer
    char sbuffer[SIZEOFBUFFER];		// send buffer
    char ctlrbuffer[SIZEOFBUFFER];	// control data recv buffer
    char ctlsbuffer[SIZEOFBUFFER];	// control data send buffer
    char pbuffer[2*SIZEOFBUFFER];	// print buffer

    char nickLocal[SIZEOFNICKNAME];	// nickname of local
    char addrLocal[SIZEOFHOSTADDR];	// address(ascii) of local

    SOCKET	sLClient;		// local client socket to remote server
    SOCKADDR_IN	saLClient;		// socket addr of local client

    char nameLServer[SIZEOFHOSTNAME];	// name of local server
    char portLServer[SIZEOFPORTNAME];	// port(ascii) of local server
    int		nportLServer;		// port of local server
    SOCKET	sLServer;		// listening socket of local server
    SOCKADDR_IN	saLServer;		// socket addr of local server

    char nickRemote[SIZEOFNICKNAME];	// nickname of remote
    char addrRemote[SIZEOFHOSTADDR];	// address(ascii) of remote

    SOCKET sRClient;			// socket to remote client
    SOCKADDR_IN	saRClient;		// socket addr of remote client

    char nameRServer[SIZEOFHOSTNAME];	// name of remote server
    char portRServer[SIZEOFPORTNAME];	// port(ascii) of remote host
    int		nportRServer;		// remote server port
    SOCKADDR_IN	saRServer;		// socket addr of server
    IN_ADDR 	iaRServer;		// inet address of server

    struct timeval timeout;	// timeout
    fd_set readfds;		// fds read
    fd_set writefds;		// fds write
    fd_set exceptfds;		// fds except

    /* -------- Initialize -------- */
    SetConsoleTitle ( STRNCHATTITLE );
    atopen ( &term );
    quit = FALSE;
    rc_connected = 0;	// flag = remote_client_not_connected
    lc_connected = 0;	// flag = local_client_not_connected
    go_connect = 0;	// flag = do_not_go_to_connect
    strncpy ( nickLocal, DEFAULTNICKNAME, sizeof(nickLocal) );
    strncpy ( portLServer, DEFAULTPORT, sizeof(portLServer) );

    /* -------- Command Line -------- */
    if ( argc > 1 )
      {
	int i = 1;
	do
	  {
	    arg = argv[i];
	    if ( *arg == '-' )
	      {
		arg++;
		if ( strcmp ( arg, "h" ) == 0 )
		  {
		    print_cmdlinehelp ( );
		    return -1;
		  }
		if ( strcmp ( arg, "local" ) == 0 )
		  {
		    parselocation ( argv[++i], nickLocal, portLServer );
		    if ( strcmp ( nickLocal, "" ) == 0 )
		      strcpy ( nickLocal, DEFAULTNICKNAME );
		    if ( strcmp ( portLServer, "" ) == 0 )
		      strcpy ( portLServer, DEFAULTPORT );
		  }
		if ( strcmp ( arg, "remote" ) == 0 )
		  {
		    parselocation ( argv[++i], addrRemote, portRServer );
		    if ( strcmp ( portRServer, "" ) == 0 )
		      strcpy ( portRServer, DEFAULTPORT );
		  }
		if ( strcmp ( arg, "connect" ) == 0 )
		  {
		    go_connect = 1;	// flag = go_to_connect
		  }
	      }
	      else
		{
		  print_cmdlinehelp ( );
		  return -1;
		}
	    i++;
	  } while ( i < argc );
      }

    /* -------- Initialize -------- */
    term_init ( );
    sprintf ( pbuffer, "%s  %s\n", STRNCHATTITLE, STRNCHATTITLE2 );
    atputs ( &term, pbuffer );

    /* -------- WINSOCK STARTUP -------- */
    wsaVerReq = 0x0101;	// version 1.1
    pwsaData = & wsaData;
    result = WSAStartup ( wsaVerReq, pwsaData );
    if ( result != 0 )
      {
	PRINTSOCKERR("WSAStartup()");
	return -1;
      }
    sprintf ( pbuffer,
      "Winsock version: %hi.%hi (max %hi.%hi)\n"
      "Descr: %s\n"
      "Sys Stat: %s\n",
      wsaData.wVersion & 0xFF,
      wsaData.wVersion >> 8,
      wsaData.wHighVersion & 0x0FF,
      wsaData.wHighVersion >> 8,
      wsaData.szDescription,
      wsaData.szSystemStatus );
    atputs ( &term, pbuffer );

    /* -------- get local host name -------- */
    result = gethostname ( nameLServer, sizeof(nameLServer) );
    if ( result == SOCKET_ERROR )
      {
	PRINTSOCKERR("gethostname()");
	return -1;
      }

    /* -------- set local port -------- */
    nportLServer = atoi ( portLServer );
    if ( nportLServer == 0 )
      PRINTERROR("local port");

    sprintf ( pbuffer, "local server: %s:%d\n", nameLServer, nportLServer );
    atputs ( &term, pbuffer );

    /* -------- Fill in the address structure for local server -------- */
    saLServer.sin_family = AF_INET;		// address family
    saLServer.sin_addr.s_addr = INADDR_ANY;	// let socket library assign address
    saLServer.sin_port = htons ( nportLServer );// port number

    /* -------- Create a TCP/IP stream socket to "listen" with -------- */
    sLServer = socket (
      AF_INET,		// address family
      SOCK_STREAM,	// socket type
      IPPROTO_TCP );	// protocol
    if ( sLServer == INVALID_SOCKET )
      {
	PRINTSOCKERR("socket()");
	return -1;
      }

    /* -------- Bind the name to the socket -------- */
    result = bind (
      sLServer,				// Socket descriptor
      (SOCKADDR*)&saLServer,		// Address to bind to
      sizeof(struct sockaddr) );	// Size of address
    if ( result == SOCKET_ERROR )
      {
	PRINTSOCKERR("bind()");
	closesocket ( sLServer );
	return -1;
      }

    /* -------- Set the socket to listen -------- */
    result = listen ( sLServer, SOMAXCONN );
    if ( result == SOCKET_ERROR )
      {
	PRINTSOCKERR("listen()");
	closesocket ( sLServer );
	return -1;
      }

    atputs ( &term, "[m[Sys:tip] " );
    atputs ( &term, "type /? or /help to see commands\n" );

    // sLServer = -1;	// invalidate socket
    sRClient = -1;	// invalidate socket
    sLClient = -1;	// invalidate socket
    TERM_MAINWIN_SAVE();
    TERM_PROMPT();

    /* -------- main loop -------- */
    while ( !quit )
      {
	if ( sLClient == -1 )
	  {
	    u_long lnRSSMode; // mode value
	    TERM_MAINWIN_RESTORE();
	    /* -------- Create TCP/IP stream socket (to remote server) -------- */
	    sLClient = socket (
	      AF_INET,		// address family
	      SOCK_STREAM,	// socket type
	      IPPROTO_TCP );	// protocol
	    if ( sLClient == INVALID_SOCKET )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: create local client socket\n" );
		break;
	      }
	    /* -------- Make socket to remote server non-blocking -------- */
	    lnRSSMode = TRUE;
	    result = ioctlsocket (
	      sLClient,		// Socket
	      FIONBIO,		// command=en_or_dis_nonblocking
	      &lnRSSMode );	// mode=1 (non-blocking)
	    if ( result == SOCKET_ERROR )
	      {
		PRINTSOCKERR("ioctlsocket(FIONBIO)");
		closesocket ( sLClient );
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: local client ioctlsocket\n" );
		break;
	      }
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  }
	/* -------- Connect to the remote server -------- */
	if ( go_connect == 1 )
	  {
	    TERM_MAINWIN_RESTORE();
	    /* set address of remote server */
	    iaRServer.s_addr = inet_addr ( addrRemote );
	    if ( iaRServer.s_addr == INADDR_NONE )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: remote server ip\n" );
	      }
	      else
		{
		  /* set remote port */
		  nportRServer = atoi ( portRServer );
		  if ( nportRServer == 0 )
		    {
		      atputs ( &term, "[m[Sys:errmsg] " );
		      atputs ( &term, "error: remote server port\n" );
		    }
		    else
		      {
			atputs ( &term, "[m[Sys:infmsg] " );
			sprintf ( pbuffer, "connect to remote server: %s:%d\n",
			  inet_ntoa ( iaRServer ),
			  nportRServer );
			atputs ( &term, pbuffer );
			/* Fill in the address structure for remote server */
			saRServer.sin_family = AF_INET;		// Address family
			saRServer.sin_addr = iaRServer;		// internet address of server
			saRServer.sin_port = htons ( nportRServer );// Port number from command line
			/* Connect to remote server */
			result = connect (
			  sLClient,			// Socket to remote server
			  (SOCKADDR*)&saRServer,	// Server address
			  sizeof(SOCKADDR) );		// Length of server address structure
			if ( result == SOCKET_ERROR )
			  {
			    result = WSAGetLastError();
			    if ( ( result != WSAEWOULDBLOCK )	// WSAEWOULDBLOCK is o.k.
			      && ( result != WSAEALREADY ) )	// WSAEALREADY is o.k.
			      {
				atputs ( &term, "[m[Sys:errmsg] " );
				atputs ( &term, "error: connecting to remote server\n" );
			      }
			  }
		      }
		}
	    lc_connected = 0;	// flag = local_client_not_connected
	    go_connect = 0;
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  }
	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sLServer,&readfds);
	FD_SET(sLServer,&exceptfds);
	if ( rc_connected == 1 )
	  {
	    FD_SET(sRClient,&readfds);
	    FD_SET(sRClient,&writefds);
	    FD_SET(sRClient,&exceptfds);
	  }
	FD_SET(sLClient,&readfds);
	FD_SET(sLClient,&writefds);
	FD_SET(sLClient,&exceptfds);
	/* -------- select -------- */
	result = select ( -1, & readfds, & writefds, & exceptfds, & timeout );
	PRINTDEBUG(" SEL:");
	PRINTDEBUGI(result);
	if ( result == SOCKET_ERROR )
	  {
	    TERM_MAINWIN_RESTORE();
	    atputs ( &term, "[m[Sys:errmsg] " );
	    atputs ( &term, "error: select\n" );
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	    break;
	  }
	/* -------- local server except ( error ) -------- */
	if ( FD_ISSET(sLServer,&exceptfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".LSx");
	    atputs ( &term, "[m[Sys:errmsg] " );
	    atputs ( &term, "error: local server exception\n" );
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	    break;
	  };
	/* -------- local server read ( accept connection ) -------- */
	if ( FD_ISSET(sLServer,&readfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".LSr");
	    len = sizeof(SOCKADDR);
	    result = accept (
	      sLServer,			// listening socket
	      (SOCKADDR*)&saRClient,	// buffer to receive remote address
	      &len );			// length of buffer
	    if ( result == SOCKET_ERROR )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: local server acception\n" );
		break;
	      }
	      else
		{
		  atputs ( &term, "[m[Sys:server] " );
		  sprintf ( pbuffer, "request accepted, remote client: %s:%d\n",
		    inet_ntoa ( saRClient.sin_addr ),
		    ntohs ( saRClient.sin_port ) );
		  atputs ( &term, pbuffer );
		  if ( rc_connected == 1 )
		    {
		      closesocket ( result );	// close connection
		      atputs ( &term, "[m[Sys:server] " );
		      sprintf ( pbuffer, "reject remote client %s:%d\n",
			inet_ntoa ( saRClient.sin_addr ),
			ntohs ( saRClient.sin_port ) );
		      atputs ( &term, pbuffer );
		    }
		    else
		      {
			rc_connected = 1;	// flag = remote_client_connected
			sRClient = result;	// set socket to remote
			atputs ( &term, "[m[Sys:server] " );
			sprintf ( pbuffer, "join remote client %s:%d\n",
			  inet_ntoa ( saRClient.sin_addr ),
			  ntohs ( saRClient.sin_port ) );
			atputs ( &term, pbuffer );
			strncpy ( ctlsbuffer, "query nick", sizeof(ctlsbuffer) );
		      }
		}
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  };
	/* -------- remote client except ( error ) -------- */
	if ( FD_ISSET(sRClient,&exceptfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".RCx");
	    atputs ( &term, "[m[Sys:errmsg] " );
	    atputs ( &term, "error: remote client exception\n" );
	    rc_connected = 0;		// flag = remote_client_not_connected
	    closesocket ( sRClient );	// close socket to remote client
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  };
	/* -------- remote client read ( recv control data ) -------- */
	if ( FD_ISSET(sRClient,&readfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".RCr");
	    result = recv (
	      sRClient,			// socket
	      ctlrbuffer,		// control data recv buffer
	      sizeof(ctlrbuffer),	// length of buffer
	      0	);			// flags
	    if ( result == SOCKET_ERROR )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: remote client recv\n" );
		rc_connected = 0;		// flag = remote_client_not_connected
		closesocket ( sRClient );	// close socket to remote client
	      }
	      else
		{
		  if ( result == 0 )	// !!! disconnected
		    {
		      atputs ( &term, "[m[Sys:errmsg] " );
		      atputs ( &term, "error: remote client disconnected\n" );
		      rc_connected = 0;		// flag = remote_client_not_connected
		      closesocket ( sRClient );	// close socket to remote client
		    }
		    else
		      {
			len = result;
			ctlrbuffer[len] = '\0';	// terminate ctlrbuffer
			atputs ( &term, "[m[Sys:ctlmsg] " );
			sprintf ( pbuffer, "%s:%d %s\n",
			  inet_ntoa ( saRClient.sin_addr ),
			  ntohs ( saRClient.sin_port ),
			  ctlrbuffer ); // !!!Warning: sizeof(ctlrbuffer) <=> pbuffer
			atputs ( &term, pbuffer );
			/* parse control data */
			{
			  char *pcmd;
			  pcmd = ctlrbuffer;
			  if ( strncmp ( pcmd, "nick ", 5 ) == 0 )
			    {
			      pcmd += 5;
			      strncpy ( nickRemote, pcmd, sizeof(nickRemote) );
			    }
			  if ( strncmp ( pcmd, "remote ", 7 ) == 0 )
			    if ( ( lc_connected == 0 )
			      && ( go_connect == 0 ) )
			      {
				pcmd += 7;
				parselocation ( pcmd, addrRemote, portRServer );
				  if ( strcmp ( portRServer, "" ) == 0 )
				    strcpy ( portRServer, DEFAULTPORT );
				go_connect = 1;	// flag = go_to_connect
			      }
			  if ( strncmp ( pcmd, "host ", 5 ) == 0 )
			    {
			      pcmd += 5;
			      strncpy ( nameRServer, pcmd, sizeof(nameRServer) );
			    }
			  if ( strncmp ( pcmd, "query ", 6 ) == 0 )
			    {
			      pcmd += 6;
			      if ( strcmp ( pcmd, "nick" ) == 0 )
				{
				  sprintf ( ctlsbuffer, "nick %s", nickLocal );
				}
			      if ( strcmp ( pcmd, "host" ) == 0 )
				{
				  sprintf ( ctlsbuffer, "host %s", nameLServer );
				}
			    }
			}
		      }
		}
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  };
	/* -------- remote client write ( send data ) -------- */
	if ( FD_ISSET(sRClient,&writefds) )
	  {
	    PRINTDEBUG(".RCw");
	    if ( ( strlen ( sbuffer ) != 0 ) )
	      {
		TERM_MAINWIN_RESTORE();
		sprintf ( pbuffer, "[m[%6s] [1m %s\n",
		  nickLocal,
		  sbuffer ); // !!!Warning: sizeof(sbuffer) <=> pbuffer
		atputs ( &term, pbuffer );
		result = send (
		  sRClient,		// socket
		  sbuffer,		// send buffer
		  strlen ( sbuffer ),	// length of data
		  0 );			// flags
		sbuffer[0] = '\0';	// empty sbuffer
		if ( result == SOCKET_ERROR )
		  {
		    atputs ( &term, "[m[Sys:errmsg] " );
		    atputs ( &term, "error: remote client send\n" );
		    rc_connected = 0;		// flag = remote_client_not_connected
		    closesocket ( sRClient );	// close socket to remote client
		  };
		TERM_MAINWIN_SAVE();
		TERM_PROMPT();
	      }
	  };
	/* -------- local client except ( error ) -------- */
	if ( FD_ISSET(sLClient,&exceptfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".RSx");
	    if ( lc_connected == 0 )
	      {
		go_connect = 1;	// flag = go_to_connect
	      }
	      else
		{
		  atputs ( &term, "[m[Sys:errmsg] " );
		  atputs ( &term, "error: local client exception\n" );
		  closesocket ( sLClient );	// close socket
		  sLClient = -1;		// invalidate socket
		  lc_connected = 0;		// flag = local_client_not_connected
		}
		TERM_MAINWIN_SAVE();
		TERM_PROMPT();
	  };
	/* -------- local client read ( recv data ) -------- */
	if ( FD_ISSET(sLClient,&readfds) )
	  {
	    TERM_MAINWIN_RESTORE();
	    PRINTDEBUG(".RSr");
	    result = recv (
	      sLClient,		// socket
	      rbuffer,		// data buffer
	      sizeof(rbuffer),	// length of buffer
	      0	);		// flags
	    if ( result == SOCKET_ERROR )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: local client read\n" );
		closesocket ( sLClient );	// close socket
		sLClient = -1;			// invalidate socket
		lc_connected = 0;		// flag = local_client_not_connected
	      };
	    if ( result == 0 )
	      {
		atputs ( &term, "[m[Sys:errmsg] " );
		atputs ( &term, "error: local client read (read 0 bytes ...disconnected)\n" );
		closesocket ( sLClient );	// close socket
		sLClient = -1;			// invalidate socket
		lc_connected = 0;		// flag = local_client_not_connected
	      };
	    len = result;
	    rbuffer[len] = '\0';
	    sprintf ( pbuffer, "[m[%6s] [1m %s\n",
	      nickRemote,
	      rbuffer );
	    atputs ( &term, pbuffer );
	    TERM_MAINWIN_SAVE();
	    TERM_PROMPT();
	  };
	/* -------- local client write ( connected / send ctl data ) -------- */
	if ( FD_ISSET(sLClient,&writefds) )
	  {
	    PRINTDEBUG(".RSw");
	    if ( lc_connected == 0 )
	      {
		TERM_MAINWIN_RESTORE();
		lc_connected = 1;	// flag = local_client_connected
		go_connect = 0;		// flag = do_not_go_to_connect
		/* get name of local client */
		len = sizeof(SOCKADDR);
		result = getsockname (
		  sLClient,			// socket
		  (SOCKADDR*)&saLClient,	// buffer to receive name
		  &len );			// length of buffer
		if ( result == SOCKET_ERROR )
		  {
		    atputs ( &term, "[m[Sys:errmsg] " );
		    atputs ( &term, "error: local client getsockname\n" );
		    closesocket ( sLClient );	// close socket
		    sLClient = -1;		// invalidate socket
		    // lc_connected = 0;	// flag = local_client_not_connected
		  }
		/* get name of remote server */
		len = sizeof(SOCKADDR);
		result = getpeername (
		  sLClient,			// socket
		  (SOCKADDR*)&saRServer,	// buffer to receive name
		  &len );			// length of buffer
		if ( result == SOCKET_ERROR )
		  {
		    atputs ( &term, "[m[Sys:errmsg] " );
		    atputs ( &term, "error: local client getpeername\n" );
		    // lc_connected = 0;	// flag = local_client_not_connected
		  }
		strncpy ( addrLocal, inet_ntoa ( saLClient.sin_addr ), sizeof(addrLocal) );
		if ( rc_connected == 0 )
		  sprintf ( ctlsbuffer, "remote %s:%s", addrLocal, portLServer );
		atputs ( &term, "[m[Sys:client] " );
		sprintf ( pbuffer, "%s:%d connected to %s:%d\n",
		  inet_ntoa ( saLClient.sin_addr ),
		  ntohs ( saLClient.sin_port ),
		  inet_ntoa ( saRServer.sin_addr ),
		  ntohs ( saRServer.sin_port ) );
		atputs ( &term, pbuffer );
		TERM_MAINWIN_SAVE();
		TERM_PROMPT();
	      }
	    /* -------- Send control data -------- */
	    if ( ( strlen ( ctlsbuffer ) != 0 ) )
	      {
		TERM_MAINWIN_RESTORE();
		result = send (
		  sLClient,			// Socket
		  ctlsbuffer,			// Data buffer
		  strlen ( ctlsbuffer ),	// Length of data
		  0 );				// Flags
		ctlsbuffer[0] = '\0';		// empty sbuffer
		if ( result == SOCKET_ERROR )
		  {
		    atputs ( &term, "[m[Sys:errmsg] " );
		    atputs ( &term, "error: local client send\n" );
		    closesocket ( sLClient );	// close socket
		    sLClient = -1;		// invalidate socket
		    lc_connected = 0;		// flag = local_client_not_connected
		  };
		TERM_MAINWIN_SAVE();
		TERM_PROMPT();
	      }
	  };
	/* -------- prompt -------- */
	if ( kbhit ( ) )
	  {
	    char kbuffer[SIZEOFBUFFER];		// keyboard buffer
	    char *pkbd;
	    TERM_PROMPT();
	    pkbd = kbuffer;
	    gets ( kbuffer );
	    if ( *pkbd == '/' )
	      {
		pkbd++;	// skip '/'
		if ( *pkbd == '/' )
		  {
		    pkbd++;	// skip '/'
		  }
		  else
		    {
		      /* -------- commands -------- */
		      if ( strcmp ( pkbd, "quit" ) == 0 )
			break;
		      if ( ( strcmp ( pkbd, "help" ) == 0 ) || ( strcmp ( pkbd, "?" ) == 0 ) )
			{
			  TERM_MAINWIN_RESTORE();
			  atputs ( &term, "[m[Sys:help]" );
			  print_help ( );
			  TERM_MAINWIN_SAVE();
			  TERM_PROMPT();
			}
		      if ( strcmp ( pkbd, "clear" ) == 0 )
			term_init ( );
		      if ( strncmp ( pkbd, "nick ", 5 ) == 0 )
			{
			  strncpy ( ctlsbuffer, pkbd, sizeof(ctlsbuffer) );
			  while ( *pkbd++ != ' ' ); // skip spaces
			  strcpy ( nickLocal, pkbd );
			}
		      if ( strcmp ( pkbd, "connect" ) == 0 )
			{
			  if ( lc_connected == 0 )
			    {
			      go_connect = 1;	// flag = go_to_connect
			    }
			}
		      if ( strncmp ( pkbd, "connect ", 8 ) == 0 )
			{
			  if ( ( lc_connected == 0 )
			    && ( go_connect == 0 ) )
			    {
			      pkbd += 8;
			      parselocation ( pkbd, addrRemote, portRServer );
				if ( strcmp ( portRServer, "" ) == 0 )
				  strcpy ( portRServer, DEFAULTPORT );
			      go_connect = 1;	// flag = go_to_connect
			    }
			}
		      if ( strncmp ( pkbd, "query ", 6 ) == 0 )
			{
			  strncpy ( ctlsbuffer, pkbd, sizeof(ctlsbuffer) );
			}
		    }
	      }
	      else
		{
		  /* -------- message -------- */
		  strncpy ( sbuffer, kbuffer, sizeof(sbuffer) );
		};
	    TERM_PROMPT();
	  };
	/* -------- prompt -------- */
      }

    /* -------- close socket -------- */
    closesocket ( sLServer );
    closesocket ( sLClient );
    closesocket ( sRClient );

    /* -------- WINSOCK CLEANUP -------- */
    result = WSACleanup ( );
    if ( result == SOCKET_ERROR )
      {
	PRINTSOCKERR("WSACleanup()");
	return -1;
      }

    return 0;
  }

int parselocation ( char * locat, char * addr, char * port )
  {
    char str[100];
    char *pstr;
    strncpy ( str, locat, sizeof(str) );
    pstr = strstr ( str, ":" );
    if ( pstr == NULL )
      {
	strcpy ( addr, str );
	strcpy ( port, "" );
      }
      else
	{
	  *pstr = '\0';
	  strcpy ( addr, str );
	  pstr++;
	  strcpy ( port, pstr );
	}
    return 0;
  }

void term_init ( void )
  {
    char pbuffer[4000];
    atputs ( &term, "[m[H[J" );
    atputs ( &term, "[H[01;44;37m[0K" );
    sprintf ( pbuffer, "[1;2H%s", STRNCHATTITLE );
    atputs ( &term, pbuffer );
    sprintf ( pbuffer, "[1;52H%s", STRNCHATTITLE2 );
    atputs ( &term, pbuffer );
    atputs ( &term, "[23;1H[m--------------------------------------------------------------------------------" );
    TERM_PROMPT();
    TERM_MAINWIN_INIT();
    TERM_MAINWIN_SAVE();
  }

void print_cmdlinehelp ( void )
  {
    char pbuffer[4000];
    atputs ( &term, "[m" );
    sprintf ( pbuffer, "%s  %s\n", STRNCHATTITLE, STRNCHATTITLE2 );
    atputs ( &term, pbuffer );
    atputs ( &term, "Written by Neven Boianoff, mailto:neven.boianoff@usa.net\n" );
    sprintf ( pbuffer,
      "usage: nchat -command_1 [argument_2] ... -command_N [argument_N] ... \n"
      "  commands:\n"
      "    -local nickname:port        set nickname and local port (default=user:8000)\n"
      "    -remote ip.add.re.ss:port   set remote ip address and port (no defaults)\n"
      "    -connect                    connect to remote\n" );
    atputs ( &term, pbuffer );
  }

void print_help ( void )
  {
    char pbuffer[4000];
    sprintf (
      pbuffer,
      "\n"
      "  _______________________________________________________________\n"
      " |                                                               |\n"
      " |  commands                                      hot keys       |\n"
      " |  -------------------------------------------   -------------  |\n"
      " |  /? or /help  - show this text                 ctrl-g - bell  |\n"
      " |  /quit        - quit program                   ctrl-c - quit  |\n"
      " |  /clear       - clear terminal                 ctrl-i - tab   |\n"
      " |                                                ctrl-h - back  |\n"
      " |  /nick NickName  - change nickname                            |\n"
      " |  /connect  - connect to location specified in command line    |\n"
      " |  /connect ip.add.re.ss:port  - connect to specified location  |\n"
      " |  /query arg_1 ...arg_n  - send query to remote (nick,host)    |\n"
      " |_______________________________________________________________|\n"
      "\n" );
    atputs ( &term, pbuffer );
  }
