/*
 * @(#)LogServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import java.io.IOException;

import stec.lang.DString;

import stec.iws.Utils;

public class LogServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        String msg;

        String qs = _request.getQueryString();
        
        if(qs == null)
        {
            msg = "hello";
        }
        else
        {
            String args = Utils.getArgs(_request);
            if(args == null)
            {
                msg = "hello";
            }    
            else 
            {
                String name = DString.extract(args, " ", 1);
                if(name == null)
                {
                    msg = "hello";
                }
                else
                {
                    msg = "hello " + name;
                }
            }    
        }
        
        log(msg);

        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Log</title></head>");
        out.println("<body>");
        out.println("<lit>");
        out.println("[" + msg + "] was sent to the log file");
        out.println("</lit>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    public String getServletInfo()
    {
        return "LogServlet";
    }
}
