/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.RTCPTransmitter;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.util.RTPMediaThread;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Random;

public class RTCPReporter
implements Runnable {
    RTCPTransmitter transmit;
    SSRCCache cache;
    RTPMediaThread reportthread;
    Random myrand;
    boolean restart = false;
    InetAddress host;
    String cname;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public RTCPReporter(SSRCCache cache, RTCPTransmitter t) {
        this.cache = cache;
        this.setTransmitter(t);
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        this.reportthread = new RTPMediaThread(this, "RTCP Reporter");
        this.reportthread.setDaemon(true);
        this.reportthread.useControlPriority();
        this.reportthread.start();
    }

    public void setTransmitter(RTCPTransmitter t) {
        this.transmit = t;
    }

    public void close(String reason) {
        this.releasessrc(reason);
        this.transmit.close();
        this.reportthread.stop();
    }

    public void releasessrc(String reason) {
        this.transmit.bye(reason);
        this.transmit.ssrc.setOurs(false);
        this.transmit.ssrc = null;
    }

    public void run() {
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            double delay = this.cache.calcReportInterval(this.transmit.ssrc.sender, false);
            if (this.restart) {
                delay = 0.0;
                this.restart = false;
            }
            while (true) {
                RTCPReporter rTCPReporter = this;
                synchronized (rTCPReporter) {
                    this.wait((long)delay);
                }
                if (!this.restart && delay != 0.0) {
                    double reschedule = this.cache.OnExpire(true);
                    if (reschedule == 0.0) {
                        this.transmit.report();
                    } else {
                        delay = reschedule;
                    }
                }
                if (!this.restart) continue;
                this.restart = false;
            }
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
            return;
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

