/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.PlayerWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.EndOfFileEvent;
import javax.media.datasink.FileSizeLimitReachedEvent;
import javax.media.datasink.FileWriterControl;
import javax.media.datasink.FileWriterEvent;
import javax.media.datasink.FileWriterListener;
import javax.media.datasink.FileWritingErrorEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import rtp.RTPUtil;

public class ExportWizard
extends WizardDialog
implements ActionListener,
ControllerListener,
FileWriterListener,
WindowListener {
    protected PanelMediaSource panelSource;
    protected PanelMediaTargetType panelTargetType;
    protected PanelMediaTargetFormat panelTargetFormat;
    protected PanelMediaTargetFile panelTargetFile;
    protected PanelMediaTargetNetwork panelTargetNetwork;
    protected String strTitle = "Export";
    protected Processor processor;
    protected String strTargetType;
    protected boolean boolChangedProcessor = false;
    protected boolean boolChangedTargetType = false;
    protected String strFailMessage;
    protected DataSink dataSinkSave;
    protected ProgressDialog dlgProgressSave;
    protected ProgressThread threadProgressSave;
    protected Vector vectorTransmitPlayers = new Vector();
    protected CaptureControlsDialog dlgCaptureControls;
    protected Vector vectorWindowsLeft = new Vector();
    Object stateLock = new Object();
    boolean stateFailed = false;

    public ExportWizard(String strTitle, Frame frame, String strSourceUrl) {
        super(frame, strTitle, false, "/images/logo.gif");
        this.strTitle = strTitle;
        this.setTitle(strTitle);
        this.panelSource.setSourceUrl(strSourceUrl);
    }

    public ExportWizard(Frame frame, String strSourceUrl) {
        this("Export", frame, strSourceUrl);
    }

    public Vector getWindowsLeft() {
        return this.vectorWindowsLeft;
    }

    protected void init() throws Exception {
        super.init();
        this.panelSource = new PanelMediaSource();
        this.panelTargetType = new PanelMediaTargetType();
        this.panelTargetFormat = new PanelMediaTargetFormat();
        this.panelTargetFile = new PanelMediaTargetFile();
        this.panelTargetNetwork = new PanelMediaTargetNetwork();
        ((Component)this).setSize(480, 480);
        ((Component)this).setLocation(100, 100);
    }

    protected Panel getFirstPage() {
        return this.panelSource;
    }

    protected Panel getLastPage() {
        Panel panel = null;
        String strTargetType = this.panelTargetType.getType();
        if (strTargetType.equals("Save to a file")) {
            panel = this.panelTargetFile;
        } else if (strTargetType.equals("Transmit over the network")) {
            panel = this.panelTargetNetwork;
        } else if (strTargetType.equals("Preview on screen")) {
            panel = this.panelTargetFormat;
        }
        return panel;
    }

    protected Panel getNextPage(Panel panelPage) {
        Panel panelPageNext = null;
        if (panelPage == null) {
            panelPageNext = this.getFirstPage();
        } else if (panelPage == this.panelSource) {
            panelPageNext = this.panelTargetType;
        } else if (panelPage == this.panelTargetType) {
            panelPageNext = this.panelTargetFormat;
        } else if (panelPage == this.panelTargetFormat) {
            String strTargetType = this.panelTargetType.getType();
            if (strTargetType.equals("Save to a file")) {
                panelPageNext = this.panelTargetFile;
            } else if (strTargetType.equals("Transmit over the network")) {
                panelPageNext = this.panelTargetNetwork;
            } else if (strTargetType.equals("Preview on screen")) {
                panelPageNext = null;
            }
        } else {
            panelPageNext = null;
        }
        return panelPageNext;
    }

    protected Panel getPrevPage(Panel panelPage) {
        Panel panelPagePrev = null;
        panelPagePrev = panelPage == null ? this.getLastPage() : (panelPage == this.panelTargetNetwork ? this.panelTargetFormat : (panelPage == this.panelTargetFile ? this.panelTargetFormat : (panelPage == this.panelTargetFile ? this.panelTargetFormat : (panelPage == this.panelTargetFormat ? this.panelTargetType : (panelPage == this.panelTargetType ? this.panelSource : null)))));
        return panelPagePrev;
    }

    protected boolean onPageDone(Panel panelPage) {
        if (panelPage == this.panelSource) {
            this.setCursor(new Cursor(3));
            this.processor = this.panelSource.createProcessor();
            if (this.processor != null) {
                this.processor.addControllerListener(this);
                this.configureProcessor();
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (this.processor == null) {
                this.setTitle(this.strTitle);
                return false;
            }
            this.boolChangedProcessor = true;
            this.setTitle(String.valueOf(this.strTitle) + " " + this.panelSource.getSourceUrl());
        } else if (panelPage == this.panelTargetType) {
            if (this.strTargetType == null || !this.panelTargetType.getType().equals(this.strTargetType)) {
                this.strTargetType = this.panelTargetType.getType();
                this.boolChangedTargetType = true;
            }
        } else if (panelPage == this.panelTargetNetwork && !this.panelTargetNetwork.checkValidFields(true)) {
            return false;
        }
        return true;
    }

    protected boolean onPageActivate(Panel panelPage) {
        if (panelPage == this.panelSource) {
            this.setTitle(this.strTitle);
        } else if (panelPage == this.panelTargetFormat) {
            if (this.boolChangedProcessor || this.boolChangedTargetType) {
                this.setCursor(new Cursor(3));
                String strContentType = this.panelSource.getDefaultContentType();
                this.panelTargetFormat.setProcessor(this.processor, strContentType, this.strTargetType);
                this.boolChangedProcessor = false;
                this.boolChangedTargetType = false;
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (panelPage != this.panelTargetFile && panelPage == this.panelTargetNetwork) {
            this.panelTargetNetwork.setTracks(this.panelTargetFormat.getEnabledVideoTracks(), this.panelTargetFormat.getEnabledAudioTracks());
        }
        return true;
    }

    protected boolean onFinish() {
        this.setCursor(new Cursor(3));
        boolean boolResult = this.strTargetType == null ? false : (this.strTargetType.equals("Save to a file") ? this.doSaveFile() : (this.strTargetType.equals("Transmit over the network") ? this.doTransmit() : (this.strTargetType.equals("Preview on screen") ? this.doPreview() : false)));
        this.setCursor(Cursor.getDefaultCursor());
        return boolResult;
    }

    private void configureProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean boolResult = this.waitForState(this.processor, 180);
        if (!boolResult) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to configure Processor. " + this.strFailMessage);
            this.destroyProcessor();
        }
    }

    private void realizeProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean boolResult = this.waitForState(this.processor, 300);
        if (!boolResult) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to realize Processor. " + this.strFailMessage);
            this.destroyProcessor();
        }
    }

    private void destroyProcessor() {
        if (this.processor == null) {
            return;
        }
        this.processor.close();
        this.processor = null;
    }

    private synchronized boolean waitForState(Processor p2, int state) {
        p2.addControllerListener(new StateListener());
        this.stateFailed = false;
        if (state == 180) {
            p2.configure();
        } else if (state == 300) {
            p2.realize();
        }
        while (p2.getState() < state && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        return !this.stateFailed;
    }

    private boolean doSaveFile() {
        Control monitorControl = null;
        Component monitor = null;
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Processor created no output. ");
            this.destroyProcessor();
            return false;
        }
        try {
            String strFileName = this.panelTargetFile.getFileName();
            MediaLocator mediaDest = new MediaLocator("file:" + strFileName);
            this.dataSinkSave = Manager.createDataSink(dsOutput, mediaDest);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.getFrame(), exception);
            return false;
        }
        try {
            Object[] arrControls = this.dataSinkSave.getControls();
            int i2 = 0;
            while (i2 < arrControls.length) {
                if (arrControls[i2] instanceof FileWriterControl) {
                    FileWriterControl fileWriter = (FileWriterControl)arrControls[i2];
                    fileWriter.addFileWriterListener(this);
                    break;
                }
                ++i2;
            }
            monitorControl = this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                monitor = monitorControl.getControlComponent();
            }
            this.dataSinkSave.open();
            this.dataSinkSave.start();
            this.processor.start();
            Time duration = this.processor.getDuration();
            int nMediaDuration = (int)duration.getSeconds();
            this.dlgProgressSave = nMediaDuration > 0 && duration != Duration.DURATION_UNBOUNDED && duration != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.getFrame(), "Saving File ...", 0, nMediaDuration, (ActionListener)this) : new ProgressDialog(this.getFrame(), "Saving File ...", "Saving File, please wait ...", monitor, (ActionListener)this);
            ((Component)this.dlgProgressSave).setVisible(true);
            this.threadProgressSave = new ProgressThread(this.processor, this.dlgProgressSave);
            this.threadProgressSave.start();
            this.vectorWindowsLeft.addElement(this.dlgProgressSave);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.getFrame(), exception);
        }
        return true;
    }

    private boolean doTransmit() {
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Processor created no output.");
            this.destroyProcessor();
            return false;
        }
        if (!(dsOutput instanceof PushBufferDataSource)) {
            MessageDialog.createErrorDialog(this.getFrame(), "Processor output incorrect for transmission.");
            this.destroyProcessor();
            return false;
        }
        PushBufferStream[] arrStreams = ((PushBufferDataSource)dsOutput).getStreams();
        if (arrStreams == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Processor output empty.");
            this.destroyProcessor();
            return false;
        }
        boolean[] arrVideoEnabled = this.panelTargetFormat.getEnabledVideoTracks();
        boolean[] arrAudioEnabled = this.panelTargetFormat.getEnabledAudioTracks();
        String[] arrVideoAddresses = this.panelTargetNetwork.getVideoAddresses();
        String[] arrAudioAddresses = this.panelTargetNetwork.getAudioAddresses();
        String[] arrVideoPorts = this.panelTargetNetwork.getVideoPorts();
        String[] arrAudioPorts = this.panelTargetNetwork.getAudioPorts();
        String[] arrVideoTtls = this.panelTargetNetwork.getVideoTtls();
        String[] arrAudioTtls = this.panelTargetNetwork.getAudioTtls();
        TrackControl[] arrTrackControls = this.processor.getTrackControls();
        int nVideoIndex = 0;
        int nAudioIndex = 0;
        boolean boolSucceeded = false;
        int i2 = 0;
        while (i2 < arrStreams.length) {
            block20: {
                String strTtl;
                String strPort;
                String strAddress;
                block19: {
                    Format format;
                    block18: {
                        format = arrStreams[i2].getFormat();
                        if (!(format instanceof VideoFormat)) break block18;
                        while (!arrVideoEnabled[nVideoIndex]) {
                            ++nVideoIndex;
                        }
                        strAddress = arrVideoAddresses[nVideoIndex];
                        strPort = arrVideoPorts[nVideoIndex];
                        strTtl = arrVideoTtls[nVideoIndex];
                        ++nVideoIndex;
                        break block19;
                    }
                    if (!(format instanceof AudioFormat)) break block20;
                    while (!arrAudioEnabled[nAudioIndex]) {
                        ++nAudioIndex;
                    }
                    strAddress = arrAudioAddresses[nAudioIndex];
                    strPort = arrAudioPorts[nAudioIndex];
                    strTtl = arrAudioTtls[nAudioIndex];
                    ++nAudioIndex;
                }
                try {
                    if (!strAddress.equals("...") && !strPort.equals("")) {
                        RTPUtil rtpUtil = new RTPUtil();
                        SessionManager managerSession = rtpUtil.createManager(strAddress, strPort, strTtl, false, true);
                        if (managerSession == null) {
                            MessageDialog.createErrorDialog(this.getFrame(), "Unable to create Session Manager.");
                            this.destroyProcessor();
                            return false;
                        }
                        SendStream streamSend = managerSession.createSendStream(dsOutput, i2);
                        streamSend.start();
                        if (!boolSucceeded) {
                            PlayerWindow player = new PlayerWindow(this.processor, "Transcoding Processor", true);
                            player.addWindowListener(this);
                            this.vectorTransmitPlayers.addElement(player);
                            this.vectorWindowsLeft.addElement(player);
                        }
                        boolSucceeded = true;
                    }
                }
                catch (Exception exception) {
                    MessageDialog.createErrorDialog(this.getFrame(), exception);
                    this.destroyProcessor();
                    return false;
                }
            }
            ++i2;
        }
        this.dlgCaptureControls = this.panelSource.getCaptureControlsDialog();
        if (this.dlgCaptureControls != null && !this.dlgCaptureControls.isEmpty()) {
            ((Component)this.dlgCaptureControls).setVisible(true);
        }
        if (!boolSucceeded) {
            MessageDialog.createErrorDialog(this.getFrame(), "Couldn't transmit any track.");
            this.destroyProcessor();
            return false;
        }
        return true;
    }

    private boolean doPreview() {
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Processor created no output. ");
            this.destroyProcessor();
            return false;
        }
        try {
            Player player = Manager.createPlayer(dsOutput);
            if (player == null) {
                MessageDialog.createErrorDialog(this.getFrame(), "Error creating player.");
                this.destroyProcessor();
                return false;
            }
            PlayerWindow windowPlayer = new PlayerWindow(player, "Preview Player");
            this.vectorWindowsLeft.addElement(windowPlayer);
            windowPlayer = new PlayerWindow(this.processor, "Transcoding Processor");
            this.vectorWindowsLeft.addElement(windowPlayer);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), "Error creating player. ", exception);
            this.destroyProcessor();
            return false;
        }
        return true;
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if ((strCmd.equals(" Abort ") || strCmd.equals(" Stop ")) && this.dataSinkSave != null) {
            this.stopSaving();
        } else if (strCmd.equals(" Pause ") && this.dataSinkSave != null) {
            this.processor.stop();
            this.dlgProgressSave.setPauseButtonText("Resume");
        } else if (strCmd.equals("Resume") && this.dataSinkSave != null) {
            this.processor.start();
            this.dlgProgressSave.setPauseButtonText(" Pause ");
        } else {
            super.actionPerformed(event);
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.strFailMessage = ((ControllerErrorEvent)event).getMessage();
        }
    }

    public void fileWriterUpdate(FileWriterEvent event) {
        if (event instanceof EndOfFileEvent) {
            this.stopSaving();
        } else if (event instanceof FileSizeLimitReachedEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.getFrame(), "Reached file size limit.");
        } else if (event instanceof FileWritingErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.getFrame(), "Error writing the file.");
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
        Object objSource = event.getSource();
        if (objSource instanceof PlayerWindow) {
            if (this.vectorTransmitPlayers.contains(objSource)) {
                this.vectorTransmitPlayers.removeElement(objSource);
            }
            if (this.vectorTransmitPlayers.isEmpty() && this.dlgCaptureControls != null) {
                this.dlgCaptureControls.dispose();
                this.dlgCaptureControls = null;
            }
        }
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    private void stopSaving() {
        if (this.threadProgressSave != null) {
            this.threadProgressSave.stop();
            this.threadProgressSave = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.destroyProcessor();
        }
        if (this.dataSinkSave != null) {
            this.dataSinkSave.close();
            this.dataSinkSave = null;
        }
        if (this.dlgProgressSave != null) {
            this.dlgProgressSave.dispose();
            this.dlgProgressSave = null;
        }
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                ExportWizard.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = ExportWizard.this.stateLock;
                synchronized (object) {
                    ExportWizard.this.stateLock.notifyAll();
                }
            }
        }

        StateListener() {
            ExportWizard.this = ExportWizard.this;
        }
    }
}

