/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Mid2Wav4 {
    static final int fq = 44100;
    static final int MAXNOTES = 128;
    static final double dt = 2.2675736961451248E-5;
    static final double DIAPASON = 440.0;
    static final double MAXDOUBLE = 1.0E300;
    static final boolean[] is_perc;
    static final short MAXSHORT = Short.MAX_VALUE;
    static final String sitePA = "http://palbou.free.fr/winstrs/";
    static String instrFile;
    static FileInputStream inputFile;
    static RandomAccessFile tempFile;
    static RandomAccessFile outputFile;
    static MIDIheader mh;
    static boolean[] pedale;
    static int nnotes;
    static int[] volume;
    static float sg;
    static float sd;
    static double tempo;
    static instrument[] ins;
    static noteJouee[] note;
    static int prev_c;
    static int prev_stat;

    static {
        boolean[] blArray = new boolean[16];
        blArray[9] = true;
        blArray[15] = true;
        is_perc = blArray;
        pedale = new boolean[16];
        nnotes = 0;
        volume = new int[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};
        ins = new instrument[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        prev_c = -1;
    }

    Mid2Wav4() {
    }

    static void doEvent(event event2) {
        switch (event2.type) {
            case 2: {
                tempo = (double)Mid2Wav4.mh.ticks4 / ((double)event2.data * 1.0E-6) * 2.2675736961451248E-5;
                break;
            }
            case 5: {
                if (is_perc[event2.channel]) break;
                Mid2Wav4.ins[event2.channel] = new instrument();
                if (Mid2Wav4.readinst(event2.data, ins[event2.channel])) break;
                System.out.println();
                System.out.print("ERROR: can't load instrument data");
                System.exit(4);
                break;
            }
            case 6: {
                int n = 0;
                while (n < nnotes) {
                    Mid2Wav4.note[n].t2eon = is_perc[Mid2Wav4.note[n].canal] ? (double)(pedale[Mid2Wav4.note[n].canal] ? Mid2Wav4.note[n].perc.sust_decr_time : Mid2Wav4.note[n].perc.decr_time) : (double)(pedale[Mid2Wav4.note[n].canal] ? Mid2Wav4.note[n].inst_rec.sust_decr_time : Mid2Wav4.note[n].inst_rec.decr_time);
                    ++n;
                }
                break;
            }
            case 9: {
                Mid2Wav4.volume[event2.channel] = event2.data;
                break;
            }
            case 10: {
                int n = 0;
                while (n < nnotes && (Mid2Wav4.note[n].demi_ton != event2.data || Mid2Wav4.note[n].canal != event2.channel || Mid2Wav4.note[n].t2eon < 1.0000000000000001E298)) {
                    ++n;
                }
                if (n >= nnotes) break;
                if (is_perc[Mid2Wav4.note[n].canal]) {
                    Mid2Wav4.note[n].t2eon = pedale[Mid2Wav4.note[n].canal] ? Mid2Wav4.note[n].perc.sust_decr_time : Mid2Wav4.note[n].perc.decr_time;
                    break;
                }
                Mid2Wav4.note[n].t2eon = pedale[Mid2Wav4.note[n].canal] ? Mid2Wav4.note[n].inst_rec.sust_decr_time : Mid2Wav4.note[n].inst_rec.decr_time;
                break;
            }
            case 11: {
                int n;
                if (nnotes == 128) {
                    System.out.println();
                    System.out.print("ERROR: too many notes (>128)");
                    System.exit(5);
                }
                Mid2Wav4.note[Mid2Wav4.nnotes] = new noteJouee();
                Mid2Wav4.note[Mid2Wav4.nnotes].canal = n = event2.channel;
                Mid2Wav4.note[Mid2Wav4.nnotes].volume = event2.data2;
                Mid2Wav4.note[Mid2Wav4.nnotes].demi_ton = event2.data;
                Mid2Wav4.note[Mid2Wav4.nnotes].t = 0.0;
                Mid2Wav4.note[Mid2Wav4.nnotes].t2eon = 1.0E300;
                if (is_perc[n]) {
                    if (!Mid2Wav4.readperc(event2.data, Mid2Wav4.note[Mid2Wav4.nnotes].perc)) {
                        System.out.println();
                        System.out.print("ERROR: can't load percussion instrument data");
                        System.exit(7);
                    }
                } else {
                    if (ins[n] == null && !Mid2Wav4.readinst(0, Mid2Wav4.ins[n] = new instrument())) {
                        System.out.println();
                        System.out.print("ERROR: can't load instrument data");
                        System.exit(4);
                    }
                    int n2 = 0;
                    while (n2 < Mid2Wav4.ins[n].E.length && Mid2Wav4.note[Mid2Wav4.nnotes].demi_ton > Mid2Wav4.ins[n].E[n2].note2) {
                        ++n2;
                    }
                    if (n2 == Mid2Wav4.ins[n].E.length) {
                        --n2;
                    }
                    Mid2Wav4.note[Mid2Wav4.nnotes].inst_rec = Mid2Wav4.ins[n].E[n2];
                    Mid2Wav4.note[Mid2Wav4.nnotes].inst = ins[n];
                    Mid2Wav4.note[Mid2Wav4.nnotes].f = 440.0 * Math.pow(2.0, (double)(event2.data - 69) / 12.0);
                }
                ++nnotes;
                break;
            }
            case 7: {
                boolean bl = Mid2Wav4.pedale[event2.channel] = event2.data != 0;
                if (event2.data != 0) break;
                if (is_perc[event2.channel]) {
                    int n = 0;
                    while (n < nnotes) {
                        if (Mid2Wav4.note[n].canal == event2.channel && Mid2Wav4.note[n].t2eon <= (double)Mid2Wav4.note[n].perc.sust_decr_time) {
                            Mid2Wav4.note[n].t2eon = Mid2Wav4.note[n].perc.decr_time;
                        }
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < nnotes) {
                        if (Mid2Wav4.note[n].canal == event2.channel && Mid2Wav4.note[n].t2eon <= (double)Mid2Wav4.note[n].inst_rec.sust_decr_time) {
                            Mid2Wav4.note[n].t2eon = Mid2Wav4.note[n].inst_rec.decr_time;
                        }
                        ++n;
                    }
                }
                break;
            }
            case 8: {
                Mid2Wav4.pedale[event2.channel] = false;
                break;
            }
            case 12: {
                int n = 0;
                while (n < nnotes && (Mid2Wav4.note[n].demi_ton != event2.data || Mid2Wav4.note[n].canal != event2.channel)) {
                    ++n;
                }
                if (n >= nnotes) break;
                Mid2Wav4.note[n].volume = event2.data2;
                break;
            }
            case 4: {
                int n = 0;
                while (n < nnotes) {
                    if (Mid2Wav4.note[n].canal == event2.channel) {
                        Mid2Wav4.note[n].volume = event2.data;
                    }
                    ++n;
                }
                break;
            }
        }
    }

    static void doNote() {
        sg = 0.0f;
        sd = 0.0f;
        int n = 0;
        while (n < nnotes) {
            double d;
            double d2;
            double d3;
            double d4;
            int n2 = Mid2Wav4.note[n].canal;
            if (is_perc[n2]) {
                d4 = pedale[n2] ? Mid2Wav4.note[n].perc.sust_decr_time : Mid2Wav4.note[n].perc.decr_time;
                d3 = Mid2Wav4.note[n].t2eon > d4 ? 1.0 : Mid2Wav4.note[n].t2eon / d4;
                d2 = (double)Mid2Wav4.note[n].perc.wt.fe * Mid2Wav4.note[n].t;
                if (d2 < (double)(Mid2Wav4.note[n].perc.wt.e.length - 1)) {
                    d = (double)((float)volume[n2] / Mid2Wav4.note[n].perc.wt.arms * (float)Mid2Wav4.note[n].volume) * d3 * Mid2Wav4.interp(Mid2Wav4.note[n].perc.wt.e, d2);
                    sg = (float)((double)sg + d * (double)Mid2Wav4.note[n].perc.left);
                    sd = (float)((double)sd + d * (double)Mid2Wav4.note[n].perc.right);
                } else {
                    Mid2Wav4.note[n].t2eon = 0.0;
                }
            } else {
                d4 = pedale[n2] ? Mid2Wav4.note[n].inst_rec.sust_decr_time : Mid2Wav4.note[n].inst_rec.decr_time;
                d3 = Mid2Wav4.note[n].t2eon > d4 ? 1.0 : Mid2Wav4.note[n].t2eon / d4;
                double d5 = Mid2Wav4.note[n].f;
                d2 = d5 / (double)Mid2Wav4.note[n].inst_rec.wt.ff * Mid2Wav4.note[n].t * (double)Mid2Wav4.note[n].inst_rec.wt.fe;
                if (d2 < (double)(Mid2Wav4.note[n].inst_rec.wt.e.length - 1)) {
                    d = (double)((float)volume[n2] / Mid2Wav4.note[n].inst_rec.wt.arms * Mid2Wav4.note[n].inst_rec.rel_amp / Mid2Wav4.note[n].inst.a_max * (float)Mid2Wav4.note[n].volume) * d3 * Mid2Wav4.interp(Mid2Wav4.note[n].inst_rec.wt.e, d2);
                    sg = (float)((double)sg + d * (double)Mid2Wav4.note[n].inst_rec.left);
                    sd = (float)((double)sd + d * (double)Mid2Wav4.note[n].inst_rec.right);
                } else {
                    Mid2Wav4.note[n].t2eon = 0.0;
                }
            }
            Mid2Wav4.note[n].t += 2.2675736961451248E-5;
            Mid2Wav4.note[n].t2eon -= 2.2675736961451248E-5;
            if (Mid2Wav4.note[n].t2eon < 0.0) {
                --nnotes;
                int n3 = n;
                while (n3 < nnotes) {
                    Mid2Wav4.note[n3] = note[n3 + 1];
                    ++n3;
                }
                --n;
            }
            ++n;
        }
    }

    static event evreturn(event event2) throws IOException {
        if (inputFile.available() == 0) {
            event2.type = 0;
        }
        return event2;
    }

    static boolean findEntry(ZipInputStream zipInputStream, String string) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equals(string)) {
                return true;
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        return false;
    }

    static int getDWORD() throws IOException {
        int n = inputFile.available();
        if (n < 4) {
            inputFile.skip(n);
            return 0;
        }
        return (((inputFile.read() << 8) + inputFile.read() << 8) + inputFile.read() << 8) + inputFile.read();
    }

    static int getDeltaSize() throws IOException {
        int n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n;
        }
        int n2 = (n & 0x7F) << 7;
        n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n2 | n;
        }
        n2 = (n2 | n & 0x7F) << 7;
        n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n2 | n;
        }
        n2 = (n2 | n & 0x7F) << 7;
        return n2 | Mid2Wav4.getchar() & 0x7F;
    }

    static int getWORD() throws IOException {
        int n = inputFile.available();
        if (n < 2) {
            inputFile.skip(n);
            return 0;
        }
        return (inputFile.read() << 8) + inputFile.read();
    }

    static int getchar() throws IOException {
        if (prev_c != -1) {
            int n = prev_c;
            prev_c = -1;
            return n;
        }
        if (inputFile.available() == 0) {
            return -1;
        }
        return inputFile.read();
    }

    static double interp(float[] fArray, double d) {
        int n = (int)d;
        return (double)fArray[n] * ((double)(n + 1) - d) + (double)fArray[n + 1] * (d - (double)n);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws IOException {
        if (var0.length == 0) {
            System.out.print("Mid2Wav4 source_file.mid dest_file.wav [l | w]\n\nCreate a 16 bits stereo WAV file (44kHz).\nl : load instrument files locally, w : load instruments data from the Web\n\nCopyright (C) Pierre Albou, 2000-2002, all rights reserved.");
            return;
        }
        if (var0.length < 2) {
            System.out.print("ERROR: source and/or destination file names missing");
            return;
        }
        if (var0.length > 3) {
            System.out.println("WARNING: unused arguments");
        }
        if (var0.length == 3 && var0[2].equals("l")) {
            var1_1 = System.getProperty("file.separator");
            if (System.getProperty("os.name").startsWith("Windows")) {
                var2_2 = 1;
                var3_5 = ":\\";
            } else {
                var2_2 = 0;
                var3_5 = var1_1;
            }
            var4_6 = System.getProperty("java.class.path");
            var5_7 = var4_6.substring(var2_2).startsWith((String)var3_5) != false ? var4_6.substring(0, var4_6.length() - 12) : String.valueOf(System.getProperty("user.dir")) + (String)var1_1 + var4_6.substring(0, var4_6.length() - 12);
            Mid2Wav4.instrFile = "file:///" + var5_7 + "instr4.zip";
        } else {
            Mid2Wav4.instrFile = "http://palbou.free.fr/winstrs/instr4.zip";
        }
        try {
            Mid2Wav4.inputFile = new FileInputStream(var0[0]);
            Mid2Wav4.tempFile = new RandomAccessFile("mid2wav4.tmp", "rw");
            Mid2Wav4.outputFile = new RandomAccessFile(var0[1], "rw");
        }
        catch (FileNotFoundException v0) {
            System.out.print("ERROR: cannot open files");
            return;
        }
        Mid2Wav4.mh = Mid2Wav4.readHeader();
        if (Mid2Wav4.mh == null) {
            System.out.print("ERROR: faulty MIDI header");
            return;
        }
        if (Mid2Wav4.mh.SMFtype > 1) {
            System.out.print("ERROR: cannot process this MIDI file type (2)");
            return;
        }
        var1_1 = null;
        var5_8 = 0;
        while (var5_8 < Mid2Wav4.mh.tracks) {
            if (Mid2Wav4.seekChunk('M', 'T', 'r', 'k') == 0) {
                System.out.print("ERROR: corrupted MIDI file");
                return;
            }
            var4_6 = null;
            var3_5 = var1_1;
            var2_3 = Mid2Wav4.readEvent();
            while (true) {
                if (var2_3.type == 0) {
                    System.out.print("ERROR: corrupted MIDI file");
                    return;
                }
                if (var3_5 != null && var3_5.date <= var2_3.date) {
                    if (var3_5.type == 1) {
                        var3_5 = null;
                        continue;
                    }
                    var2_3.date -= var3_5.date;
                    var4_6 = var3_5;
                    var3_5 = var3_5.suivant;
                    continue;
                }
                if (var2_3.type != 1 || var3_5 == null) {
                    if (var4_6 == null) {
                        var1_1 = var2_3;
                    } else {
                        var4_6.suivant = var2_3;
                    }
                    var4_6 = var2_3;
                    var2_3.suivant = var3_5;
                }
                if (var3_5 != null) {
                    var3_5.date -= var2_3.date;
                }
                if (var2_3.type == 1) break;
                var2_3 = Mid2Wav4.readEvent();
            }
            ++var5_8;
        }
        Mid2Wav4.inputFile.close();
        System.out.print("Synthesis");
        Mid2Wav4.note = new noteJouee[128];
        var6_9 = 0;
        var7_10 = 0.0;
        var9_11 = 0.0;
        var2_4 = var1_1;
        ** GOTO lbl103
        {
            Mid2Wav4.doEvent((event)var2_4);
            var2_4 = var2_4.suivant;
            var9_11 += (double)var2_4.date;
            do {
                if (var9_11 <= 0.0 && var2_4.type != 1) continue block8;
                var9_11 -= Mid2Wav4.tempo;
                Mid2Wav4.doNote();
                try {
                    Mid2Wav4.tempFile.writeFloat(Mid2Wav4.sg);
                    Mid2Wav4.sg = Math.abs(Mid2Wav4.sg);
                    if ((double)Mid2Wav4.sg > var7_10) {
                        var7_10 = Mid2Wav4.sg;
                    }
                    Mid2Wav4.tempFile.writeFloat(Mid2Wav4.sd);
                }
                catch (IOException v1) {
                    System.out.println();
                    System.out.print("ERROR: cannot write (disk full ?)");
                    return;
                }
                Mid2Wav4.sd = Math.abs(Mid2Wav4.sd);
                if ((double)Mid2Wav4.sd > var7_10) {
                    var7_10 = Mid2Wav4.sd;
                }
                if (++var6_9 % 44100 != 0) continue;
                System.out.print('.');
lbl103:
                // 3 sources

            } while (var2_4.type != 1 || var9_11 > 0.0);
        }
        Mid2Wav4.tempFile.seek(0L);
        try {
            Mid2Wav4.write_wave(Mid2Wav4.tempFile, var7_10, var6_9, 44100, 16, true);
        }
        catch (IOException v2) {
            System.out.println();
            System.out.print("ERROR: writing (disk full ?)");
            return;
        }
        Mid2Wav4.tempFile.close();
        Mid2Wav4.outputFile.close();
        var11_12 = new File("mid2wav4.tmp");
        var11_12.delete();
    }

    static void putech(double d, int n) throws IOException {
        if (n == 16) {
            Mid2Wav4.writeShort((int)(d * 32767.0));
        } else {
            outputFile.write((int)(d * 127.0 + 128.0));
        }
    }

    static boolean readCfloat(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() == -2) {
            double d = streamTokenizer.nval;
            if (streamTokenizer.nextToken() == -3 && (streamTokenizer.sval.startsWith("e") || streamTokenizer.sval.startsWith("E"))) {
                if (streamTokenizer.sval.equals("e") || streamTokenizer.sval.equals("E")) {
                    if (streamTokenizer.nextToken() == 43 && streamTokenizer.nextToken() == -2) {
                        streamTokenizer.nval = d * Math.pow(10.0, streamTokenizer.nval);
                    } else {
                        streamTokenizer.pushBack();
                        streamTokenizer.nval = d;
                    }
                } else {
                    try {
                        Integer n = new Integer(streamTokenizer.sval.substring(1));
                        streamTokenizer.nval = d * Math.pow(10.0, n.doubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        streamTokenizer.nval = d;
                        streamTokenizer.pushBack();
                    }
                }
            } else {
                streamTokenizer.pushBack();
                streamTokenizer.nval = d;
            }
            return true;
        }
        streamTokenizer.pushBack();
        return false;
    }

    static event readEvent() throws IOException {
        event event2 = new event();
        do {
            event2.date = Mid2Wav4.getDeltaSize();
            int n = Mid2Wav4.getchar();
            block0 : switch (n) {
                case 255: {
                    prev_stat = 0;
                    switch (Mid2Wav4.getchar()) {
                        case 47: {
                            event2.type = Mid2Wav4.getchar() != 0 ? 0 : 1;
                            return event2;
                        }
                        case 81: {
                            event2.data = Mid2Wav4.getDWORD();
                            if (event2.data >> 24 == 3) {
                                event2.data = (int)((long)event2.data & 0xFFFFFFL);
                                event2.type = 2;
                            } else {
                                event2.type = 1;
                            }
                            return Mid2Wav4.evreturn(event2);
                        }
                    }
                }
                case 240: 
                case 247: {
                    prev_stat = 0;
                    int n2 = Mid2Wav4.getDeltaSize();
                    inputFile.skip(n2);
                    break;
                }
                default: {
                    if ((n & 0x80) != 0) {
                        prev_stat = n;
                    } else {
                        prev_c = n;
                    }
                    event2.channel = prev_stat & 0xF;
                    switch (prev_stat >> 4) {
                        case 14: {
                            event2.type = 3;
                            event2.data = Mid2Wav4.getchar();
                            event2.data |= Mid2Wav4.getchar() << 7;
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 13: {
                            event2.type = 4;
                            event2.data = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 12: {
                            event2.type = 5;
                            event2.data = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 11: {
                            switch (Mid2Wav4.getchar()) {
                                case 120: 
                                case 123: {
                                    event2.type = 6;
                                    if (Mid2Wav4.getchar() != 0) {
                                        event2.type = 0;
                                    }
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 121: {
                                    event2.type = 8;
                                    if (Mid2Wav4.getchar() != 0) {
                                        event2.type = 0;
                                    }
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 64: {
                                    event2.type = 7;
                                    event2.data = Mid2Wav4.getchar();
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 7: {
                                    event2.type = 9;
                                    event2.data = Mid2Wav4.getchar();
                                    return Mid2Wav4.evreturn(event2);
                                }
                            }
                            Mid2Wav4.getchar();
                            break block0;
                        }
                        case 8: {
                            event2.type = 10;
                            event2.data = Mid2Wav4.getchar();
                            Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 9: {
                            event2.data = Mid2Wav4.getchar();
                            event2.data2 = Mid2Wav4.getchar();
                            event2.type = event2.data2 != 0 ? 11 : 10;
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 10: {
                            event2.type = 12;
                            event2.data = Mid2Wav4.getchar();
                            event2.data2 = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                    }
                    event2.type = 0;
                    return event2;
                }
            }
        } while (inputFile.available() != 0);
        event2.type = 0;
        return event2;
    }

    static MIDIheader readHeader() throws IOException {
        if (Mid2Wav4.seekChunk('M', 'T', 'h', 'd') != 6 || inputFile.available() < 6) {
            return null;
        }
        MIDIheader mIDIheader = new MIDIheader();
        mIDIheader.SMFtype = Mid2Wav4.getWORD();
        mIDIheader.tracks = Mid2Wav4.getWORD();
        mIDIheader.ticks4 = Mid2Wav4.getWORD();
        return mIDIheader;
    }

    static boolean readinst(int n, instrument instrument2) {
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            if (!Mid2Wav4.findEntry(zipInputStream, String.valueOf(n) + ".idt")) {
                zipInputStream.close();
                inputStream = uRL.openStream();
                zipInputStream = new ZipInputStream(inputStream);
                if (!Mid2Wav4.findEntry(zipInputStream, "0.idt")) {
                    zipInputStream.close();
                    return false;
                }
                n = 0;
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval <= 0.0) {
                return false;
            }
            instrument2.E = new enregistrement[(int)streamTokenizer.nval];
            instrument2.samples_pool = null;
            instrument2.a_max = 0.0f;
            int n2 = 0;
            while (n2 < instrument2.E.length) {
                instrument2.E[n2] = new enregistrement();
                Mid2Wav4.skipLine(streamTokenizer);
                Mid2Wav4.skipLine(streamTokenizer);
                if (streamTokenizer.nextToken() != -3) {
                    return false;
                }
                echantillon echantillon2 = instrument2.samples_pool;
                while (echantillon2 != null && !echantillon2.name.equals(streamTokenizer.sval)) {
                    echantillon2 = echantillon2.next;
                }
                if (echantillon2 == null) {
                    echantillon2 = new echantillon();
                    if (!Mid2Wav4.readsample(echantillon2, String.valueOf(n) + "." + streamTokenizer.sval + ".wt")) {
                        return false;
                    }
                    echantillon2.name = streamTokenizer.sval;
                    echantillon2.next = instrument2.samples_pool;
                    instrument2.samples_pool = echantillon2;
                }
                instrument2.E[n2].wt = echantillon2;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].note1 = (short)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].note2 = (short)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].rel_amp = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].decr_time = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].sust_decr_time = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].vbr_freq = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].vbr_amp = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].left = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[n2].right = (float)streamTokenizer.nval;
                double d = instrument2.E[n2].left + instrument2.E[n2].right;
                instrument2.E[n2].left = (float)((double)instrument2.E[n2].left / d);
                instrument2.E[n2].right = (float)((double)instrument2.E[n2].right / d);
                if (instrument2.a_max < instrument2.E[n2].rel_amp) {
                    instrument2.a_max = instrument2.E[n2].rel_amp;
                }
                ++n2;
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean readperc(int n, percussion percussion2) {
        percussion2.wt = new echantillon();
        if (!Mid2Wav4.readsample(percussion2.wt, String.valueOf(n) + ".hit") && !Mid2Wav4.readsample(percussion2.wt, "76.hit")) {
            return false;
        }
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            if (!Mid2Wav4.findEntry(zipInputStream, String.valueOf(n) + ".pdt")) {
                zipInputStream.close();
                inputStream = uRL.openStream();
                zipInputStream = new ZipInputStream(inputStream);
                if (!Mid2Wav4.findEntry(zipInputStream, "76.pdt")) {
                    zipInputStream.close();
                    return false;
                }
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.decr_time = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.sust_decr_time = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.left = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.right = (float)streamTokenizer.nval;
            zipInputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean readsample(echantillon echantillon2, String string) {
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            Mid2Wav4.findEntry(zipInputStream, string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.fe = (int)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval <= 0.0) {
                return false;
            }
            echantillon2.e = new float[(int)streamTokenizer.nval];
            int n = 0;
            while (n < echantillon2.e.length) {
                if (!Mid2Wav4.readCfloat(streamTokenizer)) {
                    return false;
                }
                echantillon2.e[n] = (float)streamTokenizer.nval;
                ++n;
            }
            if (!Mid2Wav4.readCfloat(streamTokenizer) || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.arms = (float)streamTokenizer.nval;
            if (!Mid2Wav4.readCfloat(streamTokenizer) || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.ff = (float)streamTokenizer.nval;
            zipInputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static int seekChunk(char c, char c2, char c3, char c4) throws IOException {
        int n;
        char[] cArray = new char[4];
        while (true) {
            if (inputFile.available() < 8) {
                return 0;
            }
            cArray[0] = (char)inputFile.read();
            cArray[1] = (char)inputFile.read();
            cArray[2] = (char)inputFile.read();
            cArray[3] = (char)inputFile.read();
            n = Mid2Wav4.getDWORD();
            if (cArray[0] == c && cArray[1] == c2 && cArray[2] == c3 && cArray[3] == c4) break;
            inputFile.skip(n);
        }
        return n;
    }

    static void skipLine(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.eolIsSignificant(true);
        while (streamTokenizer.nextToken() != 10) {
            if (streamTokenizer.ttype != -1) continue;
            throw new IOException();
        }
        streamTokenizer.eolIsSignificant(false);
    }

    static void writeInt(int n) throws IOException {
        Mid2Wav4.writeShort(n & 0xFFFF);
        Mid2Wav4.writeShort(n >> 16);
    }

    static void writeShort(int n) throws IOException {
        outputFile.write(n & 0xFF);
        outputFile.write(n >> 8);
    }

    static void write_wave(RandomAccessFile randomAccessFile, double d, int n, int n2, int n3, boolean bl) throws IOException {
        n = (int)((long)n & 0xFFFFFFFFFFFFFFFEL);
        int n4 = (bl ? 2 : 1) * (n3 == 16 ? 2 : 1);
        int n5 = n * n4;
        int n6 = 16;
        int n7 = n5 + 36;
        outputFile.writeBytes("RIFF");
        Mid2Wav4.writeInt(n7);
        outputFile.writeBytes("WAVEfmt ");
        Mid2Wav4.writeInt(n6);
        Mid2Wav4.writeShort(1);
        Mid2Wav4.writeShort(bl ? 2 : 1);
        Mid2Wav4.writeInt(n2);
        Mid2Wav4.writeInt(n2 *= n4);
        Mid2Wav4.writeShort(n4);
        Mid2Wav4.writeShort(n3);
        outputFile.writeBytes("data");
        Mid2Wav4.writeInt(n5);
        boolean bl2 = false;
        System.out.print("\nWriting");
        int n8 = 0;
        while (n8 < n) {
            if (n8 % 44100 == 0) {
                System.out.print(".");
            }
            float f = randomAccessFile.readFloat();
            float f2 = randomAccessFile.readFloat();
            if (bl) {
                Mid2Wav4.putech((double)f / d, n3);
                Mid2Wav4.putech((double)f2 / d, n3);
            } else {
                Mid2Wav4.putech((double)((f + f2) / 2.0f) / d, n3);
            }
            ++n8;
        }
    }
}

