/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.RTPMediaThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;

public class PacketForwarder
implements Runnable {
    PacketSource source;
    PacketConsumer consumer;
    RTPMediaThread thread;
    boolean closed = false;
    private boolean paused;
    public IOException exception;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public PacketForwarder(PacketSource s, PacketConsumer c2) {
        this.source = s;
        this.consumer = c2;
        this.closed = false;
        this.exception = null;
    }

    public void startPF() {
        this.startPF(null);
    }

    public void startPF(String threadname) {
        if (this.thread != null) {
            throw new IllegalArgumentException("Called start more than once");
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        this.thread = threadname == null ? new RTPMediaThread(this) : new RTPMediaThread(this, threadname);
        this.thread.setDaemon(true);
        this.thread.useNetworkPriority();
        this.thread.start();
    }

    public void setVideoPriority() {
        this.thread.useVideoNetworkPriority();
    }

    public PacketSource getSource() {
        return this.source;
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public String getId() {
        if (this.thread == null) {
            System.err.println("the packetforwarders thread is null");
            return null;
        }
        return this.thread.getName();
    }

    public void run() {
        if (this.closed || this.exception != null) {
            if (this.source != null) {
                this.source.closeSource();
            }
            if (this.thread != null) {
                this.thread.stop();
            }
            return;
        }
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            Packet p2 = this.source.receiveFrom();
                            this.CheckForClose();
                            if (p2 != null) {
                                this.consumer.sendTo(p2);
                            }
                            this.CheckForClose();
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.CheckForClose();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e3) {
                this.CheckForClose();
                this.exception = e3;
                e3.printStackTrace();
                Object var2_5 = null;
                this.consumer.closeConsumer();
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.consumer.closeConsumer();
            throw throwable;
        }
    }

    private void CheckForClose() {
        if (this.closed && this.thread != null) {
            if (this.source != null) {
                this.source.closeSource();
            }
            this.thread.stop();
        }
    }

    public void close() {
        this.closed = true;
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

