/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.rtpraw;

import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import javax.media.DataSink;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;

public class Handler
implements DataSink {
    MediaLocator rtpmrl;
    SessionManager rtpmanager;
    PushBufferDataSource source;
    SendStream rtpsendstream;

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[1];
    }

    public Component getControlComponent() {
        return null;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("Only supports PushBufferDataSource");
        }
        this.source = (PushBufferDataSource)source;
        PushBufferStream[] streams = this.source.getStreams();
        int numStreams = streams.length;
        System.out.println("streams is " + streams + " : " + numStreams);
        if (streams == null || numStreams <= 0) {
            throw new IOException("source " + source + " doesn't have any streams");
        }
    }

    public void setOutputLocator(MediaLocator output) {
        if (this.rtpmrl != null) {
            throw new Error("setOutputLocator cannot be called more than once");
        }
        System.out.println("sink: setOutputLocator " + output);
        this.rtpmrl = output;
    }

    public MediaLocator getOutputLocator() {
        return this.rtpmrl;
    }

    public void start() throws IOException {
        this.rtpsendstream.start();
    }

    public void stop() throws IOException {
        this.rtpsendstream.stop();
    }

    public void open() throws IOException, SecurityException {
        if (this.rtpmrl == null) {
            throw new IOException("No Valid RTP MediaLocator");
        }
        try {
            RTPSocket sock = (RTPSocket)Manager.createDataSource(this.rtpmrl);
            this.rtpmanager = new RTPSessionMgr(sock);
            this.rtpsendstream = this.rtpmanager.createSendStream(this.source, 0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new IOException(e2.getMessage());
        }
    }

    public void close() {
        if (this.rtpmanager != null) {
            this.rtpmanager.closeSession("DataSink closed");
        }
    }

    public String getContentType() {
        return "RTP";
    }
}

