/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.audio.midi;

import com.sun.media.BasicController;
import com.sun.media.BasicPlayer;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.IncompatibleSourceException;
import javax.media.StopByRequestEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.sound.midi.InvalidMidiDataException;
import javax.media.sound.midi.MetaEvent;
import javax.media.sound.midi.MetaEventListener;
import javax.media.sound.midi.MidiSystem;
import javax.media.sound.midi.MidiUnavailableException;
import javax.media.sound.midi.Sequence;
import javax.media.sound.midi.Sequencer;

public class Handler
extends BasicPlayer {
    private MidiController controller = new MidiController();
    protected DataSource datasource;
    private boolean closed = false;

    public Handler() {
        this.manageController(this.controller);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.controller.setSource(source);
    }

    protected boolean audioEnabled() {
        return true;
    }

    protected boolean videoEnabled() {
        return false;
    }

    protected TimeBase getMasterTimeBase() {
        return this.controller.getMasterTimeBase();
    }

    public void updateStats() {
    }

    class MidiController
    extends BasicController
    implements MetaEventListener {
        private MidiParser midiParser;
        private Track track;
        private Buffer buffer = new Buffer();
        private PullSourceStream stream;
        private Sequencer sequencer;
        private Sequence sequence;
        private byte[] mididata;
        private MidiFileInputStream is;
        private Time duration = Duration.DURATION_UNKNOWN;

        protected boolean isConfigurable() {
            return false;
        }

        public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
            this.midiParser = new MidiParser();
            this.midiParser.setSource(source);
            Handler.this.datasource = source;
        }

        protected TimeBase getMasterTimeBase() {
            return new SystemTimeBase();
        }

        protected boolean doRealize() {
            int bufferSize;
            long maxLocation;
            if (Handler.this.datasource == null) {
                return false;
            }
            try {
                Handler.this.datasource.start();
            }
            catch (IOException iOException) {
                return false;
            }
            this.stream = this.midiParser.getStream();
            long contentLength = this.stream.getContentLength();
            long minLocation = 0L;
            minLocation = 0L;
            if (contentLength != -1L) {
                maxLocation = contentLength;
                bufferSize = (int)contentLength;
            } else {
                maxLocation = Long.MAX_VALUE;
                bufferSize = (int)maxLocation;
            }
            int numBuffers = 1;
            this.track = new BasicTrack(this.midiParser, null, true, Duration.DURATION_UNKNOWN, new Time(0L), numBuffers, bufferSize, this.stream, minLocation, maxLocation);
            return true;
        }

        protected boolean doPrefetch() {
            if (this.track == null) {
                return false;
            }
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer(null);
                if (this.sequencer == null) {
                    return false;
                }
                this.sequencer.addMetaEventListener((MetaEventListener)this);
            }
            if (this.buffer.getLength() == 0) {
                this.track.readFrame(this.buffer);
                if (this.buffer.isDiscard() || this.buffer.isEOM()) {
                    this.buffer.setLength(0);
                    return false;
                }
                this.mididata = (byte[])this.buffer.getData();
                this.is = new MidiFileInputStream(this.mididata, this.buffer.getLength());
            }
            MidiController midiController = this;
            synchronized (midiController) {
                if (this.is != null) {
                    try {
                        this.is.rewind();
                    }
                    catch (Exception exception) {}
                } else {
                    boolean bl = false;
                    Object var3_7 = null;
                    return bl;
                }
            }
            try {
                this.sequencer.open();
            }
            catch (MidiUnavailableException e2) {
                System.err.println("Cannot open sequencer " + (Object)((Object)e2));
                return false;
            }
            catch (Exception e3) {
                System.err.println("Cannot open sequencer " + e3);
                return false;
            }
            try {
                this.sequencer.setSequence((InputStream)new BufferedInputStream(this.is));
            }
            catch (InvalidMidiDataException e4) {
                System.err.println("Invalid Midi Data " + (Object)((Object)e4));
                this.sequencer.close();
                return false;
            }
            catch (Exception e5) {
                System.err.println("Error setting sequence " + e5);
                this.sequencer.close();
                return false;
            }
            return true;
        }

        protected void abortRealize() {
        }

        protected void abortPrefetch() {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }

        protected void doStart() {
            if (this.sequencer == null) {
                return;
            }
            if (!this.sequencer.isOpen()) {
                return;
            }
            this.sequencer.start();
        }

        protected void doStop() {
            if (this.sequencer == null) {
                return;
            }
            this.sequencer.stop();
            this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }

        protected void doDeallocate() {
            if (this.sequencer == null) {
                return;
            }
            MidiController midiController = this;
            synchronized (midiController) {
                try {
                    this.sequencer.close();
                }
                catch (Exception e2) {
                    System.err.println("deallocate: " + e2);
                }
            }
        }

        protected void doClose() {
            if (Handler.this.closed) {
                return;
            }
            this.doDeallocate();
            if (Handler.this.datasource != null) {
                Handler.this.datasource.disconnect();
            }
            Handler.this.datasource = null;
            Handler.this.closed = true;
        }

        protected float doSetRate(float factor) {
            if (this.sequencer != null) {
                this.sequencer.setTempoFactor(factor);
                return this.sequencer.getTempoFactor();
            }
            return 1.0f;
        }

        protected void doSetMediaTime(Time when) {
            if (when != null && this.sequencer != null) {
                this.sequencer.setMicroseconds(when.getNanoseconds() / 1000L);
            }
        }

        public void meta(MetaEvent me) {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.stopControllerOnly();
                this.sequencer.stop();
                if (this.duration == Duration.DURATION_UNKNOWN) {
                    this.duration = this.getMediaTime();
                    this.sendEvent(new DurationUpdateEvent(this, this.duration));
                }
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
        }

        public Time getDuration() {
            return this.duration;
        }

        MidiController() {
            Handler.this = Handler.this;
        }
    }

    class MidiParser
    extends BasicPullParser {
        public ContentDescriptor[] getSupportedInputContentDescriptors() {
            return null;
        }

        public PullSourceStream getStream() {
            PullSourceStream stream = (PullSourceStream)this.streams[0];
            return stream;
        }

        public Track[] getTracks() throws IOException, BadHeaderException {
            return null;
        }

        public Time setPosition(Time where, int rounding) {
            return null;
        }

        public Time getMediaTime() {
            return null;
        }

        public Time getDuration() {
            return null;
        }

        public String getName() {
            return "Parser for MIDI file format";
        }

        MidiParser() {
            Handler.this = Handler.this;
        }
    }

    class MidiFileInputStream
    extends InputStream {
        private int length;
        private int index;
        private byte[] data;
        private int markpos;

        MidiFileInputStream(byte[] data, int length) {
            Handler.this = Handler.this;
            this.data = data;
            this.length = length;
        }

        public void rewind() {
            this.index = 0;
            this.markpos = 0;
        }

        public int read() throws IOException {
            if (this.index >= this.length) {
                return -1;
            }
            return this.data[this.index++];
        }

        public int available() throws IOException {
            return this.length - this.index;
        }

        public int read(byte[] b2) throws IOException {
            return this.read(b2, 0, b2.length);
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            if (len > this.available()) {
                len = this.available();
            }
            if (len == 0) {
                return -1;
            }
            System.arraycopy(this.data, this.index, b2, off, len);
            this.index += len;
            return len;
        }
    }
}

