/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicClock;
import com.sun.media.BasicController;
import com.sun.media.BasicFilterModule;
import com.sun.media.BasicJMD;
import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicPlayer;
import com.sun.media.BasicPlugIn;
import com.sun.media.BasicRendererModule;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicSourceModule;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Module;
import com.sun.media.ModuleListener;
import com.sun.media.OutputConnector;
import com.sun.media.StateTransistor;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FramePositioningAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.ProgressControlAdapter;
import com.sun.media.controls.StringControl;
import com.sun.media.controls.StringControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.util.JMFI18N;
import java.awt.Component;
import java.awt.Dimension;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Controller;
import javax.media.Demultiplexer;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;

public class MediaEngine
extends BasicController
implements ModuleListener {
    protected BasicPlayer player;
    protected DataSource dsource;
    protected Vector modules;
    protected Vector filters;
    protected Vector sinks;
    protected Vector waitPrefetched;
    protected Vector waitEnded;
    protected Vector waitResetted;
    protected BasicSinkModule masterSink;
    protected BasicSourceModule source;
    protected BasicMuxModule muxModule;
    protected SlaveClock slaveClock;
    protected ContentDescriptor outputContentDes;
    private boolean internalErrorOccurred = false;
    private boolean prefetched = false;
    private boolean started = false;
    private boolean dataPathBlocked = false;
    private boolean useMoreRenderBuffer = false;
    private boolean deallocated = false;
    private Time timeBeforeAbortPrefetch;
    private float rate = 1.0f;
    private BitRateControl bitRateControl;
    private FrameRateControl frameRateControl;
    private FramePositioningControl framePositioningControl;
    private long latency;
    static final boolean DEBUG = true;
    private JMD jmd;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected TControl[] trackControls = new TControl[0];
    protected ProgressControl progressControl;
    static boolean LOG;
    protected static DataOutputStream log;
    private int indent;
    private long prefetchTime;
    static String NOT_CONFIGURED_ERROR;
    long markedDataStartTime;
    boolean reportOnce = false;
    long lastBitRate;
    long lastStatsTime;
    static boolean USE_MASTER;
    static boolean USE_BACKUP;
    static final String realizeErr = "Cannot get CodecControl before reaching the realized state.";
    static final String connectErr = "Cannot set a PlugIn before reaching the configured state.";
    static int ARRAY_INC;
    static /* synthetic */ Class class$javax$media$Codec;
    static /* synthetic */ Class class$javax$media$Renderer;
    static /* synthetic */ Class class$javax$media$Multiplexer;
    static /* synthetic */ Class class$javax$media$PlugIn;

    public MediaEngine(BasicPlayer p2) {
        long initTime = System.currentTimeMillis();
        this.player = p2;
        this.createProgressControl();
        if (LOG && log == null) {
            LOG = false;
            if (securityPrivelege) {
                Object permission = null;
                try {
                    String file = String.valueOf(System.getProperty("user.dir")) + File.separator + "engine.log";
                    System.err.println("Open log file: " + file);
                    log = new DataOutputStream(new FileOutputStream(file));
                    if (log != null) {
                        LOG = true;
                    }
                }
                catch (Exception e2) {
                    securityPrivelege = false;
                }
            }
        }
        this.slaveClock = new SlaveClock();
        this.setClock(this.slaveClock);
        this.profile("instantiation", initTime);
    }

    protected boolean isConfigurable() {
        return true;
    }

    private void log(String str) {
        block3: {
            if (!LOG) break block3;
            try {
                int i2 = this.indent;
                while (i2 > 0) {
                    log.writeBytes("    ");
                    --i2;
                }
                log.writeBytes(String.valueOf(str) + "\n");
            }
            catch (IOException iOException) {}
        }
    }

    public void setSource(DataSource ds) throws IOException, IncompatibleSourceException {
        this.source = new BasicSourceModule(ds);
        if (this.jmd == null) {
            String jmdTitle = "PlugIn Viewer";
            if (ds != null && ds.getLocator() != null) {
                jmdTitle = ds.getLocator().toString();
                String protocol = ds.getLocator().getProtocol();
                if (protocol != null && ((protocol = protocol.toLowerCase()).equals("file") || protocol.equals("http") || protocol.equals("ftp"))) {
                    this.useMoreRenderBuffer = true;
                }
            }
            this.jmd = new BasicJMD(jmdTitle);
        }
        this.source.setJMD(this.jmd);
        this.source.setController(this);
        this.dsource = ds;
    }

    protected boolean doConfigure() {
        Track master;
        Track[] tracks;
        long parsingTime = System.currentTimeMillis();
        this.modules = new Vector();
        this.filters = new Vector();
        this.sinks = new Vector();
        this.waitPrefetched = new Vector();
        this.waitEnded = new Vector();
        this.waitResetted = new Vector();
        this.source.setModuleListener(this);
        this.source.setController(this);
        this.modules.addElement(this.source);
        if (!this.source.doRealize()) {
            return false;
        }
        if (this.isInterrupted()) {
            return false;
        }
        Demultiplexer parser = this.source.getDemultiplexer();
        if (parser == null) {
            return false;
        }
        try {
            tracks = parser.getTracks();
        }
        catch (Exception e2) {
            this.log("Cannot obtain tracks from parser: " + e2);
            return false;
        }
        if (this.isInterrupted()) {
            return false;
        }
        this.profile("parsing", parsingTime);
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new TControl[tracks.length];
        int i2 = 0;
        while (i2 < tracks.length) {
            this.trackControls[i2] = new TControl(this, tracks[i2], this.source.getOutputConnector(names[i2]));
            ++i2;
        }
        if (parser.isPositionable() && parser.isRandomAccess() && (master = FramePositioningAdapter.getMasterTrack(tracks)) != null) {
            this.framePositioningControl = new FramePositioningAdapter(this.player, master);
        }
        if (this.player instanceof Processor) {
            this.outputContentDes = new ContentDescriptor("raw");
        }
        return true;
    }

    protected synchronized boolean doRealize() {
        long realizeTime = System.currentTimeMillis();
        this.log("#### Building flow graph for: " + this.dsource.getLocator() + "\n");
        boolean atLeastOneTrack = false;
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled()) {
                this.indent = 0;
                this.log("## Building Track: " + i2);
                if (this.trackControls[i2].buildTrack()) {
                    atLeastOneTrack = true;
                    this.trackControls[i2].setEnabled(true);
                } else {
                    if (this.trackControls[i2].isCustomized()) {
                        return false;
                    }
                    this.trackControls[i2].setEnabled(false);
                }
                if (this.isInterrupted()) {
                    return false;
                }
                this.log("\n");
            }
            ++i2;
        }
        if (!atLeastOneTrack) {
            System.err.println("## Failed to build a flow graph for: ");
            int i3 = 0;
            while (i3 < this.trackControls.length) {
                System.err.println("        " + this.trackControls[i3].getOriginalFormat());
                ++i3;
            }
            return false;
        }
        if (!this.connectMultiplexer()) {
            return false;
        }
        if (!this.manageTimeBases()) {
            return false;
        }
        this.log("## Here's the completed flow graph:");
        this.traceGraph(this.source);
        this.log("\n");
        this.profile("graph building", realizeTime);
        realizeTime = System.currentTimeMillis();
        this.updateFormats();
        this.jmd.initGraph(this.source);
        this.profile("realize, post graph building", realizeTime);
        return true;
    }

    boolean connectMultiplexer() {
        if (this.outputContentDes == null) {
            return true;
        }
        Format[] tmp = new Format[this.trackControls.length];
        TControl[] tcs = new TControl[this.trackControls.length];
        int total = 0;
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled()) {
                tcs[total] = this.trackControls[i2];
                tmp[total++] = this.trackControls[i2].lastOC.getFormat();
            }
            ++i2;
        }
        Format[] fmts = new Format[total];
        System.arraycopy(tmp, 0, fmts, 0, total);
        this.log("## Connect to multplexer:");
        ++this.indent;
        this.log("Output content type: " + this.outputContentDes);
        this.log("Attempt to find a multiplexer.");
        Vector cnames = PlugInManager.getPlugInList(null, this.outputContentDes, 5);
        if (cnames == null || cnames.size() == 0) {
            this.log("No multiplexer is found for that content type.");
            --this.indent;
            return false;
        }
        int i3 = 0;
        while (i3 < cnames.size()) {
            block18: {
                this.log("Try multiplexer: " + cnames.elementAt(i3));
                Multiplexer m2 = (Multiplexer)MediaEngine.createPlugIn((String)cnames.elementAt(i3), 5);
                if (m2 != null) {
                    try {
                        m2.setContentDescriptor(this.outputContentDes);
                    }
                    catch (Exception exception) {
                        this.log("Failed to set the output content descriptor on the multiplexer.");
                        break block18;
                    }
                    boolean failed = false;
                    if (m2.setNumTracks(fmts.length) != fmts.length) {
                        this.log("Failed  to set number of tracks on the multiplexer.");
                    } else {
                        int mf = 0;
                        while (mf < fmts.length) {
                            if (m2.setInputFormat(fmts[mf], mf) == null) {
                                this.log("Failed to set input format on the multiplexer.");
                                failed = true;
                                break;
                            }
                            ++mf;
                        }
                        if (!failed) {
                            this.log("Found multiplexer: " + m2);
                            BasicMuxModule bmm = new BasicMuxModule(m2, fmts);
                            bmm.setJMD(this.jmd);
                            int j2 = 0;
                            while (j2 < fmts.length) {
                                InputConnector ic = bmm.getInputConnector(String.valueOf(BasicMuxModule.ConnectorNamePrefix) + j2);
                                if (ic == null) {
                                    this.log("BasicMuxModule: connector mismatched.");
                                } else {
                                    ic.setFormat(fmts[j2]);
                                    tcs[j2].lastOC.setProtocol(ic.getProtocol());
                                    tcs[j2].lastOC.connectTo(ic, fmts[j2]);
                                }
                                ++j2;
                            }
                            if (!bmm.doRealize()) {
                                this.log("Failed to open the multiplexer.");
                            } else {
                                bmm.setModuleListener(this);
                                bmm.setController(this);
                                this.modules.addElement(bmm);
                                this.sinks.addElement(bmm);
                                --this.indent;
                                this.log("\n");
                                this.muxModule = bmm;
                                return true;
                            }
                        }
                    }
                }
            }
            ++i3;
        }
        this.log("Failed to find a multiplexer for the specified output.");
        --this.indent;
        return false;
    }

    boolean manageTimeBases() {
        int i2;
        int size = this.sinks.size();
        this.masterSink = null;
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            this.masterSink = this.muxModule;
        } else {
            i2 = 0;
            while (i2 < this.trackControls.length) {
                if (this.trackControls[i2].isEnabled() && this.trackControls[i2].rendererModule != null && this.trackControls[i2].rendererModule.getClock() != null) {
                    this.masterSink = this.trackControls[i2].rendererModule;
                    break;
                }
                ++i2;
            }
        }
        if (this.masterSink != null) {
            this.slaveClock.setMaster(this.masterSink.getClock());
        } else {
            this.slaveClock.setMaster(null);
        }
        i2 = 0;
        while (i2 < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
            if (bsm != this.masterSink && !bsm.prefetchFailed()) {
                try {
                    bsm.setTimeBase(this.slaveClock.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    protected synchronized void abortConfigure() {
        if (this.source != null) {
            this.source.abortRealize();
        }
    }

    protected synchronized void abortRealize() {
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            StateTransistor m2 = (StateTransistor)this.modules.elementAt(i2);
            m2.abortRealize();
            ++i2;
        }
    }

    protected synchronized void doFailedRealize() {
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            StateTransistor m2 = (StateTransistor)this.modules.elementAt(i2);
            m2.doFailedRealize();
            ++i2;
        }
        super.doFailedRealize();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched || this.dataPathBlocked) {
            return true;
        }
        if (this.timeBeforeAbortPrefetch != null) {
            this.doSetMediaTime(this.timeBeforeAbortPrefetch);
            this.timeBeforeAbortPrefetch = null;
        }
        this.prefetchTime = System.currentTimeMillis();
        this.resetPrefetchedList();
        if (!this.source.doPrefetch()) {
            return false;
        }
        boolean atLeastOneTrack = false;
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            boolean usedToFailed = this.trackControls[i2].prefetchFailed;
            if (!usedToFailed || this.deallocated) {
                if (this.trackControls[i2].prefetchTrack()) {
                    atLeastOneTrack = true;
                    if (usedToFailed && !this.manageTimeBases()) {
                        return false;
                    }
                } else if (this.trackControls[i2].isTimeBase() && !this.manageTimeBases()) {
                    return false;
                }
            }
            ++i2;
        }
        if (!atLeastOneTrack) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            return false;
        }
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.source.doStart();
            try {
                if (!this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.wait(3000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.deallocated = false;
        return true;
    }

    protected synchronized void abortPrefetch() {
        this.timeBeforeAbortPrefetch = this.getMediaTime();
        this.reset();
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            StateTransistor m2 = (StateTransistor)this.modules.elementAt(i2);
            m2.abortPrefetch();
            ++i2;
        }
        this.deallocated = true;
    }

    protected synchronized void doFailedPrefetch() {
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            StateTransistor m2 = (StateTransistor)this.modules.elementAt(i2);
            m2.doFailedPrefetch();
            ++i2;
        }
        super.doFailedPrefetch();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.resetPrefetchedList();
        this.resetEndedList();
        this.source.doStart();
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled()) {
                this.trackControls[i2].startTrack();
            }
            ++i2;
        }
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.started = true;
    }

    public synchronized void stop() {
        super.stop();
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.resetPrefetchedList();
        this.source.doStop();
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled()) {
                this.trackControls[i2].stopTrack();
            }
            ++i2;
        }
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.started = false;
    }

    protected void doDeallocate() {
    }

    protected synchronized void doClose() {
        if (this.modules == null) {
            if (this.source != null) {
                this.source.doClose();
            }
            return;
        }
        if (this.getState() == 600) {
            this.stop();
        }
        if (this.getState() == 500) {
            this.reset();
        }
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            StateTransistor m2 = (StateTransistor)this.modules.elementAt(i2);
            m2.doClose();
            ++i2;
        }
    }

    public synchronized void setMediaTime(Time when) {
        if (this.state < 300) {
            throw new NotRealizedError("Cannot set media time on a unrealized controller");
        }
        if (when.getNanoseconds() == this.getMediaNanoseconds()) {
            return;
        }
        this.reset();
        this.timeBeforeAbortPrefetch = null;
        this.doSetMediaTime(when);
        this.doPrefetch();
        this.sendEvent(new MediaTimeSetEvent(this, this.getMediaTime()));
    }

    protected void doSetMediaTime(Time when) {
        this.slaveClock.setMediaTime(when);
        Time t = this.source.setPosition(when, 0);
        if (t == null) {
            t = when;
        }
        int size = this.sinks.size();
        int i2 = 0;
        while (i2 < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
            bsm.doSetMediaTime(when);
            if (t.getNanoseconds() < when.getNanoseconds()) {
                bsm.setPreroll(t);
            } else {
                bsm.resetPreroll();
            }
            ++i2;
        }
    }

    public synchronized float doSetRate(float r2) {
        if (r2 <= 0.0f) {
            r2 = 1.0f;
        }
        if (r2 == this.rate) {
            return r2;
        }
        r2 = this.masterSink == null ? this.getClock().setRate(r2) : this.masterSink.doSetRate(r2);
        int size = this.modules.size();
        int i2 = 0;
        while (i2 < size) {
            BasicModule m2 = (BasicModule)this.modules.elementAt(i2);
            if (m2 != this.masterSink) {
                m2.doSetRate(r2);
            }
            ++i2;
        }
        this.reset();
        this.doSetMediaTime(this.getMediaTime());
        this.rate = r2;
        return r2;
    }

    protected synchronized void reset() {
        if (this.getState() == 600) {
            System.err.println("reset cannot be called on the started engine.");
            throw new RuntimeException();
        }
        if (this.dataPathBlocked) {
            return;
        }
        Vector vector = this.waitResetted;
        synchronized (vector) {
            BasicSinkModule bsm;
            this.resetResettedList();
            int size = this.modules.size();
            int i2 = size - 1;
            while (i2 >= 0) {
                BasicModule m2 = (BasicModule)this.modules.elementAt(i2);
                if (!m2.prefetchFailed()) {
                    m2.reset();
                }
                --i2;
            }
            size = this.sinks.size();
            int i3 = 0;
            while (i3 < size) {
                bsm = (BasicSinkModule)this.sinks.elementAt(i3);
                if (!bsm.prefetchFailed()) {
                    bsm.triggerReset();
                }
                ++i3;
            }
            if (!this.waitResetted.isEmpty()) {
                try {
                    this.waitResetted.wait(3000L);
                }
                catch (Exception exception) {}
            }
            size = this.sinks.size();
            int i4 = 0;
            while (i4 < size) {
                bsm = (BasicSinkModule)this.sinks.elementAt(i4);
                if (!bsm.prefetchFailed()) {
                    bsm.doneReset();
                }
                ++i4;
            }
        }
        this.prefetched = false;
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        if (this.getState() < 180) {
            throw new NotConfiguredError("getSupportedContentDescriptors " + NOT_CONFIGURED_ERROR);
        }
        Vector names = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> fmts = new Vector<Format>();
        int i2 = 0;
        while (i2 < names.size()) {
            Format[] fs = PlugInManager.getSupportedOutputFormats((String)names.elementAt(i2), 5);
            if (fs != null) {
                int j2 = 0;
                while (j2 < fs.length) {
                    if (fs[j2] instanceof ContentDescriptor) {
                        boolean duplicate = false;
                        int k2 = 0;
                        while (k2 < fmts.size()) {
                            if (fmts.elementAt(k2).equals(fs[j2])) {
                                duplicate = true;
                                break;
                            }
                            ++k2;
                        }
                        if (!duplicate) {
                            fmts.addElement(fs[j2]);
                        }
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        ContentDescriptor[] cds = new ContentDescriptor[fmts.size()];
        i2 = 0;
        while (i2 < fmts.size()) {
            cds[i2] = (ContentDescriptor)fmts.elementAt(i2);
            ++i2;
        }
        return cds;
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        Vector cnames;
        if (this.getState() < 180) {
            throw new NotConfiguredError("setContentDescriptor " + NOT_CONFIGURED_ERROR);
        }
        if (this.getState() > 180) {
            return null;
        }
        if (ocd != null && ((cnames = PlugInManager.getPlugInList(null, ocd, 5)) == null || cnames.size() == 0)) {
            return null;
        }
        this.outputContentDes = ocd;
        return this.outputContentDes;
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            throw new NotConfiguredError("getContentDescriptor " + NOT_CONFIGURED_ERROR);
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            throw new NotRealizedError("getDataOutput " + NOT_CONFIGURED_ERROR);
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    private void resetPrefetchedList() {
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.waitPrefetched.removeAllElements();
            int size = this.sinks.size();
            int i2 = 0;
            while (i2 < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
                if (!bsm.prefetchFailed()) {
                    this.waitPrefetched.addElement(bsm);
                }
                ++i2;
            }
            this.waitPrefetched.notifyAll();
        }
    }

    private void resetEndedList() {
        Vector vector = this.waitEnded;
        synchronized (vector) {
            this.waitEnded.removeAllElements();
            int size = this.sinks.size();
            int i2 = 0;
            while (i2 < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
                if (!bsm.prefetchFailed()) {
                    this.waitEnded.addElement(bsm);
                }
                ++i2;
            }
            this.waitEnded.notifyAll();
        }
    }

    private void resetResettedList() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            this.waitResetted.removeAllElements();
            int size = this.sinks.size();
            int i2 = 0;
            while (i2 < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
                if (!bsm.prefetchFailed()) {
                    this.waitResetted.addElement(bsm);
                }
                ++i2;
            }
            this.waitResetted.notifyAll();
        }
    }

    public void bufferPrefetched(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                if (this.waitPrefetched.contains(src)) {
                    this.waitPrefetched.removeElement(src);
                }
                if (this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.notifyAll();
                    this.profile("prefetch", this.prefetchTime);
                    if (this.getState() != 600 && this.getTargetState() != 600) {
                        this.source.pause();
                    }
                    this.prefetched = true;
                }
            }
        }
    }

    public void mediaEnded(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitEnded;
            synchronized (vector) {
                if (this.waitEnded.contains(src)) {
                    this.waitEnded.removeElement(src);
                }
                if (this.waitEnded.isEmpty()) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (src == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    public void resetted(Module src) {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            if (this.waitResetted.contains(src)) {
                this.waitResetted.removeElement(src);
            }
            if (this.waitResetted.isEmpty()) {
                this.waitResetted.notifyAll();
            }
        }
    }

    public void dataBlocked(Module src, boolean blocked) {
        this.dataPathBlocked = blocked;
        if (blocked) {
            this.resetPrefetchedList();
            this.resetResettedList();
            this.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        } else {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
    }

    public void framesBehind(Module src, float frames) {
        if (!(src instanceof BasicSinkModule)) {
            return;
        }
        InputConnector ic = src.getInputConnector(null);
        while (ic != null) {
            OutputConnector oc = ic.getOutputConnector();
            if (oc == null || (src = oc.getModule()) == null || !(src instanceof BasicFilterModule)) break;
            BasicFilterModule bfm = (BasicFilterModule)src;
            bfm.setFramesBehind(frames);
            ic = src.getInputConnector(null);
        }
    }

    public void markedDataArrived(Module src, Buffer buffer) {
        if (src instanceof BasicSourceModule) {
            this.markedDataStartTime = this.getMediaNanoseconds();
        } else {
            long t = this.getMediaNanoseconds() - this.markedDataStartTime;
            if (t > 0L && t < 1000000000L) {
                if (!this.reportOnce) {
                    this.log("#### Computed latency for video: " + t + " ns\n");
                    this.reportOnce = true;
                }
                this.latency = (t + this.latency) / 2L;
            }
        }
    }

    public void formatChanged(Module src, Format oldFormat, Format newFormat) {
        System.err.println(String.valueOf(src) + ": input format changed: " + newFormat);
        if (src instanceof BasicRendererModule && oldFormat instanceof VideoFormat && newFormat instanceof VideoFormat) {
            Dimension s1 = ((VideoFormat)oldFormat).getSize();
            Dimension s2 = ((VideoFormat)newFormat).getSize();
            if (!(s2 == null || s1 != null && s1.equals(s2))) {
                this.sendEvent(new SizeChangeEvent(this, s2.width, s2.height, 1.0f));
            }
        }
    }

    public void formatChangedFailure(Module src, Format oldFormat, Format newFormat) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + ": failed to handle a data format change!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public void internalErrorOccurred(Module src) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + " failed!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public boolean audioEnabled() {
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled() && this.trackControls[i2].getOriginalFormat() instanceof AudioFormat) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean videoEnabled() {
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            if (this.trackControls[i2].isEnabled() && this.trackControls[i2].getOriginalFormat() instanceof VideoFormat) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Control[] getControls() {
        Vector<Object> cv = new Vector<Object>();
        int size = this.modules == null ? 0 : this.modules.size();
        int otherSize = 0;
        int i2 = 0;
        while (i2 < size) {
            Module m2 = (Module)this.modules.elementAt(i2);
            Object[] cs = m2.getControls();
            if (cs != null) {
                int j2 = 0;
                while (j2 < cs.length) {
                    cv.addElement(cs[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        size = cv.size();
        if (this.videoEnabled() && this.frameRateControl == null) {
            this.frameRateControl = new 1(this, 0.0f, 0.0f, 30.0f, false);
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new 2(0, -1, -1, false);
        }
        if (this.frameRateControl != null) {
            ++otherSize;
        }
        if (this.bitRateControl != null) {
            ++otherSize;
        }
        if (this.framePositioningControl != null) {
            ++otherSize;
        }
        Control[] controls = new Control[size + ++otherSize + this.trackControls.length];
        i2 = 0;
        while (i2 < size) {
            controls[i2] = (Control)cv.elementAt(i2);
            ++i2;
        }
        if (this.bitRateControl != null) {
            controls[size++] = this.bitRateControl;
        }
        if (this.frameRateControl != null) {
            controls[size++] = this.frameRateControl;
        }
        if (this.framePositioningControl != null) {
            controls[size++] = this.framePositioningControl;
        }
        controls[size++] = this.jmd;
        i2 = 0;
        while (i2 < this.trackControls.length) {
            controls[size + i2] = this.trackControls[i2];
            ++i2;
        }
        return controls;
    }

    public GainControl getGainControl() {
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            throw new NotConfiguredError("getTrackControls cannot be called before configured");
        }
        return this.trackControls;
    }

    public Component getVisualComponent() {
        if (this.modules == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.modules.size()) {
            Component comp;
            BasicModule bm = (BasicModule)this.modules.elementAt(i2);
            PlugIn pi = this.getPlugIn(bm);
            if (pi instanceof VideoRenderer && (comp = ((VideoRenderer)pi).getComponent()) != null) {
                return comp;
            }
            ++i2;
        }
        return null;
    }

    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot get start latency from an unrealized controller");
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public long getLatency() {
        return this.latency;
    }

    public Time getDuration() {
        return this.source.getDuration();
    }

    public void setProgressControl(ProgressControl p2) {
        this.progressControl = p2;
    }

    public void createProgressControl() {
        StringControlAdapter frameRate = new StringControlAdapter();
        frameRate.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter bitRate = new StringControlAdapter();
        bitRate.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter videoProps = new StringControlAdapter();
        videoProps.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter audioProps = new StringControlAdapter();
        audioProps.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter audioCodec = new StringControlAdapter();
        audioCodec.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter videoCodec = new StringControlAdapter();
        videoCodec.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        this.progressControl = new ProgressControlAdapter(frameRate, bitRate, videoProps, audioProps, videoCodec, audioCodec);
    }

    public void updateFormats() {
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            this.trackControls[i2].updateFormat();
            ++i2;
        }
    }

    public void updateRates() {
        if (this.getState() < 300) {
            return;
        }
        long now = System.currentTimeMillis();
        long rate = now == this.lastStatsTime ? this.lastBitRate : (long)((double)this.source.getBitsRead() * 8.0 / (double)(now - this.lastStatsTime) * 1000.0);
        long avg = (this.lastBitRate + rate) / 2L;
        if (this.bitRateControl != null) {
            this.bitRateControl.setBitRate((int)avg);
        }
        this.lastBitRate = rate;
        this.lastStatsTime = now;
        this.source.resetBitsRead();
        int i2 = 0;
        while (i2 < this.trackControls.length) {
            this.trackControls[i2].updateRates(now);
            ++i2;
        }
        this.source.checkLatency();
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.getClock().setTimeBase(tb);
        int size = this.sinks.size();
        int i2 = 0;
        while (i2 < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i2);
            bsm.setTimeBase(tb);
            ++i2;
        }
    }

    public TimeBase getTimeBase() {
        return this.getClock().getTimeBase();
    }

    protected GraphNode buildTrackFromGraph(TControl tc, GraphNode node) {
        BasicModule src = null;
        BasicModule dst = null;
        InputConnector ic = null;
        OutputConnector oc = null;
        boolean lastNode = true;
        Vector used = new Vector(5);
        if (node.plugin == null) {
            return null;
        }
        ++this.indent;
        while (node != null && node.plugin != null) {
            src = this.createModule(node, used);
            if (src == null) {
                this.log("Internal error: buildTrackFromGraph");
                break;
            }
            if (lastNode) {
                if (src instanceof BasicRendererModule) {
                    tc.rendererModule = (BasicRendererModule)src;
                    if (this.useMoreRenderBuffer && tc.rendererModule.getRenderer() instanceof AudioRenderer) {
                        this.setRenderBufferSize(tc.rendererModule.getRenderer());
                    }
                } else if (src instanceof BasicFilterModule) {
                    tc.lastOC = src.getOutputConnector(null);
                    tc.lastOC.setFormat(node.output);
                }
                lastNode = false;
            }
            ic = src.getInputConnector(null);
            ic.setFormat(node.input);
            if (dst != null) {
                oc = src.getOutputConnector(null);
                ic = dst.getInputConnector(null);
                oc.setFormat(ic.getFormat());
            }
            if (!src.doRealize()) {
                this.log("Failed to open plugin: " + node.plugin);
                this.log("  with input: " + node.input);
                --this.indent;
                node.failed = true;
                return node;
            }
            if (oc != null && ic != null) {
                this.connectModules(oc, ic, dst);
            }
            dst = src;
            node = node.prev;
        }
        dst = src;
        do {
            dst.setModuleListener(this);
            dst.setController(this);
            this.modules.addElement(dst);
            tc.modules.addElement(dst);
            if (dst instanceof BasicFilterModule) {
                this.filters.addElement(dst);
                continue;
            }
            if (!(dst instanceof BasicSinkModule)) continue;
            this.sinks.addElement(dst);
        } while ((oc = dst.getOutputConnector(null)) != null && (ic = oc.getInputConnector()) != null && (dst = (BasicModule)ic.getModule()) != null);
        tc.firstOC.setFormat(tc.getOriginalFormat());
        ic = src.getInputConnector(null);
        ic.setFormat(tc.getOriginalFormat());
        this.connectModules(tc.firstOC, ic, src);
        --this.indent;
        return null;
    }

    protected void setRenderBufferSize(Renderer r2) {
        BufferControl bc = (BufferControl)r2.getControl("javax.media.control.BufferControl");
        if (bc != null) {
            bc.setBufferLength(1000L);
        }
    }

    protected BasicModule lastModule(BasicModule bm) {
        InputConnector ic;
        OutputConnector oc = bm.getOutputConnector(null);
        while (oc != null && (ic = oc.getInputConnector()) != null) {
            bm = (BasicModule)ic.getModule();
            oc = bm.getOutputConnector(null);
        }
        return bm;
    }

    protected BasicModule createModule(GraphNode n2, Vector used) {
        PlugIn p2;
        BasicModule m2 = null;
        if (n2.plugin == null) {
            return null;
        }
        if (used.contains(n2.plugin)) {
            if (n2.cname == null || (p2 = MediaEngine.createPlugIn(n2.cname, -1)) == null) {
                this.log("Failed to instantiate " + n2.cname);
                return null;
            }
        } else {
            p2 = n2.plugin;
            used.addElement(p2);
        }
        if (p2 instanceof Renderer) {
            m2 = new BasicRendererModule((Renderer)p2);
        } else if (p2 instanceof Codec) {
            m2 = new BasicFilterModule((Codec)p2);
        }
        if (m2 != null) {
            m2.setJMD(this.jmd);
        }
        return m2;
    }

    protected void connectModules(OutputConnector oc, InputConnector ic, BasicModule dst) {
        if (dst instanceof BasicRendererModule) {
            oc.setProtocol(ic.getProtocol());
        } else {
            ic.setProtocol(oc.getProtocol());
        }
        oc.connectTo(ic, ic.getFormat());
    }

    protected GraphNode getPlugInNode(String name, int type, Hashtable plugIns) {
        GraphNode gn = null;
        Object obj = null;
        boolean add = false;
        if (plugIns == null || (gn = (GraphNode)plugIns.get(name)) == null) {
            PlugIn p2 = MediaEngine.createPlugIn(name, type);
            gn = new GraphNode(name, p2, null, null, 0);
            if (plugIns != null) {
                plugIns.put(name, gn);
            }
            if (p2 == null) {
                gn.failed = true;
                return null;
            }
            return gn;
        }
        if (gn.failed) {
            return null;
        }
        if (MediaEngine.verifyClass(gn.plugin, type)) {
            return gn;
        }
        return null;
    }

    public static Codec findCodec(Format in, Format out, Format[] selectedIn, Format[] selectedOut) {
        Vector cnames = PlugInManager.getPlugInList(in, out, 2);
        if (cnames == null) {
            return null;
        }
        Codec c2 = null;
        int i2 = 0;
        while (i2 < cnames.size()) {
            block9: {
                Format[] fmts;
                Format matched;
                c2 = (Codec)MediaEngine.createPlugIn((String)cnames.elementAt(i2), 2);
                if (c2 == null || (matched = MediaEngine.matches(in, fmts = c2.getSupportedInputFormats(), null, (PlugIn)c2)) == null) break block9;
                if (selectedIn != null && selectedIn.length > 0) {
                    selectedIn[0] = matched;
                }
                if ((fmts = c2.getSupportedOutputFormats(matched)) == null || fmts.length == 0) break block9;
                boolean success = false;
                int j2 = 0;
                while (j2 < fmts.length) {
                    block12: {
                        block11: {
                            block10: {
                                if (out == null) break block10;
                                if (out.matches(fmts[j2]) && (matched = out.intersects(fmts[j2])) != null) break block11;
                                break block12;
                            }
                            matched = fmts[j2];
                        }
                        if (c2.setOutputFormat(matched) != null) {
                            success = true;
                            break;
                        }
                    }
                    ++j2;
                }
                if (success) {
                    try {
                        c2.open();
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {}
                    if (selectedOut != null && selectedOut.length > 0) {
                        selectedOut[0] = matched;
                    }
                    return c2;
                }
            }
            ++i2;
        }
        return null;
    }

    public static Renderer findRenderer(Format in) {
        Vector names = PlugInManager.getPlugInList(in, null, 4);
        if (names == null) {
            return null;
        }
        Renderer r2 = null;
        int i2 = 0;
        while (i2 < names.size()) {
            Format[] fmts;
            Format matched;
            r2 = (Renderer)MediaEngine.createPlugIn((String)names.elementAt(i2), 4);
            if (r2 != null && (matched = MediaEngine.matches(in, fmts = r2.getSupportedInputFormats(), null, (PlugIn)r2)) != null) {
                try {
                    r2.open();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {}
                return r2;
            }
            ++i2;
        }
        return null;
    }

    public static PlugIn createPlugIn(String name, int type) {
        Object obj;
        try {
            Class cls = BasicPlugIn.getClassForName(name);
            obj = cls.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (MediaEngine.verifyClass(obj, type)) {
            return (PlugIn)obj;
        }
        return null;
    }

    public static boolean verifyClass(Object obj, int type) {
        Class cls;
        switch (type) {
            case 2: {
                cls = class$javax$media$Codec != null ? class$javax$media$Codec : (class$javax$media$Codec = BasicController.class$("javax.media.Codec"));
                break;
            }
            case 4: {
                cls = class$javax$media$Renderer != null ? class$javax$media$Renderer : (class$javax$media$Renderer = BasicController.class$("javax.media.Renderer"));
                break;
            }
            case 5: {
                cls = class$javax$media$Multiplexer != null ? class$javax$media$Multiplexer : (class$javax$media$Multiplexer = BasicController.class$("javax.media.Multiplexer"));
                break;
            }
            default: {
                Class clazz = cls = class$javax$media$PlugIn != null ? class$javax$media$PlugIn : (class$javax$media$PlugIn = BasicController.class$("javax.media.PlugIn"));
            }
        }
        return cls.isInstance(obj);
    }

    public static Format matches(Format[] outs, Format[] ins, PlugIn up, PlugIn down) {
        if (outs == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < outs.length) {
            Format fmt = MediaEngine.matches(outs[i2], ins, up, down);
            if (fmt != null) {
                return fmt;
            }
            ++i2;
        }
        return null;
    }

    public static Format matches(Format out, Format[] ins, PlugIn up, PlugIn down) {
        if (out == null || ins == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < ins.length) {
            Format fmt;
            if (ins[i2] != null && ins[i2].getClass().isAssignableFrom(out.getClass()) && out.matches(ins[i2]) && (fmt = out.intersects(ins[i2])) != null && (down == null || (fmt = MediaEngine.verifyInput(down, fmt)) != null)) {
                Format refined = fmt;
                if (!(up != null && (refined = MediaEngine.verifyOutput(up, fmt)) == null || down != null && refined != fmt && MediaEngine.verifyInput(down, refined) == null)) {
                    return refined;
                }
            }
            ++i2;
        }
        return null;
    }

    public static Format matches(Format[] outs, Format in, PlugIn up, PlugIn down) {
        Format[] ins = new Format[]{in};
        return MediaEngine.matches(outs, ins, up, down);
    }

    public static Format verifyInput(PlugIn p2, Format in) {
        if (p2 instanceof Codec) {
            return ((Codec)p2).setInputFormat(in);
        }
        if (p2 instanceof Renderer) {
            return ((Renderer)p2).setInputFormat(in);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn p2, Format out) {
        if (p2 instanceof Codec) {
            return ((Codec)p2).setOutputFormat(out);
        }
        return null;
    }

    void traceGraph(BasicModule source) {
        String[] names = source.getOutputConnectorNames();
        int i2 = 0;
        while (i2 < names.length) {
            Module m2;
            OutputConnector oc = source.getOutputConnector(names[i2]);
            InputConnector ic = oc.getInputConnector();
            if (ic != null && (m2 = ic.getModule()) != null) {
                this.log("  " + this.getPlugIn(source));
                this.log("     connects to: " + this.getPlugIn((BasicModule)m2));
                this.log("     format: " + oc.getFormat());
                if (ic.getProtocol() != oc.getProtocol()) {
                    this.log("     unmatched protocol: " + oc.getProtocol() + " & " + ic.getProtocol());
                } else {
                    this.log("     protocol: " + oc.getProtocol());
                }
                this.traceGraph((BasicModule)m2);
            }
            ++i2;
        }
    }

    protected PlugIn getPlugIn(BasicModule m2) {
        if (m2 instanceof BasicSourceModule) {
            return ((BasicSourceModule)m2).getDemultiplexer();
        }
        if (m2 instanceof BasicFilterModule) {
            return ((BasicFilterModule)m2).getCodec();
        }
        if (m2 instanceof BasicRendererModule) {
            return ((BasicRendererModule)m2).getRenderer();
        }
        if (m2 instanceof BasicMuxModule) {
            return ((BasicMuxModule)m2).getMultiplexer();
        }
        return null;
    }

    void profile(String msg, long time) {
        this.log("$$$$ Profile: " + msg + ": " + (System.currentTimeMillis() - time) + " ms\n");
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            if (jmfSecurity == null) {
                securityPrivelege = true;
            }
        }
        catch (SecurityException securityException) {}
        LOG = true;
        log = null;
        NOT_CONFIGURED_ERROR = "cannot be called before configured";
        USE_MASTER = true;
        ARRAY_INC = 30;
    }

    private final class 1
    extends FrameRateAdapter {
        public float setFrameRate(float rate) {
            this.value = rate;
            return this.value;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return MediaEngine.this;
        }

        /* synthetic */ 1(MediaEngine $0, float $1, float $2, float $3, boolean $4) {
            super($0, $1, $2, $3, $4);
        }
    }

    private final class 2
    extends BitRateAdapter {
        public int setBitRate(int rate) {
            this.value = rate;
            return this.value;
        }

        public Component getControlComponent() {
            return null;
        }

        /* synthetic */ 2(int $0, int $1, int $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    class SlaveClock
    implements Clock {
        Clock master;
        Clock current;
        BasicClock backup = new BasicClock();

        SlaveClock() {
            MediaEngine.this = MediaEngine.this;
            this.current = this.backup;
        }

        public void setMaster(Clock master) {
            block2: {
                this.master = master;
                Clock clock = this.current = master == null ? this.backup : master;
                if (master == null) break block2;
                try {
                    this.backup.setTimeBase(master.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {}
            }
        }

        public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setTimeBase(tb);
            }
        }

        public void syncStart(Time tbt) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.syncStart(tbt);
            }
        }

        public void stop() {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.stop();
            }
        }

        public void setStopTime(Time t) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setStopTime(t);
            }
        }

        public Time getStopTime() {
            return this.current.getStopTime();
        }

        public void setMediaTime(Time now) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setMediaTime(now);
            }
        }

        public Time getMediaTime() {
            return this.current.getMediaTime();
        }

        public long getMediaNanoseconds() {
            return this.current.getMediaNanoseconds();
        }

        public Time getSyncTime() {
            return this.current.getSyncTime();
        }

        public TimeBase getTimeBase() {
            return this.current.getTimeBase();
        }

        public Time mapToTimeBase(Time t) throws ClockStoppedException {
            return this.current.mapToTimeBase(t);
        }

        public float setRate(float factor) {
            return this.backup.setRate(factor);
        }

        public float getRate() {
            return this.current.getRate();
        }

        protected void reset(boolean useMaster) {
            if (this.master != null && useMaster) {
                this.current = this.master;
            } else {
                if (this.master != null) {
                    BasicClock basicClock = this.backup;
                    synchronized (basicClock) {
                        boolean started = false;
                        if (this.backup.getState() == 1) {
                            this.backup.stop();
                            started = true;
                        }
                        this.backup.setMediaTime(this.master.getMediaTime());
                        if (started) {
                            this.backup.syncStart(this.backup.getTimeBase().getTime());
                        }
                    }
                }
                this.current = this.backup;
            }
        }
    }

    class TControl
    implements TrackControl {
        MediaEngine engine;
        Track track;
        OutputConnector firstOC;
        OutputConnector lastOC;
        GraphBuilder gb;
        protected Format formatWanted;
        protected Codec[] codecChainWanted;
        protected Renderer rendererWanted;
        protected Vector modules = new Vector(7);
        protected BasicRendererModule rendererModule;
        protected Format[] supportedFormats;
        protected boolean prefetchFailed = false;
        long lastFrameRate;
        long lastStatsTime;

        public TControl(MediaEngine engine, Track track, OutputConnector oc) {
            MediaEngine.this = MediaEngine.this;
            this.engine = engine;
            this.track = track;
            this.firstOC = oc;
            this.lastOC = oc;
            this.setEnabled(track.isEnabled());
        }

        public Format getOriginalFormat() {
            return this.track.getFormat();
        }

        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null) {
                if (this.gb == null) {
                    this.gb = new GraphBuilder();
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
            }
            if (MediaEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(MediaEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        Format[] verifyMuxInputs(ContentDescriptor cd, Format[] inputs) {
            if (cd == null || cd.getEncoding() == "raw") {
                return inputs;
            }
            Vector cnames = PlugInManager.getPlugInList(null, cd, 5);
            if (cnames == null || cnames.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] mux = new Multiplexer[cnames.size()];
            int total = 0;
            int i2 = 0;
            while (i2 < cnames.size()) {
                block13: {
                    Multiplexer m2 = (Multiplexer)MediaEngine.createPlugIn((String)cnames.elementAt(i2), 5);
                    if (m2 != null) {
                        try {
                            m2.setContentDescriptor(MediaEngine.this.outputContentDes);
                        }
                        catch (Exception exception) {
                            break block13;
                        }
                        if (m2.setNumTracks(1) >= 1) {
                            mux[total++] = m2;
                        }
                    }
                }
                ++i2;
            }
            Format[] tmp = new Format[inputs.length];
            int vtotal = 0;
            int i3 = 0;
            while (i3 < inputs.length) {
                Format fmt;
                if (total == 1) {
                    fmt = mux[0].setInputFormat(inputs[i3], 0);
                    if (fmt != null) {
                        tmp[vtotal++] = fmt;
                    }
                } else {
                    int j2 = 0;
                    while (j2 < total) {
                        fmt = mux[j2].setInputFormat(inputs[i3], 0);
                        if (fmt != null) {
                            tmp[vtotal++] = fmt;
                            break;
                        }
                        ++j2;
                    }
                }
                ++i3;
            }
            Format[] verified = new Format[vtotal];
            System.arraycopy(tmp, 0, verified, 0, vtotal);
            return verified;
        }

        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format != null && !format.matches(this.track.getFormat())) {
                this.formatWanted = format;
            }
            return this.formatWanted;
        }

        public boolean buildTrack() {
            if (this.gb == null) {
                this.gb = new GraphBuilder();
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this);
            this.gb = null;
            return rtn;
        }

        public boolean prefetchTrack() {
            int j2 = 0;
            while (j2 < this.modules.size()) {
                BasicModule bm = (BasicModule)this.modules.elementAt(j2);
                if (!bm.doPrefetch()) {
                    this.setEnabled(false);
                    this.prefetchFailed = true;
                    return false;
                }
                ++j2;
            }
            if (this.prefetchFailed) {
                this.setEnabled(true);
                this.prefetchFailed = false;
            }
            return true;
        }

        public void startTrack() {
            int j2 = 0;
            while (j2 < this.modules.size()) {
                ((BasicModule)this.modules.elementAt(j2)).doStart();
                ++j2;
            }
        }

        public void stopTrack() {
            int j2 = 0;
            while (j2 < this.modules.size()) {
                ((BasicModule)this.modules.elementAt(j2)).doStop();
                ++j2;
            }
        }

        public boolean isTimeBase() {
            int j2 = 0;
            while (j2 < this.modules.size()) {
                if (this.modules.elementAt(j2) == MediaEngine.this.masterSink) {
                    return true;
                }
                ++j2;
            }
            return false;
        }

        public boolean isEnabled() {
            return this.track.isEnabled();
        }

        public void setEnabled(boolean enabled) {
            this.track.setEnabled(enabled);
        }

        public void setCodecChain(Codec[] codec) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                throw new NotConfiguredError(MediaEngine.connectErr);
            }
            if (codec.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codec.length];
            int i2 = 0;
            while (i2 < codec.length) {
                this.codecChainWanted[i2] = codec[i2];
                ++i2;
            }
        }

        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                throw new NotConfiguredError(MediaEngine.connectErr);
            }
            this.rendererWanted = renderer;
        }

        protected boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        public Object[] getControls() throws NotRealizedError {
            int i2;
            InputConnector ic;
            if (this.engine.getState() < 300) {
                throw new NotRealizedError(MediaEngine.realizeErr);
            }
            OutputConnector oc = this.firstOC;
            Object p2 = null;
            Vector<Object> cv = new Vector<Object>();
            while (oc != null && (ic = oc.getInputConnector()) != null) {
                Module m2 = ic.getModule();
                Object[] cs = m2.getControls();
                if (cs != null) {
                    i2 = 0;
                    while (i2 < cs.length) {
                        cv.addElement(cs[i2]);
                        ++i2;
                    }
                }
                oc = m2.getOutputConnector(null);
            }
            int size = cv.size();
            Object[] controls = new Control[size];
            i2 = 0;
            while (i2 < size) {
                controls[i2] = (Control)cv.elementAt(i2);
                ++i2;
            }
            return controls;
        }

        public Object getControl(String type) {
            Class cls;
            try {
                cls = BasicPlugIn.getClassForName(type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            Object[] cs = this.getControls();
            int i2 = 0;
            while (i2 < cs.length) {
                if (cls.isInstance(cs[i2])) {
                    return cs[i2];
                }
                ++i2;
            }
            return null;
        }

        public Component getControlComponent() {
            return null;
        }

        public void updateFormat() {
            StringControl sc;
            if (!this.track.isEnabled()) {
                return;
            }
            if (this.track.getFormat() instanceof AudioFormat) {
                String channel = "";
                AudioFormat afmt = (AudioFormat)this.track.getFormat();
                sc = MediaEngine.this.progressControl.getAudioCodec();
                sc.setValue(afmt.getEncoding());
                sc = MediaEngine.this.progressControl.getAudioProperties();
                channel = afmt.getChannels() == 1 ? JMFI18N.getResource("mediaengine.mono") : JMFI18N.getResource("mediaengine.stereo");
                sc.setValue(String.valueOf(afmt.getSampleRate() / 1000.0) + JMFI18N.getResource("mediaengine.khz") + ", " + afmt.getSampleSizeInBits() + JMFI18N.getResource("mediaengine.-bit") + ", " + channel);
            }
            if (this.track.getFormat() instanceof VideoFormat) {
                VideoFormat vfmt = (VideoFormat)this.track.getFormat();
                sc = MediaEngine.this.progressControl.getVideoCodec();
                sc.setValue(vfmt.getEncoding());
                sc = MediaEngine.this.progressControl.getVideoProperties();
                if (vfmt.getSize() != null) {
                    sc.setValue(String.valueOf(vfmt.getSize().width) + " X " + vfmt.getSize().height);
                }
            }
        }

        public void updateRates(long now) {
            if (!this.track.isEnabled() || !(this.track.getFormat() instanceof VideoFormat) || this.rendererModule == null) {
                return;
            }
            long rate = now == this.lastStatsTime ? this.lastFrameRate : (long)((double)this.rendererModule.getFramesPlayed() / (double)(now - this.lastStatsTime) * 1000.0);
            long avg = (this.lastFrameRate + rate) / 2L;
            if (MediaEngine.this.frameRateControl != null) {
                MediaEngine.this.frameRateControl.setFrameRate(avg);
            }
            this.lastFrameRate = rate;
            this.lastStatsTime = now;
            this.rendererModule.resetFramesPlayed();
        }
    }

    class GraphNode {
        Class clz;
        String cname;
        PlugIn plugin;
        Format input;
        Format output;
        Format[] supportedIns;
        Format[] supportedOuts;
        GraphNode prev;
        int level;
        boolean failed = false;
        boolean custom = false;
        int attemptedIdx;
        Format[] attempted;

        GraphNode(PlugIn plugin, Format input, GraphNode prev, int level) {
            this(plugin == null ? null : plugin.getClass().getName(), plugin, input, prev, level);
        }

        GraphNode(String cname, PlugIn plugin, Format input, GraphNode prev, int level) {
            MediaEngine.this = MediaEngine.this;
            this.cname = cname;
            this.plugin = plugin;
            this.input = input;
            this.prev = prev;
            this.level = level;
        }

        GraphNode(GraphNode gn, Format input, GraphNode prev, int level) {
            MediaEngine.this = MediaEngine.this;
            this.cname = gn.cname;
            this.plugin = gn.plugin;
            this.custom = gn.custom;
            this.input = input;
            this.prev = prev;
            this.level = level;
            this.supportedIns = gn.supportedIns;
            if (gn.input == input) {
                this.supportedOuts = gn.supportedOuts;
            }
        }

        Format[] getSupportedInputs() {
            if (this.supportedIns != null) {
                return this.supportedIns;
            }
            if (this.plugin == null) {
                return null;
            }
            if (this.plugin instanceof Codec) {
                this.supportedIns = ((Codec)this.plugin).getSupportedInputFormats();
            } else if (this.plugin instanceof Renderer) {
                this.supportedIns = ((Renderer)this.plugin).getSupportedInputFormats();
            }
            return this.supportedIns;
        }

        Format[] getSupportedOutputs(Format in) {
            if (in == this.input && this.supportedOuts != null) {
                return this.supportedOuts;
            }
            if (this.plugin == null) {
                return null;
            }
            if (this.plugin instanceof Renderer) {
                return null;
            }
            if (this.plugin instanceof Codec) {
                Format[] outs = ((Codec)this.plugin).getSupportedOutputFormats(in);
                if (this.input == in) {
                    this.supportedOuts = outs;
                }
                return outs;
            }
            return null;
        }

        public void resetAttempted() {
            this.attemptedIdx = 0;
            this.attempted = null;
        }

        boolean checkAttempted(Format input) {
            if (this.attempted == null) {
                this.attempted = new Format[ARRAY_INC];
                this.attempted[this.attemptedIdx++] = input;
                return false;
            }
            int j2 = 0;
            while (j2 < this.attemptedIdx) {
                if (input.equals(this.attempted[j2])) {
                    return true;
                }
                ++j2;
            }
            if (this.attemptedIdx >= this.attempted.length) {
                Format[] newarray = new Format[this.attempted.length + ARRAY_INC];
                System.arraycopy(this.attempted, 0, newarray, 0, this.attempted.length);
                this.attempted = newarray;
            }
            this.attempted[this.attemptedIdx++] = input;
            return false;
        }
    }

    class GraphBuilder {
        protected int STAGES = 4;
        protected Hashtable plugIns = new Hashtable(40);
        protected int nodesVisited;
        protected GraphNode[] targets;
        protected Vector targetNames;
        protected Format targetFormat;
        protected int targetType = -1;
        protected boolean ignoreContentDes = true;
        Codec[] codecs;
        Renderer rend;
        Format format;

        public void reset() {
            Enumeration enumeration = this.plugIns.elements();
            while (enumeration.hasMoreElements()) {
                GraphNode n2 = (GraphNode)enumeration.nextElement();
                n2.resetAttempted();
            }
        }

        public Format[] getSupportedOutputFormats(Format input) {
            long formatsTime = System.currentTimeMillis();
            Vector<Format> collected = new Vector<Format>();
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, input, null, 0);
            candidates.addElement(node);
            collected.addElement(input);
            ++this.nodesVisited;
            while (!candidates.isEmpty()) {
                this.doGetSupportedOutputFormats(candidates, collected);
            }
            Format[] all = new Format[collected.size()];
            int i2 = 0;
            while (i2 < all.length) {
                Object obj = collected.elementAt(i2);
                all[i2] = (Format)obj;
                ++i2;
            }
            MediaEngine.this.log("#### Getting the supported output formats for:");
            MediaEngine.this.log("    " + input);
            MediaEngine.this.log("    # of nodes visited: " + this.nodesVisited);
            MediaEngine.this.log("    # of formats supported: " + all.length + "\n");
            MediaEngine.this.profile("getSupportedOutputFormats", formatsTime);
            return all;
        }

        void doGetSupportedOutputFormats(Vector candidates, Vector collected) {
            Format input;
            Format[] outs;
            GraphNode node = (GraphNode)candidates.firstElement();
            candidates.removeElementAt(0);
            if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
                MediaEngine.this.log("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (node.plugin != null && MediaEngine.verifyInput(node.plugin, node.input) == null) {
                return;
            }
            if (node.plugin != null) {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return;
                }
                int j2 = 0;
                while (j2 < outs.length) {
                    int size = collected.size();
                    boolean found = false;
                    int k2 = 0;
                    while (k2 < size) {
                        Format other = (Format)collected.elementAt(k2);
                        if (other == outs[j2] || other.equals(outs[j2])) {
                            found = true;
                            break;
                        }
                        ++k2;
                    }
                    if (!found) {
                        collected.addElement(outs[j2]);
                    }
                    ++j2;
                }
                input = node.input;
            } else {
                outs = new Format[]{node.input};
                input = null;
            }
            if (node.level >= this.STAGES) {
                return;
            }
            int i2 = 0;
            while (i2 < outs.length) {
                Vector cnames;
                if (!(input != null && input.equals(outs[i2]) || node.plugin != null && MediaEngine.verifyOutput(node.plugin, outs[i2]) == null || (cnames = PlugInManager.getPlugInList(outs[i2], null, 2)) == null || cnames.size() == 0)) {
                    int j3 = 0;
                    while (j3 < cnames.size()) {
                        Format[] ins;
                        Format fmt;
                        GraphNode gn = MediaEngine.this.getPlugInNode((String)cnames.elementAt(j3), 2, this.plugIns);
                        if (gn != null && !gn.checkAttempted(outs[i2]) && (fmt = MediaEngine.matches(outs[i2], ins = gn.getSupportedInputs(), null, gn.plugin)) != null) {
                            GraphNode n2 = new GraphNode(gn, fmt, node, node.level + 1);
                            candidates.addElement(n2);
                            ++this.nodesVisited;
                        }
                        ++j3;
                    }
                }
                ++i2;
            }
        }

        boolean buildGraph(TControl tc) {
            if (tc.isCustomized()) {
                return this.buildCustomGraph(tc);
            }
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, tc.getOriginalFormat(), null, 0);
            MediaEngine.this.indent = 1;
            if (!this.useDefaultTargets(tc.getOriginalFormat())) {
                return false;
            }
            candidates.addElement(node);
            while ((node = this.buildGraph(candidates)) != null) {
                GraphNode failed = MediaEngine.this.buildTrackFromGraph(tc, node);
                if (failed == null) {
                    MediaEngine.this.indent = 0;
                    return true;
                }
                this.removeFailure(candidates, failed);
            }
            MediaEngine.this.indent = 0;
            return false;
        }

        GraphNode buildGraph(Format in) {
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, in, null, 0);
            MediaEngine.this.indent = 1;
            if (!this.useDefaultTargets(in)) {
                return null;
            }
            candidates.addElement(node);
            node = this.buildGraph(candidates);
            MediaEngine.this.indent = 0;
            return node;
        }

        GraphNode buildGraph(Vector candidates) {
            GraphNode node;
            while ((node = this.doBuildGraph(candidates)) == null) {
                if (candidates.isEmpty()) break;
            }
            return node;
        }

        GraphNode doBuildGraph(Vector candidates) {
            Format input;
            Format[] outs;
            if (candidates.isEmpty()) {
                return null;
            }
            GraphNode node = (GraphNode)candidates.firstElement();
            candidates.removeElementAt(0);
            if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
                MediaEngine.this.log("Internal error: doBuildGraph");
                return null;
            }
            int oldIndent = MediaEngine.this.indent;
            MediaEngine.this.indent = node.level + 1;
            MediaEngine.this.log("level: " + node.level);
            if (node.plugin != null) {
                if (MediaEngine.verifyInput(node.plugin, node.input) == null) {
                    return null;
                }
                MediaEngine.this.log("Build graph for plugin: " + node.plugin);
            } else {
                MediaEngine.this.log("Build graph for input: " + node.input);
            }
            GraphNode n2 = this.findTarget(node);
            if (n2 != null) {
                if (n2.plugin != null) {
                    MediaEngine.this.log("Found target: " + n2.plugin);
                } else {
                    MediaEngine.this.log("Found target: " + n2.cname);
                }
                MediaEngine.this.indent = oldIndent;
                return n2;
            }
            if (node.level >= this.STAGES) {
                MediaEngine.this.indent = oldIndent;
                return null;
            }
            if (node.plugin != null) {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    MediaEngine.this.log("Weird!  The given plugin does not support any output.");
                    MediaEngine.this.indent = oldIndent;
                    return null;
                }
                input = node.input;
            } else {
                outs = new Format[]{node.input};
                input = null;
            }
            boolean foundSomething = false;
            int i2 = 0;
            while (i2 < outs.length) {
                if (node.custom || input == null || !input.equals(outs[i2])) {
                    if (node.plugin != null && MediaEngine.verifyOutput(node.plugin, outs[i2]) == null) {
                        MediaEngine.this.log("Verify output failed: " + node.plugin);
                        MediaEngine.this.log("  with: " + outs[i2]);
                    } else {
                        Vector cnames = PlugInManager.getPlugInList(outs[i2], null, 2);
                        if (cnames != null && cnames.size() != 0) {
                            int j2 = 0;
                            while (j2 < cnames.size()) {
                                GraphNode gn = MediaEngine.this.getPlugInNode((String)cnames.elementAt(j2), 2, this.plugIns);
                                if (gn != null && !gn.checkAttempted(outs[i2])) {
                                    Format[] ins = gn.getSupportedInputs();
                                    Format fmt = MediaEngine.matches(outs[i2], ins, null, gn.plugin);
                                    if (fmt == null) {
                                        MediaEngine.this.log("Verify input failed: " + outs[i2]);
                                        MediaEngine.this.log("    : " + gn.plugin);
                                    } else {
                                        n2 = new GraphNode(gn, fmt, node, node.level + 1);
                                        candidates.addElement(n2);
                                        foundSomething = true;
                                    }
                                }
                                ++j2;
                            }
                        }
                    }
                }
                ++i2;
            }
            if (!foundSomething) {
                if (node.plugin == null) {
                    MediaEngine.this.log("No codec supports the given input.");
                } else {
                    MediaEngine.this.log("No codec supports the outputs from the given plugin.");
                }
            }
            MediaEngine.this.indent = oldIndent;
            return null;
        }

        GraphNode findTarget(GraphNode node) {
            GraphNode n2;
            Format[] outs;
            if (node.plugin == null) {
                outs = new Format[]{node.input};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    MediaEngine.this.log("Weird!  The given plugin does not support any output.");
                    return null;
                }
            }
            if (this.targetFormat != null && MediaEngine.matches(outs, this.targetFormat, node.plugin, null) == null) {
                return null;
            }
            if (!this.ignoreContentDes && MediaEngine.this.outputContentDes != null && (n2 = this.verifyMultiplexer(node, outs)) != null) {
                return n2;
            }
            n2 = this.verifyTargets(node, outs);
            if (n2 != null) {
                return n2;
            }
            return null;
        }

        GraphNode verifyMultiplexer(GraphNode node, Format[] outs) {
            boolean done = false;
            int i2 = 0;
            while (i2 < outs.length) {
                if (node.plugin == null || MediaEngine.verifyOutput(node.plugin, outs[i2]) != null) {
                    if (this.targetFormat != null) {
                        if (this.targetFormat.getClass().isAssignableFrom(outs[i2].getClass()) && outs[i2].matches(this.targetFormat)) {
                            node.output = outs[i2];
                            done = true;
                            break;
                        }
                    } else {
                        node.output = outs[i2];
                        done = true;
                        break;
                    }
                }
                ++i2;
            }
            if (!done) {
                MediaEngine.this.log("Weird!  The given plugin does not support any output.");
                return null;
            }
            return node;
        }

        /*
         * Unable to fully structure code
         */
        GraphNode verifyTargets(GraphNode node, Format[] outs) {
            i = 0;
            while (i < this.targets.length) {
                block7: {
                    gn = this.targets[i];
                    if (gn != null) ** GOTO lbl12
                    name = (String)this.targetNames.elementAt(i);
                    if (name == null || MediaEngine.matches(outs, base = PlugInManager.getSupportedInputFormats(name, this.targetType), null, null) == null) break block7;
                    gn = MediaEngine.this.getPlugInNode(name, this.targetType, this.plugIns);
                    if (gn == null) {
                        this.targetNames.setElementAt(null, i);
                    } else {
                        this.targets[i] = gn;
lbl12:
                        // 2 sources

                        if ((fmt = MediaEngine.matches(outs, gn.getSupportedInputs(), node.plugin, gn.plugin)) != null) {
                            return new GraphNode(gn, fmt, node, node.level + 1);
                        }
                    }
                }
                ++i;
            }
            return null;
        }

        boolean useDefaultTargets(Format in) {
            this.targetNames = in instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (in instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
            if (this.targetNames == null || this.targetNames.size() == 0) {
                MediaEngine.this.log("The graph builder does not recognize the input format at all:");
                MediaEngine.this.log(in.toString());
                return false;
            }
            this.targets = new GraphNode[this.targetNames.size()];
            this.targetType = 4;
            this.ignoreContentDes = false;
            return true;
        }

        void removeFailure(Vector candidates, GraphNode failed) {
            GraphNode n2;
            if (failed.plugin == null) {
                return;
            }
            Enumeration enumeration = candidates.elements();
            while (enumeration.hasMoreElements()) {
                n2 = (GraphNode)enumeration.nextElement();
                if (n2.plugin != failed.plugin) continue;
                candidates.removeElement(n2);
            }
            n2 = (GraphNode)this.plugIns.get(failed.plugin.getClass().getName());
            if (n2 != null) {
                n2.failed = true;
            }
        }

        boolean buildCustomGraph(TControl tc) {
            GraphNode failed;
            this.codecs = tc.codecChainWanted;
            this.rend = tc.rendererWanted;
            this.format = tc.formatWanted;
            this.ignoreContentDes = true;
            GraphNode node = this.buildCustomGraph(tc.getOriginalFormat());
            return node != null && (failed = MediaEngine.this.buildTrackFromGraph(tc, node)) == null;
        }

        GraphNode buildCustomGraph(Format in) {
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            Object n2 = null;
            GraphNode node = new GraphNode(null, null, in, null, 0);
            candidates.addElement(node);
            MediaEngine.this.log("Custom options specified.");
            MediaEngine.this.indent = 1;
            if (this.codecs != null) {
                int i2 = 0;
                while (i2 < this.codecs.length) {
                    if (this.codecs[i2] != null) {
                        MediaEngine.this.log("A custom codec is specified: " + this.codecs[i2]);
                        this.targets = new GraphNode[1];
                        this.targets[0] = new GraphNode(this.codecs[i2], null, null, 0);
                        this.targets[0].custom = true;
                        node = this.buildGraph(candidates);
                        if (node == null) {
                            MediaEngine.this.log("The input format is not compatible with the given codec plugin: " + this.codecs[i2]);
                            MediaEngine.this.indent = 0;
                            return null;
                        }
                        node.level = 0;
                        candidates = new Vector();
                        candidates.addElement(node);
                    }
                    ++i2;
                }
            }
            if (this.rend != null) {
                MediaEngine.this.log("A custom renderer is specified: " + this.rend);
                this.targets = new GraphNode[1];
                this.targets[0] = new GraphNode(this.rend, null, null, 0);
                this.targets[0].custom = true;
                node = this.buildGraph(candidates);
                if (node == null) {
                    MediaEngine.this.log("The input format is not compatible with the given renderer plugin: " + this.rend);
                    MediaEngine.this.indent = 0;
                    return null;
                }
            } else {
                if (!this.useDefaultTargets(in)) {
                    return null;
                }
                if (this.format != null) {
                    this.targetFormat = this.format;
                    MediaEngine.this.log("An output format is specified:");
                    MediaEngine.this.log("  " + this.format);
                }
                if ((node = this.buildGraph(candidates)) == null) {
                    MediaEngine.this.log("Failed to build a graph for the given custom options.");
                    MediaEngine.this.indent = 0;
                    return null;
                }
            }
            MediaEngine.this.indent = 0;
            return node;
        }

        GraphBuilder() {
            MediaEngine.this = MediaEngine.this;
        }
    }
}

