/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.rc;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.rc.RateConversion;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class RCModule
extends AudioCodec {
    private RateConversion rateConversion;
    private Format lastInputFormat;
    private Format lastOutputFormat;
    private static boolean DEBUG;

    public RCModule() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1), new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.PLUGIN_NAME = "Rate Conversion";
    }

    public Format setInputFormat(Format format) {
        if (!this.isSampleRateSupported(format)) {
            return null;
        }
        return super.setInputFormat(format);
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        if (!this.isSampleRateSupported(in)) {
            return new Format[0];
        }
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1), new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
        if (this.rateConversion != null) {
            this.rateConversion.reset();
        }
    }

    public void close() {
        if (this.rateConversion != null) {
            this.rateConversion.close();
        }
        this.rateConversion = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int inputLength = inputBuffer.getLength();
        if (!(this.lastInputFormat == this.inputFormat && this.lastOutputFormat == this.outputFormat && this.rateConversion != null || this.initConverter(this.inputFormat, this.outputFormat, inputLength))) {
            return 1;
        }
        int maxOutLength = this.rateConversion.getMaxOutputLength(inputLength);
        byte[] inputData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, maxOutLength);
        int outLength = this.rateConversion.process(inputData, inputBuffer.getOffset(), inputLength, outData, outputBuffer.getOffset());
        this.updateOutput(outputBuffer, this.outputFormat, outLength, outputBuffer.getOffset());
        return 0;
    }

    private boolean isSampleRateSupported(Format format) {
        try {
            int sampleRate = (int)((AudioFormat)format).getSampleRate();
            if (sampleRate != 11025 && sampleRate != 11127 && sampleRate != 16000 && sampleRate != 22050 && sampleRate != 22254 && sampleRate != 22255 && sampleRate != 32000 && sampleRate != 44100 && sampleRate != 48000) {
                if (DEBUG) {
                    System.out.println("RCModule - input format sampling rate isn't supported");
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private boolean initConverter(AudioFormat inFormat, AudioFormat outFormat, int inputLength) {
        this.lastInputFormat = inFormat;
        this.lastOutputFormat = outFormat;
        boolean isSigned = false;
        int numberOfInputChannels = inFormat.getChannels();
        int numberOfOutputChannels = outFormat.getChannels();
        int inputSampleSize = inFormat.getSampleSizeInBits();
        int sampleRate = (int)inFormat.getSampleRate();
        boolean ulawOutput = false;
        if (sampleRate == 8000) {
            return false;
        }
        int pcmType = 1;
        if (inFormat.getEndian() == 1) {
            pcmType = 0;
        }
        if (inputSampleSize == 8) {
            pcmType = 2;
        }
        if (inFormat.getSigned() == 1) {
            isSigned = true;
        }
        if (this.rateConversion != null) {
            this.close();
        }
        if (outFormat.getEncoding() == "ULAW") {
            ulawOutput = true;
        }
        this.rateConversion = new RateConversion();
        if (this.rateConversion.init(inputLength, sampleRate, 8000, numberOfInputChannels, numberOfOutputChannels, pcmType, isSigned, ulawOutput) != -1) {
            this.rateConversion = null;
            return false;
        }
        return true;
    }
}

