/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.g723;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.g723.G723Dec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    protected G723Dec decoder;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("g723"), new AudioFormat("g723/rtp")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "G723 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.decoder = new G723Dec();
        this.decoder.decoderOpen();
    }

    public void reset() {
        this.resetDecoder();
    }

    public void close() {
        this.freeDecoder();
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int inpLength = inputBuffer.getLength();
        int outLength = this.calculateOutputSize(inputBuffer.getLength());
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        this.decode(inpData, inputBuffer.getOffset(), outData, 0, inpLength);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    protected void initDecoder() {
        this.decoder.decoderReset();
    }

    protected void freeDecoder() {
        this.decoder = null;
    }

    protected void resetDecoder() {
        this.decoder.decoderReset();
    }

    protected int calculateOutputSize(int inputSize) {
        return inputSize / 24 * 480;
    }

    protected void decode(byte[] inpData, int readPtr, byte[] outData, int writePtr, int inpLength) {
        int numberOfFrames = inpLength / 24;
        int frameSize = 24;
        int n2 = 0;
        while (n2 < numberOfFrames) {
            this.decoder.decodeFrame(inpData, readPtr, outData, writePtr);
            ++n2;
            readPtr += frameSize;
            writePtr += 480;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, true, false);
        }
        return this.controls;
    }
}

