/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.courier;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.TwoPanesView;
import rogatkin.BaseController;
import rogatkin.Serializer;

public class HTTPCourier
implements Courier {
    public static final String SECNAME = "HTTPCourier";
    public static final String CRLF = "\r\n";
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_LENGTH = "Content-Length";
    static final String SET_COOKIE = "Set-Cookie";
    static final String USER_AGENT = "User-Agent";
    static final String CONTENT_DISP = "Content-Disposition: form-data; name=\"";
    static final String FILENAME = "\"; filename=\"";
    static final String CONTENT_ENCODING = "Content-Encoding: ";
    static final String CONTENT_TYPE_ = "Content-Type: ";
    static final String MULTIPART = "multipart/form-data; boundary=";
    static final String POST_ENCODING = "application/x-www-form-urlencoded";
    static final String DEFAULT_CONTENTTYPE = "application/octet-stream";
    static final String SEP = "--";
    static final String COOKIE = "Cookie";
    static final String SECURE = "secure";
    static final String DEFAULT_AGENT = "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)";
    static final int AUTH_COOKIE = 1;
    static final int METHOD_GET = 0;
    static final int METHOD_POST = 1;
    static final int BUFSIZE = 1024;
    private static final boolean debugHeaders = false;
    Controller controller;
    Serializer s;
    boolean manualMode;
    TwoPanesView mmView;
    String albumName;
    URL publisherURL;
    String mask;
    int authMode;
    Map cookieValues;

    public HTTPCourier(Controller controller) {
        this(controller, null);
    }

    public HTTPCourier(Controller controller, String string) {
        this.controller = controller;
        this.albumName = string;
        if (this.albumName != null && this.albumName.length() == 0) {
            this.albumName = null;
        }
        this.s = controller.getSerializer();
        boolean bl = this.manualMode = Serializer.getInt((Object)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpManualMode"), (int)0) != 0;
        if (this.manualMode) {
            this.mmView = TwoPanesView.createFramed(false, null, 5, null);
            this.mmView.setSize(300, 500);
        }
    }

    public void deliver(StringBuffer stringBuffer, String string, String string2, String string3) throws IOException {
        String string4;
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string5 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string5);
        String string6 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDestName");
        if (string6 == null || string6.length() == 0) {
            string6 = "UploadDestName";
        }
        if ((string4 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDataName")) == null || string4.length() == 0) {
            string4 = "UploadDataName";
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream(), string3));
        }
        catch (Exception exception) {
            printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        }
        printWriter.print(SEP + string5 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string6);
        printWriter.print("\"\r\n");
        printWriter.print(CRLF);
        printWriter.print(string + CRLF);
        printWriter.print(SEP + string5 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string4);
        printWriter.print(FILENAME);
        printWriter.print(string);
        printWriter.print("\"\r\n");
        if (string2 != null && string2.length() > 0) {
            printWriter.print(CONTENT_TYPE_);
            printWriter.print(string2 + CRLF);
        }
        if (string3 == null || string3.length() > 0) {
            // empty if block
        }
        printWriter.print(CRLF);
        printWriter.print(stringBuffer + CRLF);
        printWriter.print(SEP + string5 + SEP + CRLF);
        printWriter.close();
        HTTPCourier.saveCookies(httpURLConnection, this.cookieValues);
        this.reportConnectionStatus(httpURLConnection, "HTML", false, false);
        httpURLConnection.disconnect();
    }

    public void deliver(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string3 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string3);
        String string4 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDestName");
        if (string4 == null || string4.length() == 0) {
            string4 = "UploadDestName";
        }
        String string5 = new File(string).getName();
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '/' && string2.charAt(string2.length() - 1) != '\\') {
            string2 = string2 + '/';
        }
        string2 = string2 + string5;
        String string6 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDataName");
        if (string6 == null || string6.length() == 0) {
            string6 = "UploadDataName";
        }
        String string7 = null;
        try {
            string7 = URLConnection.getFileNameMap().getContentTypeFor(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string7 == null || string7.length() == 0) {
            string7 = DEFAULT_CONTENTTYPE;
            System.err.println("Content type for " + string + " not found, " + string7 + " will be used.");
        }
        File file = new File(string);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.print(SEP + string3 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string4);
        printWriter.print("\"\r\n");
        printWriter.print(CRLF);
        printWriter.print(string2 + CRLF);
        printWriter.print(SEP + string3 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string6);
        printWriter.print(FILENAME);
        printWriter.print(string);
        printWriter.print("\"\r\n");
        printWriter.print(CONTENT_TYPE_);
        printWriter.print(string7 + CRLF);
        printWriter.print(CRLF);
        if (printWriter.checkError()) {
            System.err.println("Error happened in output stream at writing form fields.");
        }
        Controller.copyFile((File)file, (OutputStream)outputStream);
        if (printWriter.checkError()) {
            System.err.println("Error happened in output stream at writing form data.");
        }
        printWriter.print(CRLF);
        printWriter.print(SEP + string3 + SEP + CRLF);
        if (printWriter.checkError()) {
            System.err.println("Error happened in output stream at finishing.");
        }
        printWriter.close();
        HTTPCourier.saveCookies(httpURLConnection, this.cookieValues);
        this.reportConnectionStatus(httpURLConnection, "IMAGE", false, false);
        httpURLConnection.disconnect();
    }

    public void checkForDestPath(String string) throws IOException {
    }

    public String deliver(AbstractFormat abstractFormat, String string) throws IOException {
        AbstractInfo abstractInfo;
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string2 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string2);
        String string3 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDestName");
        if (string3 == null || string3.length() == 0) {
            string3 = "UploadDestName";
        }
        if ((abstractInfo = abstractFormat.getInfo()) == null) {
            return "";
        }
        String string4 = FileNameFormat.makeValidPathName(new FileNameFormat(this.mask, true).format(abstractFormat), abstractFormat.getThumbnailType());
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            string = string + '/';
        }
        string = string + string4;
        String string5 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadDataName");
        if (string5 == null || string5.length() == 0) {
            string5 = "UploadDataName";
        }
        String string6 = "image/" + abstractFormat.getThumbnailType();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        if (abstractInfo instanceof AbstractImageInfo) {
            ((AbstractImageInfo)abstractInfo).saveThumbnailImage((BasicJpeg)abstractFormat, byteArrayOutputStream);
        } else {
            byteArrayOutputStream.write(abstractFormat.getThumbnailData(null));
        }
        OutputStream outputStream = httpURLConnection.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.print(SEP + string2 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string3);
        printWriter.print("\"\r\n");
        printWriter.print(CRLF);
        printWriter.print(string + CRLF);
        printWriter.print(SEP + string2 + CRLF);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string5);
        printWriter.print(FILENAME);
        printWriter.print(string4);
        printWriter.print("\"\r\n");
        printWriter.print(CONTENT_TYPE_);
        printWriter.print(string6 + CRLF);
        printWriter.print(CRLF);
        if (printWriter.checkError()) {
            System.err.println("Error happened in output stream at writing form fields.");
        }
        outputStream.write(byteArrayOutputStream.toByteArray());
        if (printWriter.checkError()) {
            System.err.println("Error happened in output stream at writing thumbnail.");
        }
        printWriter.print(CRLF);
        printWriter.print(SEP + string2 + SEP + CRLF);
        printWriter.close();
        byteArrayOutputStream.close();
        HTTPCourier.saveCookies(httpURLConnection, this.cookieValues);
        this.reportConnectionStatus(httpURLConnection, "THUMBNAIL", false, false);
        httpURLConnection.disconnect();
        return string;
    }

    public void init() throws IOException {
        String string;
        Object object;
        boolean bl;
        this.authMode = Serializer.getInt((Object)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpAuthentication"), (int)0);
        boolean bl2 = bl = Serializer.getInt((Object)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpLoginMethod"), (int)0) == 0;
        if (this.authMode == 1) {
            Object object2;
            this.cookieValues = new Hashtable(2);
            object = null;
            HttpURLConnection.setFollowRedirects(false);
            string = URLEncoder.encode((String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpLoginName"));
            string = string + '=';
            string = string + URLEncoder.encode((String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpLogin"));
            string = string + '&';
            string = string + URLEncoder.encode((String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpPasswordName"));
            string = string + '=';
            String string2 = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpPassword");
            if (string2 != null) {
                try {
                    string = string + URLEncoder.encode(Controller.encryptXor((String)new String(BaseController.hexToBytes((String)string2), "iso-8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IOException("Unsupported encoding in password decryption: " + unsupportedEncodingException);
                }
            }
            string = string + '&';
            string = string + (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpStaticQuery");
            if (bl) {
                try {
                    object2 = new URL((String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpLoginURL") + '?' + string);
                    object = (HttpURLConnection)((URL)object2).openConnection();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IOException("MalformedURLException at GET method: " + malformedURLException);
                }
                HTTPCourier.restoreCookies((URLConnection)object, this.cookieValues);
                ((URLConnection)object).setRequestProperty(USER_AGENT, DEFAULT_AGENT);
            } else {
                try {
                    object = (HttpURLConnection)new URL((String)this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpLoginURL")).openConnection();
                    ((URLConnection)object).setDoOutput(true);
                    ((URLConnection)object).setUseCaches(false);
                    ((URLConnection)object).setAllowUserInteraction(false);
                    ((URLConnection)object).setRequestProperty(USER_AGENT, DEFAULT_AGENT);
                    HTTPCourier.restoreCookies((URLConnection)object, this.cookieValues);
                    object2 = new PrintWriter(((URLConnection)object).getOutputStream());
                    ((PrintWriter)object2).print(string + CRLF);
                    if (((PrintWriter)object2).checkError()) {
                        System.err.println("Error happened in output stream at POST query.");
                    }
                    ((PrintWriter)object2).close();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IOException("MalformedURLException at POST method: " + malformedURLException);
                }
            }
            if (object != null) {
                int n = ((HttpURLConnection)object).getResponseCode();
                HTTPCourier.saveCookies((URLConnection)object, this.cookieValues);
                if (n == 200) {
                    this.reportConnectionStatus((HttpURLConnection)object, "LOGIN", false, true);
                } else if (n >= 300 && n <= 305) {
                    String string3 = ((URLConnection)object).getHeaderField("Location");
                    this.reportConnectionStatus((HttpURLConnection)object, "LOGIN", false, false);
                    URL uRL = ((URLConnection)object).getURL();
                    ((HttpURLConnection)object).disconnect();
                    try {
                        object = (HttpURLConnection)new URL(uRL, string3).openConnection();
                        HTTPCourier.restoreCookies((URLConnection)object, this.cookieValues);
                        ((URLConnection)object).setRequestProperty(USER_AGENT, DEFAULT_AGENT);
                        HTTPCourier.saveCookies((URLConnection)object, this.cookieValues);
                        this.reportConnectionStatus((HttpURLConnection)object, "LOGIN-REDIRECT", false, false);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IOException("MalformedURLException at redirect: " + malformedURLException);
                    }
                } else {
                    this.reportConnectionStatus((HttpURLConnection)object, "LOGIN", false, false);
                }
                ((HttpURLConnection)object).disconnect();
            }
        }
        object = Serializer.arrayToString((Object)this.s.getProperty((Object)"WebPublishOptions", (Object)"UploadServletURL"));
        if (this.albumName != null && object != null) {
            if (((String)object).indexOf(63) < 0) {
                object = (String)object + "?";
            } else if (((String)object).charAt(((String)object).length() - 1) != '&') {
                object = (String)object + "&";
            }
            string = this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpAlbumName").toString();
            if (string == null || string.length() == 0) {
                string = this.s.getProperty((Object)"WebPublishOptions", (Object)"HttpAlbumId").toString();
            }
            if (string != null && string.length() > 0) {
                object = (String)object + string;
                object = (String)object + '=';
                object = (String)object + this.albumName;
            }
        }
        try {
            this.publisherURL = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Invalid upload URL format " + (String)object);
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Upload URL not specified " + (String)object);
        }
        this.mask = (String)this.s.getProperty((Object)"ThumbnailsOptions", (Object)"FileMask");
        if (this.mask == null || this.mask.length() == 0) {
            this.mask = "tumbnail%00c.jpg";
        }
    }

    public void done() {
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isContentIncluded() {
        return false;
    }

    private String genBoundary() {
        return Long.toHexString(new Random().nextLong());
    }

    private void reportConnectionStatus(HttpURLConnection httpURLConnection, String string, boolean bl, boolean bl2) throws IOException {
        int n = httpURLConnection.getResponseCode();
        System.err.println("************* " + string + " *************");
        System.err.println("Request: " + httpURLConnection.getURL());
        System.err.println("Server returned: " + n + "/" + httpURLConnection.getResponseMessage());
        if (n >= 300 && n <= 305) {
            System.err.println("Redirect requested to: " + httpURLConnection.getHeaderField("Location"));
        }
        if (bl) {
            System.err.println("Cookies: " + this.cookieValues);
        }
        if (bl2) {
            System.err.println("Returned content: \n" + new String(Controller.readStreamInBuffer(httpURLConnection.getInputStream())));
        }
        if (this.manualMode) {
            InputStream inputStream = httpURLConnection.getInputStream();
            this.mmView.readToUpper(inputStream);
            inputStream.close();
            if ("OK".equals(this.mmView.showModal())) {
                this.manualMode = false;
            }
        }
    }

    private HttpURLConnection getConnectedToPublish() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.publisherURL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setRequestProperty(USER_AGENT, DEFAULT_AGENT);
        if (this.authMode == 1) {
            HTTPCourier.restoreCookies(httpURLConnection, this.cookieValues);
        }
        return httpURLConnection;
    }

    public static void saveCookies(URLConnection uRLConnection, Map map) {
        int n = 0;
        while (uRLConnection.getHeaderField(n) != null) {
            if (SET_COOKIE.equalsIgnoreCase(uRLConnection.getHeaderFieldKey(n))) {
                String string = uRLConnection.getHeaderField(n);
                int n2 = string.indexOf(59);
                if (string.lastIndexOf(SECURE) <= n2 && n2 > 0 && (n2 = (string = string.substring(0, n2)).indexOf(61)) > 0) {
                    map.put(string.substring(0, n2), string);
                }
            }
            ++n;
        }
    }

    public static void restoreCookies(URLConnection uRLConnection, Map map) {
        String string = null;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            if (string == null) {
                string = (String)iterator.next().getValue();
                continue;
            }
            string = string + "; ";
            string = string + (String)iterator.next().getValue();
        }
        if (string != null) {
            uRLConnection.setRequestProperty(COOKIE, string);
        }
    }
}

