/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AD_InputStreamSource.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



import java.io.InputStream;
import java.io.IOException;

/**
 * <i>Work In Progress.</i>
 *
 * An instance of <code>AD_InputStreamAD_Source</code> implements a
 * <code>AD_Source</code> that provides data from an <code>InputStream
 * </code>. Seeking functionality is not supported.
 *
 * @author MDM
 */
public class AD_InputStreamSource implements AD_Source
{
	private final InputStream		in;

	public AD_InputStreamSource(InputStream in)
	{
		if (in==null)
			throw new NullPointerException("in");

		this.in = in;
	}

	public int read(byte[] b, int offs, int len)
		throws IOException
	{
		int read = in.read(b, offs, len);
		return read;
	}

	public boolean willReadBlock()
	{
		return true;
		//boolean block = (in.available()==0);
		//return block;
	}

	public boolean isSeekable()
	{
		return false;
	}

	public long	tell()
	{
		return -1;
	}

	public long	seek(long to)
	{
		return -1;
	}

	public long length()
	{
		return -1;
	}
}
