/*
 * Decompiled with CFR 0.152.
 */
package rogatkin.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import rogatkin.servlet.PageServant;

public class Dispatcher
extends HttpServlet {
    public static final String IP_PROPERTIES = "properties";
    public static final String PN_LOCALE = "LOCALE";
    public static final String PN_WORKER_CLASS_PREFX = "WorkerPrefix";
    public static final String PN_MAX_UPLOAD_SIZE = "MaxUploadSize";
    public static final String PN_DEF_SERVANT = "DefaultServant";
    public static final String PRODUCT_NAME = "Generic Rogatkin's product";
    public static final String P_PRODUCT_NAME = "";
    public static final String VERSION = "1";
    public static final String SUB_RELEASE = "00";
    public static final String BUILD = "001";
    public static final String COPYRIGHT = "Dmitriy Rogatkin";
    public static final String HOME_URL = "http://drogatkin.openestate.net";
    public static final String REFERER = "Referer";
    private static final String CLASS_ID = "Dispatcher: ";
    public String HELPER_PREFIX = "rogatkin.servlet.worker.";
    protected String defLocale;
    private boolean initialized;
    private PageHelpersCache helpersCache;
    private Properties properties;
    public static String INFO_PAGE_HEADER_PRE = "<html><head><title>DemRog Info</title><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"></head><body bgcolor=\"#FFFFFF\"><center><table width=\"400\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td colspan=\"2\"><img src=\"image/dlogo.jpg\"></td></tr><tr><td colspan=\"2\"><img src=\"image/clear_spacer.gif\" width=\"1\" height=\"20\"></td></tr><tr><td colspan=\"2\" align=\"center\"><p><b><font color=\"#ff0000\" size=\"4\">";
    public static String INFO_PAGE_HEADER_PST = "</font></b></p>";
    public static String INFO_PAGE_BODY_PRE = "<p><b><font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">";
    public static String INFO_PAGE_BODY_PST = "</font></b></p><hr align=\"center\" noshade width=\"100%\" size=\"1\"></td></tr><tr><td colspan=\"2\"><img src=\"image/clear_spacer.gif\" width=\"1\" height=\"30\"></td></tr><tr><td>&nbsp;</td>";
    public static String INFO_PAGE_HOME_PRE = "<td align=\"center\"><a href=\"";
    public static String INFO_PAGE_HOME_PST = "\"><img src=\"image/button_back.gif\" border=\"0\"></a></td>";
    public static String INFO_PAGE_FOOTER_PRE = "</tr></table><p><font face=\"Arial, Helvetica, sans-serif\" size=\"1\" color=\"#AAAAAA\">";
    public static String INFO_PAGE_FOOTER_PST = "</font></p></body></html>";
    private static final String NOT_INIT_PROPERLY = "Servlet wasn't initialized properly, probably a properties file is missed.";

    public void init(ServletConfig servletConfig) throws ServletException {
        int n;
        super.init(servletConfig);
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(servletConfig.getInitParameter(IP_PROPERTIES)));
        }
        catch (Exception exception) {
            this.log(CLASS_ID + exception);
            this.log("Dispatcher:  trying to load as a resource " + servletConfig.getInitParameter(IP_PROPERTIES));
            try {
                this.properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(servletConfig.getInitParameter(IP_PROPERTIES)));
            }
            catch (Exception exception2) {
                this.log(CLASS_ID + exception2);
            }
        }
        this.helpersCache = new PageHelpersCache();
        this.HELPER_PREFIX = this.properties.getProperty(PN_WORKER_CLASS_PREFX, this.HELPER_PREFIX);
        String string = this.properties.getProperty(PN_LOCALE);
        if (string != null && (n = string.indexOf(95)) > 0) {
            Locale.setDefault(new Locale(string.substring(0, n), string.substring(n + 1)));
            string = Locale.getDefault().toString();
        }
        this.initialized = true;
    }

    public final HttpServlet getServlet() {
        return this;
    }

    public final String getDefLocaleString() {
        return this.defLocale;
    }

    public final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    public final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
        if (!this.initialized) {
            this.log("Dispatcher: Destroy code has been skipped, since the servlet has not been initialized properly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PageServant pageServant;
        String string = httpServletRequest.getPathInfo();
        boolean bl = false;
        if (string == null && (bl = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null)) {
            string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        }
        if (!(string != null && string.length() != 0 || bl)) {
            httpServletResponse.sendRedirect(httpServletRequest.getServletPath() + '/');
            return;
        }
        if (string.length() == 1) {
            string = string + this.properties.getProperty(PN_DEF_SERVANT);
        } else {
            int n = string.indexOf(47, 1);
            if (n > 0) {
                string = string.substring(0, n);
            }
        }
        PageServant pageServant2 = pageServant = string != null && this.initialized ? this.helpersCache.getServant(string) : null;
        if (pageServant != null) {
            if (pageServant.isThreadSafe()) {
                pageServant.serve(httpServletRequest, httpServletResponse, this);
            } else {
                PageServant pageServant3 = pageServant;
                synchronized (pageServant3) {
                    pageServant.serve(httpServletRequest, httpServletResponse, this);
                }
            }
            if (!pageServant.isThreadFriendly() && pageServant.isThreadSafe()) {
                this.helpersCache.releaseServant(string, pageServant);
            }
        } else {
            httpServletResponse.setContentType("text/html");
            if (this.initialized) {
                httpServletResponse.sendError(404, string + " not found or can't be instantiated at request " + httpServletRequest.getRequestURI());
            } else {
                httpServletResponse.sendError(500, NOT_INIT_PROPERLY);
            }
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(INFO_PAGE_HEADER_PRE);
            if (this.initialized) {
                printWriter.print("404 - Not found");
            } else {
                printWriter.print("500 - Internal server error");
            }
            printWriter.print(INFO_PAGE_HEADER_PST);
            printWriter.print(INFO_PAGE_BODY_PRE);
            if (this.initialized) {
                printWriter.print(string + " not found or can't be instantiated at request " + httpServletRequest.getRequestURI());
            } else {
                printWriter.print(NOT_INIT_PROPERLY);
            }
            printWriter.print(INFO_PAGE_BODY_PST);
            printWriter.print(INFO_PAGE_HOME_PRE);
            String string2 = httpServletRequest.getHeader(REFERER);
            printWriter.print(string2 != null ? string2 : "Userlogin");
            printWriter.print(INFO_PAGE_HOME_PST);
            printWriter.print(INFO_PAGE_FOOTER_PRE);
            printWriter.print(this.getServletInfo());
            printWriter.print(INFO_PAGE_FOOTER_PST);
            if (!bl) {
                printWriter.close();
            }
        }
    }

    public String getServletInfo() {
        return "Generic Rogatkin's product version 1.00.001    Dmitriy Rogatkin http://drogatkin.openestate.net";
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public final String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public final String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    class PageHelpersCache
    extends HashMap {
        PageHelpersCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        PageServant getServant(String string) {
            Cloneable cloneable;
            if (string.length() == 2) {
                string = string.substring(1).toUpperCase();
            } else if (string.length() > 2) {
                string = string.substring(1, 2).toUpperCase() + string.substring(2).toLowerCase();
            }
            PageServant pageServant = null;
            LinkedList linkedList = null;
            Object v = this.get(string);
            if (v != null) {
                if (v instanceof LinkedList) {
                    linkedList = (LinkedList)v;
                    cloneable = linkedList;
                    synchronized (cloneable) {
                        if (linkedList.size() > 0) {
                            return (PageServant)linkedList.removeFirst();
                        }
                    }
                } else if (v instanceof PageServant) {
                    pageServant = (PageServant)v;
                }
            }
            if (pageServant != null) {
                return pageServant;
            }
            try {
                cloneable = this;
                synchronized (cloneable) {
                    v = this.get(string);
                    if (v != null) {
                        if (v instanceof LinkedList) {
                            LinkedList linkedList2 = linkedList = (LinkedList)v;
                            synchronized (linkedList2) {
                                if (linkedList.size() > 0) {
                                    return (PageServant)linkedList.removeFirst();
                                }
                                this.remove(string);
                            }
                        } else if (v instanceof PageServant) {
                            return (PageServant)v;
                        }
                    }
                    if (!(pageServant = (PageServant)Class.forName(Dispatcher.this.HELPER_PREFIX + string).newInstance()).isThreadFriendly()) return pageServant;
                    this.put(string, pageServant);
                    return pageServant;
                }
            }
            catch (Throwable throwable) {
                Dispatcher.this.log("Dispatcher: Can't instantiate class " + Dispatcher.this.HELPER_PREFIX + string + ". Reason: " + throwable);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseServant(String string, PageServant pageServant) {
            Cloneable cloneable;
            if (string.length() == 2) {
                string = string.substring(1).toUpperCase();
            } else if (string.length() > 2) {
                string = string.substring(1, 2).toUpperCase() + string.substring(2).toLowerCase();
            }
            LinkedList<PageServant> linkedList = null;
            try {
                cloneable = this;
                synchronized (cloneable) {
                    linkedList = (LinkedList<PageServant>)this.get(string);
                    if (linkedList == null) {
                        linkedList = new LinkedList<PageServant>();
                        this.put(string, linkedList);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                Dispatcher.this.log("Dispatcher: Invalid type of a cache element for released elements. " + classCastException);
            }
            cloneable = linkedList;
            synchronized (cloneable) {
                linkedList.addFirst(pageServant);
            }
        }
    }
}

