/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.courier;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.ftp.Ftp;
import photoorganizer.ftp.FtpCommandReply;
import photoorganizer.renderer.WebPublishOptionsTab;
import rogatkin.Serializer;

public class FTPCourier
implements Courier {
    Controller controller;
    FtpCommandReply fcr;
    String mask;
    String home;
    Ftp ftp_connection;

    public FTPCourier(Controller controller) {
        this.controller = controller;
    }

    public void deliver(StringBuffer stringBuffer, String string, String string2, String string3) throws IOException {
        try {
            this.ftp_connection.cwd();
            this.fcr = this.ftp_connection.stor(this.home + string);
            if (this.fcr.serverSocket != null || this.fcr.socket == null) {
                this.fcr.socket = this.fcr.serverSocket.accept();
            }
            OutputStream outputStream = this.fcr.socket.getOutputStream();
            byte[] byArray = string3 != null && string3.length() > 0 ? stringBuffer.toString().getBytes(string3) : stringBuffer.toString().getBytes();
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            if (this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            throw new IOException("Accept failed for FTP socket " + interruptedIOException);
        }
        catch (IOException iOException) {
            if (this.fcr != null && this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            throw iOException;
        }
        if (this.fcr != null) {
            if (this.fcr.socket != null) {
                this.fcr.socket.close();
            }
            if (this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            this.ftp_connection.getReply("EOF");
        }
    }

    public void deliver(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '/') {
            string2 = string2 + '/';
        }
        this.ftp_connection.type("I");
        this.ftp_connection.cwd();
        try {
            this.fcr = this.ftp_connection.stor(this.home + string2 + new File(string).getName());
            if (this.fcr.serverSocket != null || this.fcr.socket == null) {
                this.fcr.socket = this.fcr.serverSocket.accept();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            throw new IOException("Accept failed for FTP socket " + interruptedIOException);
        }
        catch (IOException iOException) {
            if (this.fcr != null && this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            throw iOException;
        }
        Controller.copyFile((File)new File(string), (OutputStream)this.fcr.socket.getOutputStream());
        if (this.fcr != null) {
            if (this.fcr.socket != null) {
                this.fcr.socket.close();
            }
            if (this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            this.ftp_connection.getReply("EOF");
        }
    }

    public String deliver(AbstractFormat abstractFormat, String string) throws IOException {
        AbstractInfo abstractInfo = abstractFormat.getInfo();
        if (abstractInfo == null) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        String string2 = FileNameFormat.makeValidPathName(new FileNameFormat(this.mask, true).format(abstractFormat), abstractFormat.getThumbnailType());
        string = string + string2;
        this.ftp_connection.type("I");
        this.fcr = this.ftp_connection.stor(this.home + string);
        try {
            if (this.fcr.serverSocket != null || this.fcr.socket == null) {
                this.fcr.socket = this.fcr.serverSocket.accept();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (this.fcr.serverSocket != null) {
                this.fcr.serverSocket.close();
            }
            throw new IOException(this.fcr.toString() + " " + interruptedIOException);
        }
        if (abstractInfo instanceof AbstractImageInfo) {
            ((AbstractImageInfo)abstractInfo).saveThumbnailImage((BasicJpeg)abstractFormat, this.fcr.socket.getOutputStream());
        } else {
            this.fcr.socket.getOutputStream().write(abstractFormat.getThumbnailData(null));
        }
        if (this.fcr.socket != null) {
            this.fcr.socket.close();
        }
        if (this.fcr.serverSocket != null) {
            this.fcr.serverSocket.close();
        }
        this.fcr = this.ftp_connection.getReply("EOF");
        if (this.fcr.replyCode / 100 != 2) {
            throw new IOException(this.fcr.toString());
        }
        return string;
    }

    public void checkForDestPath(String string) throws IOException {
        this.ftp_connection.cwd();
        string = string.replace('\\', '/');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.ftp_connection.mkd(string2);
            this.ftp_connection.cwd(string2);
        }
    }

    public void init() throws IOException {
        Serializer serializer = this.controller.getSerializer();
        this.ftp_connection = new Ftp(WebPublishOptionsTab.getConnectionInfo(serializer));
        if (!this.ftp_connection.isConnected) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Ftp connection failed, check host name and/or proxy settings.", "Error", 0);
            throw new IOException("Couldn't open FTP connection for HTML file");
        }
        try {
            this.ftp_connection.login();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Ftp login's been failed, 'cause\n\n" + iOException, "Error", 0);
            throw iOException;
        }
        this.mask = (String)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"FileMask");
        if (this.mask == null || this.mask.length() == 0) {
            this.mask = "tumbnail%00c.jpg";
        }
        this.home = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"WebRoot");
        if (this.home == null || this.home.length() == 0) {
            this.home = this.ftp_connection.getHomeDirectory();
        }
        if (this.home.length() == 0) {
            this.home = "/";
        } else if (this.home.charAt(this.home.length() - 1) != '/') {
            this.home = this.home + '/';
        }
    }

    public void done() {
        if (this.ftp_connection.isConnected) {
            this.ftp_connection.quit();
        }
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isContentIncluded() {
        return false;
    }

    protected void finalize() throws Throwable {
        this.done();
        super.finalize();
    }
}

