/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.Interface.Gateway.LocalDebugGateway;
import X10Gimli.Interface.InputGateway;
import X10Gimli.Interface.InputListener;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Interface.OutputGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Control;
import X10Gimli.System.Environment;
import X10Gimli.System.Mode;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10addressPacket;
import X10Gimli.System.Packet.X10functionPacket;
import X10Gimli.System.Switch;
import X10Gimli.System.Trigger;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueBoolean;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValuePacket;
import X10Gimli.X10.X10Queue;
import X10Gimli.X10.X10Tracker;
import java.util.ArrayList;
import java.util.Vector;

public class SystemModel
extends Environment
implements InputListener,
OutputListener {
    private Vector vReturnData = new Vector();
    private String sTitle;
    private ArrayList vModes;
    private X10Tracker x10tracker;
    private X10Queue packetQueue = new X10Queue(15);
    private Packet pInput = new Packet();
    private ArrayList vSwitch;
    private ArrayList vControl;
    private Mode mMode;
    private ArrayList vInput;
    private ArrayList vOutput;
    private long lastTriggerCheckTime = 0L;
    private LocalDebugGateway dbg;
    private ArrayList firingTriggers;

    public Value getTransmitReturnData(Packet p) {
        p.packData();
        ReturnData d = new ReturnData(this, p.getID(), p.getType());
        this.vReturnData.add(d);
        this.transmitPacket(p);
        Packet r = d.getReturn();
        this.vReturnData.remove(d);
        if (r.getValue("RETURN") != null) {
            return r.getValue("RETURN");
        }
        return new ValuePacket(p);
    }

    public SystemModel() {
        this.x10tracker = new X10Tracker();
        this.vOutput = new ArrayList();
        this.vInput = new ArrayList();
        this.vSwitch = new ArrayList();
        this.vSwitch.add(new ValueBoolean(true));
        this.vControl = new ArrayList();
        this.vControl.add(new ValueBoolean(true));
        this.vModes = new ArrayList();
    }

    public void startDebugGateway() {
        this.dbg = new LocalDebugGateway();
        this.dbg.addOutputListener(this);
    }

    private void addInput(BasicGateway input) {
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Adding input gateway of class ").append(input.getClass().getName()).append("...\""))));
        this.vInput.add(input);
        if (input instanceof InputGateway) {
            ((InputGateway)input).addInputListener(this);
        }
        if (input instanceof InputOutputGateway) {
            ((InputOutputGateway)input).addInputListener(this);
        }
    }

    private void addOutput(BasicGateway output) {
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Adding output gateway of class ").append(output.getClass().getName()).append("...\""))));
        this.vOutput.add(output);
    }

    public ArrayList getInputGateways() {
        return this.vInput;
    }

    public ArrayList getOutputGateways() {
        return this.vOutput;
    }

    public void addConnection(Object connection) {
        if (connection instanceof InputGateway) {
            this.addInput((BasicGateway)connection);
        }
        if (connection instanceof OutputGateway) {
            this.addOutput((BasicGateway)connection);
        }
        if (connection instanceof InputOutputGateway) {
            this.addInput((BasicGateway)connection);
            this.addOutput((BasicGateway)connection);
        }
        if (connection instanceof Runnable) {
            Thread t = new Thread((Runnable)connection);
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Starting thread for class ").append(connection.getClass().getName()).append("...\""))));
            t.start();
        }
    }

    public void startThreads() {
        this.startDebugGateway();
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"Model trigger check thread started...\"");
                long millis = System.currentTimeMillis();
                millis -= millis % (long)1000;
                while (true) {
                    SystemModel.this.handleTriggers(false);
                    if ((millis += (long)1000) < System.currentTimeMillis()) {
                        Debug.log(1, "\"Warning: trigger checking has fallen behind, triggers sensitive to individual seconds may be missed.\"");
                        while (millis < System.currentTimeMillis()) {
                            millis += (long)1000;
                        }
                    }
                    try {
                        Thread.sleep(millis - System.currentTimeMillis());
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                        continue;
                    }
                    break;
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"Model input handler thread started...\"");
                while (true) {
                    SystemModel.this.setInputPacket((Packet)SystemModel.this.packetQueue.get());
                }
            }
        });
        t1.start();
        t2.start();
    }

    public void startInitCommands() {
        if (this.getStartCommand() != null) {
            Debug.log(1, "\"Running init commands for system model.\"");
            this.executeCommand(this.getStartCommand());
        }
    }

    public void startFinishCommands() {
        if (this.getFinishCommand() != null) {
            Debug.log(1, "\"Running finishing commands for system model.\"");
            this.executeCommand(this.getFinishCommand());
        }
        Debug.log(1, "\"Ending X10GIMLI...\"");
        System.exit(0);
    }

    public void setSwitch(ArrayList theswitch) {
        this.vSwitch = theswitch;
    }

    public void setControl(ArrayList control) {
        this.vControl = control;
    }

    public ArrayList getSwitch() {
        return this.vSwitch;
    }

    public ArrayList getControl() {
        return this.vControl;
    }

    public void setTitle(String title) {
        this.sTitle = new String(title);
    }

    public void setModes(ArrayList modes) {
        this.vModes = modes;
    }

    public String getTitle() {
        return this.sTitle;
    }

    public ArrayList getModes() {
        return this.vModes;
    }

    public Value getTaggedValue(String tag) {
        if (this.pInput != null) {
            return this.pInput.getValue(tag);
        }
        return null;
    }

    public void setEnvironment(Environment env) {
        this.setImports(env.getImports());
        this.setControls(env.getControls());
        this.setFinishCommand(env.getFinishCommand());
        this.setStartCommand(env.getStartCommand());
        this.setFunctions(env.getFunctions());
        this.setDefinitions(env.getDefinitions());
        this.setTriggers(env.getTriggers());
    }

    public void setInputPacket(Packet packet) {
        try {
            if (packet.getType().equals("X10GIMLI")) {
                if (packet.getValue("COMMAND").getValueString().equals("SHUTDOWN")) {
                    this.startFinishCommands();
                } else {
                    this.dbg.transmitPacket(packet);
                }
            } else {
                packet = packet.getPacketType();
                this.vControl = new ArrayList();
                this.vControl.add(new ValueIdent(packet.getType()));
                this.vControl.add(new ValueBoolean(true));
                if (packet instanceof X10addressPacket || packet instanceof X10functionPacket) {
                    this.vSwitch = new ArrayList();
                    this.pInput = this.x10tracker.inputPacket(packet);
                    if (this.pInput.getValue("COMMAND") != null) {
                        this.setInputPacket(this.pInput);
                    }
                } else {
                    this.pInput = packet;
                    this.vSwitch = new ArrayList();
                    this.vSwitch.addAll(packet.getValues());
                    this.vSwitch.add(new ValueBoolean(true));
                    this.executeInput();
                }
            }
        }
        catch (Exception e) {
            Debug.printCallStack("There was a problem setting the input packet.\r\n".concat(String.valueOf(String.valueOf(packet.toString()))), e);
        }
    }

    public Packet getInputPacket() {
        return this.pInput;
    }

    public Value getAddressValue() {
        return this.x10tracker.getAddressValue();
    }

    public Value getFunctionValue() {
        return this.x10tracker.getFunctionValue();
    }

    public Value getFunctionExtra() {
        return this.x10tracker.getFunctionExtra();
    }

    public ArrayList getControls(ArrayList con) {
        if (this.mMode != null) {
            return this.mMode.findControls(con);
        }
        return super.findControls(con);
    }

    public ArrayList getSwitches(ArrayList control, ArrayList id) {
        if (this.mMode != null) {
            ArrayList s = this.mMode.getSwitches(control, id);
            return s;
        }
        ArrayList con = this.getControls(control);
        for (int i = 0; i < con.size(); ++i) {
            Control c = (Control)con.get(i);
            ArrayList s = c.getSwitches(id, this);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public Switch getSwitch(ArrayList control, ArrayList id) {
        ArrayList s = this.getSwitches(control, id);
        if (s != null) {
            return (Switch)s.get(0);
        }
        return null;
    }

    public Mode findMode(String name) {
        Mode m = null;
        if (this.vModes != null) {
            for (int i = 0; i < this.vModes.size(); ++i) {
                m = (Mode)this.vModes.get(i);
                if (m.getName() != name) continue;
                return m;
            }
        }
        return null;
    }

    public void changeMode(String mode) {
        this.changeMode(this.findMode(mode));
    }

    public void changeMode(Mode mode) {
        if (mode != null) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Changing to mode ").append(mode.getName()).append("...\""))));
        } else {
            Debug.log(1, "\"Changing to default mode...\"");
        }
        if (this.mMode != null) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Doing exit commands for ").append(this.mMode.getName()).append(".\""))));
            this.mMode.executeCommand(this.mMode.getFinishCommand());
        }
        this.mMode = mode;
        if (this.mMode != null) {
            this.mMode.setParent(this);
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Running init commands for ").append(this.mMode.getName()).append(".\""))));
            this.mMode.executeCommand(this.mMode.getStartCommand());
        }
    }

    public void handleTriggers(boolean forcecheck) {
        long timediff = System.currentTimeMillis() - this.lastTriggerCheckTime;
        if (forcecheck || timediff >= (long)1000) {
            this.setTime();
            if (this.mMode != null) {
                this.mMode.setTime();
            }
            this.lastTriggerCheckTime = System.currentTimeMillis();
            ArrayList triggers = this.mMode != null ? this.mMode.checkTriggers() : this.checkTriggers();
            if (triggers != null && triggers.size() > 0) {
                this.firingTriggers = triggers;
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        Debug.log(1, "\"Events have been triggered.  Running.\"");
                        ArrayList tr = SystemModel.this.firingTriggers;
                        for (int i = 0; i < tr.size(); ++i) {
                            Trigger t = (Trigger)tr.get(i);
                            if (SystemModel.this.mMode != null) {
                                SystemModel.this.mMode.executeCommand(t.getCommand());
                                continue;
                            }
                            SystemModel.this.executeCommand(t.getCommand());
                        }
                    }
                });
                t.start();
            }
        }
    }

    public void executeInput() {
        Switch s = this.getSwitch(this.vControl, this.vSwitch);
        if (s != null && s.isActive()) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Handling ").append(this.pInput.getType()).append(" switch ").append(s.toString()).append(".\""))));
            if (this.mMode == null) {
                this.spawnEnvironment().executeCommand(s.getCommand());
            } else {
                this.mMode.spawnEnvironment().executeCommand(s.getCommand());
            }
            this.handleTriggers(true);
        } else if (s != null && !s.isActive()) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(this.vControl.toString()).append(" switch ").append(s.toString()).append(" is disabled.  Ignoring input.\""))));
        } else if (s == null) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(this.vControl.toString()).append(" switch ").append(this.vSwitch.toString()).append(" doesn't exist.\""))));
        }
    }

    public void transmitPacket(Packet packet) {
        try {
            Value c;
            if (packet.getType().equals("X10GIMLI") && (c = packet.getValue("COMMAND")) != null) {
                if (c.getValueString().equals("SHUTDOWN")) {
                    this.startFinishCommands();
                } else if (c.getValueString().equals("LOGMESSAGE")) {
                    // empty if block
                }
            }
            if (packet.getSource().length() == 0) {
                packet.setSource("X10GIMLI");
            }
            for (int i = 0; i < this.vOutput.size(); ++i) {
                Object o = this.vOutput.get(i);
                if (o instanceof OutputGateway) {
                    ((OutputGateway)o).transmitPacket(packet);
                }
                if (!(o instanceof InputOutputGateway)) continue;
                ((InputOutputGateway)o).transmitPacket(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void receivePacket(Packet packet) {
        if (((packet = packet.getPacketType()).getFlags() & 1) != 0) {
            int size = this.vReturnData.size();
            for (int i = 0; i < size; ++i) {
                ReturnData r = (ReturnData)this.vReturnData.get(i);
                if (r.sequencenumber != packet.getID()) continue;
                r.postReturn(packet);
                return;
            }
        } else {
            this.packetQueue.put(packet);
        }
    }

    public String toX10GIMLI() {
        StringBuffer sBuf = new StringBuffer("");
        sBuf.append("x10gimli ");
        sBuf.append(this.sTitle);
        sBuf.append(";\r\n\r\n");
        sBuf.append(super.toX10GIMLI(0));
        for (int i = 0; i < this.vModes.size(); ++i) {
            sBuf.append(((Mode)this.vModes.get(i)).toX10GIMLI());
        }
        sBuf.append("end x10gimli.\r\n");
        return sBuf.toString();
    }

    protected class ReturnData {
        private X10Queue returnval = new X10Queue(1);
        private int sequencenumber;
        private boolean success = false;
        private String stype = "NONE";

        public ReturnData(SystemModel this$0, int num, String type) {
            this.sequencenumber = num;
            this.stype = new String(type);
            Thread t = new Thread(new Runnable(this){
                private final /* synthetic */ ReturnData this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!ReturnData.access$0(this.this$1)) {
                        Debug.error(301, String.valueOf(String.valueOf(new StringBuffer("Timeout waiting for response to ").append(ReturnData.access$1(this.this$1)).append(" packet."))));
                        Packet p = new Packet();
                        p.addSegment("RETURN", new ValueNumber(0));
                        ReturnData.access$2(this.this$1).put(p);
                    }
                }
            });
            t.start();
        }

        public Packet getReturn() {
            Packet p = (Packet)this.returnval.get();
            this.success = true;
            return p;
        }

        public void postReturn(Object o) {
            this.returnval.put(o);
        }

        static /* synthetic */ String access$1(ReturnData x$0) {
            return x$0.stype;
        }

        static /* synthetic */ boolean access$0(ReturnData x$0) {
            return x$0.success;
        }

        static /* synthetic */ X10Queue access$2(ReturnData x$0) {
            return x$0.returnval;
        }
    }
}

