/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.OutputGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.SmtpPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class SMTPGateway
extends OutputGateway {
    private String serverName = "localhost";
    private int port = 25;

    public SMTPGateway() {
        this.sSource = "SMTP";
    }

    public boolean initialize(Value id) {
        if (id instanceof ValueString) {
            this.serverName = id.getValueString();
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully activated SMTP gateway for ").append(this.serverName).append(" on port ").append(this.port).append(".\""))));
            return true;
        }
        Debug.error(100, "\"Server address or server/port combination required to initialize SMTP gateway.\"");
        return false;
    }

    public void sendPacket(Packet pack) {
        Packet packet = pack.getPacketType();
        if (packet instanceof SmtpPacket) {
            SmtpPacket smtp = (SmtpPacket)packet;
            String to = null;
            String from = "X10GIMLI";
            String subject = "X10GIMLI message";
            String message = "This is a message from X10GIMLI.";
            if (smtp.getTo() != null) {
                to = smtp.getTo().getValueString();
            }
            if (smtp.getFrom() != null) {
                from = smtp.getFrom().getValueString();
            }
            if (smtp.getSubject() != null) {
                subject = smtp.getSubject().getValueString();
            }
            if (smtp.getMessage() != null) {
                message = smtp.getMessage().getValueString();
            }
            this.sendMessage(to, from, subject, message);
        }
    }

    public void sendMessage(String to, String from, String subject, String message) {
        Vector<String> tolist = new Vector<String>();
        tolist.add(to);
        this.sendMessage(tolist, from, String.valueOf(String.valueOf(new StringBuffer("Subject: ").append(subject).append("\n\n"))), message);
    }

    public void sendMessage(Vector to, String from, String header, String message) {
        try {
            Socket smtp = new Socket(InetAddress.getByName(this.serverName), this.port);
            BufferedReader in = new BufferedReader(new InputStreamReader(smtp.getInputStream()));
            OutputStreamWriter out = new OutputStreamWriter(smtp.getOutputStream());
            String input = in.readLine();
            if (!input.substring(0, 3).equals("220")) {
                Debug.error(302, "No SMTP ready on connection.");
                return;
            }
            out.write(String.valueOf(String.valueOf(new StringBuffer("MAIL FROM:").append(from).append("\n"))));
            out.flush();
            input = in.readLine();
            if (!input.substring(0, 3).equals("250")) {
                Debug.error(302, "Unable to begin e-mail message.");
                return;
            }
            if (to != null) {
                for (int i = 0; i < to.size(); ++i) {
                    out.write(String.valueOf(String.valueOf(new StringBuffer("RCPT TO:").append((String)to.get(i)).append("\n"))));
                    out.flush();
                    input = in.readLine();
                    if (input.substring(0, 3).equals("250")) continue;
                    Debug.error(302, "Problem setting e-mail recipient.");
                    return;
                }
            }
            out.write("DATA\n");
            out.flush();
            input = in.readLine();
            if (!input.substring(0, 3).equals("354")) {
                Debug.error(302, "Problem setting e-mail message content.");
                return;
            }
            out.write(header);
            out.write(message);
            out.write("\n.\n");
            out.flush();
            input = in.readLine();
            if (!input.substring(0, 3).equals("250")) {
                Debug.error(302, "Error sending e-mail message.");
                return;
            }
            out.write("QUIT\n");
            out.flush();
            input = in.readLine();
            if (!input.substring(0, 3).equals("221")) {
                // empty if block
            }
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"SMTP e-mail successfully transmitted to ").append(to).append(".\""))));
            smtp.close();
        }
        catch (Exception e) {
            Debug.error(302, "Error occurred while attempting to send e-mail message.");
        }
    }
}

